/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.table.sdv;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.controller.helper.SdvFilterDataBean;
import org.akaza.openclinica.controller.helper.table.SDVToolbar;
import org.akaza.openclinica.controller.helper.table.SubjectSDVContainer;
import org.akaza.openclinica.dao.EventCRFSDVFilter;
import org.akaza.openclinica.dao.EventCRFSDVSort;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.web.table.sdv.CrfStatusFilter;
import org.akaza.openclinica.web.table.sdv.CrfStatusMatcher;
import org.akaza.openclinica.web.table.sdv.SDVRequirementFilter;
import org.akaza.openclinica.web.table.sdv.SDVRequirementMatcher;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.akaza.openclinica.web.table.sdv.SdvStatusFilter;
import org.akaza.openclinica.web.table.sdv.SdvStatusMatcher;
import org.akaza.openclinica.web.table.sdv.SubjectStatusFilter;
import org.akaza.openclinica.web.table.sdv.SubjectStatusMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.facade.TableFacadeFactory;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.View;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.component.HtmlColumn;
import org.jmesa.view.html.component.HtmlRow;
import org.jmesa.view.html.component.HtmlTable;
import org.jmesa.view.html.toolbar.Toolbar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;

public class SDVUtil {
    private static final Logger logger = LoggerFactory.getLogger(SDVUtil.class);
    private static final String VIEW_ICON_FORSUBJECT_PREFIX = "<a onmouseup=\"javascript:setImage('bt_View1','images/bt_View.gif');\" onmousedown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\" href=\"ViewStudySubject?id=";
    private static final String ICON_FORCRFSTATUS_SUFFIX = ".gif'/>";
    public static final String CHECKBOX_NAME = "sdvCheck_";
    public static final String VIEW_ICON_HTML = "<img src=\"../images/bt_View.gif\" border=\"0\" />";
    private String pathPrefix;
    public static final Map<Integer, String> SUBJECT_EVENT_STATUS_ICONS = new HashMap();
    public static final Map<Integer, String> CRF_STATUS_ICONS = new HashMap();
    private DataSource dataSource;

    String getIconForSdvStatusPrefix() {
        String prefix = this.pathPrefix == null ? "../" : this.pathPrefix;
        return "<img hspace='2' border='0'  title='SDV Complete' alt='SDV Complete' src='" + prefix + "images/icon_";
    }

    String getIconForCrfStatusPrefix() {
        String prefix = this.pathPrefix == null ? "../" : this.pathPrefix;
        return "<img hspace='2' border='0'  title='Event CRF Status' alt='Event CRF Status' src='" + prefix + "images/icon_";
    }

    String getIconForSubjectSufix() {
        String prefix = this.pathPrefix == null ? "../" : this.pathPrefix;
        return "\"><img hspace=\"6\" border=\"0\" align=\"left\" title=\"View\" alt=\"View\" src=\"" + prefix + "images/bt_View.gif\" name=\"bt_View1\"/></a>";
    }

    String getIconForViewHtml() {
        String prefix = this.pathPrefix == null ? "../" : this.pathPrefix;
        return "<img src=\"" + prefix + "images/bt_View.gif\" border=\"0\" />";
    }

    public NoEscapeHtmlCellEditor getCellEditorNoEscapes() {
        return new NoEscapeHtmlCellEditor(this);
    }

    public int setDataAndLimitVariablesSubjects(TableFacade tableFacade, int studyId, int studySubjectId, HttpServletRequest request) {
        Limit limit = tableFacade.getLimit();
        FilterSet filterSet = limit.getFilterSet();
        int totalRows = this.getTotalRowCountSubjects(filterSet, studyId, studySubjectId);
        tableFacade.setTotalRows(totalRows);
        SortSet sortSet = limit.getSortSet();
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        Collection items = this.getFilteredItemsSubject(filterSet, sortSet, rowStart, rowEnd, studyId, studySubjectId, request);
        tableFacade.setItems(items);
        return totalRows;
    }

    public int getTotalRowCountSubjects(FilterSet filterSet, int studyId, int studySubjectId) {
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        if (filterSet.getFilters().size() == 0) {
            return eventCRFDAO.countEventCRFsByStudySubject(studySubjectId, studyId, studyId);
        }
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        StudySubjectBean studySubjectBean = new StudySubjectBean();
        studySubjectBean = studySubjectDAO.findByPK(studySubjectId);
        String label = studySubjectBean.getLabel();
        String eventNameValue = "";
        String eventDateValue = "";
        String crfStatus = "";
        String sdvStatus = "";
        for (Filter filter : filterSet.getFilters()) {
            if (filter.getProperty().equalsIgnoreCase("eventName")) {
                eventNameValue = filter.getValue();
                continue;
            }
            if (filter.getProperty().equalsIgnoreCase("eventDate")) {
                eventDateValue = filter.getValue();
                continue;
            }
            if (filter.getProperty().equalsIgnoreCase("crfStatus")) {
                crfStatus = filter.getValue();
                continue;
            }
            if (!filter.getProperty().equalsIgnoreCase("sdvStatusActions")) continue;
            sdvStatus = filter.getValue();
        }
        if (eventNameValue.length() > 0) {
            return eventCRFDAO.countEventCRFsByEventNameSubjectLabel(eventNameValue, label);
        }
        if (eventDateValue.length() > 0) {
            // empty if block
        }
        if (crfStatus.length() > 0) {
            // empty if block
        }
        if (sdvStatus.length() > 0) {
            // empty if block
        }
        return eventCRFDAO.countEventCRFsByStudySubject(studySubjectId, studyId, studyId);
    }

    public void setDataAndLimitVariables(TableFacade tableFacade, int studyId, HttpServletRequest request) {
        int totalRows;
        Limit limit = tableFacade.getLimit();
        EventCRFSDVFilter eventCRFSDVFilter = this.getEventCRFSDVFilter(limit, Integer.valueOf(studyId));
        String restore = request.getAttribute(limit.getId() + "_restore") + "";
        if (!limit.isComplete()) {
            totalRows = this.getTotalRowCount(eventCRFSDVFilter, Integer.valueOf(studyId));
            tableFacade.setTotalRows(totalRows);
        } else if (restore != null && "true".equalsIgnoreCase(restore)) {
            totalRows = this.getTotalRowCount(eventCRFSDVFilter, Integer.valueOf(studyId));
            int pageNum = limit.getRowSelect().getPage();
            int maxRows = limit.getRowSelect().getMaxRows();
            tableFacade.setMaxRows(maxRows);
            tableFacade.setTotalRows(totalRows);
            limit.getRowSelect().setPage(pageNum);
        }
        EventCRFSDVSort eventCRFSDVSort = this.getEventCRFSDVSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        Collection items = this.getFilteredItems(eventCRFSDVFilter, eventCRFSDVSort, rowStart, rowEnd, studyId, request);
        tableFacade.setItems(items);
    }

    public int getTotalRowCount(EventCRFSDVFilter eventCRFSDVFilter, Integer studyId) {
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        return eventCRFDAO.getCountWithFilter(studyId.intValue(), studyId.intValue(), eventCRFSDVFilter);
    }

    protected EventCRFSDVFilter getEventCRFSDVFilter(Limit limit, Integer studyId) {
        EventCRFSDVFilter eventCRFSDVFilter = new EventCRFSDVFilter(studyId);
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            eventCRFSDVFilter.addFilter(property, (Object)value);
        }
        return eventCRFSDVFilter;
    }

    protected EventCRFSDVSort getEventCRFSDVSort(Limit limit) {
        EventCRFSDVSort eventCRFSDVSort = new EventCRFSDVSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            eventCRFSDVSort.addSort(property, order);
        }
        return eventCRFSDVSort;
    }

    private Collection<SubjectSDVContainer> getFilteredItems(EventCRFSDVFilter filterSet, EventCRFSDVSort sortSet, int rowStart, int rowEnd, int studyId, HttpServletRequest request) {
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        ArrayList eventCRFBeans = new ArrayList();
        eventCRFBeans = eventCRFDAO.getWithFilterAndSort(studyId, studyId, filterSet, sortSet, rowStart, rowEnd);
        return this.getSubjectRows((List)eventCRFBeans, request);
    }

    private Collection<SubjectSDVContainer> getFilteredItemsSubject(FilterSet filterSet, SortSet sortSet, int rowStart, int rowEnd, int studyId, int studySubjectId, HttpServletRequest request) {
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        ArrayList eventCRFBeans = new ArrayList();
        String label = "";
        if (filterSet.getFilter("studySubjectId") != null) {
            label = filterSet.getFilter("studySubjectId").getValue().trim();
            eventCRFBeans = eventCRFDAO.getEventCRFsByStudySubjectLabelLimit(label, studyId, studyId, rowEnd - rowStart, rowStart);
        } else if (filterSet.getFilter("eventName") == null && filterSet.getFilter("eventDate") == null && filterSet.getFilter("crfStatus") == null && filterSet.getFilter("sdvStatusActions") == null) {
            eventCRFBeans = eventCRFDAO.getEventCRFsByStudySubjectLimit(studySubjectId, studyId, studyId, rowEnd - rowStart, rowStart);
        }
        return this.getSubjectRows(eventCRFBeans, request);
    }

    public String renderEventCRFTableWithLimit(HttpServletRequest request, int studyId, String pathPrefix) {
        boolean showMoreLink = Boolean.parseBoolean(request.getAttribute("showMoreLink") == null ? "false" : request.getAttribute("showMoreLink").toString());
        TableFacade tableFacade = TableFacadeFactory.createTableFacade((String)"sdv", (HttpServletRequest)request);
        tableFacade.setStateAttr("sdv_restore");
        this.pathPrefix = pathPrefix;
        String[] allColumns = new String[]{"sdvStatus", "studySubjectId", "studyIdentifier", "personId", "secondaryId", "eventName", "eventDate", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "sdvRequirementDefinition", "crfStatus", "lastUpdatedDate", "lastUpdatedBy", "studyEventStatus", "sdvStatusActions"};
        tableFacade.setColumnProperties(new String[]{"sdvStatus", "studySubjectId", "studyIdentifier", "personId", "secondaryId", "eventName", "eventDate", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "sdvRequirementDefinition", "crfStatus", "lastUpdatedDate", "lastUpdatedBy", "studyEventStatus", "sdvStatusActions"});
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "studySubjectStatus"), (FilterMatcher)new SubjectStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "crfStatus"), (FilterMatcher)new CrfStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "sdvStatus"), (FilterMatcher)new SdvStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "sdvRequirementDefinition"), (FilterMatcher)new SDVRequirementMatcher());
        this.setDataAndLimitVariables(tableFacade, studyId, request);
        HtmlRow row = (HtmlRow)tableFacade.getTable().getRow();
        HtmlColumn studySubjectStatus = row.getColumn("studySubjectStatus");
        studySubjectStatus.getFilterRenderer().setFilterEditor((FilterEditor)new SubjectStatusFilter());
        HtmlColumn crfStatus = row.getColumn("crfStatus");
        crfStatus.getFilterRenderer().setFilterEditor((FilterEditor)new CrfStatusFilter());
        HtmlColumn actions = row.getColumn("sdvStatusActions");
        actions.getFilterRenderer().setFilterEditor((FilterEditor)new DefaultActionsEditor(LocaleResolver.getLocale((HttpServletRequest)request)));
        HtmlColumn sdvStatus = row.getColumn("sdvStatus");
        sdvStatus.getFilterRenderer().setFilterEditor((FilterEditor)new SdvStatusFilter());
        HtmlColumn sdvRequirementDefinition = row.getColumn("sdvRequirementDefinition");
        sdvRequirementDefinition.getFilterRenderer().setFilterEditor((FilterEditor)new SDVRequirementFilter());
        this.setHtmlCellEditors(tableFacade, allColumns, true);
        this.turnOffFilters(tableFacade, new String[]{"personId", "secondaryId", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "lastUpdatedDate", "lastUpdatedBy", "eventDate", "studyEventStatus"});
        this.turnOffSorts(tableFacade, new String[]{"sdvStatus", "studySubjectId", "studyIdentifier", "personId", "secondaryId", "eventName", "eventDate", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "sdvRequirementDefinition", "crfStatus", "lastUpdatedDate", "lastUpdatedBy", "studyEventStatus", "sdvStatusActions"});
        SDVToolbar sDVToolbar = new SDVToolbar(showMoreLink);
        sDVToolbar.setMaxRowsIncrements(new int[]{15, 25, 50});
        tableFacade.setToolbar((Toolbar)sDVToolbar);
        tableFacade.setView((View)new SDVView(this, LocaleResolver.getLocale((HttpServletRequest)request), request));
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        ResourceBundle resword = ResourceBundle.getBundle("org.akaza.openclinica.i18n.words", LocaleResolver.getLocale((HttpServletRequest)request));
        String[] allTitles = new String[]{resword.getString("SDV_status"), resword.getString("study_subject_ID"), resword.getString("site_id"), resword.getString("person_ID"), resword.getString("secondary_ID"), resword.getString("event_name"), resword.getString("event_date"), resword.getString("enrollment_date"), resword.getString("subject_status"), resword.getString("CRF_name") + " / " + resword.getString("version"), resword.getString("SDV_requirement"), resword.getString("CRF_status"), resword.getString("last_updated_date"), resword.getString("last_updated_by"), resword.getString("study_event_status"), resword.getString("actions")};
        this.setTitles(allTitles, table);
        this.formatColumns(table, new String[]{"eventDate", "enrollmentDate", "lastUpdatedDate"}, request);
        table.getTableRenderer().setWidth("800");
        return tableFacade.render();
    }

    public String renderSubjectsTableWithLimit(HttpServletRequest request, int studyId, int studySubjectId) {
        TableFacade tableFacade = TableFacadeFactory.createTableFacade((String)"sdv", (HttpServletRequest)request);
        tableFacade.setStateAttr("restore");
        String[] allColumns = new String[]{"studySubjectId", "studyIdentifier", "personId", "secondaryId", "eventName", "eventDate", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "sdvRequirementDefinition", "crfStatus", "lastUpdatedDate", "lastUpdatedBy", "studyEventStatus", "sdvStatusActions"};
        tableFacade.setColumnProperties(new String[]{"studySubjectId", "studyIdentifier", "personId", "secondaryId", "eventName", "eventDate", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "sdvRequirementDefinition", "crfStatus", "lastUpdatedDate", "lastUpdatedBy", "studyEventStatus", "sdvStatusActions"});
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "studySubjectStatus"), (FilterMatcher)new SubjectStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "crfStatus"), (FilterMatcher)new CrfStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "sdvStatusActions"), (FilterMatcher)new SdvStatusMatcher());
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "sdvRequirementDefinition"), (FilterMatcher)new SDVRequirementMatcher());
        int totalRowCount = 0;
        totalRowCount = this.setDataAndLimitVariablesSubjects(tableFacade, studyId, studySubjectId, request);
        HtmlRow row = (HtmlRow)tableFacade.getTable().getRow();
        HtmlColumn studySubjectStatus = row.getColumn("studySubjectStatus");
        studySubjectStatus.getFilterRenderer().setFilterEditor((FilterEditor)new SubjectStatusFilter());
        HtmlColumn crfStatus = row.getColumn("crfStatus");
        crfStatus.getFilterRenderer().setFilterEditor((FilterEditor)new CrfStatusFilter());
        HtmlColumn sdvStatus = row.getColumn("sdvStatusActions");
        sdvStatus.getFilterRenderer().setFilterEditor((FilterEditor)new SdvStatusFilter());
        HtmlColumn sdvRequirementDefinition = row.getColumn("sdvRequirementDefinition");
        sdvRequirementDefinition.getFilterRenderer().setFilterEditor((FilterEditor)new SDVRequirementFilter());
        this.setHtmlCellEditors(tableFacade, allColumns, true);
        this.turnOffFilters(tableFacade, new String[]{"personId", "secondaryId", "enrollmentDate", "studySubjectStatus", "crfNameVersion", "lastUpdatedDate", "lastUpdatedBy"});
        SDVToolbar sDVToolbar = new SDVToolbar(true);
        sDVToolbar.setMaxRowsIncrements(new int[]{15, 50, totalRowCount});
        tableFacade.setToolbar((Toolbar)sDVToolbar);
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        ResourceBundle resword = ResourceBundle.getBundle("org.akaza.openclinica.i18n.words", LocaleResolver.getLocale((HttpServletRequest)request));
        String[] allTitles = new String[]{resword.getString("study_subject_ID"), resword.getString("site_id"), resword.getString("person_ID"), resword.getString("secondary_ID"), resword.getString("event_name"), resword.getString("event_date"), resword.getString("enrollment_date"), resword.getString("subject_status"), resword.getString("CRF_name") + " / " + resword.getString("version"), resword.getString("SDV_requirement"), resword.getString("CRF_status"), resword.getString("last_updated_date"), resword.getString("last_updated_by"), resword.getString("study_event_status"), resword.getString("SDV_status") + " / " + resword.getString("actions")};
        this.setTitles(allTitles, table);
        this.formatColumns(table, new String[]{"eventDate", "enrollmentDate", "lastUpdatedDate"}, request);
        table.getTableRenderer().setWidth("800");
        return tableFacade.render();
    }

    public void turnOffFilters(TableFacade tableFacade, String[] colNames) {
        HtmlRow row = (HtmlRow)tableFacade.getTable().getRow();
        HtmlColumn col = null;
        for (String colName : colNames) {
            col = row.getColumn(colName);
            col.setFilterable(Boolean.valueOf(false));
        }
    }

    public void turnOffSorts(TableFacade tableFacade, String[] colNames) {
        HtmlRow row = (HtmlRow)tableFacade.getTable().getRow();
        HtmlColumn col = null;
        for (String colName : colNames) {
            col = row.getColumn(colName);
            col.setSortable(Boolean.valueOf(false));
        }
    }

    public void setHtmlCellEditors(TableFacade tableFacade, String[] columnNames, boolean preventHtmlEscapes) {
        HtmlRow row = ((HtmlTable)tableFacade.getTable()).getRow();
        HtmlColumn column = null;
        for (String col : columnNames) {
            column = row.getColumn(col);
            column.getCellRenderer().setCellEditor((CellEditor)this.getCellEditorNoEscapes());
        }
    }

    public void formatColumns(HtmlTable table, String[] columnNames, HttpServletRequest request) {
        Locale locale = (Locale)ResourceBundleProvider.localeMap.get(Thread.currentThread());
        if (locale == null) {
            ResourceBundleProvider.updateLocale((Locale)LocaleResolver.getLocale((HttpServletRequest)request));
        }
        ResourceBundle bundle = ResourceBundleProvider.getFormatBundle();
        String format = bundle.getString("date_time_format_string");
        HtmlRow row = table.getRow();
        HtmlColumn column = null;
        for (String colName : columnNames) {
            column = row.getColumn(colName);
            if (column == null) continue;
            column.getCellRenderer().setCellEditor((CellEditor)new DateCellEditor(format));
        }
    }

    public Collection<SubjectSDVContainer> getSubjectRows(List<EventCRFBean> eventCRFBeans, HttpServletRequest request) {
        if (eventCRFBeans == null || eventCRFBeans.isEmpty()) {
            return new ArrayList<SubjectSDVContainer>();
        }
        this.getEventNamesForEventCRFs(eventCRFBeans);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        SubjectDAO subjectDAO = new SubjectDAO(this.dataSource);
        StudyDAO studyDAO = new StudyDAO(this.dataSource);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        EventDefinitionCRFDAO eventDefinitionCRFDAO = new EventDefinitionCRFDAO(this.dataSource);
        StudySubjectBean studySubjectBean = null;
        SubjectBean subjectBean = null;
        StudyEventBean studyEventBean = null;
        StudyBean studyBean = null;
        EventDefinitionCRFBean eventDefinitionCRFBean = null;
        ArrayList<SubjectSDVContainer> allRows = new ArrayList<SubjectSDVContainer>();
        SubjectSDVContainer tempSDVBean = null;
        StringBuilder actions = new StringBuilder("");
        for (EventCRFBean crfBean : eventCRFBeans) {
            tempSDVBean = new SubjectSDVContainer();
            studySubjectBean = studySubjectDAO.findByPK(crfBean.getStudySubjectId());
            studyEventBean = studyEventDAO.findByPK(crfBean.getStudyEventId());
            subjectBean = subjectDAO.findByPK(studySubjectBean.getSubjectId());
            studyBean = studyDAO.findByPK(studySubjectBean.getStudyId());
            tempSDVBean.setStudyIdentifier(studyBean.getIdentifier());
            eventDefinitionCRFBean = eventDefinitionCRFDAO.findByStudyEventIdAndCRFVersionId(studyBean, studyEventBean.getId(), crfBean.getCRFVersionId());
            SourceDataVerification sourceData = eventDefinitionCRFBean.getSourceDataVerification();
            if (sourceData != null) {
                tempSDVBean.setSdvRequirementDefinition(sourceData.toString());
            } else {
                tempSDVBean.setSdvRequirementDefinition("");
            }
            tempSDVBean.setCrfNameVersion(this.getCRFName(crfBean.getCRFVersionId()) + "/ " + this.getCRFVersionName(crfBean.getCRFVersionId()));
            if (crfBean.getStatus() != null) {
                Integer status = crfBean.getStage().getId();
                if (studyEventBean.getSubjectEventStatus() == SubjectEventStatus.LOCKED || studyEventBean.getSubjectEventStatus() == SubjectEventStatus.STOPPED || studyEventBean.getSubjectEventStatus() == SubjectEventStatus.SKIPPED) {
                    status = DataEntryStage.LOCKED.getId();
                }
                tempSDVBean.setCrfStatus(this.getCRFStatusIconPath(status.intValue(), request, studySubjectBean.getId(), crfBean.getId(), crfBean.getCRFVersionId()));
            }
            tempSDVBean.setStudyEventStatus(studyEventBean.getStatus().getName());
            Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
            SimpleDateFormat sdformat = I18nFormatUtil.getDateFormat((Locale)locale);
            if (studySubjectBean.getEnrollmentDate() != null) {
                tempSDVBean.setEnrollmentDate(sdformat.format(studySubjectBean.getEnrollmentDate()));
            }
            StudyEventDAO sedao = new StudyEventDAO(this.dataSource);
            StudyEventBean seBean = sedao.findByPK(crfBean.getStudyEventId());
            tempSDVBean.setEventDate(sdformat.format(seBean.getDateStarted()));
            tempSDVBean.setEventName(crfBean.getEventName());
            StringBuilder sdvStatus = new StringBuilder("");
            if (crfBean.isSdvStatus() && studyBean.getStatus().isLocked()) {
                sdvStatus.append(this.getIconForSdvStatusPrefix()).append("DoubleCheck").append(ICON_FORCRFSTATUS_SUFFIX).append("</a></center>");
            } else if (crfBean.isSdvStatus() && !studyBean.getStatus().isLocked()) {
                sdvStatus.append("<center><a href='javascript:void(0)' onclick='prompt(document.sdvForm,");
                sdvStatus.append(crfBean.getId());
                sdvStatus.append(")'>");
                sdvStatus.append(this.getIconForSdvStatusPrefix()).append("DoubleCheck").append(ICON_FORCRFSTATUS_SUFFIX).append("</a></center>");
            } else {
                sdvStatus.append("<center><input style='margin-right: 5px' type='checkbox' ").append("class='sdvCheck'").append(" name='").append(CHECKBOX_NAME).append(crfBean.getId()).append("' /></center>");
            }
            tempSDVBean.setSdvStatus(sdvStatus.toString());
            tempSDVBean.setStudySubjectId(studySubjectBean.getLabel());
            if (subjectBean != null) {
                tempSDVBean.setPersonId(subjectBean.getUniqueIdentifier());
            } else {
                tempSDVBean.setPersonId("");
            }
            tempSDVBean.setSecondaryId(studySubjectBean.getSecondaryLabel());
            String statusName = studySubjectBean.getStatus().getName();
            if (statusName != null) {
                tempSDVBean.setStudySubjectStatus(statusName);
            }
            if (crfBean.getUpdatedDate() != null) {
                tempSDVBean.setLastUpdatedDate(sdformat.format(crfBean.getUpdatedDate()));
            } else {
                tempSDVBean.setLastUpdatedDate("unknown");
            }
            if (crfBean.getUpdater() != null) {
                tempSDVBean.setLastUpdatedBy(crfBean.getUpdater().getFirstName() + " " + crfBean.getUpdater().getLastName());
            }
            actions = new StringBuilder("");
            if (!crfBean.isSdvStatus()) {
                StringBuilder jsCodeString = new StringBuilder("this.form.method='GET'; this.form.action='").append(request.getContextPath()).append("/pages/handleSDVGet").append("';").append("this.form.crfId.value='").append(crfBean.getId()).append("';").append("this.form.submit();");
                if (!studyBean.getStatus().isLocked()) {
                    actions.append("<input type=\"submit\" class=\"button_medium\" value=\"SDV\" name=\"sdvSubmit\" ").append("onclick=\"").append(jsCodeString.toString()).append("\" />");
                }
            }
            tempSDVBean.setSdvStatusActions(actions.toString());
            allRows.add(tempSDVBean);
        }
        return allRows;
    }

    private String getCRFStatusIconPath(int statusId, HttpServletRequest request, int studySubjectId, int eventDefinitionCRFId, int crfVersionId) {
        HtmlBuilder html = new HtmlBuilder();
        html.a().onclick("openDocWindow('" + request.getContextPath() + "/ViewSectionDataEntry?eventDefinitionCRFId=&ecId=" + eventDefinitionCRFId + "&tabId=1&studySubjectId=" + studySubjectId + "');");
        html.href("#").close();
        StringBuilder builderHref = new StringBuilder("<a href='javascript:void(0)' onclick=\"");
        builderHref.append("document.location.href='").append(request.getContextPath()).append("/");
        builderHref.append("ViewSectionDataEntry?eventDefinitionCRFId=").append(eventDefinitionCRFId);
        builderHref.append("&crfVersionId=").append(crfVersionId).append("&tabId=1&studySubjectId=").append(studySubjectId).append("'\">");
        StringBuilder builder = new StringBuilder(html.toString()).append(this.getIconForCrfStatusPrefix());
        StringBuilder input = new StringBuilder("<input type=\"hidden\" statusId=\"");
        input.append(statusId).append("\" />");
        if (statusId > 0 && statusId < 8) {
            builder.append((String)CRF_STATUS_ICONS.get(statusId));
        } else {
            builder.append((String)CRF_STATUS_ICONS.get(0));
        }
        builder.append(ICON_FORCRFSTATUS_SUFFIX);
        builder.append("</a>");
        builder.append(" ");
        builder.append(input.toString());
        return builder.toString();
    }

    public List<Integer> getListOfSdvEventCRFIds(Collection<String> paramsContainingIds) {
        ArrayList<Integer> eventCRFWithSDV = new ArrayList<Integer>();
        if (paramsContainingIds == null || paramsContainingIds.isEmpty()) {
            return eventCRFWithSDV;
        }
        for (String param : paramsContainingIds) {
            int tmpInt = this.stripPrefixFromParam(param);
            if (tmpInt == 0) continue;
            eventCRFWithSDV.add(tmpInt);
        }
        return eventCRFWithSDV;
    }

    private int stripPrefixFromParam(String param) {
        if (param != null && param.contains(CHECKBOX_NAME)) {
            return Integer.parseInt(param.substring(param.indexOf("_") + 1));
        }
        return 0;
    }

    public List<Integer> getListOfStudySubjectIds(Set<String> paramsContainingIds) {
        ArrayList<Integer> studySubjectIds = new ArrayList<Integer>();
        if (paramsContainingIds == null || paramsContainingIds.isEmpty()) {
            return studySubjectIds;
        }
        for (String param : paramsContainingIds) {
            int tmpInt = this.stripPrefixFromParam(param);
            if (tmpInt == 0) continue;
            studySubjectIds.add(tmpInt);
        }
        return studySubjectIds;
    }

    public Collection<SubjectSDVContainer> getSubjectAggregateRows(List<StudySubjectBean> studySubjectBeans) {
        if (studySubjectBeans == null || studySubjectBeans.isEmpty()) {
            return new ArrayList<SubjectSDVContainer>();
        }
        ArrayList<SubjectSDVContainer> allRows = new ArrayList<SubjectSDVContainer>();
        SubjectSDVContainer tempSDVBean = null;
        tempSDVBean = new SubjectSDVContainer();
        String firstRowActions = "Select All <input type=checkbox name='checkAll' onclick='selectAllChecks(this.form)'/>";
        tempSDVBean.setSdvStatusActions(firstRowActions);
        allRows.add(tempSDVBean);
        for (StudySubjectBean studySubjectBean : studySubjectBeans) {
            tempSDVBean = new SubjectSDVContainer();
            tempSDVBean.setStudySubjectId(studySubjectBean.getId() + "");
            tempSDVBean.setStudySubjectStatus("subject status");
            tempSDVBean.setNumberOfCRFsSDV("0");
            tempSDVBean.setPercentageOfCRFsSDV("0");
            tempSDVBean.setGroup("group");
            StringBuilder actions = new StringBuilder("<input class='sdvCheckbox' type='checkbox' name=");
            actions.append("'sdvCheck").append(studySubjectBean.getId()).append("'/>&nbsp;&nbsp");
            actions.append(VIEW_ICON_FORSUBJECT_PREFIX).append(studySubjectBean.getId()).append(this.getIconForSubjectSufix());
            tempSDVBean.setSdvStatusActions(actions.toString());
            allRows.add(tempSDVBean);
        }
        return allRows;
    }

    public void getEventNamesForEventCRFs(List<EventCRFBean> eventCRFBeans) {
        if (eventCRFBeans == null || eventCRFBeans.isEmpty()) {
            return;
        }
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.dataSource);
        StudyEventBean studyEventBean = null;
        StudyEventDefinitionBean studyEventDefBean = null;
        for (EventCRFBean eventCRFBean : eventCRFBeans) {
            if (!"".equalsIgnoreCase(eventCRFBean.getEventName())) continue;
            studyEventBean = studyEventDAO.findByPK(eventCRFBean.getStudyEventId());
            studyEventDefBean = studyEventDefinitionDAO.findByPK(studyEventBean.getStudyEventDefinitionId());
            eventCRFBean.setEventName(studyEventDefBean.getName() + "(" + studyEventBean.getSampleOrdinal() + ")");
        }
    }

    public void setTitles(String[] allTitles, HtmlTable table) {
        HtmlRow row = table.getRow();
        HtmlColumn tempColumn = null;
        for (int i = 0; i < allTitles.length; ++i) {
            tempColumn = row.getColumn(i);
            tempColumn.setTitle(allTitles[i]);
        }
    }

    public String getCRFName(int crfVersionId) {
        CRFBean crfBean;
        CRFVersionDAO cRFVersionDAO = new CRFVersionDAO(this.dataSource);
        CRFDAO cRFDAO = new CRFDAO(this.dataSource);
        CRFVersionBean versionBean = cRFVersionDAO.findByPK(crfVersionId);
        if (versionBean != null && (crfBean = cRFDAO.findByPK(versionBean.getCrfId())) != null) {
            return crfBean.getName();
        }
        return "";
    }

    public String getCRFVersionName(int crfVersionId) {
        CRFVersionDAO cRFVersionDAO = new CRFVersionDAO(this.dataSource);
        CRFVersionBean versionBean = cRFVersionDAO.findByPK(crfVersionId);
        if (versionBean != null) {
            return versionBean.getName();
        }
        return "";
    }

    public List<EventCRFBean> getAllEventCRFs(List<StudyEventBean> studyEventBeans) {
        ArrayList eventCRFBeans = new ArrayList();
        ArrayList<EventCRFBean> studyEventCRFBeans = new ArrayList<EventCRFBean>();
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        for (StudyEventBean studyEventBean : studyEventBeans) {
            eventCRFBeans = eventCRFDAO.findAllByStudyEvent(studyEventBean);
            if (eventCRFBeans == null || eventCRFBeans.isEmpty()) continue;
            studyEventCRFBeans.addAll(eventCRFBeans);
        }
        return studyEventCRFBeans;
    }

    public String renderSubjectsAggregateTable(int studyId, HttpServletRequest request) {
        ArrayList studySubjectBeans = new ArrayList();
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        studySubjectBeans = studySubjectDAO.findAllByStudyId(studyId);
        Collection items = this.getSubjectAggregateRows((List)studySubjectBeans);
        int totalRowCount = 0;
        if (items != null && items.size() > 0) {
            totalRowCount = items.size();
        }
        TableFacade tableFacade = TableFacadeFactory.createTableFacade((String)"sdv", (HttpServletRequest)request);
        if (totalRowCount > 1) {
            tableFacade.setMaxRowsIncrements(new int[]{15, 50, totalRowCount});
        }
        tableFacade.setColumnProperties(new String[]{"studySubjectId", "studySubjectStatus", "numberOfCRFsSDV", "percentageOfCRFsSDV", "group", "sdvStatusActions"});
        tableFacade.setItems(items);
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        ResourceBundle resword = ResourceBundle.getBundle("org.akaza.openclinica.i18n.words", LocaleResolver.getLocale((HttpServletRequest)request));
        String[] allTitles = new String[]{resword.getString("study_subject_ID"), resword.getString("study_subject_status"), resword.getString("num_CRFs_SDV"), resword.getString("porc_CRFs_SDV"), resword.getString("group")};
        this.setTitles(allTitles, table);
        table.getTableRenderer().setWidth("800");
        return tableFacade.render();
    }

    public boolean setSDVStatusForStudySubjects(List<Integer> studySubjectIds, int userId, boolean setVerification) {
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        EventDefinitionCRFDAO eventDefinitionCrfDAO = new EventDefinitionCRFDAO(this.dataSource);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        CRFDAO crfDAO = new CRFDAO(this.dataSource);
        if (studySubjectIds == null || studySubjectIds.isEmpty()) {
            return true;
        }
        for (Integer studySubjectId : studySubjectIds) {
            ArrayList eventCrfs = eventCRFDAO.getEventCRFsByStudySubjectCompleteOrLocked(studySubjectId.intValue());
            StudySubjectBean studySubject = studySubjectDAO.findByPK(studySubjectId.intValue());
            for (EventCRFBean eventCRFBean : eventCrfs) {
                CRFBean crfBean = crfDAO.findByVersionId(eventCRFBean.getCRFVersionId());
                StudyEventBean studyEvent = studyEventDAO.findByPK(eventCRFBean.getStudyEventId());
                EventDefinitionCRFBean eventDefinitionCrf = eventDefinitionCrfDAO.findByStudyEventDefinitionIdAndCRFIdAndStudyId(studyEvent.getStudyEventDefinitionId(), crfBean.getId(), studySubject.getStudyId());
                if (eventDefinitionCrf.getId() == 0) {
                    eventDefinitionCrf = eventDefinitionCrfDAO.findForStudyByStudyEventDefinitionIdAndCRFId(studyEvent.getStudyEventDefinitionId(), crfBean.getId());
                }
                if (eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.AllREQUIRED && eventDefinitionCrf.getSourceDataVerification() != SourceDataVerification.PARTIALREQUIRED) continue;
                try {
                    eventCRFDAO.setSDVStatus(setVerification, userId, eventCRFBean.getId());
                }
                catch (Exception exc) {
                    return false;
                }
            }
            studySubjectDAO.update(studySubject);
        }
        return true;
    }

    public boolean setSDVerified(List<Integer> eventCRFIds, int userId, boolean setVerification) {
        if (eventCRFIds == null || eventCRFIds.isEmpty()) {
            return true;
        }
        EventCRFDAO eventCRFDAO = new EventCRFDAO(this.dataSource);
        for (Integer eventCrfId : eventCRFIds) {
            try {
                eventCRFDAO.setSDVStatus(setVerification, userId, eventCrfId.intValue());
            }
            catch (Exception exc) {
                return false;
            }
        }
        return true;
    }

    public void forwardRequestFromController(HttpServletRequest request, HttpServletResponse response, String path) {
        try {
            request.getRequestDispatcher(path).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            logger.error("Error while forwarding to other location: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while forwarding to other location: ", (Throwable)e);
        }
    }

    public void prepareSDVSelectElements(HttpServletRequest request, StudyBean studyBean) {
        ArrayList<String> studyEventStatuses = new ArrayList<String>();
        for (org.akaza.openclinica.domain.Status stat : org.akaza.openclinica.domain.Status.values()) {
            studyEventStatuses.add(stat.getDescription());
        }
        request.setAttribute("studyEventStatuses", studyEventStatuses);
        ArrayList<String> sdvRequirements = new ArrayList<String>();
        for (SourceDataVerification sdvRequire : SourceDataVerification.values()) {
            sdvRequirements.add(sdvRequire.getDescription());
        }
        request.setAttribute("sdvRequirements", (Object)SourceDataVerification.values());
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.dataSource);
        ArrayList studyEventDefinitionBeans = new ArrayList();
        studyEventDefinitionBeans = studyEventDefinitionDAO.findAllByStudy(studyBean);
        request.setAttribute("studyEventDefinitions", (Object)studyEventDefinitionBeans);
        request.setAttribute("studyEventStatuses", (Object)Status.toArrayList());
        request.setAttribute("eventCRFDStatuses", (Object)SubjectEventStatus.toArrayList());
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        ArrayList studyEventBeans = studyEventDAO.findAllByStudy(studyBean);
        List eventCRFBeans = this.getAllEventCRFs((List)studyEventBeans);
        TreeSet<String> eventCRFNames = new TreeSet<String>();
        for (EventCRFBean bean : eventCRFBeans) {
            eventCRFNames.add(this.getCRFName(bean.getCRFVersionId()));
        }
        request.setAttribute("eventCRFNames", eventCRFNames);
    }

    public List<EventCRFBean> filterEventCRFs(List<EventCRFBean> eventCRFBeans, BindingResult bindingResult) {
        ArrayList<EventCRFBean> newList = new ArrayList<EventCRFBean>();
        if (eventCRFBeans == null || eventCRFBeans.isEmpty() || bindingResult == null) {
            return eventCRFBeans;
        }
        SdvFilterDataBean filterBean = (SdvFilterDataBean)bindingResult.getTarget();
        StudySubjectBean studySubjectBean = null;
        StudyEventBean studyEventBean = null;
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO(this.dataSource);
        StudyEventDAO studyEventDAO = new StudyEventDAO(this.dataSource);
        boolean studySub = true;
        boolean studyEventDef = true;
        boolean studyEventStatus = true;
        boolean eventCRFStatusBool = true;
        boolean eventcrfSDVStatus = true;
        boolean eventCRFNameBool = true;
        boolean upDatedDateBool = true;
        for (EventCRFBean eventCBean : eventCRFBeans) {
            if (filterBean.getStudy_subject_id().length() > 0) {
                studySubjectBean = studySubjectDAO.findByPK(eventCBean.getStudySubjectId());
                studySub = filterBean.getStudy_subject_id().equalsIgnoreCase(studySubjectBean.getLabel());
            }
            if (filterBean.getStudyEventDefinition() > 0) {
                studyEventBean = studyEventDAO.findByPK(eventCBean.getStudyEventId());
                boolean bl = studyEventDef = filterBean.getStudyEventDefinition() == studyEventBean.getStudyEventDefinitionId();
            }
            if (filterBean.getStudyEventStatus() > 0) {
                boolean bl = studyEventStatus = filterBean.getStudyEventStatus() == eventCBean.getStatus().getId();
            }
            if (filterBean.getEventCRFStatus() > 0) {
                studyEventBean = studyEventDAO.findByPK(eventCBean.getStudyEventId());
                boolean bl = eventCRFStatusBool = filterBean.getEventCRFStatus() == studyEventBean.getSubjectEventStatus().getId();
            }
            if (!filterBean.getEventcrfSDVStatus().equalsIgnoreCase("N/A")) {
                boolean sdvBool = filterBean.getEventcrfSDVStatus().equalsIgnoreCase("complete");
                boolean bl = eventcrfSDVStatus = eventCBean.isSdvStatus() == sdvBool;
            }
            if (filterBean.getEventCRFName().length() > 0) {
                String tmpName = this.getCRFName(eventCBean.getCRFVersionId());
                eventCRFNameBool = tmpName.equalsIgnoreCase(filterBean.getEventCRFName());
            }
            if (eventCBean.getUpdatedDate() != null && filterBean.getStartUpdatedDate() != null && filterBean.getEndDate() != null) {
                GregorianCalendar calStart = new GregorianCalendar();
                calStart.setTime(filterBean.getStartUpdatedDate());
                GregorianCalendar calendarEnd = new GregorianCalendar();
                calendarEnd.setTime(filterBean.getEndDate());
                GregorianCalendar calendarNow = new GregorianCalendar();
                calendarNow.setTime(eventCBean.getUpdatedDate());
                boolean bl = upDatedDateBool = calendarNow.after(calStart) && calendarNow.before(calendarEnd) || calendarNow.equals(calStart) || calendarNow.equals(calendarEnd);
            }
            if (!upDatedDateBool || !eventCRFNameBool || !eventcrfSDVStatus || !eventCRFStatusBool || !studyEventStatus || !studyEventDef || !studySub) continue;
            newList.add(eventCBean);
        }
        return newList;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    static {
        SUBJECT_EVENT_STATUS_ICONS.put(0, "Invalid");
        SUBJECT_EVENT_STATUS_ICONS.put(1, "Scheduled");
        SUBJECT_EVENT_STATUS_ICONS.put(2, "NotStarted");
        SUBJECT_EVENT_STATUS_ICONS.put(3, "InitialDE");
        SUBJECT_EVENT_STATUS_ICONS.put(4, "DEcomplete");
        SUBJECT_EVENT_STATUS_ICONS.put(5, "Stopped");
        SUBJECT_EVENT_STATUS_ICONS.put(6, "Skipped");
        SUBJECT_EVENT_STATUS_ICONS.put(7, "Locked");
        SUBJECT_EVENT_STATUS_ICONS.put(8, "Signed");
        CRF_STATUS_ICONS.put(0, "Invalid");
        CRF_STATUS_ICONS.put(1, "NotStarted");
        CRF_STATUS_ICONS.put(2, "InitialDE");
        CRF_STATUS_ICONS.put(3, "InitialDEComplete");
        CRF_STATUS_ICONS.put(4, "DDE");
        CRF_STATUS_ICONS.put(5, "DEcomplete");
        CRF_STATUS_ICONS.put(6, "InitialDE");
        CRF_STATUS_ICONS.put(7, "Locked");
    }
}

