/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.control.XmlView;
import org.akaza.openclinica.control.XmlViewExporter;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.jmesa.core.CoreContext;
import org.jmesa.facade.TableFacadeImpl;
import org.jmesa.limit.ExportType;
import org.jmesa.view.View;
import org.jmesa.view.csv.CsvViewExporter;
import org.jmesa.view.excel.ExcelViewExporter;

public class OCTableFacadeImpl
extends TableFacadeImpl {
    private final HttpServletResponse response;
    private final HttpServletRequest request;
    private final String fileName;

    public OCTableFacadeImpl(String id, HttpServletRequest request, HttpServletResponse response, String fileName) {
        super(id, request);
        this.response = response;
        this.fileName = fileName + System.currentTimeMillis();
        this.request = request;
    }

    protected View getExportView(ExportType exportType) {
        if (exportType == ExportType.PDF) {
            return new XmlView(this.getTable(), this.getCoreContext());
        }
        return super.getExportView(exportType);
    }

    protected void renderExport(ExportType exportType, View view) {
        try {
            CoreContext cc = this.getCoreContext();
            if (exportType == ExportType.CSV) {
                new CsvViewExporter(view, cc, this.response, this.fileName + ".txt").export();
            } else if (exportType == ExportType.EXCEL) {
                new ExcelViewExporter(view, cc, this.response, this.fileName + ".xls").export();
            } else if (exportType == ExportType.PDF) {
                new XmlViewExporter(view, cc, this.request, this.response).export();
            } else {
                super.renderExport(exportType, view);
            }
        }
        catch (Exception e) {
            throw new OpenClinicaSystemException((Throwable)e);
        }
    }
}

