/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.HashMap;
import javax.servlet.ServletContext;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.hibernate.ConfigurationDao;
import org.akaza.openclinica.dao.hibernate.PasswordRequirementsDao;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ConfigurePasswordRequirementsServlet
extends SecureController {
    private static final long serialVersionUID = 2729725318725545575L;

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        ConfigurationDao configurationDao = (ConfigurationDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(ConfigurationDao.class);
        PasswordRequirementsDao passwordRequirementsDao = new PasswordRequirementsDao(configurationDao);
        if (!fp.isSubmitted()) {
            this.setPresetValues(new HashMap(passwordRequirementsDao.configs()));
            this.forwardPage(Page.CONFIGURATION_PASSWORD_REQUIREMENTS);
        } else {
            Validator v = new Validator(this.request);
            for (String key : passwordRequirementsDao.intConfigKeys()) {
                v.addValidation(key, 10);
            }
            HashMap errors = v.validate();
            int minChars = fp.getInt("pwd.chars.min");
            int maxChars = fp.getInt("pwd.chars.max");
            if (minChars > 0 && maxChars > 0 && maxChars < minChars) {
                Validator.addError((HashMap)errors, (String)"pwd.chars.min", (String)resexception.getString("pwd_min_greater_than_max"));
            }
            if (errors.isEmpty()) {
                passwordRequirementsDao.setHasLower(Boolean.valueOf(fp.getString("pwd.chars.case.lower")).booleanValue());
                passwordRequirementsDao.setHasUpper(Boolean.valueOf(fp.getString("pwd.chars.case.upper")).booleanValue());
                passwordRequirementsDao.setHasDigits(Boolean.valueOf(fp.getString("pwd.chars.digits")).booleanValue());
                passwordRequirementsDao.setHasSpecials(Boolean.valueOf(fp.getString("pwd.chars.specials")).booleanValue());
                passwordRequirementsDao.setMinLength(fp.getInt("pwd.chars.min"));
                passwordRequirementsDao.setMaxLength(fp.getInt("pwd.chars.max"));
                passwordRequirementsDao.setExpirationDays(fp.getInt("pwd.expiration.days"));
                passwordRequirementsDao.setChangeRequired(fp.getInt("pwd.change.required"));
                this.addPageMessage(respage.getString("password_req_changes_have_been_saved"));
                this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
            } else {
                this.setPresetValues(this.submittedValues(passwordRequirementsDao, fp));
                this.setInputMessages(errors);
                this.forwardPage(Page.CONFIGURATION_PASSWORD_REQUIREMENTS);
            }
        }
    }

    private HashMap<String, Object> submittedValues(PasswordRequirementsDao passwordRequirementsDao, FormProcessor fp) {
        String val;
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (String key : passwordRequirementsDao.boolConfigKeys()) {
            val = fp.getString(key);
            if (val == null) continue;
            values.put(key, Boolean.valueOf(val));
        }
        for (String key : passwordRequirementsDao.intConfigKeys()) {
            val = fp.getString(key);
            if (val == null) continue;
            values.put(key, val);
        }
        return values;
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

