/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.HashMap;
import javax.servlet.ServletContext;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.hibernate.ConfigurationDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.technicaladmin.ConfigurationBean;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ConfigureServlet
extends SecureController {
    private static final long serialVersionUID = 2729725318725545575L;
    private ConfigurationDao configurationDao;

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        if (!fp.isSubmitted()) {
            this.loadPresetValuesFromBean(fp);
            this.setPresetValues(fp.getPresetValues());
            this.forwardPage(Page.CONFIGURATION);
        } else {
            Validator v = new Validator(this.request);
            v.addValidation("lockcount", 10);
            v.addValidation("lockcount", 1);
            v.addValidation("lockcount", 3, 1, 25);
            HashMap errors = v.validate();
            if (!errors.isEmpty()) {
                this.loadPresetValuesFromForm(fp);
                this.setPresetValues(fp.getPresetValues());
                this.setInputMessages(errors);
                this.forwardPage(Page.CONFIGURATION);
            } else {
                ConfigurationBean userLockSwitch = this.getConfigurationDao().findByKey("user.lock.switch");
                ConfigurationBean userLockAllowedFailedConsecutiveLoginAttempts = this.getConfigurationDao().findByKey("user.lock.allowedFailedConsecutiveLoginAttempts");
                userLockSwitch.setValue(fp.getString("lockswitch"));
                userLockAllowedFailedConsecutiveLoginAttempts.setValue(fp.getString("lockcount"));
                this.getConfigurationDao().saveOrUpdate((DomainObject)userLockSwitch);
                this.getConfigurationDao().saveOrUpdate((DomainObject)userLockAllowedFailedConsecutiveLoginAttempts);
                this.addPageMessage(respage.getString("lockout_changes_have_been_saved"));
                this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
            }
        }
    }

    private void loadPresetValuesFromBean(FormProcessor fp) {
        ConfigurationBean userLockSwitch = this.getConfigurationDao().findByKey("user.lock.switch");
        ConfigurationBean userLockAllowedFailedConsecutiveLoginAttempts = this.getConfigurationDao().findByKey("user.lock.allowedFailedConsecutiveLoginAttempts");
        fp.addPresetValue("lockswitch", userLockSwitch.getValue());
        fp.addPresetValue("lockcount", userLockAllowedFailedConsecutiveLoginAttempts.getValue());
    }

    private void loadPresetValuesFromForm(FormProcessor fp) {
        fp.clearPresetValues();
        String[] textFields = new String[]{"lockswitch", "lockcount"};
        fp.setCurrentStringValuesAsPreset(textFields);
    }

    public ConfigurationDao getConfigurationDao() {
        this.configurationDao = this.configurationDao != null ? this.configurationDao : (ConfigurationDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("configurationDao");
        return this.configurationDao;
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

