/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class DownloadVersionSpreadSheetServlet
extends SecureController {
    private static final long serialVersionUID = 6969545356468114843L;
    private static final int BUFFER_SIZE = 4096;
    public static String CRF_ID = "crfId";
    public static String CRF_VERSION_ID = "crfVersionId";
    public static String CRF_VERSION_TEMPLATE = "CRF_Template_lc_v1.0.xls";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MANAGE_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        File excelFile;
        String excelFileName;
        FormProcessor fp = new FormProcessor(this.request);
        String crfIdString = fp.getString(CRF_ID);
        int crfVersionId = fp.getInt(CRF_VERSION_ID);
        boolean isTemplate = fp.getBoolean("template");
        if (isTemplate) {
            String originalCrfRelDir = "crf" + File.separator + "original" + File.separator;
            excelFileName = CRF_VERSION_TEMPLATE;
            excelFile = this.getCoreResources().getFile(excelFileName, originalCrfRelDir);
        } else {
            CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFVersionBean version = cvdao.findByPK(crfVersionId);
            String newCrfRelDir = "crf" + File.separator + "new" + File.separator;
            excelFileName = crfIdString + version.getOid() + ".xls";
            excelFile = this.getCoreResources().getFile(excelFileName, newCrfRelDir);
            String oldExcelFileName = crfIdString + version.getName() + ".xls";
            File oldExcelFile = this.getCoreResources().getFile(oldExcelFileName, newCrfRelDir);
            if (oldExcelFile != null && oldExcelFile.exists() && oldExcelFile.length() > 0L && (excelFile == null || !excelFile.exists() || excelFile.length() <= 0L)) {
                excelFile = oldExcelFile;
                excelFileName = oldExcelFileName;
            }
        }
        logger.info("looking for : " + excelFileName);
        if (excelFile == null || !excelFile.exists() || excelFile.length() <= 0L) {
            this.addPageMessage(respage.getString("the_excel_is_not_available_on_server_contact"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            this.response.setHeader("Content-disposition", "attachment; filename=\"" + excelFileName + "\";");
            this.response.setContentType("application/vnd.ms-excel");
            this.response.setHeader("Pragma", "public");
            this.response.setContentLength((int)excelFile.length());
            try (InputStream in = Files.newInputStream(excelFile.toPath(), new OpenOption[0]);){
                int length;
                ServletOutputStream out = this.response.getOutputStream();
                byte[] buffer = new byte[4096];
                while ((length = in.read(buffer)) > 0) {
                    out.write(buffer, 0, length);
                }
            }
            catch (Exception ee) {
                logger.error("Input Stream is not working properly: ", (Throwable)ee);
            }
        }
    }

    private CoreResources getCoreResources() {
        return (CoreResources)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("coreResources");
    }
}

