/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class InitCreateCRFVersionServlet
extends SecureController {
    private static final long serialVersionUID = -628838222201677748L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (!this.request.getParameter("module").equals("admin") && (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR))) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        String idString = this.request.getParameter("crfId");
        String name = this.request.getParameter("name");
        logger.info("*** ^^^ *** crf id:" + idString);
        String module = this.request.getParameter("module");
        this.request.setAttribute("module", (Object)module);
        this.session.setAttribute("xformEnabled", (Object)CoreResources.getField((String)"xform.enabled"));
        if (idString == null || idString.trim().isEmpty() || name == null || name.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_add_new_version_for"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            int crfId = Integer.valueOf(idString.trim());
            CRFVersionBean version = new CRFVersionBean();
            version.setCrfId(crfId);
            this.session.setAttribute("version", (Object)version);
            this.request.setAttribute("crfName", (Object)name);
            this.request.setAttribute("CrfId", (Object)new Integer(crfId));
            this.forwardPage(Page.CREATE_CRF_VERSION);
        }
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

