/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.admin.ListSubjectTableFactory;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.ListSubjectFilter;
import org.akaza.openclinica.dao.submit.ListSubjectSort;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.DateCellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;

public class ListSubjectTableFactory
extends AbstractTableFactory {
    private StudySubjectDAO studySubjectDao;
    private UserAccountDAO userAccountDao;
    private StudyDAO studyDao;
    private SubjectDAO subjectDao;
    private StudyBean currentStudy;
    private ResourceBundle resword;
    private ResourceBundle resformat;

    protected String getTableName() {
        return "listSubjects";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"subject.uniqueIdentifier", "studySubjectIdAndStudy", "subject.gender", "subject.createdDate", "subject.owner", "subject.updatedDate", "subject.updater", "subject.status", "actions"});
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("subject.uniqueIdentifier"), this.resword.getString("person_ID"), null, null);
        this.configureColumn(row.getColumn("studySubjectIdAndStudy"), this.resword.getString("Protocol_Study_subject_IDs"), null, null, true, false);
        this.configureColumn(row.getColumn("subject.gender"), this.resword.getString("gender"), null, null);
        this.configureColumn(row.getColumn("subject.createdDate"), this.resword.getString("date_created"), (CellEditor)new DateCellEditor(this.getDateFormat()), null);
        this.configureColumn(row.getColumn("subject.owner"), this.resword.getString("owner"), (CellEditor)new OwnerCellEditor(this, null), null, false, false);
        this.configureColumn(row.getColumn("subject.updatedDate"), this.resword.getString("date_updated"), (CellEditor)new DateCellEditor(this.getDateFormat()), null);
        this.configureColumn(row.getColumn("subject.updater"), this.resword.getString("last_updated_by"), (CellEditor)new UpdaterCellEditor(this, null), null, false, false);
        this.configureColumn(row.getColumn("subject.status"), this.resword.getString("status"), (CellEditor)new StatusCellEditor(this, null), (FilterEditor)new StatusDroplistFilterEditor(this, null));
        this.configureColumn(row.getColumn("actions"), this.resword.getString("actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;", (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Status.class, "subject.status"), (FilterMatcher)new StatusFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(UserAccountBean.class, "subject.owner"), (FilterMatcher)new GenericFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(UserAccountBean.class, "subject.updater"), (FilterMatcher)new GenericFilterMatcher(this, null));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)this.getLocale());
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)this.getLocale());
        Limit limit = tableFacade.getLimit();
        ListSubjectFilter listSubjectFilter = this.getListSubjectFilter(limit);
        if (!limit.isComplete()) {
            Integer totalRows = this.getSubjectDao().getCountWithFilter(listSubjectFilter, this.getCurrentStudy());
            if (totalRows == null) {
                totalRows = 0;
            }
            tableFacade.setTotalRows(totalRows.intValue());
        }
        ListSubjectSort listSubjectSort = this.getListSubjectSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getSubjectDao().getWithFilterAndSort(this.getCurrentStudy(), listSubjectFilter, listSubjectSort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        for (SubjectBean subject : items) {
            UserAccountBean owner = this.getUserAccountDao().findByPK(subject.getOwnerId());
            UserAccountBean updater = subject.getUpdaterId() == 0 ? null : this.getUserAccountDao().findByPK(subject.getUpdaterId());
            HashMap<String, Object> h = new HashMap<String, Object>();
            StringBuilder studySubjectIdAndStudy = new StringBuilder();
            ArrayList studySubjects = this.getStudySubjectDao().findAllBySubjectId(subject.getId());
            for (StudySubjectBean studySubjectBean : studySubjects) {
                StudyBean study = this.getStudyDao().findByPK(studySubjectBean.getStudyId());
                studySubjectIdAndStudy.append(studySubjectIdAndStudy.length() == 0 ? "" : ",");
                studySubjectIdAndStudy.append(study.getIdentifier()).append("-").append(studySubjectBean.getLabel());
            }
            h.put("studySubjectIdAndStudy", studySubjectIdAndStudy.toString());
            h.put("subject", subject);
            h.put("subject.uniqueIdentifier", subject.getUniqueIdentifier());
            h.put("subject.gender", Character.valueOf(subject.getGender()));
            Date tempDate = subject.getCreatedDate();
            String tempDateStr = tempDate == null ? "" : I18nFormatUtil.getDateFormat((Locale)this.getLocale()).format(tempDate);
            h.put("subject.createdDate", tempDateStr);
            h.put("subject.owner", owner);
            tempDate = subject.getUpdatedDate();
            tempDateStr = tempDate == null ? "" : I18nFormatUtil.getDateFormat((Locale)this.getLocale()).format(tempDate);
            h.put("subject.updatedDate", tempDateStr);
            h.put("subject.updater", updater);
            h.put("subject.status", subject.getStatus());
            theItems.add(h);
        }
        tableFacade.setItems(theItems);
    }

    protected ListSubjectFilter getListSubjectFilter(Limit limit) {
        ListSubjectFilter listSubjectFilter = new ListSubjectFilter(this.getDateFormat());
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            listSubjectFilter.addFilter(property, (Object)value);
        }
        return listSubjectFilter;
    }

    protected ListSubjectSort getListSubjectSort(Limit limit) {
        ListSubjectSort listSubjectSort = new ListSubjectSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            listSubjectSort.addSort(property, order);
        }
        return listSubjectSort;
    }

    private String updateSubjectLink(Integer subjectId) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.a().href("UpdateSubject?action=show&id=" + subjectId);
        builder.onmouseout("javascript:setImage('bt_Edit1','images/bt_Edit_d.gif');");
        builder.onmouseover("javascript:setImage('bt_Edit1','images/bt_Edit.gif');");
        builder.close();
        builder.img().name("bt_Edit1").src("images/bt_Edit.gif").border("0").alt(this.resword.getString("edit")).title(this.resword.getString("edit")).align("left").append((Object)"hspace=\"6\"").close();
        builder.aEnd();
        return builder.toString();
    }

    private String removeSubjectLink(Integer subjectId) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.a().href("RemoveSubject?action=confirm&id=" + subjectId);
        builder.onmouseout("javascript:setImage('bt_Remove1','images/bt_Remove_d.gif');");
        builder.onmouseover("javascript:setImage('bt_Remove1','images/bt_Remove.gif');");
        builder.close();
        builder.img().name("bt_Remove1").src("images/bt_Remove.gif").border("0").alt(this.resword.getString("remove")).title(this.resword.getString("remove")).append((Object)"hspace=\"2\"").close();
        builder.aEnd();
        return builder.toString();
    }

    private String viewSubjectLink(Integer subjectId) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.a().href("ViewSubject?action=show&id=" + subjectId);
        builder.onmouseout("javascript:setImage('bt_View1','images/bt_View_d.gif');");
        builder.onmouseover("javascript:setImage('bt_View1','images/bt_View.gif');");
        builder.close();
        builder.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).align("left").append((Object)"hspace=\"6\"").close();
        builder.aEnd();
        return builder.toString();
    }

    private String restoreSubjectLink(Integer subjectId) {
        HtmlBuilder builder = new HtmlBuilder();
        builder.a().href("RestoreSubject?action=confirm&id=" + subjectId);
        builder.onmouseout("javascript:setImage('bt_Restor3','images/bt_Restore_d.gif');");
        builder.onmouseover("javascript:setImage('bt_Restore3','images/bt_Restore.gif');");
        builder.close();
        builder.img().name("bt_Restore3").src("images/bt_Restore.gif").border("0").alt(this.resword.getString("restore")).title(this.resword.getString("restore")).align("left").append((Object)"hspace=\"6\"").close();
        builder.aEnd();
        return builder.toString();
    }

    private String getDateFormat() {
        return this.resformat.getString("date_format_string");
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public SubjectDAO getSubjectDao() {
        return this.subjectDao;
    }

    public void setSubjectDao(SubjectDAO subjectDao) {
        this.subjectDao = subjectDao;
    }

    public StudyDAO getStudyDao() {
        return this.studyDao;
    }

    public void setStudyDao(StudyDAO studyDao) {
        this.studyDao = studyDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }

    public UserAccountDAO getUserAccountDao() {
        return this.userAccountDao;
    }

    public void setUserAccountDao(UserAccountDAO userAccountDao) {
        this.userAccountDao = userAccountDao;
    }

    static /* synthetic */ String access$700(ListSubjectTableFactory x0, Integer x1) {
        return x0.viewSubjectLink(x1);
    }

    static /* synthetic */ String access$800(ListSubjectTableFactory x0, Integer x1) {
        return x0.updateSubjectLink(x1);
    }

    static /* synthetic */ String access$900(ListSubjectTableFactory x0, Integer x1) {
        return x0.removeSubjectLink(x1);
    }

    static /* synthetic */ String access$1000(ListSubjectTableFactory x0, Integer x1) {
        return x0.restoreSubjectLink(x1);
    }
}

