/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.StatisticsView;
import org.akaza.openclinica.control.admin.SiteStatisticsTableFactory;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.DateFilterMatcher;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Limit;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.html.renderer.HtmlTableRenderer;

public class SiteStatisticsTableFactory
extends AbstractTableFactory {
    private StudyDAO studyDao;
    private StudySubjectDAO studySubjectDao;
    private StudyBean currentStudy;
    private ResourceBundle reswords = ResourceBundleProvider.getWordsBundle();

    protected String getTableName() {
        return "studySiteStatistics";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new StatisticsView(this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"name", "enrolled", "expectedTotalEnrollment", "percentage"});
        ((HtmlTableRenderer)tableFacade.getTable().getTableRenderer()).setWidth("375px");
        Row row = tableFacade.getTable().getRow();
        this.configureColumn(row.getColumn("name"), this.reswords.getString("site"), null, null, false, true);
        this.configureColumn(row.getColumn("enrolled"), this.reswords.getString("enrolled"), null, null, false, true);
        this.configureColumn(row.getColumn("expectedTotalEnrollment"), this.reswords.getString("expected_enrollment"), null, null, false, true);
        this.configureColumn(row.getColumn("percentage"), this.reswords.getString("percentage"), (CellEditor)new PercentageCellEditor(this, null), null, false, true);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        super.configureTableFacade(response, tableFacade);
        tableFacade.addFilterMatcher(new MatcherKey(Date.class, "loginAttemptDate"), (FilterMatcher)new DateFilterMatcher("yyyy-MM-dd hh:mm"));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        ArrayList studies = this.studyDao.findAll(this.currentStudy.getId());
        ArrayList theItems = new ArrayList();
        if (!limit.isComplete()) {
            int totalRows = studies.size();
            tableFacade.setMaxRows(totalRows);
            tableFacade.setTotalRows(totalRows);
        }
        for (StudyBean studyBean : studies) {
            Integer countofStudySubjectsAtStudyOrSite = this.studySubjectDao.getCountofStudySubjectsAtStudyOrSite(studyBean);
            Integer expectedTotalEnrollment = studyBean.getExpectedTotalEnrollment();
            Long percentage = expectedTotalEnrollment == 0 ? 0L : Math.round(countofStudySubjectsAtStudyOrSite.doubleValue() / expectedTotalEnrollment.doubleValue() * 100.0);
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("name", studyBean.getName());
            theItem.put("enrolled", countofStudySubjectsAtStudyOrSite);
            theItem.put("expectedTotalEnrollment", studyBean.getExpectedTotalEnrollment());
            theItem.put("percentage", String.valueOf(percentage) + "%");
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
    }

    public StudyDAO getStudyDao() {
        return this.studyDao;
    }

    public void setStudyDao(StudyDAO studyDao) {
        this.studyDao = studyDao;
    }

    public StudySubjectDAO getStudySubjectDao() {
        return this.studySubjectDao;
    }

    public void setStudySubjectDao(StudySubjectDAO studySubjectDao) {
        this.studySubjectDao = studySubjectDao;
    }

    public StudyBean getCurrentStudy() {
        return this.currentStudy;
    }

    public void setCurrentStudy(StudyBean currentStudy) {
        this.currentStudy = currentStudy;
    }
}

