/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.admin.StudyRowContainer;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ItemGroupCrvVersionUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.jmesa.facade.TableFacade;
import org.jmesa.facade.TableFacadeFactory;
import org.jmesa.view.html.component.HtmlColumn;
import org.jmesa.view.html.component.HtmlRow;
import org.jmesa.view.html.component.HtmlTable;

public class ViewCRFServlet
extends SecureController {
    private static final long serialVersionUID = 9110391473513698480L;
    private static String CRF_ID = "crfId";
    private static String CRF = "crf";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.panel.setSubmitDataModule(false);
        this.panel.setExtractData(false);
        this.panel.setCreateDataset(false);
        this.setToPanel(resword.getString("create_CRF"), respage.getString("br_create_new_CRF_entering"));
        this.setToPanel(resword.getString("create_CRF_version"), respage.getString("br_create_new_CRF_uploading"));
        this.setToPanel(resword.getString("revise_CRF_version"), respage.getString("br_if_you_owner_CRF_version"));
        this.setToPanel(resword.getString("CRF_spreadsheet_template"), respage.getString("br_download_blank_CRF_spreadsheet_from"));
        this.setToPanel(resword.getString("example_CRF_br_spreadsheets"), respage.getString("br_download_example_CRF_instructions_from"));
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int crfId = fp.getInt(CRF_ID);
        List studyBeans = null;
        if (crfId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFVersionDAO vdao = new CRFVersionDAO(this.sm.getDataSource());
            CRFBean crf = cdao.findByPK(crfId);
            this.request.setAttribute("crfName", (Object)crf.getName());
            ArrayList versions = vdao.findAllByCRF(crfId);
            crf.setVersions(versions);
            ArrayList items_verified = this.verifyUniqueItemPlacementInGroups(crf.getName());
            this.request.setAttribute("items", (Object)items_verified);
            if ("admin".equalsIgnoreCase(module)) {
                StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
                studyBeans = this.findStudiesForCRFId(crfId, studyDAO);
                String studyHtml = this.renderStudiesTable(studyBeans);
                this.request.setAttribute("studiesTableHTML", (Object)studyHtml);
            }
            this.request.setAttribute(CRF, (Object)crf);
            this.forwardPage(Page.VIEW_CRF);
        }
    }

    private ArrayList<ItemGroupCrvVersionUtil> verifyUniqueItemPlacementInGroups(String crfName) {
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        String temp_buffer = null;
        ArrayList<ItemGroupCrvVersionUtil> results = new ArrayList<ItemGroupCrvVersionUtil>();
        ItemGroupCrvVersionUtil cur_item = null;
        StringBuffer error_message = null;
        ArrayList item_group_crf_records = idao.findAllWithItemDetailsGroupCRFVersionMetadataByCRFId(crfName);
        for (ItemGroupCrvVersionUtil check_group : item_group_crf_records) {
            if (results.size() == 0 || !check_group.getItemName().equals(cur_item.getItemName())) {
                cur_item = new ItemGroupCrvVersionUtil(check_group.getItemName(), check_group.getGroupName(), check_group.getGroupOID(), check_group.getCrfVersionName(), check_group.getCrfVersionStatus(), check_group.getItemOID(), check_group.getItemDescription(), check_group.getItemDataType(), check_group.getId());
                cur_item.setVersions(check_group.getCrfVersionName());
                temp_buffer = respage.getString("verifyUniqueItemPlacementInGroups_4") + check_group.getGroupName() + respage.getString("verifyUniqueItemPlacementInGroups_5") + check_group.getCrfVersionName() + "'";
                results.add(cur_item);
                continue;
            }
            if (check_group.getItemName().equals(cur_item.getItemName()) && !check_group.getGroupName().equals(cur_item.getGroupName())) {
                error_message = new StringBuffer();
                error_message.append(respage.getString("verifyUniqueItemPlacementInGroups_4") + check_group.getGroupName());
                error_message.append(respage.getString("verifyUniqueItemPlacementInGroups_5"));
                error_message.append(check_group.getCrfVersionName());
                if (temp_buffer != null) {
                    cur_item.getArrErrorMesages().add(temp_buffer);
                }
                temp_buffer = null;
                cur_item.getArrErrorMesages().add(error_message.toString());
                if (check_group.getCrfVersionStatus() == 1 && cur_item.getCrfVersionStatus() != 1) {
                    cur_item.setCrfVersionStatus(1);
                }
            }
            cur_item.setVersions(cur_item.getVersions() + "," + check_group.getCrfVersionName());
        }
        return results;
    }

    private String renderStudiesTable(List<StudyBean> studyBeans) {
        Collection items = this.getStudyRows(studyBeans);
        TableFacade tableFacade = TableFacadeFactory.createTableFacade((String)"studies", (HttpServletRequest)this.request);
        tableFacade.setColumnProperties(new String[]{"name", "uniqueProtocolid", "actions"});
        tableFacade.setItems(items);
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        HtmlRow row = table.getRow();
        SDVUtil sDVUtil = new SDVUtil();
        String[] colNames = new String[]{"name", "uniqueProtocolid", "actions"};
        sDVUtil.setHtmlCellEditors(tableFacade, colNames, true);
        HtmlColumn firstName = row.getColumn("name");
        firstName.setTitle("Study Name");
        HtmlColumn protocol = row.getColumn("uniqueProtocolid");
        protocol.setTitle("Unique Protocol Id");
        HtmlColumn actions = row.getColumn("actions");
        actions.setTitle("Actions");
        return tableFacade.render();
    }

    private Collection<StudyRowContainer> getStudyRows(List<StudyBean> studyBeans) {
        ArrayList<StudyRowContainer> allRows = new ArrayList<StudyRowContainer>();
        StudyRowContainer tempBean = null;
        StringBuilder actions = new StringBuilder("");
        for (StudyBean studBean : studyBeans) {
            tempBean = new StudyRowContainer();
            tempBean.setName(studBean.getName());
            tempBean.setUniqueProtocolid(studBean.getIdentifier());
            tempBean.setStudyBean(studBean);
            actions.append("<a onmouseup=\"javascript:setImage('bt_View1','images/bt_View.gif');\" onmousedown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\" href=\"ViewStudy?id=").append(studBean.getId()).append("&amp;viewFull=yes\"><img hspace=\"6\" border=\"0\" align=\"left\" title=\"View\" alt=\"View\" src=\"images/bt_View.gif\" name=\"bt_View1\"/></a>");
            tempBean.setActions(actions.toString());
            allRows.add(tempBean);
            actions = new StringBuilder("");
        }
        return allRows;
    }

    private List<StudyBean> findStudiesForCRFId(int crfId, StudyDAO studyDao) {
        ArrayList<StudyBean> studyBeans = new ArrayList<StudyBean>();
        if (crfId == 0 || studyDao == null) {
            return studyBeans;
        }
        ArrayList studyIds = studyDao.getStudyIdsByCRF(crfId);
        StudyBean tempBean = new StudyBean();
        for (Integer id : studyIds) {
            tempBean = studyDao.findByPK(id.intValue());
            studyBeans.add(tempBean);
        }
        return studyBeans;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }
}

