/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.core;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.AuditableEntityBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.core.CRFLocker;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.StudyInfoPanel;
import org.akaza.openclinica.view.StudyInfoPanelLine;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public abstract class CoreSecureController
extends HttpServlet {
    private static final long serialVersionUID = -4705456347136667876L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreSecureController.class);
    protected HashMap<String, ArrayList<String>> errors = new HashMap();
    public static ResourceBundle resadmin;
    public static ResourceBundle resaudit;
    public static ResourceBundle resexception;
    public static ResourceBundle resformat;
    public static ResourceBundle respage;
    public static ResourceBundle resterm;
    public static ResourceBundle restext;
    public static ResourceBundle resword;
    public static ResourceBundle resworkflow;
    protected StudyInfoPanel panel = new StudyInfoPanel();
    public static final String PAGE_MESSAGE = "pageMessages";
    public static final String INPUT_MESSAGES = "formMessages";
    public static final String PRESET_VALUES = "presetValues";
    public static final String ADMIN_SERVLET_CODE = "admin";
    public static final String BEAN_TABLE = "table";
    public static final String STUDY_INFO_PANEL = "panel";
    public static final String BREADCRUMB_TRAIL = "breadcrumbs";
    public static final String POP_UP_URL = "popUpURL";
    public static final String SUPPORT_URL = "supportURL";
    public static final String MODULE = "module";
    private CRFLocker crfLocker;
    private DataSource dataSource = null;
    public static final String USER_BEAN_NAME = "userBean";

    protected void addPageMessage(String message, HttpServletRequest request) {
        ArrayList<String> pageMessages = ClassCastHelper.getAttributeAsList((HttpServletRequest)request, (String)PAGE_MESSAGE, String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList<String>();
        }
        pageMessages.add(message);
        LOGGER.debug(message);
        request.setAttribute(PAGE_MESSAGE, pageMessages);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = this.getServletContext();
        ApplicationContext appCtx = SpringServletAccess.getApplicationContext((ServletContext)context);
        SessionManager sm = new SessionManager(appCtx);
        this.dataSource = sm.getDataSource();
        this.crfLocker = (CRFLocker)appCtx.getBean(CRFLocker.class);
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void resetPanel() {
        this.panel.reset();
    }

    protected void setToPanel(String title, String info, HttpServletRequest request) {
        if (this.panel.isOrderedData()) {
            ArrayList data = this.panel.getUserOrderedData();
            data.add(new StudyInfoPanelLine(title, info));
            this.panel.setUserOrderedData(data);
        } else {
            this.panel.setData(title, info);
        }
        request.setAttribute(STUDY_INFO_PANEL, (Object)this.panel);
    }

    protected void setInputMessages(HashMap<String, ArrayList<String>> messages, HttpServletRequest request) {
        request.setAttribute(INPUT_MESSAGES, messages);
    }

    protected void setPresetValues(HashMap<String, Object> presetValues, HttpServletRequest request) {
        request.setAttribute(PRESET_VALUES, presetValues);
    }

    protected void setTable(EntityBeanTable table, HttpServletRequest request) {
        request.setAttribute(BEAN_TABLE, (Object)table);
    }

    public void init() throws ServletException {
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    protected abstract void mayProceed(HttpServletRequest var1, HttpServletResponse var2) throws InsufficientPermissionException;

    public void passwdTimeOut(HttpServletRequest request, HttpServletResponse response, UserAccountBean ub) {
        Date lastChangeDate = ub.getPasswdTimestamp();
        if (!ub.isLdapUser() && lastChangeDate == null) {
            this.addPageMessage(respage.getString("welcome") + " " + ub.getFirstName() + " " + ub.getLastName() + ". " + respage.getString("password_set"), request);
            int pwdChangeRequired = new Integer(SQLInitServlet.getField((String)"change_passwd_required"));
            if (pwdChangeRequired == 1) {
                request.setAttribute("mustChangePass", (Object)"yes");
                this.forwardPage(Page.RESET_PASSWORD, request, response);
            }
        }
    }

    private void unlockCRFOnError(HttpServletRequest req) {
        if (req != null) {
            EventCRFBean eventCrf = (EventCRFBean)req.getAttribute("event");
            UserAccountBean ub = (UserAccountBean)req.getSession().getAttribute(USER_BEAN_NAME);
            if (eventCrf != null && this.crfLocker.isLocked(eventCrf.getId())) {
                if (ub != null && ub.getId() == this.crfLocker.getLockOwner(eventCrf.getId()).intValue()) {
                    this.crfLocker.unlock(eventCrf.getId());
                } else if (ub == null) {
                    this.crfLocker.unlock(eventCrf.getId());
                }
            }
        }
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws OpenClinicaException, UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Encoding", "gzip");
        HttpSession session = request.getSession();
        try {
            session.setMaxInactiveInterval(Integer.parseInt(SQLInitServlet.getField((String)"max_inactive_interval")));
        }
        catch (NumberFormatException nfe) {
            session.setMaxInactiveInterval(3600);
        }
        if (session.getAttribute(SUPPORT_URL) == null) {
            session.setAttribute(SUPPORT_URL, (Object)SQLInitServlet.getSupportURL());
        }
        UserAccountBean ub = (UserAccountBean)session.getAttribute(USER_BEAN_NAME);
        StudyBean currentStudy = (StudyBean)session.getAttribute("study");
        StudyUserRoleBean currentRole = (StudyUserRoleBean)session.getAttribute("userRole");
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundleProvider.updateLocale((Locale)locale);
        resadmin = ResourceBundleProvider.getAdminBundle((Locale)locale);
        resaudit = ResourceBundleProvider.getAuditEventsBundle((Locale)locale);
        resexception = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
        resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        restext = ResourceBundleProvider.getTextsBundle((Locale)locale);
        resterm = ResourceBundleProvider.getTermsBundle((Locale)locale);
        resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        respage = ResourceBundleProvider.getPageMessagesBundle((Locale)locale);
        resworkflow = ResourceBundleProvider.getWorkflowBundle((Locale)locale);
        try {
            ArrayList roles;
            String userName = request.getRemoteUser();
            ServletContext context = this.getServletContext();
            SessionManager sm = new SessionManager(ub, userName, SpringServletAccess.getApplicationContext((ServletContext)context));
            ub = sm.getUserBean();
            request.getSession().setAttribute("sm", (Object)sm);
            session.setAttribute(USER_BEAN_NAME, (Object)ub);
            StudyDAO sdao = new StudyDAO(this.getDataSource());
            if (currentStudy == null || currentStudy.getId() <= 0) {
                if (ub.getId() > 0 && ub.getActiveStudyId() > 0) {
                    StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.getDataSource());
                    currentStudy = sdao.findByPK(ub.getActiveStudyId());
                    ArrayList studyParameters = spvdao.findParamConfigByStudy(currentStudy);
                    currentStudy.setStudyParameters(studyParameters);
                    StudyConfigService scs = new StudyConfigService(this.getDataSource());
                    if (currentStudy.getParentStudyId() <= 0) {
                        scs.setParametersForStudy(currentStudy);
                    } else {
                        currentStudy.setParentStudyName(sdao.findByPK(currentStudy.getParentStudyId()).getName());
                        scs.setParametersForSite(currentStudy);
                    }
                    this.panel.reset();
                    session.setAttribute(STUDY_INFO_PANEL, (Object)this.panel);
                } else {
                    currentStudy = new StudyBean();
                }
                session.setAttribute("study", (Object)currentStudy);
            } else if (currentStudy.getId() > 0 && currentStudy.getParentStudyId() > 0) {
                currentStudy.setParentStudyName(sdao.findByPK(currentStudy.getParentStudyId()).getName());
            }
            if (currentStudy.getParentStudyId() > 0) {
                roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("site_Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("site_Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("site_investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("site_Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("site_monitor");
                            break;
                        }
                        case 7: {
                            role.setDescription("site_Data_Entry_Person2");
                            break;
                        }
                    }
                }
            } else {
                roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("Investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("Monitor");
                            break;
                        }
                    }
                }
            }
            if (currentRole == null || currentRole.getId() <= 0) {
                if (ub.getId() > 0 && currentStudy.getId() > 0 && !currentStudy.getStatus().getName().equals("removed")) {
                    currentRole = ub.getRoleByStudy(currentStudy.getId());
                    if (currentStudy.getParentStudyId() > 0) {
                        StudyUserRoleBean roleInParent = ub.getRoleByStudy(currentStudy.getParentStudyId());
                        currentRole.setRole(Role.max((Role)currentRole.getRole(), (Role)roleInParent.getRole()));
                    }
                } else {
                    currentRole = new StudyUserRoleBean();
                }
                session.setAttribute("userRole", (Object)currentRole);
            } else if (currentRole.getId() > 0 && (currentStudy.getStatus().equals((Term)Status.DELETED) || currentStudy.getStatus().equals((Term)Status.AUTO_DELETED))) {
                currentRole.setRole(Role.INVALID);
                currentRole.setStatus(Status.DELETED);
                session.setAttribute("userRole", (Object)currentRole);
            }
            request.setAttribute("isAdminServlet", (Object)this.getAdminServlet());
            if (!request.getRequestURI().endsWith("ResetPassword")) {
                this.passwdTimeOut(request, response, ub);
            }
            this.mayProceed(request, response);
            this.processRequest(request, response);
        }
        catch (InconsistentStateException ise) {
            LOGGER.warn("InconsistentStateException: org.akaza.openclinica.control.CoreSecureController: ", (Throwable)ise);
            this.unlockCRFOnError(request);
            this.addPageMessage(ise.getOpenClinicaMessage(), request);
            this.forwardPage(ise.getGoTo(), request, response);
        }
        catch (InsufficientPermissionException ipe) {
            LOGGER.warn("InsufficientPermissionException: org.akaza.openclinica.control.CoreSecureController: ", (Throwable)ipe);
            this.unlockCRFOnError(request);
            this.forwardPage(ipe.getGoTo(), request, response);
        }
        catch (Exception e) {
            LOGGER.error("Error processing request", (Throwable)e);
            this.unlockCRFOnError(request);
            this.forwardPage(Page.ERROR, request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            LOGGER.debug("GET Request");
            this.process(request, response);
        }
        catch (Exception e) {
            LOGGER.error("Error processing request", (Throwable)e);
            this.unlockCRFOnError(request);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            LOGGER.debug("POST Request");
            this.process(request, response);
        }
        catch (Exception e) {
            LOGGER.error("Error processing request", (Throwable)e);
            this.unlockCRFOnError(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardPage(Page jspPage, boolean checkTrail, HttpServletRequest request, HttpServletResponse response) {
        Page page1 = Page.valueOf((String)jspPage.name());
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.setHeader("Cache-Control", "no-store");
        if (request.getAttribute(POP_UP_URL) == null) {
            request.setAttribute(POP_UP_URL, (Object)"");
        }
        try {
            String temp = page1.getFileName();
            this.getServletContext().getRequestDispatcher(temp).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception se) {
            LOGGER.error(se.getMessage(), (Throwable)se);
        }
        finally {
            page1 = null;
            jspPage = null;
            Object temp = null;
        }
    }

    protected void forwardPage(Page jspPage, HttpServletRequest request, HttpServletResponse response) {
        this.forwardPage(jspPage, true, request, response);
    }

    protected String getAdminServlet() {
        return "";
    }

    protected void setPopUpURL(String url, HttpServletRequest request) {
        if (url != null && request != null) {
            request.setAttribute(POP_UP_URL, (Object)url);
            LOGGER.info("just set pop up url: " + url);
        }
    }

    protected boolean entityIncluded(int entityId, String userName, AuditableEntityDAO<? extends AuditableEntityBean> adao, DataSource ds) {
        StudyDAO sdao = new StudyDAO(ds);
        ArrayList studies = sdao.findAllByUserNotRemoved(userName);
        for (int i = 0; i < studies.size(); ++i) {
            ArrayList sites;
            AuditableEntityBean bean = (AuditableEntityBean)adao.findByPKAndStudy(entityId, (StudyBean)studies.get(i));
            if (bean != null && bean.getId() > 0) {
                return true;
            }
            if (((StudyBean)studies.get(i)).getParentStudyId() > 0 || (sites = sdao.findAllByParent(((StudyBean)studies.get(i)).getId())).size() <= 0) continue;
            for (int j = 0; j < sites.size(); ++j) {
                if (((AuditableEntityBean)adao.findByPKAndStudy(entityId, (StudyBean)sites.get(j))).getId() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getRequestURLMinusServletPath(HttpServletRequest request) {
        String requestURLMinusServletPath = request.getRequestURL().toString().replaceAll(request.getServletPath(), "");
        return requestURLMinusServletPath;
    }

    public String getHostPath(HttpServletRequest request) {
        String requestURLMinusServletPath = this.getRequestURLMinusServletPath(request);
        return requestURLMinusServletPath.substring(0, requestURLMinusServletPath.lastIndexOf("/"));
    }

    public String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath().replaceAll("/", "");
        return contextPath;
    }

    public void checkStudyLocked(Page page, String message, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy.getStatus().equals((Term)Status.LOCKED)) {
            this.addPageMessage(message, request);
            this.forwardPage(page, request, response);
        }
    }

    public void checkStudyLocked(String url, String message, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        try {
            if (currentStudy.getStatus().equals((Term)Status.LOCKED)) {
                this.addPageMessage(message, request);
                response.sendRedirect(url);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Study is not present: ", (Throwable)ex);
        }
    }

    public void checkStudyFrozen(Page page, String message, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        if (currentStudy.getStatus().equals((Term)Status.FROZEN)) {
            this.addPageMessage(message, request);
            this.forwardPage(page, request, response);
        }
    }

    public void checkStudyFrozen(String url, String message, HttpServletRequest request, HttpServletResponse response) {
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        try {
            if (currentStudy.getStatus().equals((Term)Status.FROZEN)) {
                this.addPageMessage(message, request);
                response.sendRedirect(url);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Study is not present: ", (Throwable)ex);
        }
    }

    public ArrayList<StudyEventDefinitionBean> getEventDefinitionsByCurrentStudy(HttpServletRequest request) {
        StudyDAO studyDAO = new StudyDAO(this.getDataSource());
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.getDataSource());
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        int parentStudyId = currentStudy.getParentStudyId();
        ArrayList allDefs = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = studyDAO.findByPK(parentStudyId);
            allDefs = studyEventDefinitionDAO.findAllActiveByStudy(parentStudy);
        } else {
            parentStudyId = currentStudy.getId();
            allDefs = studyEventDefinitionDAO.findAllActiveByStudy(currentStudy);
        }
        return allDefs;
    }

    public ArrayList<StudyGroupClassBean> getStudyGroupClassesByCurrentStudy(HttpServletRequest request) {
        StudyDAO studyDAO = new StudyDAO(this.getDataSource());
        StudyGroupClassDAO studyGroupClassDAO = new StudyGroupClassDAO(this.getDataSource());
        StudyGroupDAO studyGroupDAO = new StudyGroupDAO(this.getDataSource());
        StudyBean currentStudy = (StudyBean)request.getSession().getAttribute("study");
        int parentStudyId = currentStudy.getParentStudyId();
        ArrayList studyGroupClasses = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = studyDAO.findByPK(parentStudyId);
            studyGroupClasses = studyGroupClassDAO.findAllActiveByStudy(parentStudy);
        } else {
            parentStudyId = currentStudy.getId();
            studyGroupClasses = studyGroupClassDAO.findAllActiveByStudy(currentStudy);
        }
        for (int i = 0; i < studyGroupClasses.size(); ++i) {
            StudyGroupClassBean sgc = (StudyGroupClassBean)studyGroupClasses.get(i);
            ArrayList groups = studyGroupDAO.findAllByGroupClass(sgc);
            sgc.setStudyGroups(groups);
        }
        return studyGroupClasses;
    }

    protected UserDetails getUserDetails() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            return (UserDetails)principal;
        }
        return null;
    }

    public Boolean sendEmail(String to, String subject, String body, Boolean htmlEmail, Boolean sendMessage, HttpServletRequest request) throws Exception {
        return this.sendEmail(to, EmailEngine.getAdminEmail(), subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), sendMessage, request);
    }

    public Boolean sendEmail(String to, String subject, String body, Boolean htmlEmail, HttpServletRequest request) throws Exception {
        return this.sendEmail(to, EmailEngine.getAdminEmail(), subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), Boolean.valueOf(true), request);
    }

    public Boolean sendEmail(String to, String from, String subject, String body, Boolean htmlEmail, HttpServletRequest request) throws Exception {
        return this.sendEmail(to, from, subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), Boolean.valueOf(true), request);
    }

    public Boolean sendEmail(String to, String from, String subject, String body, Boolean htmlEmail, String successMessage, String failMessage, Boolean sendMessage, HttpServletRequest request) throws Exception {
        Boolean messageSent = true;
        try {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)SpringServletAccess.getApplicationContext((ServletContext)this.getServletContext()).getBean("mailSender");
            Properties javaMailProperties = mailSender.getJavaMailProperties();
            if (null != javaMailProperties && (javaMailProperties.get("mail.smtp.localhost") == null || ((String)javaMailProperties.get("mail.smtp.localhost")).equalsIgnoreCase(""))) {
                javaMailProperties.put("mail.smtp.localhost", "localhost");
            }
            MimeMessage mimeMessage = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, htmlEmail.booleanValue());
            helper.setFrom(from);
            helper.setTo(this.processMultipleImailAddresses(to.trim()));
            helper.setSubject(subject);
            helper.setText(body, true);
            mailSender.send(mimeMessage);
            if (successMessage != null && sendMessage.booleanValue()) {
                this.addPageMessage(successMessage, request);
            }
            LOGGER.debug("Email sent successfully on {}", (Object)new Date());
        }
        catch (MailException me) {
            if (failMessage != null && sendMessage.booleanValue()) {
                this.addPageMessage(failMessage, request);
            }
            LOGGER.debug("Email could not be sent on {} due to: {}", (Object)new Date(), (Object)me.toString());
            messageSent = false;
        }
        return messageSent;
    }

    private InternetAddress[] processMultipleImailAddresses(String to) throws MessagingException {
        ArrayList<String> recipientsArray = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(to, ",");
        while (st.hasMoreTokens()) {
            recipientsArray.add(st.nextToken());
        }
        int sizeTo = recipientsArray.size();
        InternetAddress[] addressTo = new InternetAddress[sizeTo];
        for (int i = 0; i < sizeTo; ++i) {
            addressTo[i] = new InternetAddress(((String)recipientsArray.get(i)).toString());
        }
        return addressTo;
    }

    public void unlockCRFsForUser(int userId) {
        this.crfLocker.unlockAllForUser(userId);
    }

    public CRFLocker getCrfLocker() {
        return this.crfLocker;
    }

    protected void addErrorMessage(String key, String errorMsg) {
        ArrayList<String> messages;
        if (this.errors == null) {
            this.errors = new HashMap();
        }
        if ((messages = (ArrayList<String>)this.errors.get(key)) == null) {
            messages = new ArrayList<String>();
            this.errors.put(key, messages);
        }
        messages.add(errorMsg);
    }

    static /* synthetic */ void access$000(CoreSecureController x0, HttpServletRequest x1, HttpServletResponse x2) throws OpenClinicaException, UnsupportedEncodingException {
        x0.process(x1, x2);
    }
}

