/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.core;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.ArchivedDatasetFileBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.core.CRFLocker;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.core.SessionManager;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.core.AuditableEntityDAO;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.extract.ArchivedDatasetFileDAO;
import org.akaza.openclinica.dao.hibernate.UserAccountDao;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyConfigService;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.exception.OpenClinicaException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.I18nFormatUtil;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.Authorization;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.view.StudyInfoPanel;
import org.akaza.openclinica.view.StudyInfoPanelLine;
import org.akaza.openclinica.web.InconsistentStateException;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SecureController
extends HttpServlet
implements SingleThreadModel {
    private static final long serialVersionUID = -4534604636525309665L;
    protected ServletContext context;
    protected SessionManager sm;
    protected static final Logger logger = LoggerFactory.getLogger(SecureController.class);
    protected String logDir;
    protected String logLevel;
    protected HttpSession session;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected UserAccountBean ub;
    protected StudyBean currentStudy;
    protected StudyUserRoleBean currentRole;
    protected HashMap<String, ArrayList<String>> errors = new HashMap();
    protected UserAccountDao userDaoDomain;
    private static String SCHEDULER = "schedulerFactoryBean";
    private StdScheduler scheduler;
    protected SimpleDateFormat local_df = new SimpleDateFormat("MM/dd/yyyy");
    public static ResourceBundle resadmin;
    public static ResourceBundle resaudit;
    public static ResourceBundle resexception;
    public static ResourceBundle resformat;
    public static ResourceBundle respage;
    public static ResourceBundle resterm;
    public static ResourceBundle restext;
    public static ResourceBundle resword;
    public static ResourceBundle resworkflow;
    protected StudyInfoPanel panel = new StudyInfoPanel();
    public static final String PAGE_MESSAGE = "pageMessages";
    public static final String INPUT_MESSAGES = "formMessages";
    public static final String PRESET_VALUES = "presetValues";
    public static final String ADMIN_SERVLET_CODE = "admin";
    public static final String BEAN_TABLE = "table";
    public static final String STUDY_INFO_PANEL = "panel";
    public static final String BREADCRUMB_TRAIL = "breadcrumbs";
    public static final String POP_UP_URL = "popUpURL";
    public static final String SUPPORT_URL = "supportURL";
    public static final String MODULE = "module";
    private CRFLocker crfLocker;
    public static final String USER_BEAN_NAME = "userBean";

    protected <T> T getBean(Class<T> clazz) {
        return (T)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getBean(clazz);
    }

    protected <T> T getBean(String name) {
        return (T)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getBean(name);
    }

    protected void addPageMessage(String message) {
        ArrayList<String> pageMessages = ClassCastHelper.asArrayList((Object)this.request.getAttribute(PAGE_MESSAGE), String.class);
        if (pageMessages == null) {
            pageMessages = new ArrayList<String>();
        }
        pageMessages.add(message);
        logger.debug(message);
        this.request.setAttribute(PAGE_MESSAGE, pageMessages);
    }

    protected void resetPanel() {
        this.panel.reset();
    }

    protected void setToPanel(String title, String info) {
        if (this.panel.isOrderedData()) {
            ArrayList data = this.panel.getUserOrderedData();
            data.add(new StudyInfoPanelLine(title, info));
            this.panel.setUserOrderedData(data);
        } else {
            this.panel.setData(title, info);
        }
        this.request.setAttribute(STUDY_INFO_PANEL, (Object)this.panel);
    }

    protected void setInputMessages(HashMap<String, ArrayList<String>> messages) {
        this.request.setAttribute(INPUT_MESSAGES, messages);
    }

    protected void setPresetValues(HashMap<String, Object> presetValues) {
        this.request.setAttribute(PRESET_VALUES, presetValues);
    }

    protected void setTable(EntityBeanTable table) {
        this.request.setAttribute(BEAN_TABLE, (Object)table);
    }

    public void init() throws ServletException {
        this.context = this.getServletContext();
        this.crfLocker = (CRFLocker)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean(CRFLocker.class);
    }

    protected abstract void processRequest() throws Exception;

    protected abstract void mayProceed() throws InsufficientPermissionException;

    public void passwdTimeOut() {
        int pwdChangeRequired;
        Date lastChangeDate = this.ub.getPasswdTimestamp();
        if (!this.ub.isLdapUser() && lastChangeDate == null && (pwdChangeRequired = new Integer(SQLInitServlet.getField((String)"change_passwd_required")).intValue()) == 1) {
            this.addPageMessage(respage.getString("welcome") + " " + this.ub.getFirstName() + " " + this.ub.getLastName() + ". " + respage.getString("password_set"));
            this.request.setAttribute("mustChangePass", (Object)"yes");
            this.forwardPage(Page.RESET_PASSWORD);
        }
    }

    private void pingJobServer(HttpServletRequest request) {
        String jobName = (String)request.getSession().getAttribute("jobName");
        String groupName = (String)request.getSession().getAttribute("groupName");
        Integer datasetId = (Integer)request.getSession().getAttribute("datasetId");
        try {
            if (jobName != null && groupName != null) {
                Trigger.TriggerState state = this.getScheduler(request).getTriggerState(new TriggerKey(jobName, groupName));
                JobDetail details = this.getScheduler(request).getJobDetail(new JobKey(jobName, groupName));
                JobDataMap dataMap = details.getJobDataMap();
                String failMessage = dataMap.getString("failMessage");
                if (state == Trigger.TriggerState.NONE || state == Trigger.TriggerState.COMPLETE) {
                    if (failMessage != null) {
                        this.addPageMessage("The extract data job failed with the message: <br/><br/>" + failMessage + "<br/><br/>More information may be available in the log files.");
                        request.getSession().removeAttribute("jobName");
                        request.getSession().removeAttribute("groupName");
                        request.getSession().removeAttribute("datasetId");
                    } else {
                        String successMsg = dataMap.getString("SUCCESS_MESSAGE");
                        String success = dataMap.getString("successMsg");
                        if (success != null) {
                            if (successMsg.contains("$linkURL")) {
                                successMsg = this.decodeLINKURL(successMsg, datasetId);
                            }
                            if (successMsg != null && !successMsg.isEmpty()) {
                                this.addPageMessage(successMsg);
                            } else {
                                this.addPageMessage("Your Extract is now completed. Please go to review them at <a href='ExportDataset?datasetId=" + datasetId + "'> Here </a>.");
                            }
                            request.getSession().removeAttribute("jobName");
                            request.getSession().removeAttribute("groupName");
                            request.getSession().removeAttribute("datasetId");
                        }
                    }
                }
            }
        }
        catch (SchedulerException se) {
            logger.error("Pinging job server is failing due to ", (Throwable)se);
        }
    }

    private String decodeLINKURL(String successMsg, Integer datasetId) {
        ArchivedDatasetFileDAO asdfDAO = new ArchivedDatasetFileDAO(this.sm.getDataSource());
        ArrayList fileBeans = asdfDAO.findByDatasetId(datasetId.intValue());
        successMsg = successMsg.replace("$linkURL", "<a href=\"" + CoreResources.getField((String)"sysURL.base") + "AccessFile?fileId=" + ((ArchivedDatasetFileBean)fileBeans.get(0)).getId() + "\">here </a>");
        return successMsg;
    }

    private StdScheduler getScheduler(HttpServletRequest request) {
        this.scheduler = this.scheduler != null ? this.scheduler : (StdScheduler)SpringServletAccess.getApplicationContext((ServletContext)request.getSession().getServletContext()).getBean(SCHEDULER);
        return this.scheduler;
    }

    private void process(HttpServletRequest request, HttpServletResponse response) throws OpenClinicaException, UnsupportedEncodingException {
        request.setCharacterEncoding("UTF-8");
        this.session = request.getSession();
        try {
            this.session.setMaxInactiveInterval(Integer.parseInt(SQLInitServlet.getField((String)"max_inactive_interval")));
        }
        catch (NumberFormatException nfe) {
            this.session.setMaxInactiveInterval(3600);
        }
        if (this.session.getAttribute(SUPPORT_URL) == null) {
            this.session.setAttribute(SUPPORT_URL, (Object)SQLInitServlet.getSupportURL());
        }
        this.ub = (UserAccountBean)this.session.getAttribute(USER_BEAN_NAME);
        this.currentStudy = (StudyBean)this.session.getAttribute("study");
        this.currentRole = (StudyUserRoleBean)this.session.getAttribute("userRole");
        Locale locale = LocaleResolver.getLocale((HttpServletRequest)request);
        ResourceBundleProvider.updateLocale((Locale)locale);
        resadmin = ResourceBundleProvider.getAdminBundle((Locale)locale);
        resaudit = ResourceBundleProvider.getAuditEventsBundle((Locale)locale);
        resexception = ResourceBundleProvider.getExceptionsBundle((Locale)locale);
        resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        restext = ResourceBundleProvider.getTextsBundle((Locale)locale);
        resterm = ResourceBundleProvider.getTermsBundle((Locale)locale);
        resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        respage = ResourceBundleProvider.getPageMessagesBundle((Locale)locale);
        resworkflow = ResourceBundleProvider.getWorkflowBundle((Locale)locale);
        this.local_df = I18nFormatUtil.getDateFormat((Locale)locale);
        try {
            ArrayList roles;
            String userName = request.getRemoteUser();
            this.sm = new SessionManager(this.ub, userName, SpringServletAccess.getApplicationContext((ServletContext)this.context));
            this.ub = this.sm.getUserBean();
            this.session.setAttribute(USER_BEAN_NAME, (Object)this.ub);
            StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
            if (this.currentStudy == null || this.currentStudy.getId() <= 0) {
                if (this.ub.getId() > 0 && this.ub.getActiveStudyId() > 0) {
                    StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
                    this.currentStudy = sdao.findByPK(this.ub.getActiveStudyId());
                    ArrayList studyParameters = spvdao.findParamConfigByStudy(this.currentStudy);
                    this.currentStudy.setStudyParameters(studyParameters);
                    StudyConfigService scs = new StudyConfigService(this.sm.getDataSource());
                    if (this.currentStudy.getParentStudyId() <= 0) {
                        scs.setParametersForStudy(this.currentStudy);
                    } else {
                        this.currentStudy.setParentStudyName(sdao.findByPK(this.currentStudy.getParentStudyId()).getName());
                        scs.setParametersForSite(this.currentStudy);
                    }
                    this.panel.reset();
                    this.session.setAttribute(STUDY_INFO_PANEL, (Object)this.panel);
                } else {
                    this.currentStudy = new StudyBean();
                }
                this.session.setAttribute("study", (Object)this.currentStudy);
            } else if (this.currentStudy.getId() > 0 && this.currentStudy.getParentStudyId() > 0) {
                this.currentStudy.setParentStudyName(sdao.findByPK(this.currentStudy.getParentStudyId()).getName());
            }
            if (this.currentStudy.getParentStudyId() > 0) {
                roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("site_Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("site_Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("site_investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("site_Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("site_monitor");
                            break;
                        }
                        case 7: {
                            role.setDescription("site_Data_Entry_Person2");
                            break;
                        }
                    }
                }
            } else {
                roles = Role.toArrayList();
                for (Role role : roles) {
                    switch (role.getId()) {
                        case 2: {
                            role.setDescription("Study_Coordinator");
                            break;
                        }
                        case 3: {
                            role.setDescription("Study_Director");
                            break;
                        }
                        case 4: {
                            role.setDescription("Investigator");
                            break;
                        }
                        case 5: {
                            role.setDescription("Data_Entry_Person");
                            break;
                        }
                        case 6: {
                            role.setDescription("Monitor");
                            break;
                        }
                    }
                }
            }
            if (this.currentRole == null || this.currentRole.getId() <= 0) {
                if (this.ub.getId() > 0 && this.currentStudy.getId() > 0 && !this.currentStudy.getStatus().getName().equals("removed")) {
                    this.currentRole = this.ub.getRoleByStudy(this.currentStudy.getId());
                    if (this.currentStudy.getParentStudyId() > 0) {
                        StudyUserRoleBean roleInParent = this.ub.getRoleByStudy(this.currentStudy.getParentStudyId());
                        this.currentRole.setRole(Role.max((Role)this.currentRole.getRole(), (Role)roleInParent.getRole()));
                    }
                } else {
                    this.currentRole = new StudyUserRoleBean();
                }
                this.session.setAttribute("userRole", (Object)this.currentRole);
            } else if (this.currentRole.getId() > 0 && (this.currentStudy.getStatus().equals((Term)Status.DELETED) || this.currentStudy.getStatus().equals((Term)Status.AUTO_DELETED))) {
                this.currentRole.setRole(Role.INVALID);
                this.currentRole.setStatus(Status.DELETED);
                this.session.setAttribute("userRole", (Object)this.currentRole);
            }
            request.setAttribute("isAdminServlet", (Object)this.getAdminServlet());
            this.request = request;
            this.response = response;
            if (!request.getRequestURI().endsWith("ResetPassword")) {
                this.passwdTimeOut();
            }
            this.mayProceed();
            this.pingJobServer(request);
            this.processRequest();
        }
        catch (InconsistentStateException ise) {
            logger.warn("InconsistentStateException: org.akaza.openclinica.control.SecureController: ", (Throwable)ise);
            this.addPageMessage(ise.getOpenClinicaMessage());
            this.forwardPage(ise.getGoTo());
        }
        catch (InsufficientPermissionException ipe) {
            logger.warn("InsufficientPermissionException: org.akaza.openclinica.control.SecureController: ", (Throwable)ipe);
            this.forwardPage(ipe.getGoTo());
        }
        catch (OutOfMemoryError ome) {
            logger.error("Memory full in the process: ", (Throwable)ome);
            this.session.setAttribute("ome", (Object)"yes");
        }
        catch (Exception e) {
            logger.error("Process is throwing exception: ", (Throwable)e);
            this.forwardPage(Page.ERROR);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            logger.debug("GET Request");
            this.process(request, response);
        }
        catch (Exception e) {
            logger.error("Error processing request", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            logger.debug("POST Request");
            this.process(request, response);
        }
        catch (Exception e) {
            logger.error("Error processing request", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forwardPage(Page jspPage, boolean checkTrail) {
        Page page1 = Page.valueOf((String)jspPage.name());
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setHeader("Pragma", "no-cache");
        this.response.setDateHeader("Expires", -1L);
        this.response.setHeader("Cache-Control", "no-store");
        if (this.request.getAttribute(POP_UP_URL) == null) {
            this.request.setAttribute(POP_UP_URL, (Object)"");
        }
        try {
            if (checkTrail && this.session != null) {
                this.panel = (StudyInfoPanel)this.session.getAttribute(STUDY_INFO_PANEL);
                if (this.panel == null) {
                    this.panel = new StudyInfoPanel();
                    this.panel.setData(jspPage, this.session, this.request);
                } else {
                    this.panel.setData(jspPage, this.session, this.request);
                }
                this.session.setAttribute(STUDY_INFO_PANEL, (Object)this.panel);
            }
            String temp = page1.getFileName();
            this.context.getRequestDispatcher(temp).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (Exception se) {
            logger.error(se.getMessage(), (Throwable)se);
        }
        finally {
            page1 = null;
            jspPage = null;
            Object temp = null;
        }
    }

    protected void forwardPage(Page jspPage) {
        this.forwardPage(jspPage, true);
    }

    protected void addEntityList(String beanName, Collection<?> list, String messageIfEmpty, Page destinationIfEmpty) throws InconsistentStateException {
        if (list.isEmpty()) {
            throw new InconsistentStateException(destinationIfEmpty, messageIfEmpty);
        }
        this.request.setAttribute(beanName, list);
    }

    protected String getAdminServlet() {
        return "";
    }

    protected void setPopUpURL(String url) {
        if (url != null && this.request != null) {
            this.request.setAttribute(POP_UP_URL, (Object)url);
            this.request.setAttribute("hasPopUp", (Object)1);
            logger.info("just set pop up url: " + url);
        }
    }

    protected boolean entityIncluded(int entityId, String userName, AuditableEntityDAO<?> adao, DataSource ds) {
        StudyDAO sdao = new StudyDAO(ds);
        ArrayList studies = sdao.findAllByUserNotRemoved(userName);
        for (int i = 0; i < studies.size(); ++i) {
            ArrayList sites;
            if (adao.findByPKAndStudy(entityId, (StudyBean)studies.get(i)).getId() > 0) {
                return true;
            }
            if (((StudyBean)studies.get(i)).getParentStudyId() > 0 || (sites = sdao.findAllByParent(((StudyBean)studies.get(i)).getId())).size() <= 0) continue;
            for (int j = 0; j < sites.size(); ++j) {
                if (adao.findByPKAndStudy(entityId, (StudyBean)sites.get(j)).getId() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getRequestURLMinusServletPath() {
        String requestURLMinusServletPath = this.request.getRequestURL().toString().replaceAll(this.request.getServletPath(), "");
        return requestURLMinusServletPath;
    }

    public String getHostPath() {
        String requestURLMinusServletPath = this.getRequestURLMinusServletPath();
        return requestURLMinusServletPath.substring(0, requestURLMinusServletPath.lastIndexOf("/"));
    }

    public String getContextPath() {
        String contextPath = this.request.getContextPath().replaceAll("/", "");
        return contextPath;
    }

    public void checkStudyLocked(Page page, String message) {
        if (this.currentStudy.getStatus().equals((Term)Status.LOCKED)) {
            this.addPageMessage(message);
            this.forwardPage(page);
        }
    }

    public void checkStudyLocked(String url, String message) {
        try {
            if (this.currentStudy.getStatus().equals((Term)Status.LOCKED)) {
                this.addPageMessage(message);
                this.response.sendRedirect(url);
            }
        }
        catch (Exception ex) {
            logger.error("Study is not present: ", (Throwable)ex);
        }
    }

    public void checkStudyFrozen(Page page, String message) {
        if (this.currentStudy.getStatus().equals((Term)Status.FROZEN)) {
            this.addPageMessage(message);
            this.forwardPage(page);
        }
    }

    public void checkStudyFrozen(String url, String message) {
        try {
            if (this.currentStudy.getStatus().equals((Term)Status.FROZEN)) {
                this.addPageMessage(message);
                this.response.sendRedirect(url);
            }
        }
        catch (Exception ex) {
            logger.error("Study is not present: ", (Throwable)ex);
        }
    }

    public ArrayList<StudyEventDefinitionBean> getEventDefinitionsByCurrentStudy() {
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO studyEventDefinitionDAO = new StudyEventDefinitionDAO(this.sm.getDataSource());
        int parentStudyId = this.currentStudy.getParentStudyId();
        ArrayList allDefs = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = studyDAO.findByPK(parentStudyId);
            allDefs = studyEventDefinitionDAO.findAllActiveByStudy(parentStudy);
        } else {
            parentStudyId = this.currentStudy.getId();
            allDefs = studyEventDefinitionDAO.findAllActiveByStudy(this.currentStudy);
        }
        return allDefs;
    }

    public ArrayList<StudyGroupClassBean> getStudyGroupClassesByCurrentStudy() {
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        StudyGroupClassDAO studyGroupClassDAO = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyGroupDAO studyGroupDAO = new StudyGroupDAO(this.sm.getDataSource());
        int parentStudyId = this.currentStudy.getParentStudyId();
        ArrayList studyGroupClasses = new ArrayList();
        if (parentStudyId > 0) {
            StudyBean parentStudy = studyDAO.findByPK(parentStudyId);
            studyGroupClasses = studyGroupClassDAO.findAllActiveByStudy(parentStudy);
        } else {
            parentStudyId = this.currentStudy.getId();
            studyGroupClasses = studyGroupClassDAO.findAllActiveByStudy(this.currentStudy);
        }
        for (int i = 0; i < studyGroupClasses.size(); ++i) {
            StudyGroupClassBean sgc = (StudyGroupClassBean)studyGroupClasses.get(i);
            ArrayList groups = studyGroupDAO.findAllByGroupClass(sgc);
            sgc.setStudyGroups(groups);
        }
        return studyGroupClasses;
    }

    protected UserDetails getUserDetails() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (principal instanceof UserDetails) {
            return (UserDetails)principal;
        }
        return null;
    }

    public Boolean sendEmail(String to, String subject, String body, Boolean htmlEmail, Boolean sendMessage) throws Exception {
        return this.sendEmail(to, EmailEngine.getAdminEmail(), subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), sendMessage);
    }

    public Boolean sendEmail(String to, String subject, String body, Boolean htmlEmail) throws Exception {
        return this.sendEmail(to, EmailEngine.getAdminEmail(), subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), Boolean.valueOf(true));
    }

    public Boolean sendEmail(String to, String from, String subject, String body, Boolean htmlEmail) throws Exception {
        return this.sendEmail(to, from, subject, body, htmlEmail, respage.getString("your_message_sent_succesfully"), respage.getString("mail_cannot_be_sent_to_admin"), Boolean.valueOf(true));
    }

    public Boolean sendEmail(String to, String from, String subject, String body, Boolean htmlEmail, String successMessage, String failMessage, Boolean sendMessage) throws Exception {
        Boolean messageSent = true;
        try {
            JavaMailSenderImpl mailSender = (JavaMailSenderImpl)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("mailSender");
            Properties javaMailProperties = mailSender.getJavaMailProperties();
            if (null != javaMailProperties && (javaMailProperties.get("mail.smtp.localhost") == null || ((String)javaMailProperties.get("mail.smtp.localhost")).equalsIgnoreCase(""))) {
                javaMailProperties.put("mail.smtp.localhost", "localhost");
            }
            MimeMessage mimeMessage = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, htmlEmail.booleanValue());
            helper.setFrom(from);
            helper.setTo(this.processMultipleImailAddresses(to.trim()));
            helper.setSubject(subject);
            helper.setText(body, true);
            mailSender.send(mimeMessage);
            if (successMessage != null && sendMessage.booleanValue()) {
                this.addPageMessage(successMessage);
            }
            logger.debug("Email sent successfully on {}", (Object)new Date());
        }
        catch (MailException me) {
            if (failMessage != null && sendMessage.booleanValue()) {
                this.addPageMessage(failMessage);
            }
            logger.debug("Email could not be sent on {} due to: {}", (Object)new Date(), (Object)me.toString());
            messageSent = false;
        }
        return messageSent;
    }

    private InternetAddress[] processMultipleImailAddresses(String to) throws MessagingException {
        ArrayList<String> recipientsArray = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(to, ",");
        while (st.hasMoreTokens()) {
            recipientsArray.add(st.nextToken());
        }
        int sizeTo = recipientsArray.size();
        InternetAddress[] addressTo = new InternetAddress[sizeTo];
        for (int i = 0; i < sizeTo; ++i) {
            addressTo[i] = new InternetAddress(((String)recipientsArray.get(i)).toString());
        }
        return addressTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dowloadFile(File f, String contentType) throws Exception {
        this.response.setHeader("Content-disposition", "attachment; filename=\"" + f.getName() + "\";");
        this.response.setContentType("text/xml");
        this.response.setHeader("Pragma", "public");
        ServletOutputStream op = this.response.getOutputStream();
        FilterInputStream in = null;
        try {
            int length;
            this.response.setContentType("text/xml");
            this.response.setHeader("Pragma", "public");
            this.response.setContentLength((int)f.length());
            byte[] bbuf = new byte[(int)f.length()];
            in = new DataInputStream(new FileInputStream(f));
            while (in != null && (length = ((DataInputStream)in).read(bbuf)) != -1) {
                op.write(bbuf, 0, length);
            }
            in.close();
            op.flush();
            op.close();
        }
        catch (Exception ee) {
            logger.error("Error while downloading the file: ", (Throwable)ee);
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (op != null) {
                op.close();
            }
        }
    }

    public String getPageServletFileName() {
        String fileName = this.request.getServletPath();
        String temp = this.request.getPathInfo();
        if (temp != null) {
            fileName = fileName + temp;
        }
        if ((temp = this.request.getQueryString()) != null && temp.length() > 0) {
            fileName = fileName + "?" + temp;
        }
        return fileName;
    }

    public String getPageURL() {
        String url = this.request.getRequestURL().toString();
        String query = this.request.getQueryString();
        if (url != null && url.length() > 0 && query != null) {
            url = url + "?" + query;
        }
        return url;
    }

    public DiscrepancyNoteBean getNoteInfo(DiscrepancyNoteBean note) {
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        if ("itemData".equalsIgnoreCase(note.getEntityType())) {
            int itemDataId = note.getEntityId();
            ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
            ItemDataBean itemData = (ItemDataBean)iddao.findByPK(itemDataId);
            ItemDAO idao = new ItemDAO(this.sm.getDataSource());
            String entityName = note.getEntityName();
            if (entityName == null || entityName.trim().isEmpty()) {
                ItemBean item = idao.findByPK(itemData.getItemId());
                note.setEntityName(item.getName());
                this.request.setAttribute("item", (Object)item);
            }
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            EventCRFBean ec = ecdao.findByPK(itemData.getEventCRFId());
            StudyEventBean event = svdao.findByPK(ec.getStudyEventId());
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            note.setEventName(sed.getName());
            note.setEventStart(event.getDateStarted());
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = cdao.findByVersionId(ec.getCRFVersionId());
            note.setCrfName(crf.getName());
            note.setEventCRFId(ec.getId());
            String subjectName = note.getSubjectName();
            if (subjectName == null || subjectName.trim().isEmpty()) {
                StudySubjectBean ss = ssdao.findByPK(ec.getStudySubjectId());
                note.setSubjectName(ss.getName());
            }
            if (note.getDiscrepancyNoteTypeId() == 0) {
                note.setDiscrepancyNoteTypeId(DiscrepancyNoteType.FAILEDVAL.getId());
            }
        } else if ("eventCrf".equalsIgnoreCase(note.getEntityType())) {
            int eventCRFId = note.getEntityId();
            EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            EventCRFBean ec = ecdao.findByPK(eventCRFId);
            StudyEventBean event = svdao.findByPK(ec.getStudyEventId());
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            note.setEventName(sed.getName());
            note.setEventStart(event.getDateStarted());
            CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = cdao.findByVersionId(ec.getCRFVersionId());
            note.setCrfName(crf.getName());
            StudySubjectBean ss = ssdao.findByPK(ec.getStudySubjectId());
            note.setSubjectName(ss.getName());
            note.setEventCRFId(ec.getId());
        } else if ("studyEvent".equalsIgnoreCase(note.getEntityType())) {
            int eventId = note.getEntityId();
            StudyEventDAO svdao = new StudyEventDAO(this.sm.getDataSource());
            StudyEventBean event = svdao.findByPK(eventId);
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            note.setEventName(sed.getName());
            note.setEventStart(event.getDateStarted());
            StudySubjectBean ss = ssdao.findByPK(event.getStudySubjectId());
            note.setSubjectName(ss.getName());
        } else if ("studySub".equalsIgnoreCase(note.getEntityType())) {
            int studySubjectId = note.getEntityId();
            StudySubjectBean ss = ssdao.findByPK(studySubjectId);
            note.setSubjectName(ss.getName());
        } else if ("Subject".equalsIgnoreCase(note.getEntityType())) {
            int subjectId = note.getEntityId();
            StudySubjectBean ss = ssdao.findBySubjectIdAndStudy(subjectId, this.currentStudy);
            note.setSubjectName(ss.getName());
        }
        return note;
    }

    public void checkRoleByUserAndStudy(UserAccountBean ub, int studyId, int siteId) {
        StudyUserRoleBean studyUserRole = ub.getRoleByStudy(studyId);
        StudyUserRoleBean siteUserRole = new StudyUserRoleBean();
        if (siteId != 0) {
            siteUserRole = ub.getRoleByStudy(siteId);
        }
        if (studyUserRole.getRole().equals((Term)Role.INVALID) && siteUserRole.getRole().equals((Term)Role.INVALID)) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
    }

    protected void baseUrl() throws MalformedURLException {
        String portalURL = CoreResources.getField((String)"portalURL");
        URL pManageUrl = new URL(portalURL);
        ParticipantPortalRegistrar registrar = new ParticipantPortalRegistrar();
        Authorization pManageAuthorization = registrar.getAuthorization(this.currentStudy.getOid());
        String url = "";
        if (pManageAuthorization != null) {
            url = pManageUrl.getProtocol() + "://" + pManageAuthorization.getStudy().getHost() + "." + pManageUrl.getHost() + (pManageUrl.getPort() > 0 ? ":" + pManageUrl.getPort() : "");
        }
        logger.debug("the url: " + url);
        this.request.setAttribute("participantUrl", (Object)(url + "/"));
    }

    public CRFLocker getCrfLocker() {
        return this.crfLocker;
    }

    static /* synthetic */ void access$000(SecureController x0, HttpServletRequest x1, HttpServletResponse x2) throws OpenClinicaException, UnsupportedEncodingException {
        x0.process(x1, x2);
    }
}

