/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

public class CreateFiltersThreeServlet
extends SecureController {
    private static final long serialVersionUID = -4092193480703544003L;
    Locale locale;

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        if (action != null && !action.trim().isEmpty() && "validate".equalsIgnoreCase(action)) {
            FormProcessor fp = new FormProcessor(this.request);
            Validator v = new Validator(this.request);
            v.addValidation("fName", 1);
            v.addValidation("fDesc", 1);
            v.addValidation("fStatusId", 17, TermType.STATUS);
            this.errors = v.validate();
            if (!this.errors.isEmpty()) {
                String[] fieldNames = new String[]{"fName", "fDesc"};
                fp.setCurrentStringValuesAsPreset(fieldNames);
                fp.addPresetValue("fStatusId", fp.getInt("fStatusId"));
                this.addPageMessage(respage.getString("errors_in_submission_see_below"));
                this.setInputMessages(this.errors);
                this.setPresetValues(fp.getPresetValues());
                this.request.setAttribute("statuses", (Object)this.getStatuses());
                this.forwardPage(Page.CREATE_FILTER_SCREEN_5);
            } else {
                FilterBean fb = (FilterBean)this.session.getAttribute("newFilter");
                fb.setName(fp.getString("fName"));
                this.session.removeAttribute("newFilter");
                this.session.removeAttribute("newExp");
                fb.setDescription(fp.getString("fDesc"));
                fb.setStatus(Status.get((int)fp.getInt("fStatusId")));
                fb.setOwner(this.ub);
                logger.info("found owner id: " + fb.getOwner().getId());
                FilterDAO fDAO = new FilterDAO(this.sm.getDataSource());
                FilterBean fbFinal = fDAO.create(fb);
                this.addPageMessage(restext.getString("the_filter_named") + fbFinal.getName() + respage.getString("X_was_created_succesfully"));
                Integer check = (Integer)this.session.getAttribute("partOfCreateDataset");
                if (check != null) {
                    this.request.setAttribute("statuses", (Object)this.getStatuses());
                    this.session.removeAttribute("partOfCreateDataset");
                    this.forwardPage(Page.CREATE_DATASET_4);
                } else {
                    this.session.removeAttribute("newFilter");
                    FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
                    EntityBeanTable table = fp.getEntityBeanTable();
                    ArrayList filters = fdao.findAll();
                    ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
                    String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
                    table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
                    table.hideColumnLink(5);
                    table.setQuery("CreateFiltersOne", new HashMap());
                    table.setRows(filterRows);
                    table.computeDisplay();
                    this.request.setAttribute("table", (Object)table);
                    this.forwardPage(Page.CREATE_FILTER_SCREEN_1);
                }
            }
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    private ArrayList<Status> getStatuses() {
        Status[] statusesArray = new Status[]{Status.AVAILABLE, Status.PENDING, Status.PRIVATE, Status.UNAVAILABLE};
        List<Status> statuses = Arrays.asList(statusesArray);
        return new ArrayList<Status>(statuses);
    }
}

