/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.extract.CreateDatasetServlet;
import org.akaza.openclinica.control.extract.ViewSelectedServlet;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

/*
 * Exception performing whole class analysis ignored.
 */
public class EditSelectedServlet
extends SecureController {
    private static final long serialVersionUID = 7788585798902319150L;
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR) || this.currentRole.getRole().equals((Term)Role.MONITOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public void setUpStudyGroups() {
        ArrayList sgclasses = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allSelectedGroups"), StudyGroupClassBean.class);
        if (sgclasses == null || sgclasses.size() == 0) {
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyGroupClassDAO sgclassdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
            sgclasses = sgclassdao.findAllActiveByStudy(theStudy);
        }
        this.session.setAttribute("allSelectedGroups", (Object)sgclasses);
        this.request.setAttribute("allSelectedGroups", (Object)sgclasses);
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        boolean selectAll = fp.getBoolean("all");
        boolean selectAllItemsGroupsAttrs = fp.getBoolean("allAttrsAndItems");
        this.request.setAttribute("EditSelectedSubmitted", (Object)true);
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO imfdao = new ItemFormMetadataDAO(this.sm.getDataSource());
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        DatasetBean db = (DatasetBean)this.session.getAttribute("newDataset");
        if (db == null) {
            db = new DatasetBean();
            this.session.setAttribute("newDataset", (Object)db);
        }
        HashMap eventlist = (HashMap)this.session.getAttribute("eventsForCreateDataset");
        ArrayList ids = CreateDatasetServlet.allSedItemIdsInStudy((HashMap)eventlist, (CRFDAO)crfdao, (ItemDAO)idao);
        if (selectAll) {
            logger.info("select all..........");
            db = this.selectAll(db);
            MessageFormat msg = new MessageFormat("");
            msg.setLocale(this.locale);
            msg.applyPattern(respage.getString("choose_include_all_items_dataset"));
            Object[] arguments = new Object[]{ids.size()};
            this.addPageMessage(msg.format(arguments));
        }
        if (selectAllItemsGroupsAttrs) {
            logger.info("select everything....");
            db = this.selectAll(db);
            db.setShowCRFcompletionDate(true);
            db.setShowCRFinterviewerDate(true);
            db.setShowCRFinterviewerName(true);
            db.setShowCRFstatus(true);
            db.setShowCRFversion(true);
            db.setShowEventEnd(true);
            db.setShowEventEndTime(true);
            db.setShowEventLocation(true);
            db.setShowEventStart(true);
            db.setShowEventStartTime(true);
            db.setShowEventStatus(true);
            db.setShowSubjectAgeAtEvent(true);
            db.setShowSubjectDob(true);
            db.setShowSubjectGender(true);
            db.setShowSubjectGroupInformation(true);
            db.setShowSubjectStatus(true);
            db.setShowSubjectUniqueIdentifier(true);
            ArrayList sgclasses = ClassCastHelper.asArrayList((Object)this.session.getAttribute("allSelectedGroups"), StudyGroupClassBean.class);
            ArrayList<StudyGroupClassBean> newsgclasses = new ArrayList<StudyGroupClassBean>();
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyGroupClassDAO sgclassdao = new StudyGroupClassDAO(this.sm.getDataSource());
            StudyBean theStudy = studydao.findByPK(this.sm.getUserBean().getActiveStudyId());
            sgclasses = sgclassdao.findAllActiveByStudy(theStudy);
            for (int i = 0; i < sgclasses.size(); ++i) {
                StudyGroupClassBean sgclass = (StudyGroupClassBean)sgclasses.get(i);
                sgclass.setSelected(true);
                newsgclasses.add(sgclass);
            }
            this.session.setAttribute("allSelectedGroups", newsgclasses);
            this.request.setAttribute("allSelectedGroups", newsgclasses);
        }
        this.session.setAttribute("newDataset", (Object)db);
        HashMap events = (HashMap)this.session.getAttribute("eventsForCreateDataset");
        if (events == null) {
            events = new HashMap();
        }
        ArrayList allSelectItems = selectAll ? EditSelectedServlet.selectAll(events, (CRFDAO)crfdao, (ItemDAO)idao) : ViewSelectedServlet.getAllSelected((DatasetBean)db, (ItemDAO)idao, (ItemFormMetadataDAO)imfdao);
        this.session.setAttribute("numberOfStudyItems", (Object)new Integer(ids.size()).toString());
        this.session.setAttribute("allSelectedItems", (Object)allSelectItems);
        this.setUpStudyGroups();
        this.forwardPage(Page.CREATE_DATASET_VIEW_SELECTED);
    }

    public DatasetBean selectAll(DatasetBean db) {
        HashMap events = (HashMap)this.session.getAttribute("eventsForCreateDataset");
        if (events == null) {
            events = new HashMap();
        }
        this.request.setAttribute("eventlist", events);
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
        ArrayList allItems = EditSelectedServlet.selectAll(events, (CRFDAO)crfdao, (ItemDAO)idao);
        for (StudyEventDefinitionBean sed : events.keySet()) {
            if (db.getEventIds().contains(new Integer(sed.getId()))) continue;
            db.getEventIds().add(new Integer(sed.getId()));
        }
        db.getItemDefCrf().clear();
        db.setItemDefCrf(allItems);
        return db;
    }

    public static ArrayList<ItemBean> selectAll(HashMap<StudyEventDefinitionBean, ?> events, CRFDAO crfdao, ItemDAO idao) {
        ArrayList<ItemBean> allItems = new ArrayList<ItemBean>();
        for (StudyEventDefinitionBean sed : events.keySet()) {
            ArrayList crfs = crfdao.findAllActiveByDefinition(sed);
            for (int i = 0; i < crfs.size(); ++i) {
                CRFBean crf = (CRFBean)crfs.get(i);
                ArrayList items = idao.findAllActiveByCRF(crf);
                for (int j = 0; j < items.size(); ++j) {
                    ItemBean item = (ItemBean)items.get(j);
                    item.setCrfName(crf.getName());
                    item.setDefName(sed.getName());
                    item.setDefId(sed.getId());
                    item.setSelected(true);
                }
                allItems.addAll(items);
            }
        }
        return allItems;
    }
}

