/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.SectionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemFormMetadataDAO;
import org.akaza.openclinica.dao.submit.ItemGroupMetadataDAO;
import org.akaza.openclinica.dao.submit.SectionDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewItemDetailServlet
extends SecureController {
    private static final long serialVersionUID = 2300501836696638829L;
    Locale locale;
    public static String ITEM_ID = "itemId";
    public static String ITEM_OID = "itemOid";
    public static String ITEM_BEAN = "item";
    public static String VERSION_ITEMS = "versionItems";

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.currentStudy.getParentStudyId() == 0 && SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int itemId = fp.getInt(ITEM_ID);
        String itemOid = fp.getString(ITEM_OID);
        ItemDAO idao = new ItemDAO(this.sm.getDataSource());
        ItemFormMetadataDAO ifmdao = new ItemFormMetadataDAO(this.sm.getDataSource());
        ItemGroupMetadataDAO igmdao = new ItemGroupMetadataDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        SectionDAO sectionDao = new SectionDAO(this.sm.getDataSource());
        if (itemId == 0 && itemOid == null) {
            this.addPageMessage(respage.getString("please_choose_an_item_first"));
            this.forwardPage(Page.ITEM_DETAIL);
            return;
        }
        ItemBean item = itemId > 0 ? idao.findByPK(itemId) : (ItemBean)idao.findByOid(itemOid).get(0);
        ArrayList versions = idao.findAllVersionsByItemId(item.getId());
        ArrayList<ItemFormMetadataBean> versionItems = new ArrayList<ItemFormMetadataBean>();
        CRFBean crf = null;
        ItemFormMetadataBean imfBean = null;
        for (int i = 0; i < versions.size(); ++i) {
            Integer versionId = (Integer)versions.get(i);
            CRFVersionBean version = cvdao.findByPK(versionId.intValue());
            if (versionId == null || versionId <= 0) continue;
            if (igmdao.versionIncluded(versionId.intValue())) {
                imfBean = ifmdao.findByItemIdAndCRFVersionId(item.getId(), versionId.intValue());
                imfBean.setCrfVersionName(version.getName());
                crf = cdao.findByPK(version.getCrfId());
                imfBean.setCrfName(crf.getName());
                versionItems.add(imfBean);
                continue;
            }
            imfBean = ifmdao.findByItemIdAndCRFVersionIdNotInIGM(item.getId(), versionId.intValue());
            imfBean.setCrfVersionName(version.getName());
            crf = cdao.findByPK(version.getCrfId());
            imfBean.setCrfName(crf.getName());
            versionItems.add(imfBean);
        }
        SectionBean section = sectionDao.findByPK(imfBean.getSectionId());
        this.request.setAttribute(VERSION_ITEMS, versionItems);
        this.request.setAttribute(ITEM_BEAN, (Object)item);
        this.request.setAttribute("crf", crf);
        this.request.setAttribute("section", (Object)section);
        this.request.setAttribute("ifmdBean", (Object)imfBean);
        this.forwardPage(Page.ITEM_DETAIL);
    }
}

