/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.form;

import java.util.ArrayList;

public class Validation {
    private int type;
    private String errorMessage;
    private boolean errorMessageSet;
    private ArrayList<Object> arguments;
    private boolean alwaysExecuted;

    public Validation(int type) {
        this.type = type;
        this.arguments = new ArrayList();
        this.errorMessage = "";
        this.alwaysExecuted = false;
    }

    public ArrayList<Object> getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList<Object> arguments) {
        this.arguments = arguments;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public void addArgument(int arg) {
        this.arguments.add(new Integer(arg));
    }

    public void addArgument(boolean b) {
        this.arguments.add(new Boolean(b));
    }

    public void addArgument(float arg) {
        this.arguments.add(new Float(arg));
    }

    public boolean getBoolean(int index) {
        if (index >= this.arguments.size()) {
            return false;
        }
        Boolean b = (Boolean)this.arguments.get(index);
        return b;
    }

    public int getInt(int index) {
        if (index >= this.arguments.size()) {
            return 0;
        }
        Integer i = (Integer)this.arguments.get(index);
        return i;
    }

    public float getFloat(int index) {
        if (index >= this.arguments.size()) {
            return 0.0f;
        }
        try {
            Float i = (Float)this.arguments.get(index);
            return i.floatValue();
        }
        catch (ClassCastException ce) {
            Integer i = (Integer)this.arguments.get(index);
            return i.intValue();
        }
    }

    public String getString(int index) {
        if (index >= this.arguments.size()) {
            return "";
        }
        String s = (String)this.arguments.get(index);
        return s;
    }

    public Object getArg(int index) {
        if (index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(index);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.errorMessageSet = true;
    }

    public boolean isErrorMessageSet() {
        return this.errorMessageSet;
    }

    public boolean isAlwaysExecuted() {
        return this.alwaysExecuted;
    }

    public void setAlwaysExecuted(boolean alwaysExecuted) {
        this.alwaysExecuted = alwaysExecuted;
    }
}

