/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.core.EmailEngine;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;

public class ContactServlet
extends SecureController {
    private static final long serialVersionUID = 1418512105084748633L;

    public void mayProceed() throws InsufficientPermissionException {
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        if (action == null || action.trim().isEmpty()) {
            if (this.ub != null && this.ub.getId() > 0) {
                this.request.setAttribute("name", (Object)this.ub.getName());
                this.request.setAttribute("email", (Object)this.ub.getEmail());
            }
            this.forwardPage(Page.CONTACT);
        } else if ("submit".equalsIgnoreCase(action)) {
            Validator v = new Validator(this.request);
            v.addValidation("name", 1);
            v.addValidation("email", 6);
            v.addValidation("subject", 1);
            v.addValidation("message", 1);
            this.errors = v.validate();
            FormProcessor fp = new FormProcessor(this.request);
            if (!this.errors.isEmpty()) {
                this.request.setAttribute("name", (Object)fp.getString("name"));
                this.request.setAttribute("email", (Object)fp.getString("email"));
                this.request.setAttribute("subject", (Object)fp.getString("subject"));
                this.request.setAttribute("message", (Object)fp.getString("message"));
                this.request.setAttribute("formMessages", (Object)this.errors);
                this.forwardPage(Page.CONTACT);
            } else {
                this.sendEmail();
            }
        } else {
            if (this.ub != null && this.ub.getId() > 0) {
                this.request.setAttribute("name", (Object)this.ub.getName());
                this.request.setAttribute("email", (Object)this.ub.getEmail());
            }
            this.forwardPage(Page.CONTACT);
        }
    }

    private void sendEmail() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        String name = fp.getString("name");
        String email = fp.getString("email");
        String subject = fp.getString("subject");
        String message = fp.getString("message");
        logger.info("Sending email...");
        StringBuilder emailBody = new StringBuilder(restext.getString("dear_openclinica_administrator") + ",<br>");
        emailBody.append("<br>").append(name).append(" ").append(restext.getString("sent_you_the_following_message_br")).append("<br>");
        emailBody.append("<br>").append(resword.getString("email")).append(": ").append(email);
        emailBody.append("<br>").append(resword.getString("subject")).append(": ").append(subject);
        emailBody.append("<br>").append(resword.getString("message")).append(": ").append(message);
        if (this.currentStudy != null && this.currentStudy.isActive()) {
            String activeStudyLabel = this.currentStudy.getParentStudyId() > 0 ? this.currentStudy.getParentStudyName() + ": " + this.currentStudy.getName() + " (" + this.currentStudy.getIdentifier() + ")" : this.currentStudy.getName() + " (" + this.currentStudy.getIdentifier() + ")";
            emailBody.append("<br>").append(resword.getString("active_study")).append(": ").append(activeStudyLabel);
        }
        String sysUrl = SQLInitServlet.getField((String)"sysURL");
        emailBody.append("<br><br>").append("System URL: ").append("<a href='").append(sysUrl).append("'>").append(sysUrl).append("</a><br>");
        this.sendEmail(EmailEngine.getAdminEmail(), email, subject, emailBody.toString(), Boolean.valueOf(true));
        if (this.ub != null && this.ub.getId() > 0) {
            this.forwardPage(Page.MENU_SERVLET);
        } else {
            this.forwardPage(Page.LOGIN);
        }
    }
}

