/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.UserAccountRow;

public class AssignUserToStudyServlet
extends SecureController {
    private static final long serialVersionUID = 4960926890819274181L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        ArrayList users = this.findUsers();
        String nextListPage = this.request.getParameter("next_list_page");
        if (action == null || action.trim().isEmpty() || nextListPage != null && nextListPage.equalsIgnoreCase("true")) {
            HashMap<Integer, Integer> tmpSelectedUsersMap;
            FormProcessor fp = new FormProcessor(this.request);
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList allRows = UserAccountRow.generateRowsFromBeans((ArrayList)users);
            if (nextListPage == null) {
                this.session.removeAttribute("tmpSelectedUsersMap");
            }
            if ((tmpSelectedUsersMap = ClassCastHelper.asHashMap((Object)this.session.getAttribute("tmpSelectedUsersMap"), Integer.class, Integer.class)) == null) {
                tmpSelectedUsersMap = new HashMap<Integer, Integer>();
            }
            if (nextListPage != null && nextListPage.equalsIgnoreCase("true")) {
                for (int i = 0; i < users.size(); ++i) {
                    int id = fp.getInt("id" + i);
                    int roleId = fp.getInt("activeStudyRoleId" + i);
                    String checked = fp.getString("selected" + i);
                    if (checked != null && !checked.trim().isEmpty() && "yes".equalsIgnoreCase(checked.trim())) {
                        tmpSelectedUsersMap.put(id, roleId);
                        continue;
                    }
                    if (!tmpSelectedUsersMap.containsKey(id)) continue;
                    tmpSelectedUsersMap.remove(id);
                }
                this.session.setAttribute("tmpSelectedUsersMap", tmpSelectedUsersMap);
            }
            String[] columns = new String[]{resword.getString("user_name"), resword.getString("first_name"), resword.getString("last_name"), resword.getString("role"), resword.getString("selected"), resword.getString("notes")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(3);
            table.hideColumnLink(4);
            table.hideColumnLink(5);
            table.setQuery("AssignUserToStudy", new HashMap());
            table.setRows(allRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            ArrayList roles = Role.toArrayList();
            if (this.currentStudy.getParentStudyId() > 0) {
                roles.remove(Role.COORDINATOR);
                roles.remove(Role.STUDYDIRECTOR);
            }
            roles.remove(Role.ADMIN);
            this.request.setAttribute("roles", (Object)roles);
            this.forwardPage(Page.STUDY_USER_LIST);
        } else if ("submit".equalsIgnoreCase(action)) {
            this.addUser(users);
        }
    }

    private void addUser(ArrayList<UserAccountBean> users) throws Exception {
        String pageMass = "";
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        HashMap tmpSelectedUsersMap = ClassCastHelper.asHashMap((Object)this.session.getAttribute("tmpSelectedUsersMap"), Integer.class, Integer.class);
        HashSet<Integer> addedUsers = new HashSet<Integer>();
        boolean continueLoop = true;
        for (int i = 0; i < users.size() && continueLoop; ++i) {
            int id = fp.getInt("id" + i);
            String firstName = fp.getString("firstName" + i);
            String lastName = fp.getString("lastName" + i);
            String name = fp.getString("name" + i);
            String email = fp.getString("email" + i);
            int roleId = fp.getInt("activeStudyRoleId" + i);
            String checked = fp.getString("selected" + i);
            if (checked != null && !checked.trim().isEmpty() && "yes".equalsIgnoreCase(checked.trim())) {
                logger.info("one user selected");
                UserAccountBean u = new UserAccountBean();
                u.setId(id);
                u.setLastName(lastName);
                u.setFirstName(firstName);
                u.setName(name);
                u.setEmail(email);
                u.setActiveStudyId(this.ub.getActiveStudyId());
                u.setOwnerId(id);
                addedUsers.add(id);
                StudyUserRoleBean sub = new StudyUserRoleBean();
                sub.setRoleName(Role.get((int)roleId).getName());
                sub.setStudyId(this.currentStudy.getId());
                sub.setStatus(Status.AVAILABLE);
                sub.setOwner(this.ub);
                if (udao.findStudyUserRole(u, sub).getName() == null || !udao.findStudyUserRole(u, sub).getName().isEmpty()) {
                    continueLoop = false;
                    break;
                }
                udao.createStudyUserRole(u, sub);
                logger.info("one user added");
                pageMass = pageMass + this.sendEmail(u, sub);
                continue;
            }
            if (tmpSelectedUsersMap == null || !tmpSelectedUsersMap.containsKey(id)) continue;
            tmpSelectedUsersMap.remove(id);
        }
        if (tmpSelectedUsersMap != null) {
            for (Integer idSelected : tmpSelectedUsersMap.keySet()) {
                int roleId = (Integer)tmpSelectedUsersMap.get(idSelected);
                boolean alreadyAdded = false;
                for (Integer idAdded : addedUsers) {
                    if (idSelected != idAdded) continue;
                    alreadyAdded = true;
                    break;
                }
                if (alreadyAdded) continue;
                UserAccountBean u = new UserAccountBean();
                u.setId(idSelected.intValue());
                u.setName(udao.findByPK(idSelected.intValue()).getName());
                u.setActiveStudyId(this.ub.getActiveStudyId());
                u.setOwnerId(idSelected.intValue());
                StudyUserRoleBean sub = new StudyUserRoleBean();
                sub.setRoleName(Role.get((int)roleId).getName());
                sub.setStudyId(this.currentStudy.getId());
                sub.setStatus(Status.AVAILABLE);
                sub.setOwner(this.ub);
                udao.createStudyUserRole(u, sub);
                logger.info("one user added");
                pageMass = pageMass + this.sendEmail(u, sub);
            }
        }
        this.session.removeAttribute("tmpSelectedUsersMap");
        if ("".equals(pageMass)) {
            this.addPageMessage(respage.getString("no_new_user_assigned_to_study"));
        } else {
            this.addPageMessage(pageMass);
        }
        ArrayList pageMessages = ClassCastHelper.asArrayList((Object)this.request.getAttribute("pageMessages"), String.class);
        this.session.setAttribute("pageMessages", (Object)pageMessages);
        if (this.currentStudy.getParentStudyId() == 0) {
            this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
        } else {
            this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
        }
    }

    private ArrayList<UserAccountBean> findUsers() {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList userList = udao.findAll();
        ArrayList<UserAccountBean> userAvailable = new ArrayList<UserAccountBean>();
        for (int i = 0; i < userList.size(); ++i) {
            UserAccountBean u = (UserAccountBean)userList.get(i);
            int activeStudyId = this.currentStudy.getId();
            StudyUserRoleBean sub = udao.findRoleByUserNameAndStudyId(u.getName(), activeStudyId);
            if (!sub.isActive()) {
                sub.setRole(Role.RESEARCHASSISTANT);
                sub.setStudyId(activeStudyId);
                u.setActiveStudyId(activeStudyId);
                u.addRole(sub);
                u.setStatus(Status.AVAILABLE);
                if (this.currentStudy.getParentStudyId() > 0) {
                    StudyUserRoleBean subParent = udao.findRoleByUserNameAndStudyId(u.getName(), this.currentStudy.getParentStudyId());
                    if (subParent.isActive()) {
                        u.setNotes(subParent.getRole().getDescription() + " " + respage.getString("in_parent_study"));
                    }
                } else {
                    StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
                    ArrayList sites = sdao.findAllByParent(this.currentStudy.getId());
                    String notes = "";
                    for (int j = 0; j < sites.size(); ++j) {
                        StudyBean site = (StudyBean)sites.get(j);
                        StudyUserRoleBean subSite = udao.findRoleByUserNameAndStudyId(u.getName(), site.getId());
                        if (!subSite.isActive()) continue;
                        notes = notes + subSite.getRole().getDescription() + respage.getString("in_site") + ":" + site.getName() + "; ";
                    }
                    u.setNotes(notes);
                }
            } else {
                sub.setStudyId(activeStudyId);
                u.setActiveStudyId(activeStudyId);
                u.addRole(sub);
                u.setStatus(Status.UNAVAILABLE);
            }
            userAvailable.add(u);
        }
        return userAvailable;
    }

    private String sendEmail(UserAccountBean u, StudyUserRoleBean sub) throws Exception {
        logger.info("Sending email...");
        String body = u.getFirstName() + " " + u.getLastName() + "(" + resword.getString("username") + ": " + u.getName() + ") " + respage.getString("has_been_assigned_to_the_study") + this.currentStudy.getName() + " " + resword.getString("as") + " \"" + sub.getRole().getDescription() + "\". ";
        if (this.currentStudy.getParentStudyId() > 0) {
            body = u.getFirstName() + " " + u.getLastName() + "(" + resword.getString("username") + ": " + u.getName() + ") " + respage.getString("has_been_assigned_to_the_site") + this.currentStudy.getName() + " under the Study " + this.currentStudy.getParentStudyName() + " " + resword.getString("as") + " \"" + sub.getRole().getDescription() + "\". ";
        }
        return body;
    }
}

