/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.FontRecord;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.akaza.openclinica.bean.admin.AuditBean;
import org.akaza.openclinica.bean.admin.DeletedEventCRFBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.AuditDAO;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ExportExcelStudySubjectAuditLogServlet
extends SecureController {
    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_STUDY_SUBJECTS, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        Label label;
        int i;
        int j;
        Label label2;
        int i2;
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        AuditDAO adao = new AuditDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
        StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        StudySubjectBean studySubject = null;
        SubjectBean subject = null;
        ArrayList events = null;
        ArrayList studySubjectAudits = new ArrayList();
        ArrayList eventCRFAudits = new ArrayList();
        ArrayList studyEventAudits = new ArrayList();
        ArrayList allDeletedEventCRFs = new ArrayList();
        ArrayList allEventCRFs = new ArrayList();
        ArrayList allEventCRFItems = new ArrayList();
        FormProcessor fp = new FormProcessor(this.request);
        int studySubId = fp.getInt("id", true);
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_view"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
        } else {
            Object studyEvent;
            int i3;
            studySubject = subdao.findByPK(studySubId);
            StudyBean study = studydao.findByPK(studySubject.getStudyId());
            if (studySubject.getStudyId() != this.currentStudy.getId()) {
                if (this.currentStudy.getParentStudyId() > 0) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
                ArrayList sites = studydao.findOlnySiteIdsByStudy(this.currentStudy);
                if (!sites.contains(study.getId())) {
                    this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
                    this.forwardPage(Page.MENU_SERVLET);
                    return;
                }
            }
            subject = sdao.findByPK(studySubject.getSubjectId());
            ArrayList studySubjectAuditEvents = adao.findStudySubjectAuditEvents(studySubject.getId());
            for (AuditBean auditBean : studySubjectAuditEvents) {
                if (auditBean.getAuditEventTypeId() != 3) continue;
                auditBean.setOldValue(Status.get((int)Integer.parseInt(auditBean.getOldValue())).getName());
                auditBean.setNewValue(Status.get((int)Integer.parseInt(auditBean.getNewValue())).getName());
            }
            studySubjectAudits.addAll(studySubjectAuditEvents);
            studySubjectAudits.addAll(adao.findSubjectAuditEvents(subject.getId()));
            studySubjectAudits.addAll(adao.findStudySubjectGroupAssignmentAuditEvents(studySubject.getId()));
            events = sedao.findAllByStudySubject(studySubject);
            for (i3 = 0; i3 < events.size(); ++i3) {
                studyEvent = (StudyEventBean)events.get(i3);
                studyEvent.setStudyEventDefinition(seddao.findByPK(studyEvent.getStudyEventDefinitionId()));
                studyEvent.setEventCRFs(ecdao.findAllByStudyEvent((StudyEventBean)studyEvent));
                ArrayList deletedEventCRFs = adao.findDeletedEventCRFsFromAuditEvent(studyEvent.getId());
                allDeletedEventCRFs.addAll(deletedEventCRFs);
                ArrayList eventCRFs = adao.findAllEventCRFAuditEvents(studyEvent.getId());
                allEventCRFs.addAll(eventCRFs);
                ArrayList eventCRFItems = adao.findAllEventCRFAuditEventsWithItemDataType(studyEvent.getId());
                allEventCRFItems.addAll(eventCRFItems);
                logger.info("deletedEventCRFs size[" + deletedEventCRFs.size() + "]");
                logger.info("allEventCRFItems size[" + allEventCRFItems.size() + "]");
            }
            for (i3 = 0; i3 < events.size(); ++i3) {
                studyEvent = (StudyEventBean)events.get(i3);
                studyEventAudits.addAll(adao.findStudyEventAuditEvents(studyEvent.getId()));
                ArrayList eventCRFs = studyEvent.getEventCRFs();
                for (int j2 = 0; j2 < eventCRFs.size(); ++j2) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(j2);
                    eventCRF.setCrfVersion(cvdao.findByPK(eventCRF.getCRFVersionId()));
                    eventCRF.setCrf(cdao.findByVersionId(eventCRF.getCRFVersionId()));
                    eventCRFAudits.addAll(adao.findEventCRFAuditEventsWithItemDataType(eventCRF.getId()));
                    logger.info("eventCRFAudits size [" + eventCRFAudits.size() + "] eventCRF id [" + eventCRF.getId() + "]");
                }
            }
            ItemDataDAO itemDataDao = new ItemDataDAO(this.sm.getDataSource());
            for (Object o : eventCRFAudits) {
                AuditBean ab = (AuditBean)o;
                if (!ab.getAuditTable().equalsIgnoreCase("item_data")) continue;
                ItemDataBean idBean = (ItemDataBean)itemDataDao.findByPK(ab.getEntityId());
                ab.setOrdinal(idBean.getOrdinal());
            }
        }
        WritableFont headerFormat = new WritableFont(WritableFont.ARIAL, 8, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLUE2);
        WritableCellFormat cellFormat = new WritableCellFormat();
        cellFormat.setFont((FontRecord)headerFormat);
        this.response.setContentType("application/vnd.ms-excel");
        this.response.setHeader("Content-Disposition", "attachment; filename=export.xls");
        WorkbookSettings wbSettings = new WorkbookSettings();
        wbSettings.setLocale(new Locale("en", "EN"));
        WritableWorkbook workbook = Workbook.createWorkbook((OutputStream)this.response.getOutputStream(), (WorkbookSettings)wbSettings);
        int row = 0;
        workbook.createSheet("Subject Information", 0);
        WritableSheet excelSheet = workbook.getSheet(0);
        String[] excelRow = new String[]{"study_subject_ID", "secondary_subject_ID", "date_of_birth", "person_ID", "created_by", "status"};
        for (i2 = 0; i2 < excelRow.length; ++i2) {
            label2 = new Label(i2, row, ResourceBundleProvider.getResWord((String)excelRow[i2]), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label2);
        }
        ++row;
        excelRow = new String[]{studySubject.getLabel(), studySubject.getSecondaryLabel(), this.dateFormat(subject.getDateOfBirth()), subject.getUniqueIdentifier(), studySubject.getOwner().getName(), studySubject.getStatus().getName()};
        for (i2 = 0; i2 < excelRow.length; ++i2) {
            label2 = new Label(i2, row, ResourceBundleProvider.getResWord((String)excelRow[i2]), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label2);
        }
        ++row;
        ++row;
        excelRow = new String[]{"audit_event", "date_time_of_server", "user", "value_type", "old", "new"};
        for (i2 = 0; i2 < excelRow.length; ++i2) {
            label2 = new Label(i2, row, ResourceBundleProvider.getResWord((String)excelRow[i2]), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label2);
        }
        ++row;
        for (j = 0; j < studySubjectAudits.size(); ++j) {
            AuditBean audit = (AuditBean)studySubjectAudits.get(j);
            excelRow = new String[]{audit.getAuditEventTypeName(), this.dateTimeFormat(audit.getAuditDate()), audit.getUserName(), audit.getEntityName(), audit.getOldValue(), audit.getNewValue()};
            for (i = 0; i < excelRow.length; ++i) {
                label = new Label(i, row, ResourceBundleProvider.getResWord((String)excelRow[i]), (CellFormat)cellFormat);
                excelSheet.addCell((WritableCell)label);
            }
            ++row;
        }
        ++row;
        excelRow = new String[]{"study_events", "location", "date", "occurrence_number"};
        for (i2 = 0; i2 < excelRow.length; ++i2) {
            label2 = new Label(i2, row, ResourceBundleProvider.getResWord((String)excelRow[i2]), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label2);
        }
        ++row;
        for (j = 0; j < events.size(); ++j) {
            StudyEventBean event = (StudyEventBean)events.get(j);
            excelRow = event.getStartTimeFlag() ? new String[]{event.getStudyEventDefinition().getName(), event.getLocation(), this.dateTimeFormat(event.getDateStarted()), Integer.toString(event.getSampleOrdinal())} : new String[]{event.getStudyEventDefinition().getName(), event.getLocation(), this.dateFormat(event.getDateStarted()), Integer.toString(event.getSampleOrdinal())};
            for (i = 0; i < excelRow.length; ++i) {
                label = new Label(i, row, ResourceBundleProvider.getResWord((String)excelRow[i]), (CellFormat)cellFormat);
                excelSheet.addCell((WritableCell)label);
            }
            ++row;
        }
        this.autoSizeColumns(excelSheet);
        int sheet = 0;
        for (int eventCount = 0; eventCount < events.size(); ++eventCount) {
            String newValue;
            int j3;
            int i4;
            row = 0;
            StudyEventBean event = (StudyEventBean)events.get(eventCount);
            workbook.createSheet(event.getStudyEventDefinition().getName().replace("/", ".") + "_" + event.getSampleOrdinal(), ++sheet);
            excelSheet = workbook.getSheet(sheet);
            label = null;
            label = new Label(0, row, ResourceBundleProvider.getResWord((String)"name"), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label);
            label = new Label(1, row, event.getStudyEventDefinition().getName(), (CellFormat)cellFormat);
            excelSheet.addCell((WritableCell)label);
            label = new Label(0, ++row, "Location");
            excelSheet.addCell((WritableCell)label);
            label = new Label(1, row, event.getLocation());
            excelSheet.addCell((WritableCell)label);
            label = new Label(0, ++row, "Start Date");
            excelSheet.addCell((WritableCell)label);
            label = event.getStartTimeFlag() ? new Label(1, row, this.dateTimeFormat(event.getDateStarted())) : new Label(1, row, this.dateFormat(event.getDateStarted()));
            excelSheet.addCell((WritableCell)label);
            label = new Label(0, ++row, "Status");
            excelSheet.addCell((WritableCell)label);
            label = new Label(1, row, event.getSubjectEventStatus().getName());
            excelSheet.addCell((WritableCell)label);
            label = new Label(0, ++row, ResourceBundleProvider.getResWord((String)"occurrence_number"));
            excelSheet.addCell((WritableCell)label);
            label = new Label(1, row, Integer.toString(event.getSampleOrdinal()));
            excelSheet.addCell((WritableCell)label);
            ++row;
            ++row;
            excelRow = new String[]{"name", "version", "deleted_by", "delete_date"};
            for (i4 = 0; i4 < excelRow.length; ++i4) {
                label = new Label(i4, row, ResourceBundleProvider.getResWord((String)excelRow[i4]), (CellFormat)cellFormat);
                excelSheet.addCell((WritableCell)label);
            }
            ++row;
            for (j3 = 0; j3 < allDeletedEventCRFs.size(); ++j3) {
                DeletedEventCRFBean deletedEventCRF = (DeletedEventCRFBean)allDeletedEventCRFs.get(j3);
                if (deletedEventCRF.getStudyEventId() != event.getId()) continue;
                excelRow = new String[]{deletedEventCRF.getCrfName(), deletedEventCRF.getCrfVersion(), deletedEventCRF.getDeletedBy(), this.dateFormat(deletedEventCRF.getDeletedDate())};
                for (int i5 = 0; i5 < excelRow.length; ++i5) {
                    label = new Label(i5, row, ResourceBundleProvider.getResWord((String)excelRow[i5]), (CellFormat)cellFormat);
                    excelSheet.addCell((WritableCell)label);
                }
                ++row;
            }
            ++row;
            ++row;
            excelRow = new String[]{"audit_event", "date_time_of_server", "user", "value_type", "old", "new"};
            for (i4 = 0; i4 < excelRow.length; ++i4) {
                label = new Label(i4, row, ResourceBundleProvider.getResWord((String)excelRow[i4]), (CellFormat)cellFormat);
                excelSheet.addCell((WritableCell)label);
            }
            ++row;
            for (j3 = 0; j3 < studyEventAudits.size(); ++j3) {
                AuditBean studyEvent = (AuditBean)studyEventAudits.get(j3);
                if (studyEvent.getEntityId() != event.getId()) continue;
                String getOld = studyEvent.getOldValue();
                String oldValue = "";
                oldValue = getOld.equals("0") ? "invalid" : (getOld.equals("1") ? "scheduled" : (getOld.equals("2") ? "not_scheduled" : (getOld.equals("3") ? "data_entry_started" : (getOld.equals("4") ? "completed" : (getOld.equals("5") ? "stopped" : (getOld.equals("6") ? "skipped" : (getOld.equals("7") ? "locked" : (getOld.equals("8") ? "signed" : studyEvent.getOldValue()))))))));
                String getNew = studyEvent.getNewValue();
                newValue = "";
                newValue = getNew.equals("0") ? "invalid" : (getNew.equals("1") ? "scheduled" : (getNew.equals("2") ? "not_scheduled" : (getNew.equals("3") ? "data_entry_started" : (getNew.equals("4") ? "completed" : (getNew.equals("5") ? "removed" : (getNew.equals("6") ? "skipped" : (getNew.equals("7") ? "locked" : (getNew.equals("8") ? "signed" : (getNew.equals("9") ? "forzen" : studyEvent.getNewValue())))))))));
                excelRow = new String[]{studyEvent.getAuditEventTypeName(), this.dateTimeFormat(studyEvent.getAuditDate()), studyEvent.getUserName(), studyEvent.getEntityName() + "(" + studyEvent.getOrdinal() + ")", oldValue, newValue};
                for (int i6 = 0; i6 < excelRow.length; ++i6) {
                    label = new Label(i6, row, ResourceBundleProvider.getResWord((String)excelRow[i6]), (CellFormat)cellFormat);
                    excelSheet.addCell((WritableCell)label);
                }
                ++row;
            }
            ++row;
            ++row;
            for (j3 = 0; j3 < allEventCRFs.size(); ++j3) {
                AuditBean auditBean = (AuditBean)allEventCRFs.get(j3);
                if (auditBean.getStudyEventId() == event.getId()) {
                    int i7;
                    excelRow = new String[]{"name", "version", "date_interviewed", "interviewer_name", "owner"};
                    for (i7 = 0; i7 < excelRow.length; ++i7) {
                        label = new Label(i7, row, ResourceBundleProvider.getResWord((String)excelRow[i7]), (CellFormat)cellFormat);
                        excelSheet.addCell((WritableCell)label);
                    }
                    ++row;
                    excelRow = new String[]{auditBean.getCrfName(), auditBean.getCrfVersionName(), this.dateFormat(auditBean.getDateInterviewed()), auditBean.getInterviewerName(), auditBean.getUserName()};
                    for (i7 = 0; i7 < excelRow.length; ++i7) {
                        label = new Label(i7, row, ResourceBundleProvider.getResWord((String)excelRow[i7]), (CellFormat)cellFormat);
                        excelSheet.addCell((WritableCell)label);
                    }
                    ++row;
                    ++row;
                    excelRow = new String[]{"audit_event", "date_time_of_server", "user", "value_type", "old", "new"};
                    for (i7 = 0; i7 < excelRow.length; ++i7) {
                        label = new Label(i7, row, ResourceBundleProvider.getResWord((String)excelRow[i7]), (CellFormat)cellFormat);
                        excelSheet.addCell((WritableCell)label);
                    }
                    ++row;
                    ++row;
                    for (int k = 0; k < allEventCRFItems.size(); ++k) {
                        --row;
                        AuditBean eventCrfAudit = (AuditBean)allEventCRFItems.get(k);
                        if (eventCrfAudit.getStudyEventId() == event.getId() && eventCrfAudit.getEventCrfVersionId() == auditBean.getEventCrfVersionId()) {
                            String getNew;
                            String getOld;
                            String oldValue = "";
                            newValue = "";
                            oldValue = eventCrfAudit.getAuditEventTypeId() == 12 || eventCrfAudit.getEntityName().equals("Status") ? ((getOld = eventCrfAudit.getOldValue()).equals("0") ? "invalid" : (getOld.equals("1") ? "available" : (getOld.equals("2") ? "unavailable" : (getOld.equals("3") ? "private" : (getOld.equals("4") ? "pending" : (getOld.equals("5") ? "removed" : (getOld.equals("6") ? "locked" : (getOld.equals("7") ? "auto-removed" : getOld)))))))) : (eventCrfAudit.getAuditEventTypeId() == 32 ? ((getOld = eventCrfAudit.getOldValue()).equals("0") ? "FALSE" : (getOld.equals("1") ? "TRUE" : getOld)) : eventCrfAudit.getOldValue());
                            newValue = eventCrfAudit.getAuditEventTypeId() == 12 || eventCrfAudit.getEntityName().equals("Status") ? ((getNew = eventCrfAudit.getNewValue()).equals("0") ? "invalid" : (getNew.equals("1") ? "available" : (getNew.equals("2") ? "unavailable" : (getNew.equals("3") ? "private" : (getNew.equals("4") ? "pending" : (getNew.equals("5") ? "removed" : (getNew.equals("6") ? "locked" : (getNew.equals("7") ? "auto-removed" : getNew)))))))) : (eventCrfAudit.getAuditEventTypeId() == 32 ? ((getNew = eventCrfAudit.getNewValue()).equals("0") ? "FALSE" : (getNew.equals("1") ? "TRUE" : getNew)) : eventCrfAudit.getNewValue());
                            String ordinal = "";
                            if (eventCrfAudit.getOrdinal() != 0) {
                                ordinal = "(" + eventCrfAudit.getOrdinal() + ")";
                            } else if (eventCrfAudit.getOrdinal() == 0 && eventCrfAudit.getItemDataRepeatKey() != 0) {
                                ordinal = "(" + eventCrfAudit.getItemDataRepeatKey() + ")";
                            }
                            excelRow = new String[]{eventCrfAudit.getAuditEventTypeName(), this.dateTimeFormat(eventCrfAudit.getAuditDate()), eventCrfAudit.getUserName(), eventCrfAudit.getEntityName() + ordinal, oldValue, newValue};
                            for (int i8 = 0; i8 < excelRow.length; ++i8) {
                                label = new Label(i8, row, ResourceBundleProvider.getResWord((String)excelRow[i8]), (CellFormat)cellFormat);
                                excelSheet.addCell((WritableCell)label);
                            }
                            ++row;
                            ++row;
                        }
                        ++row;
                    }
                    ++row;
                }
                this.autoSizeColumns(excelSheet);
            }
        }
        workbook.write();
        workbook.close();
        this.session.setAttribute("subject", null);
        this.session.setAttribute("study", null);
        this.session.setAttribute("studySub", null);
        this.session.setAttribute("studyEventAudits", null);
        this.session.setAttribute("studySubjectAudits", null);
        this.session.setAttribute("events", null);
        this.session.setAttribute("eventCRFAudits", null);
        this.session.setAttribute("allDeletedEventCRFs", null);
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    private String dateFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dteFormat = new SimpleDateFormat(ResourceBundleProvider.getFormatBundle().getString("date_format_string"));
        return dteFormat.format(date);
    }

    private String dateTimeFormat(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dtetmeFormat = new SimpleDateFormat(ResourceBundleProvider.getFormatBundle().getString("date_time_format_string"));
        return dtetmeFormat.format(date);
    }

    private void autoSizeColumns(WritableSheet sheet) {
        for (int x = 0; x < 6; ++x) {
            CellView cell = sheet.getColumnView(x);
            cell.setAutosize(true);
            sheet.setColumnView(x, cell);
        }
    }
}

