/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.SubjectEventStatus;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupClassBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.control.managestudy.ListEventsForSubjectTableFactory;
import org.akaza.openclinica.control.managestudy.ListEventsForSubjectTableToolbar;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.ListEventsForSubjectFilter;
import org.akaza.openclinica.dao.managestudy.ListEventsForSubjectSort;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.core.filter.FilterMatcher;
import org.jmesa.core.filter.MatcherKey;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Filter;
import org.jmesa.limit.FilterSet;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.HtmlBuilder;
import org.jmesa.view.html.toolbar.Toolbar;

public class ListEventsForSubjectTableFactory
extends AbstractTableFactory {
    private StudyEventDefinitionDAO studyEventDefinitionDao;
    private StudySubjectDAO studySubjectDAO;
    private SubjectDAO subjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private StudyGroupDAO studyGroupDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private CRFDAO crfDAO;
    private CRFVersionDAO crfVersionDAO;
    private StudyBean studyBean;
    private String[] columnNames = new String[0];
    private ArrayList<StudyEventDefinitionBean> studyEventDefinitions;
    private ArrayList<CRFBean> crfBeans;
    private ArrayList<EventDefinitionCRFBean> eventDefinitionCrfs;
    private ArrayList<StudyGroupClassBean> studyGroupClasses;
    private StudyUserRoleBean currentRole;
    private UserAccountBean currentUser;
    private boolean showMoreLink;
    private ResourceBundle resword;
    private ResourceBundle resformat;
    private StudyEventDefinitionBean selectedStudyEventDefinition;
    final HashMap<Integer, String> imageIconPaths = new HashMap(8);
    final HashMap<Integer, String> crfColumnImageIconPaths = new HashMap(8);

    public CRFVersionDAO getCrfVersionDAO() {
        return this.crfVersionDAO;
    }

    public void setCrfVersionDAO(CRFVersionDAO crfVersionDAO) {
        this.crfVersionDAO = crfVersionDAO;
    }

    public ListEventsForSubjectTableFactory(boolean showMoreLink) {
        this.imageIconPaths.put(1, "images/icon_Scheduled.gif");
        this.imageIconPaths.put(2, "images/icon_NotStarted.gif");
        this.imageIconPaths.put(3, "images/icon_InitialDE.gif");
        this.imageIconPaths.put(4, "images/icon_DEcomplete.gif");
        this.imageIconPaths.put(5, "images/icon_Stopped.gif");
        this.imageIconPaths.put(6, "images/icon_Skipped.gif");
        this.imageIconPaths.put(7, "images/icon_Locked.gif");
        this.imageIconPaths.put(8, "images/icon_Signed.gif");
        this.crfColumnImageIconPaths.put(0, "images/CRF_status_icon_Invalid.gif");
        this.crfColumnImageIconPaths.put(1, "images/CRF_status_icon_Scheduled.gif");
        this.crfColumnImageIconPaths.put(2, "images/CRF_status_icon_Started.gif");
        this.crfColumnImageIconPaths.put(3, "images/CRF_status_icon_InitialDEcomplete.gif");
        this.crfColumnImageIconPaths.put(4, "images/CRF_status_icon_DDE.gif");
        this.crfColumnImageIconPaths.put(5, "images/CRF_status_icon_Complete.gif");
        this.crfColumnImageIconPaths.put(6, "images/CRF_status_icon_Complete.gif");
        this.crfColumnImageIconPaths.put(7, "images/CRF_status_icon_Locked.gif");
        this.showMoreLink = showMoreLink;
    }

    protected String getTableName() {
        return "listEventsForSubject";
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        int i;
        this.resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
        this.resformat = ResourceBundleProvider.getFormatBundle((Locale)locale);
        tableFacade.setColumnProperties(this.columnNames);
        Row row = tableFacade.getTable().getRow();
        int index = 0;
        this.configureColumn(row.getColumn(this.columnNames[index]), this.resword.getString("study_subject_ID"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("subject_status"), (CellEditor)new StatusCellEditor(this, null), (FilterEditor)new StatusDroplistFilterEditor(this, null));
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("site_id"), null, null);
        this.configureColumn(row.getColumn(this.columnNames[++index]), this.resword.getString("gender"), null, null, true, false);
        for (i = ++index; i < index + this.studyGroupClasses.size(); ++i) {
            StudyGroupClassBean studyGroupClass = (StudyGroupClassBean)this.studyGroupClasses.get(i - index);
            this.configureColumn(row.getColumn(this.columnNames[i]), studyGroupClass.getName(), (CellEditor)new StudyGroupClassCellEditor(this, studyGroupClass), (FilterEditor)new SubjectGroupClassDroplistFilterEditor(this, studyGroupClass), true, false);
        }
        this.configureColumn(row.getColumn(this.columnNames[index + this.studyGroupClasses.size()]), this.resword.getString("event_status"), (CellEditor)new EventStatusCellEditor(this, null), (FilterEditor)new SubjectEventStatusDroplistFilterEditor(this, null), true, false);
        this.configureColumn(row.getColumn(this.columnNames[++index + this.studyGroupClasses.size()]), this.resword.getString("event_date"), (CellEditor)new EventStartDateCellEditor(this, null), null);
        for (i = ++index + this.studyGroupClasses.size(); i < this.columnNames.length - 1; ++i) {
            CRFBean crfBean = (CRFBean)this.crfBeans.get(i - (index + this.studyGroupClasses.size()));
            this.configureColumn(row.getColumn(this.columnNames[i]), crfBean.getName(), (CellEditor)new EventCrfCellEditor(this, null), (FilterEditor)new SubjectEventCRFStatusDroplistFilterEditor(this, null), true, false);
        }
        String actionsHeader = this.resword.getString("rule_actions") + "&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;";
        this.configureColumn(row.getColumn(this.columnNames[this.columnNames.length - 1]), actionsHeader, (CellEditor)new ActionsCellEditor(this, null), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        int i;
        super.configureTableFacade(response, tableFacade);
        this.getColumnNamesMap();
        tableFacade.addFilterMatcher(new MatcherKey(Character.class), (FilterMatcher)new CharFilterMatcher(this, null));
        tableFacade.addFilterMatcher(new MatcherKey(Status.class), (FilterMatcher)new StatusFilterMatcher(this));
        tableFacade.addFilterMatcher(new MatcherKey(String.class, "event.status"), (FilterMatcher)new SubjectEventStatusFilterMatcher(this));
        for (i = 4; i < 4 + this.studyGroupClasses.size(); ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(String.class, this.columnNames[i]), (FilterMatcher)new SubjectGroupFilterMatcher(this));
        }
        for (i = 6 + this.studyGroupClasses.size(); i < this.columnNames.length - 1; ++i) {
            tableFacade.addFilterMatcher(new MatcherKey(String.class, this.columnNames[i]), (FilterMatcher)new SubjectEventCRFStatusFilterMatcher(this));
        }
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        Role r = this.currentRole.getRole();
        boolean addSubjectLinkShow = this.studyBean.getStatus().isAvailable() && !r.equals((Term)Role.MONITOR);
        tableFacade.setToolbar((Toolbar)new ListEventsForSubjectTableToolbar(this.getStudyEventDefinitions(), this.getStudyGroupClasses(), this.selectedStudyEventDefinition, addSubjectLinkShow, this.showMoreLink));
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
        Limit limit = tableFacade.getLimit();
        ListEventsForSubjectFilter eventsForSubjectFilter = this.getListEventsForSubjectFilter(limit);
        if (!limit.isComplete()) {
            int totalRows = this.getStudySubjectDAO().getCountWithFilter(eventsForSubjectFilter, this.getStudyBean());
            tableFacade.setTotalRows(totalRows);
        }
        ListEventsForSubjectSort eventsForSubjectSort = this.getListEventsForSubjectSort(limit);
        int rowStart = limit.getRowSelect().getRowStart();
        int rowEnd = limit.getRowSelect().getRowEnd();
        ArrayList items = this.getStudySubjectDAO().getWithFilterAndSort(this.getStudyBean(), eventsForSubjectFilter, eventsForSubjectSort, rowStart, rowEnd);
        ArrayList theItems = new ArrayList();
        for (StudySubjectBean studySubjectBean : items) {
            HashMap<String, Object> theItem = new HashMap<String, Object>();
            theItem.put("studySubject", studySubjectBean);
            theItem.put("studySubject.label", studySubjectBean.getLabel());
            theItem.put("studySubject.status", studySubjectBean.getStatus());
            theItem.put("enrolledAt", this.getStudyDAO().findByPK(studySubjectBean.getStudyId()).getIdentifier());
            SubjectBean subjectBean = this.getSubjectDAO().findByPK(studySubjectBean.getSubjectId());
            theItem.put("subject", subjectBean);
            theItem.put("subject.charGender", Character.valueOf(subjectBean.getGender()));
            SubjectGroupMapBean subjectGroupMapBean = new SubjectGroupMapBean();
            for (StudyGroupClassBean studyGroupClass : this.getStudyGroupClasses()) {
                subjectGroupMapBean = this.getSubjectGroupMapDAO().findByStudySubjectAndStudyGroupClass(studySubjectBean.getId(), studyGroupClass.getId());
                if (null == subjectGroupMapBean) continue;
                theItem.put("sgc_" + studyGroupClass.getId(), subjectGroupMapBean.getStudyGroupId());
                theItem.put("grpName_sgc_" + studyGroupClass.getId(), subjectGroupMapBean.getStudyGroupName());
            }
            subjectGroupMapBean = null;
            ArrayList eventCrfs = this.getEventCRFDAO().findAllByStudySubject(studySubjectBean.getId());
            HashMap<String, EventCRFBean> crfAsKeyEventCrfAsValue = new HashMap<String, EventCRFBean>();
            for (EventCRFBean eventCRFBean : eventCrfs) {
                CRFBean crf = this.getCrfDAO().findByVersionId(eventCRFBean.getCRFVersionId());
                crfAsKeyEventCrfAsValue.put(crf.getId() + "_" + eventCRFBean.getStudyEventId(), eventCRFBean);
            }
            ArrayList eventsForStudySubjectAndEventDefinitions = this.getStudyEventDAO().findAllByDefinitionAndSubject(this.selectedStudyEventDefinition, studySubjectBean);
            ArrayList<DisplayBean> events = new ArrayList<DisplayBean>();
            if (eventsForStudySubjectAndEventDefinitions.size() < 1) {
                DisplayBean d = new DisplayBean(this);
                d.getProps().put("event", null);
                d.getProps().put("event.status", SubjectEventStatus.NOT_SCHEDULED);
                d.getProps().put("studySubject.createdDate", null);
                for (int i = 0; i < this.getCrfs(this.selectedStudyEventDefinition).size(); ++i) {
                    CRFBean crf = (CRFBean)this.getCrfs(this.selectedStudyEventDefinition).get(i);
                    d.getProps().put("crf_" + crf.getId(), DataEntryStage.UNCOMPLETED);
                    d.getProps().put("crf_" + crf.getId() + "_eventCrf", null);
                    d.getProps().put("crf_" + crf.getId() + "_crf", crf);
                    d.getProps().put("crf_" + crf.getId() + "_eventDefinitionCrf", this.getEventDefinitionCRFBean(Integer.valueOf(this.selectedStudyEventDefinition.getId()), crf, studySubjectBean));
                    theItem.put("crf_" + crf.getId(), "");
                }
                events.add(d);
            }
            for (StudyEventBean studyEventBean : eventsForStudySubjectAndEventDefinitions) {
                DisplayBean d = new DisplayBean(this);
                d.getProps().put("event", studyEventBean);
                d.getProps().put("event.status", studyEventBean.getSubjectEventStatus());
                d.getProps().put("studySubject.createdDate", studyEventBean.getDateStarted());
                for (int i = 0; i < this.getCrfs(this.selectedStudyEventDefinition).size(); ++i) {
                    CRFBean crf = (CRFBean)this.getCrfs(this.selectedStudyEventDefinition).get(i);
                    EventCRFBean eventCRFBean = (EventCRFBean)crfAsKeyEventCrfAsValue.get(crf.getId() + "_" + studyEventBean.getId());
                    if (eventCRFBean != null) {
                        d.getProps().put("crf_" + crf.getId(), eventCRFBean.getStage());
                        d.getProps().put("crf_" + crf.getId() + "_eventCrf", eventCRFBean);
                    } else {
                        d.getProps().put("crf_" + crf.getId(), DataEntryStage.UNCOMPLETED);
                        d.getProps().put("crf_" + crf.getId() + "_eventCrf", null);
                    }
                    d.getProps().put("crf_" + crf.getId() + "_crf", crf);
                    d.getProps().put("crf_" + crf.getId() + "_eventDefinitionCrf", this.getEventDefinitionCRFBean(Integer.valueOf(this.selectedStudyEventDefinition.getId()), crf, studySubjectBean));
                    theItem.put("crf_" + crf.getId(), "");
                }
                events.add(d);
            }
            theItem.put("events", events);
            theItem.put("event.status", "");
            theItem.put("studySubject.createdDate", "");
            theItem.put("webappContext", tableFacade.getWebContext().getContextPath());
            theItems.add(theItem);
        }
        tableFacade.setItems(theItems);
    }

    private EventDefinitionCRFBean getEventDefinitionCRFBean(Integer studyEventDefinitionId, CRFBean crfBean, StudySubjectBean studySubject) {
        EventDefinitionCRFBean eventDefinitionCrf = this.getEventDefintionCRFDAO().findByStudyEventDefinitionIdAndCRFIdAndStudyId(studyEventDefinitionId.intValue(), crfBean.getId(), studySubject.getStudyId());
        if (eventDefinitionCrf.getId() == 0) {
            eventDefinitionCrf = this.getEventDefintionCRFDAO().findForStudyByStudyEventDefinitionIdAndCRFId(studyEventDefinitionId.intValue(), crfBean.getId());
        }
        CRFVersionBean defaultVersion = this.getCrfVersionDAO().findByPK(eventDefinitionCrf.getDefaultVersionId());
        eventDefinitionCrf.setDefaultCRF(defaultVersion);
        return eventDefinitionCrf;
    }

    private void getColumnNamesMap() {
        ArrayList<String> columnNamesList = new ArrayList<String>();
        columnNamesList.add("studySubject.label");
        columnNamesList.add("studySubject.status");
        columnNamesList.add("enrolledAt");
        columnNamesList.add("subject.charGender");
        for (StudyGroupClassBean studyGroupClass : this.getStudyGroupClasses()) {
            columnNamesList.add("sgc_" + studyGroupClass.getId());
        }
        columnNamesList.add("event.status");
        columnNamesList.add("studySubject.createdDate");
        for (CRFBean crfBean : this.getCrfs(this.selectedStudyEventDefinition)) {
            columnNamesList.add("crf_" + crfBean.getId());
        }
        columnNamesList.add("actions");
        this.columnNames = columnNamesList.toArray(this.columnNames);
    }

    protected ListEventsForSubjectFilter getListEventsForSubjectFilter(Limit limit) {
        ListEventsForSubjectFilter listEventsForSubjectFilter = new ListEventsForSubjectFilter(Integer.valueOf(this.selectedStudyEventDefinition.getId()));
        FilterSet filterSet = limit.getFilterSet();
        Collection filters = filterSet.getFilters();
        for (Filter filter : filters) {
            String property = filter.getProperty();
            String value = filter.getValue();
            if ("studySubject.status".equalsIgnoreCase(property)) {
                value = Status.getByName((String)value).getId() + "";
            } else if ("event.status".equalsIgnoreCase(property)) {
                value = SubjectEventStatus.getByName((String)value).getId() + "";
            } else if (property.startsWith("sgc_")) {
                int studyGroupClassId = property.endsWith("_") ? 0 : Integer.valueOf(property.split("_")[1]);
                value = this.studyGroupDAO.findByNameAndGroupClassID(value, studyGroupClassId).getId() + "";
            } else if (property.startsWith("crf_")) {
                value = DataEntryStage.getByName((String)value).getId() + "";
            }
            listEventsForSubjectFilter.addFilter(property, (Object)value);
        }
        return listEventsForSubjectFilter;
    }

    protected ListEventsForSubjectSort getListEventsForSubjectSort(Limit limit) {
        ListEventsForSubjectSort listEventsForSubjectSort = new ListEventsForSubjectSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            listEventsForSubjectSort.addSort(property, order);
        }
        return listEventsForSubjectSort;
    }

    private ArrayList<StudyEventDefinitionBean> getStudyEventDefinitions() {
        if (this.studyEventDefinitions == null) {
            if (this.studyBean.getParentStudyId() > 0) {
                StudyBean parentStudy = this.getStudyDAO().findByPK(this.studyBean.getParentStudyId());
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(parentStudy);
            } else {
                this.studyEventDefinitions = this.getStudyEventDefinitionDao().findAllByStudy(this.studyBean);
            }
        }
        return this.studyEventDefinitions;
    }

    private ArrayList<CRFBean> getCrfs(StudyEventDefinitionBean eventDefinition) {
        if (this.crfBeans == null) {
            this.crfBeans = new ArrayList();
            this.eventDefinitionCrfs = new ArrayList();
            for (EventDefinitionCRFBean eventDefinitionCrf : this.getEventDefintionCRFDAO().findAllActiveByEventDefinitionId(eventDefinition.getId())) {
                CRFBean crfBean = this.getCrfDAO().findByPK(eventDefinitionCrf.getCrfId());
                ArrayList crfVersions = this.getCrfVersionDAO().findAllByCRFId(eventDefinitionCrf.getCrfId());
                crfBean.setVersions(crfVersions);
                if (eventDefinitionCrf.getParentId() != 0) continue;
                this.crfBeans.add(crfBean);
                this.eventDefinitionCrfs.add(eventDefinitionCrf);
            }
            return this.crfBeans;
        }
        return this.crfBeans;
    }

    private ArrayList<StudyGroupClassBean> getStudyGroupClasses() {
        if (this.studyGroupClasses == null) {
            if (this.studyBean.getParentStudyId() > 0) {
                StudyBean parentStudy = this.getStudyDAO().findByPK(this.studyBean.getParentStudyId());
                this.studyGroupClasses = this.getStudyGroupClassDAO().findAllActiveByStudy(parentStudy);
            } else {
                this.studyGroupClasses = this.getStudyGroupClassDAO().findAllActiveByStudy(this.studyBean);
            }
        }
        return this.studyGroupClasses;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        return this.studyEventDefinitionDao;
    }

    public void setStudyEventDefinitionDao(StudyEventDefinitionDAO studyEventDefinitionDao) {
        this.studyEventDefinitionDao = studyEventDefinitionDao;
    }

    public StudyBean getStudyBean() {
        return this.studyBean;
    }

    public void setStudyBean(StudyBean studyBean) {
        this.studyBean = studyBean;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        return this.studySubjectDAO;
    }

    public void setStudySubjectDAO(StudySubjectDAO studySubjectDAO) {
        this.studySubjectDAO = studySubjectDAO;
    }

    public SubjectDAO getSubjectDAO() {
        return this.subjectDAO;
    }

    public void setSubjectDAO(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        return this.studyEventDAO;
    }

    public void setStudyEventDAO(StudyEventDAO studyEventDAO) {
        this.studyEventDAO = studyEventDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        return this.studyGroupClassDAO;
    }

    public void setStudyGroupClassDAO(StudyGroupClassDAO studyGroupClassDAO) {
        this.studyGroupClassDAO = studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        return this.subjectGroupMapDAO;
    }

    public void setSubjectGroupMapDAO(SubjectGroupMapDAO subjectGroupMapDAO) {
        this.subjectGroupMapDAO = subjectGroupMapDAO;
    }

    public StudyDAO getStudyDAO() {
        return this.studyDAO;
    }

    public void setStudyDAO(StudyDAO studyDAO) {
        this.studyDAO = studyDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        return this.studyGroupDAO;
    }

    public void setStudyGroupDAO(StudyGroupDAO studyGroupDAO) {
        this.studyGroupDAO = studyGroupDAO;
    }

    public StudyUserRoleBean getCurrentRole() {
        return this.currentRole;
    }

    public void setCurrentRole(StudyUserRoleBean currentRole) {
        this.currentRole = currentRole;
    }

    public EventCRFDAO getEventCRFDAO() {
        return this.eventCRFDAO;
    }

    public void setEventCRFDAO(EventCRFDAO eventCRFDAO) {
        this.eventCRFDAO = eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefintionCRFDAO() {
        return this.eventDefintionCRFDAO;
    }

    public void setEventDefintionCRFDAO(EventDefinitionCRFDAO eventDefintionCRFDAO) {
        this.eventDefintionCRFDAO = eventDefintionCRFDAO;
    }

    public CRFDAO getCrfDAO() {
        return this.crfDAO;
    }

    public void setCrfDAO(CRFDAO crfDAO) {
        this.crfDAO = crfDAO;
    }

    public UserAccountBean getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(UserAccountBean currentUser) {
        this.currentUser = currentUser;
    }

    public StudyEventDefinitionBean getSelectedStudyEventDefinition() {
        return this.selectedStudyEventDefinition;
    }

    public void setSelectedStudyEventDefinition(StudyEventDefinitionBean selectedStudyEventDefinition) {
        this.selectedStudyEventDefinition = selectedStudyEventDefinition;
    }

    private String viewStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("ViewStudySubject?id=" + studySubject.getId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_View1','images/bt_View_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_View1','images/bt_View.gif');\"").close();
        actionLink.img().name("bt_View1").src("images/bt_View.gif").border("0").alt(this.resword.getString("view")).title(this.resword.getString("view")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String removeStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("RemoveStudySubject?action=confirm&id=" + studySubject.getId() + "&subjectId=" + studySubject.getSubjectId() + "&studyId=" + studySubject.getStudyId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Remove1','images/bt_Remove_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Remove1','images/bt_Remove.gif');\"").close();
        actionLink.img().name("bt_Remove1").src("images/bt_Remove.gif").border("0").alt(this.resword.getString("remove")).title(this.resword.getString("remove")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String reAssignStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("ReassignStudySubject?id=" + studySubject.getId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Reassign1','images/bt_Reassign_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Reassign1','images/bt_Reassign.gif');\"").close();
        actionLink.img().name("bt_Reassign1").src("images/bt_Reassign.gif").border("0").alt(this.resword.getString("reassign")).title(this.resword.getString("reassign")).append((Object)"hspace=\"2\"").end().aEnd();
        actionLink.append((Object)"&nbsp;&nbsp;&nbsp;");
        return actionLink.toString();
    }

    private String restoreStudySubjectLinkBuilder(StudySubjectBean studySubject) {
        HtmlBuilder actionLink = new HtmlBuilder();
        actionLink.a().href("RestoreStudySubject?action=confirm&id=" + studySubject.getId() + "&subjectId=" + studySubject.getSubjectId() + "&studyId=" + studySubject.getStudyId());
        actionLink.append((Object)"onMouseDown=\"javascript:setImage('bt_Restor3','images/bt_Restore_d.gif');\"");
        actionLink.append((Object)"onMouseUp=\"javascript:setImage('bt_Restor3','images/bt_Restore_d.gif');\"").close();
        actionLink.img().name("bt_Restore1").src("images/bt_Restore.gif").border("0").alt(this.resword.getString("restore")).title(this.resword.getString("restore")).append((Object)"hspace=\"2\"").end().aEnd();
        return actionLink.toString();
    }

    private String eventDivBuilder(SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject) {
        String studySubjectLabel = studySubject.getLabel();
        String divWidth = studyEvents.size() >= 3 ? "540" : (studyEvents.size() == 2 ? "360" : "180");
        HtmlBuilder eventDiv = new HtmlBuilder();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").close();
        eventDiv.div().id("S_Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("position: absolute; visibility: hidden; z-index: 3; width: 50px; height: 30px; top: 0px;").close();
        this.lockLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
        eventDiv.divEnd();
        eventDiv.tr(0).valign("top").close().td(0).close();
        eventDiv.div().id("S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("position: absolute; visibility: hidden; z-index: 3;width:" + divWidth + "px; top: 0px; float: left;").close();
        eventDiv.div().styleClass("box_T").close().div().styleClass("box_L").close().div().styleClass("box_R").close().div().styleClass("box_B").close().div().styleClass("box_TL").close().div().styleClass("box_TR").close().div().styleClass("box_BL").close().div().styleClass("box_BR").close();
        eventDiv.div().styleClass("tablebox_center").close();
        eventDiv.div().styleClass("ViewSubjectsPopup").style("color: rgb(91, 91, 91);").close();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").close();
        eventDiv.tr(0).valign("top").close();
        this.singleEventDivBuilder(eventDiv, subject, rowCount, studyEvents, sed, studySubject);
        return eventDiv.toString();
    }

    private void singleEventDivBuilder(HtmlBuilder eventDiv, SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed, StudySubjectBean studySubject) {
        String tableHeaderRowLeftStyleClass = "table_header_row_left";
        String click_for_more_options = this.resword.getString("click_for_more_options");
        String schedule = this.resword.getString("schedule");
        String view = this.resword.getString("view") + "/" + this.resword.getString("enter_data");
        String edit = this.resword.getString("edit");
        String remove = this.resword.getString("remove");
        String subjectText = this.resword.getString("subject");
        String eventText = this.resword.getString("event");
        SubjectEventStatus eventStatus = studyEvents.size() == 0 ? SubjectEventStatus.NOT_SCHEDULED : studyEvents.get(0).getSubjectEventStatus();
        String studyEventId = studyEvents.size() == 0 ? "" : String.valueOf(studyEvents.get(0).getId());
        Status eventSysStatus = studySubject.getStatus();
        String studySubjectLabel = studySubject.getLabel();
        eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).close();
        eventDiv.append((Object)subjectText).append((Object)": ").append((Object)studySubjectLabel).br();
        eventDiv.append((Object)eventText).append((Object)": ").append((Object)sed.getName()).br();
        eventDiv.append((Object)this.resword.getString("status")).append((Object)":").append((Object)eventStatus.getName()).br();
        eventDiv.tdEnd();
        eventDiv.td(0).styleClass(tableHeaderRowLeftStyleClass).align("right").close();
        this.linkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
        eventDiv.tdEnd();
        eventDiv.trEnd(0);
        eventDiv.tr(0).id("S_Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("display: all").close();
        eventDiv.td(0).styleClass("table_cell_left").colspan("2").close().append((Object)"<i>").append((Object)click_for_more_options).append((Object)"</i>").tdEnd();
        eventDiv.trEnd(0);
        eventDiv.tr(0).id("S_Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount).style("display: none").close();
        eventDiv.td(0).colspan("2").close();
        eventDiv.table(0).border("0").cellpadding("0").cellspacing("0").width("100%").close();
        if (eventSysStatus.getId() == Status.AVAILABLE.getId() || eventSysStatus == Status.SIGNED) {
            if (eventStatus == SubjectEventStatus.NOT_SCHEDULED && this.currentRole.getRole() != Role.MONITOR && !this.studyBean.getStatus().isFrozen()) {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left").close();
                this.createNewStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), sed, schedule);
                eventDiv.tdEnd().trEnd(0);
            } else if (eventStatus == SubjectEventStatus.COMPLETED) {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left").close();
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            } else if (eventStatus == SubjectEventStatus.LOCKED) {
                eventDiv.tdEnd().trEnd(0);
                if (this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                    eventDiv.tdEnd().trEnd(0);
                    if (this.studyBean.getStatus() == Status.AVAILABLE) {
                        eventDiv.tr(0).valign("top").close();
                        eventDiv.td(0).styleClass("table_cell_left").close();
                        this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                        eventDiv.tdEnd().trEnd(0);
                    }
                }
            } else {
                eventDiv.tr(0).valign("top").close();
                eventDiv.td(0).styleClass("table_cell_left").close();
                this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
                eventDiv.tdEnd().trEnd(0);
                if ((this.currentRole.getRole() == Role.STUDYDIRECTOR || this.currentUser.isSysAdmin()) && this.studyBean.getStatus() == Status.AVAILABLE) {
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.updateStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, edit);
                    eventDiv.tdEnd().trEnd(0);
                    eventDiv.tr(0).valign("top").close();
                    eventDiv.td(0).styleClass("table_cell_left").close();
                    this.removeStudyEventLinkBuilder(eventDiv, Integer.valueOf(studySubject.getId()), studyEventId, remove);
                    eventDiv.tdEnd().trEnd(0);
                }
            }
        }
        if (eventSysStatus == Status.DELETED || eventSysStatus == Status.AUTO_DELETED) {
            eventDiv.tr(0).valign("top").close();
            eventDiv.td(0).styleClass("table_cell_left").close();
            this.enterDataForStudyEventLinkBuilder(eventDiv, studyEventId, view);
            eventDiv.tdEnd().trEnd(0);
        }
        eventDiv.tableEnd(0).tdEnd().trEnd(0);
        eventDiv.tableEnd(0);
        eventDiv.divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd();
        this.iconLinkBuilder(eventDiv, studySubjectLabel, rowCount, studyEvents, sed);
    }

    private void updateStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, String studyEventId, String edit) {
        String href1 = "UpdateStudyEvent?event_id=" + studyEventId + "&ss_id=" + studySubjectId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)edit).aEnd();
    }

    private void removeStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, String studyEventId, String remove) {
        String href1 = "RemoveStudyEvent?action=confirm&id=" + studyEventId + "&studySubId=" + studySubjectId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Remove.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)remove).aEnd();
    }

    private void createNewStudyEventLinkBuilder(HtmlBuilder builder, Integer studySubjectId, StudyEventDefinitionBean sed, String schedule) {
        String href1 = "CreateNewStudyEvent?studySubjectId=" + studySubjectId + "&studyEventDefinition=" + sed.getId();
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_Schedule.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)schedule).aEnd();
    }

    private void enterDataForStudyEventLinkBuilder(HtmlBuilder builder, String studyEventId, String view) {
        String href1 = "EnterDataForStudyEvent?eventId=" + studyEventId;
        builder.a().href(href1);
        builder.close();
        builder.img().src("images/bt_View.gif").border("0").align("left").close().aEnd();
        builder.nbsp().nbsp().a().href(href1);
        builder.close().append((Object)view).aEnd();
    }

    private void lockLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:leftnavExpand('S_Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('S_Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "layersShowOrHide('visible','S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseover = onmouseover + "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_collapse.gif');";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','S_Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close();
        builder.img().src("images/spacer.gif").border("0").append((Object)"height=\"30\"").width("50").close().aEnd();
    }

    private void iconLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1Repeating = "javascript:ExpandEventOccurrences('" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'," + studyEvents.size() + "); ";
        String href1 = "javascript:leftnavExpand('S_Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('S_Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onmouseover = "moveObject('S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "', event); ";
        onmouseover = onmouseover + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_expand.gif');";
        String onmouseout = "layersShowOrHide('hidden','S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        onmouseout = onmouseout + "setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif');";
        String onClick1 = "layersShowOrHide('visible','Lock_all'); ";
        String onClick2 = "LockObject('S_Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "',event); ";
        String href = studyEvents.size() > 1 ? href1Repeating + href2 : href1 + href2;
        builder.a().href(href);
        builder.onmouseover(onmouseover);
        builder.onmouseout(onmouseout);
        builder.onclick(onClick1 + onClick2);
        builder.close();
    }

    private void linkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, List<StudyEventBean> studyEvents, StudyEventDefinitionBean sed) {
        String href1 = "javascript:leftnavExpand('S_Menu_on_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('S_Menu_off_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','S_Event_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','S_Lock_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('ExpandIcon_" + studySubjectLabel + "_" + sed.getId() + "_" + rowCount + "','images/icon_blank.gif'); ";
        builder.a().href(href1 + href2);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close().append((Object)"X").aEnd();
    }

    private String formatDate(Date date) {
        String format = this.resformat.getString("date_format_string");
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    static /* synthetic */ StudyGroupDAO access$900(ListEventsForSubjectTableFactory x0) {
        return x0.studyGroupDAO;
    }

    static /* synthetic */ StudyEventDefinitionBean access$1000(ListEventsForSubjectTableFactory x0) {
        return x0.selectedStudyEventDefinition;
    }

    static /* synthetic */ String access$1100(ListEventsForSubjectTableFactory x0, SubjectBean x1, Integer x2, List x3, StudyEventDefinitionBean x4, StudySubjectBean x5) {
        return x0.eventDivBuilder(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ String access$1200(ListEventsForSubjectTableFactory x0, Date x1) {
        return x0.formatDate(x1);
    }

    static /* synthetic */ StudyBean access$1300(ListEventsForSubjectTableFactory x0) {
        return x0.studyBean;
    }

    static /* synthetic */ StudyUserRoleBean access$1400(ListEventsForSubjectTableFactory x0) {
        return x0.currentRole;
    }

    static /* synthetic */ UserAccountBean access$1500(ListEventsForSubjectTableFactory x0) {
        return x0.currentUser;
    }

    static /* synthetic */ String access$1600(ListEventsForSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.viewStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1700(ListEventsForSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.removeStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1800(ListEventsForSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.restoreStudySubjectLinkBuilder(x1);
    }

    static /* synthetic */ String access$1900(ListEventsForSubjectTableFactory x0, StudySubjectBean x1) {
        return x0.reAssignStudySubjectLinkBuilder(x1);
    }
}

