/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormDiscrepancyNotes;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.ListEventsForSubjectTableFactory;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ListEventsForSubjectsServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    private StudyEventDefinitionDAO studyEventDefinitionDAO;
    private SubjectDAO subjectDAO;
    private StudySubjectDAO studySubjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private StudyGroupDAO studyGroupDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private CRFDAO crfDAO;
    Locale locale;
    private boolean showMoreLink;

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        this.showMoreLink = fp.getString("showMoreLink").equals("") ? true : Boolean.parseBoolean(fp.getString("showMoreLink"));
        String idSetting = this.currentStudy.getStudyParameterConfig().getSubjectIdGeneration();
        if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
            this.request.setAttribute("label", (Object)resword.getString("id_generated_Save_Add"));
        }
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int definitionId = fp.getInt("defId");
        if (definitionId <= 0) {
            this.addPageMessage(respage.getString("please_choose_an_ED_ta_to_vies_details"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS);
            return;
        }
        ListEventsForSubjectTableFactory factory = new ListEventsForSubjectTableFactory(this.showMoreLink);
        factory.setStudyEventDefinitionDao(this.getStudyEventDefinitionDao());
        factory.setSubjectDAO(this.getSubjectDAO());
        factory.setStudySubjectDAO(this.getStudySubjectDAO());
        factory.setStudyEventDAO(this.getStudyEventDAO());
        factory.setStudyBean(this.currentStudy);
        factory.setStudyGroupClassDAO(this.getStudyGroupClassDAO());
        factory.setSubjectGroupMapDAO(this.getSubjectGroupMapDAO());
        factory.setStudyDAO(this.getStudyDAO());
        factory.setStudyGroupDAO(this.getStudyGroupDAO());
        factory.setCurrentRole(this.currentRole);
        factory.setCurrentUser(this.ub);
        factory.setEventCRFDAO(this.getEventCRFDAO());
        factory.setEventDefintionCRFDAO(this.getEventDefinitionCRFDAO());
        factory.setCrfDAO(this.getCrfDAO());
        factory.setCrfVersionDAO(this.getCRFVersionDAO());
        factory.setSelectedStudyEventDefinition(this.getStudyEventDefinitionDao().findByPK(definitionId));
        String listEventsForSubjectsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("listEventsForSubjectsHtml", (Object)listEventsForSubjectsHtml);
        this.request.setAttribute("defId", (Object)definitionId);
        this.request.setAttribute("allDefsArray", (Object)super.getEventDefinitionsByCurrentStudy());
        this.request.setAttribute("studyGroupClasses", (Object)super.getStudyGroupClassesByCurrentStudy());
        FormDiscrepancyNotes discNotes = new FormDiscrepancyNotes();
        this.session.setAttribute("fdnotes", (Object)discNotes);
        this.forwardPage(Page.LIST_EVENTS_FOR_SUBJECTS);
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        this.studyEventDefinitionDAO = this.studyEventDefinitionDAO == null ? new StudyEventDefinitionDAO(this.sm.getDataSource()) : this.studyEventDefinitionDAO;
        return this.studyEventDefinitionDAO;
    }

    public SubjectDAO getSubjectDAO() {
        this.subjectDAO = this.subjectDAO == null ? new SubjectDAO(this.sm.getDataSource()) : this.subjectDAO;
        return this.subjectDAO;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        this.studySubjectDAO = this.studySubjectDAO == null ? new StudySubjectDAO(this.sm.getDataSource()) : this.studySubjectDAO;
        return this.studySubjectDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        this.studyGroupClassDAO = this.studyGroupClassDAO == null ? new StudyGroupClassDAO(this.sm.getDataSource()) : this.studyGroupClassDAO;
        return this.studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        this.subjectGroupMapDAO = this.subjectGroupMapDAO == null ? new SubjectGroupMapDAO(this.sm.getDataSource()) : this.subjectGroupMapDAO;
        return this.subjectGroupMapDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        this.studyEventDAO = this.studyEventDAO == null ? new StudyEventDAO(this.sm.getDataSource()) : this.studyEventDAO;
        return this.studyEventDAO;
    }

    public StudyDAO getStudyDAO() {
        this.studyDAO = this.studyDAO == null ? new StudyDAO(this.sm.getDataSource()) : this.studyDAO;
        return this.studyDAO;
    }

    public EventCRFDAO getEventCRFDAO() {
        this.eventCRFDAO = this.eventCRFDAO == null ? new EventCRFDAO(this.sm.getDataSource()) : this.eventCRFDAO;
        return this.eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDAO() {
        this.eventDefintionCRFDAO = this.eventDefintionCRFDAO == null ? new EventDefinitionCRFDAO(this.sm.getDataSource()) : this.eventDefintionCRFDAO;
        return this.eventDefintionCRFDAO;
    }

    public CRFDAO getCrfDAO() {
        this.crfDAO = this.crfDAO == null ? new CRFDAO(this.sm.getDataSource()) : this.crfDAO;
        return this.crfDAO;
    }

    public CRFVersionDAO getCRFVersionDAO() {
        CRFVersionDAO crfVersionDAO = new CRFVersionDAO(this.sm.getDataSource());
        return crfVersionDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        this.studyGroupDAO = this.studyGroupDAO == null ? new StudyGroupDAO(this.sm.getDataSource()) : this.studyGroupDAO;
        return this.studyGroupDAO;
    }
}

