/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.admin.DisplayStudyBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ReassignStudySubjectServlet
extends SecureController {
    private static final long serialVersionUID = -1589960233538141490L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String action = this.request.getParameter("action");
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        SubjectDAO subdao = new SubjectDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studySubId = fp.getInt("id");
        if (studySubId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_subject_to_reassign"));
            this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
            return;
        }
        StudySubjectBean studySub = ssdao.findByPK(studySubId);
        int subjectId = studySub.getSubjectId();
        this.request.setAttribute("studySub", (Object)studySub);
        SubjectBean subject = subdao.findByPK(subjectId);
        this.request.setAttribute("subject", (Object)subject);
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        ArrayList groupMaps = sgmdao.findAllByStudySubject(studySubId);
        if (action == null || action.trim().isEmpty()) {
            DisplayStudyBean displayStudy = new DisplayStudyBean();
            StudyBean study = sdao.findByPK(studySub.getStudyId());
            StudyBean parent = study.getParentStudyId() > 0 ? sdao.findByPK(study.getParentStudyId()) : study;
            ArrayList studies = sdao.findAllByParent(parent.getId());
            displayStudy.setParent(parent);
            displayStudy.setChildren(studies);
            this.request.setAttribute("displayStudy", (Object)displayStudy);
            this.forwardPage(Page.REASSIGN_STUDY_SUBJECT);
        } else {
            int studyId = fp.getInt("studyId");
            if (studyId == 0) {
                this.addPageMessage(respage.getString("please_choose_a_study_site_to_reassign_the_subject"));
                this.forwardPage(Page.REASSIGN_STUDY_SUBJECT);
                return;
            }
            StudyBean st = sdao.findByPK(studyId);
            if ("confirm".equalsIgnoreCase(action)) {
                StudySubjectBean sub1 = ssdao.findAnotherBySameLabel(studySub.getLabel(), studyId, studySub.getId());
                if (sub1.getId() > 0) {
                    this.addPageMessage(respage.getString("the_study_subject_ID_used_by_another_in_study_site"));
                    this.forwardPage(Page.REASSIGN_STUDY_SUBJECT);
                    return;
                }
                this.request.setAttribute("newStudy", (Object)st);
                this.forwardPage(Page.REASSIGN_STUDY_SUBJECT_CONFIRM);
            } else {
                logger.info("submit to reassign the subject");
                studySub.setUpdatedDate(new Date());
                studySub.setUpdater(this.ub);
                studySub.setStudyId(studyId);
                ssdao.update(studySub);
                for (int i = 0; i < groupMaps.size(); ++i) {
                    SubjectGroupMapBean sgm = (SubjectGroupMapBean)groupMaps.get(i);
                    sgm.setUpdatedDate(new Date());
                    sgm.setUpdater(this.ub);
                    sgm.setStatus(Status.DELETED);
                    sgmdao.update(sgm);
                }
                MessageFormat mf = new MessageFormat("");
                mf.applyPattern(respage.getString("subject_reassigned"));
                Object[] arguments = new Object[]{studySub.getLabel(), st.getName()};
                this.addPageMessage(mf.format(arguments));
                this.forwardPage(Page.LIST_STUDY_SUBJECTS_SERVLET);
            }
        }
    }
}

