/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.DatasetBean;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyGroupBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.bean.submit.SubjectGroupMapBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.extract.DatasetDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveSiteServlet
extends SecureController {
    private static final long serialVersionUID = -5537588699250419149L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SITE_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.SITE_LIST_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        String idString = this.request.getParameter("id");
        logger.info("site id:" + idString);
        int siteId = Integer.valueOf(idString.trim());
        StudyBean study = sdao.findByPK(siteId);
        if (this.currentStudy.getId() != study.getParentStudyId()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_active_study_or_contact"));
            this.forwardPage(Page.MENU_SERVLET);
            return;
        }
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        ArrayList userRoles = udao.findAllByStudyId(siteId);
        StudySubjectDAO ssdao = new StudySubjectDAO(this.sm.getDataSource());
        ArrayList subjects = ssdao.findAllByStudy(study);
        String action = this.request.getParameter("action");
        if (idString == null || idString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_site_to_remove"));
            this.forwardPage(Page.SITE_LIST_SERVLET);
        } else if ("confirm".equalsIgnoreCase(action)) {
            this.request.setAttribute("siteToRemove", (Object)study);
            this.request.setAttribute("userRolesToRemove", (Object)userRoles);
            this.request.setAttribute("subjectsToRemove", (Object)subjects);
            this.forwardPage(Page.REMOVE_SITE);
        } else {
            logger.info("submit to remove the site");
            StudyDAO studao = new StudyDAO(this.sm.getDataSource());
            study.setOldStatus(study.getStatus());
            study.setStatus(Status.DELETED);
            study.setUpdater(this.ub);
            study.setUpdatedDate(new Date());
            studao.update(study);
            for (int i = 0; i < userRoles.size(); ++i) {
                StudyUserRoleBean role = (StudyUserRoleBean)userRoles.get(i);
                if (role.getStatus().equals((Term)Status.DELETED)) continue;
                role.setStatus(Status.AUTO_DELETED);
                role.setUpdater(this.ub);
                role.setUpdatedDate(new Date());
                udao.updateStudyUserRole(role, role.getUserName());
            }
            if (study.getId() == this.currentStudy.getId()) {
                this.currentStudy.setStatus(Status.DELETED);
                this.currentRole.setStatus(Status.DELETED);
            }
            StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
            SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
            ArrayList groups = sgdao.findAllByStudy(study);
            for (int i = 0; i < groups.size(); ++i) {
                StudyGroupBean group = (StudyGroupBean)groups.get(i);
                if (group.getStatus().equals((Term)Status.DELETED)) continue;
                group.setStatus(Status.AUTO_DELETED);
                group.setUpdater(this.ub);
                group.setUpdatedDate(new Date());
                sgdao.update(group);
                ArrayList subjectGroupMaps = sgmdao.findAllByStudyGroupId(group.getId());
                for (int j = 0; j < subjectGroupMaps.size(); ++j) {
                    SubjectGroupMapBean sgMap = (SubjectGroupMapBean)subjectGroupMaps.get(j);
                    if (sgMap.getStatus().equals((Term)Status.DELETED)) continue;
                    sgMap.setStatus(Status.AUTO_DELETED);
                    sgMap.setUpdater(this.ub);
                    sgMap.setUpdatedDate(new Date());
                    sgmdao.update(sgMap);
                }
            }
            StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
            for (int i = 0; i < subjects.size(); ++i) {
                StudySubjectBean subject = (StudySubjectBean)subjects.get(i);
                if (subject.getStatus().equals((Term)Status.DELETED)) continue;
                subject.setStatus(Status.AUTO_DELETED);
                subject.setUpdater(this.ub);
                subject.setUpdatedDate(new Date());
                ssdao.update(subject);
                ArrayList events = sedao.findAllByStudySubject(subject);
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                for (int j = 0; j < events.size(); ++j) {
                    StudyEventBean event = (StudyEventBean)events.get(j);
                    if (event.getStatus().equals((Term)Status.DELETED)) continue;
                    event.setStatus(Status.AUTO_DELETED);
                    event.setUpdater(this.ub);
                    event.setUpdatedDate(new Date());
                    sedao.update(event);
                    ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                    ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                    for (int k = 0; k < eventCRFs.size(); ++k) {
                        EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                        if (eventCRF.getStatus().equals((Term)Status.DELETED)) continue;
                        eventCRF.setOldStatus(eventCRF.getStatus());
                        eventCRF.setStatus(Status.AUTO_DELETED);
                        eventCRF.setUpdater(this.ub);
                        eventCRF.setUpdatedDate(new Date());
                        ecdao.update(eventCRF);
                        ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                        for (int a = 0; a < itemDatas.size(); ++a) {
                            ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                            if (item.getStatus().equals((Term)Status.DELETED)) continue;
                            item.setOldStatus(item.getStatus());
                            item.setStatus(Status.AUTO_DELETED);
                            item.setUpdater(this.ub);
                            item.setUpdatedDate(new Date());
                            iddao.update(item);
                        }
                    }
                }
            }
            DatasetDAO datadao = new DatasetDAO(this.sm.getDataSource());
            ArrayList dataset = datadao.findAllByStudyId(study.getId());
            for (int i = 0; i < dataset.size(); ++i) {
                DatasetBean data = (DatasetBean)dataset.get(i);
                if (data.getStatus().equals((Term)Status.DELETED)) continue;
                data.setStatus(Status.AUTO_DELETED);
                data.setUpdater(this.ub);
                data.setUpdatedDate(new Date());
                datadao.update(data);
            }
            this.addPageMessage(respage.getString("this_site_has_been_removed_succesfully"));
            String fromListSite = (String)this.session.getAttribute("fromListSite");
            if (fromListSite != null && fromListSite.equals("yes") && this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR)) {
                this.session.removeAttribute("fromListSite");
                this.forwardPage(Page.SITE_LIST_SERVLET);
            } else {
                this.session.removeAttribute("fromListSite");
                if (this.currentRole.getRole().equals((Term)Role.ADMIN)) {
                    this.forwardPage(Page.STUDY_LIST_SERVLET);
                } else {
                    this.forwardPage(Page.SITE_LIST_SERVLET);
                }
            }
        }
    }
}

