/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class SetStudyUserRoleServlet
extends SecureController {
    private static final long serialVersionUID = 7607566814278848612L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_IN_STUDY_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        String name = this.request.getParameter("name");
        String studyIdString = this.request.getParameter("studyId");
        if (name == null || name.trim().isEmpty() || studyIdString == null || studyIdString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_user_to_set_role_for"));
            this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
        } else {
            String action = this.request.getParameter("action");
            FormProcessor fp = new FormProcessor(this.request);
            UserAccountBean user = udao.findByUserName(name);
            StudyBean userStudy = sdao.findByPK(fp.getInt("studyId"));
            if ("confirm".equalsIgnoreCase(action)) {
                int studyId = Integer.parseInt(studyIdString.trim());
                this.request.setAttribute("user", (Object)user);
                StudyUserRoleBean uRole = udao.findRoleByUserNameAndStudyId(name, studyId);
                uRole.setStudyName(userStudy.getName());
                this.request.setAttribute("uRole", (Object)uRole);
                ArrayList roles = Role.toArrayList();
                roles.remove(Role.ADMIN);
                roles.remove(Role.RESEARCHASSISTANT2);
                StudyBean studyBean = sdao.findByPK(uRole.getStudyId());
                if (this.currentStudy.getParentStudyId() > 0) {
                    roles.remove(Role.COORDINATOR);
                    roles.remove(Role.STUDYDIRECTOR);
                } else if (studyBean.getParentStudyId() > 0) {
                    roles.remove(Role.COORDINATOR);
                    roles.remove(Role.STUDYDIRECTOR);
                    Role r = Role.RESEARCHASSISTANT;
                    r.setDescription("site_Data_Entry_Person");
                    roles.remove(Role.RESEARCHASSISTANT);
                    roles.add(r);
                    Role ri = Role.INVESTIGATOR;
                    ri.setDescription("site_investigator");
                    roles.remove(Role.INVESTIGATOR);
                    roles.add(ri);
                    Role r2 = Role.RESEARCHASSISTANT2;
                    r2.setDescription("site_Data_Entry_Person2");
                    roles.remove(Role.RESEARCHASSISTANT2);
                    roles.add(r2);
                }
                this.request.setAttribute("roles", (Object)roles);
                this.forwardPage(Page.SET_USER_ROLE_IN_STUDY);
            } else {
                String userName = fp.getString("name");
                int studyId = fp.getInt("studyId");
                int roleId = fp.getInt("roleId");
                StudyUserRoleBean sur = new StudyUserRoleBean();
                sur.setName(userName);
                sur.setRole(Role.get((int)roleId));
                sur.setStudyId(studyId);
                sur.setStudyName(userStudy.getName());
                sur.setStatus(Status.AVAILABLE);
                sur.setUpdater(this.ub);
                sur.setUpdatedDate(new Date());
                udao.updateStudyUserRole(sur, userName);
                this.addPageMessage(this.generateAlert(user, sur));
                this.forwardPage(Page.LIST_USER_IN_STUDY_SERVLET);
            }
        }
    }

    private String generateAlert(UserAccountBean u, StudyUserRoleBean surb) {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean study = sdao.findByPK(surb.getStudyId());
        String roleNameTerm = study.getParentStudyId() == 0 ? resterm.getString((String)Role.studyRoleMap.get(surb.getId())).trim() : resterm.getString((String)Role.siteRoleMap.get(surb.getId())).trim();
        return u.getFirstName() + " " + u.getLastName() + " (" + resword.getString("username") + ": " + u.getName() + ") " + respage.getString("has_been_granted_the_role") + " " + roleNameTerm + " " + respage.getString("in_the_study_site") + " " + study.getName() + ".";
    }
}

