/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.CRFVersionMetadataUtil;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ViewCRFVersionServlet
extends SecureController {
    private static final long serialVersionUID = -920947631341814197L;

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + " " + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_director"), "1");
    }

    public void processRequest() throws Exception {
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        String module = fp.getString("module");
        this.request.setAttribute("module", (Object)module);
        int crfVersionId = fp.getInt("id");
        if (crfVersionId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_crf_to_view_details"));
            this.forwardPage(Page.CRF_LIST_SERVLET);
        } else {
            CRFVersionBean version = cvdao.findByPK(crfVersionId);
            CRFDAO crfdao = new CRFDAO(this.sm.getDataSource());
            CRFBean crf = crfdao.findByPK(version.getCrfId());
            CRFVersionMetadataUtil metadataUtil = new CRFVersionMetadataUtil(this.sm.getDataSource());
            ArrayList sections = metadataUtil.retrieveFormMetadata(version);
            this.request.setAttribute("sections", (Object)sections);
            this.request.setAttribute("version", (Object)version);
            this.request.setAttribute("crfname", (Object)crf.getName());
            this.forwardPage(Page.VIEW_CRF_VERSION);
        }
    }
}

