/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.DiscrepancyNoteType;
import org.akaza.openclinica.bean.core.ResolutionStatus;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.DiscrepancyNoteBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.ListNotesTableFactory;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.service.DiscrepancyNotesSummary;
import org.akaza.openclinica.service.managestudy.ViewNotesService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.jmesa.facade.TableFacade;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ViewNotesServlet
extends SecureController {
    private static final long serialVersionUID = 6196337101804576598L;
    public static final String PRINT = "print";
    public static final String RESOLUTION_STATUS = "resolutionStatus";
    public static final String TYPE = "discNoteType";
    public static final String WIN_LOCATION = "window_location";
    public static final String NOTES_TABLE = "notesTable";
    public static final String DISCREPANCY_NOTE_TYPE = "discrepancyNoteType";
    private boolean showMoreLink;
    private ViewNotesService viewNotesService;

    protected void processRequest() throws Exception {
        FormProcessor fp;
        String module = this.request.getParameter("module");
        String moduleStr = "manage";
        if (module != null && module.trim().length() > 0) {
            if ("submit".equals(module)) {
                this.request.setAttribute("module", (Object)"submit");
                moduleStr = "submit";
            } else if ("admin".equals(module)) {
                this.request.setAttribute("module", (Object)"admin");
                moduleStr = "admin";
            } else {
                this.request.setAttribute("module", (Object)"manage");
            }
        }
        this.showMoreLink = (fp = new FormProcessor(this.request)).getString("showMoreLink").equals("") ? true : Boolean.parseBoolean(fp.getString("showMoreLink"));
        int oneSubjectId = fp.getInt("id");
        this.session.setAttribute("subjectId", (Object)oneSubjectId);
        int discNoteType = 0;
        try {
            discNoteType = Integer.parseInt(this.request.getParameter("type"));
        }
        catch (NumberFormatException nfe) {
            discNoteType = -1;
        }
        this.request.setAttribute(DISCREPANCY_NOTE_TYPE, (Object)discNoteType);
        boolean removeSession = fp.getBoolean("removeSession");
        this.session.setAttribute("module", (Object)module);
        String viewForOne = fp.getString("viewForOne");
        DiscrepancyNoteDAO dndao = new DiscrepancyNoteDAO(this.sm.getDataSource());
        dndao.setFetchMapping(true);
        int resolutionStatus = 0;
        try {
            resolutionStatus = Integer.parseInt(this.request.getParameter(RESOLUTION_STATUS));
        }
        catch (NumberFormatException nfe) {
            resolutionStatus = -1;
        }
        if (removeSession) {
            this.session.removeAttribute(WIN_LOCATION);
            this.session.removeAttribute(NOTES_TABLE);
        }
        this.session.setAttribute(WIN_LOCATION, (Object)("ViewNotes?viewForOne=" + viewForOne + "&id=" + oneSubjectId + "&module=" + module + " &removeSession=1"));
        boolean hasAResolutionStatus = resolutionStatus >= 1 && resolutionStatus <= 5;
        HashSet<Integer> resolutionStatusIds = ClassCastHelper.asHashSet((Object)this.session.getAttribute(RESOLUTION_STATUS), Integer.class);
        if (!hasAResolutionStatus && resolutionStatusIds != null) {
            this.session.removeAttribute(RESOLUTION_STATUS);
            resolutionStatusIds = null;
        }
        if (hasAResolutionStatus) {
            if (resolutionStatusIds == null) {
                resolutionStatusIds = new HashSet<Integer>();
            }
            resolutionStatusIds.add(resolutionStatus);
            this.session.setAttribute(RESOLUTION_STATUS, resolutionStatusIds);
        }
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        StudyDAO studyDao = new StudyDAO(this.sm.getDataSource());
        SubjectDAO sdao = new SubjectDAO(this.sm.getDataSource());
        UserAccountDAO uadao = new UserAccountDAO(this.sm.getDataSource());
        CRFVersionDAO crfVersionDao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO crfDao = new CRFDAO(this.sm.getDataSource());
        StudyEventDAO studyEventDao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO studyEventDefinitionDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO eventDefinitionCRFDao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        ItemDataDAO itemDataDao = new ItemDataDAO(this.sm.getDataSource());
        ItemDAO itemDao = new ItemDAO(this.sm.getDataSource());
        EventCRFDAO eventCRFDao = new EventCRFDAO(this.sm.getDataSource());
        ListNotesTableFactory factory = new ListNotesTableFactory(this.showMoreLink);
        factory.setSubjectDao(sdao);
        factory.setStudySubjectDao(subdao);
        factory.setUserAccountDao(uadao);
        factory.setStudyDao(studyDao);
        factory.setCurrentStudy(this.currentStudy);
        factory.setDiscrepancyNoteDao(dndao);
        factory.setCrfDao(crfDao);
        factory.setCrfVersionDao(crfVersionDao);
        factory.setStudyEventDao(studyEventDao);
        factory.setStudyEventDefinitionDao(studyEventDefinitionDao);
        factory.setEventDefinitionCRFDao(eventDefinitionCRFDao);
        factory.setItemDao(itemDao);
        factory.setItemDataDao(itemDataDao);
        factory.setEventCRFDao(eventCRFDao);
        factory.setModule(moduleStr);
        factory.setDiscNoteType(Integer.valueOf(discNoteType));
        factory.setResolutionStatus(Integer.valueOf(resolutionStatus));
        factory.setViewNotesService(this.resolveViewNotesService());
        TableFacade tf = factory.createTable(this.request, this.response);
        Map stats = this.generateDiscrepancyNotesSummary(factory.getNotesSummary());
        Map totalMap = this.generateDiscrepancyNotesTotal(stats);
        int grandTotal = 0;
        for (String typeName : totalMap.keySet()) {
            String total = (String)totalMap.get(typeName);
            grandTotal = total.equals("--") ? grandTotal + 0 : grandTotal + Integer.parseInt(total);
        }
        this.request.setAttribute("summaryMap", (Object)stats);
        tf.setTotalRows(grandTotal);
        String viewNotesHtml = tf.render();
        this.request.setAttribute("viewNotesHtml", (Object)viewNotesHtml);
        String viewNotesURL = this.getPageURL();
        this.session.setAttribute("viewNotesURL", (Object)viewNotesURL);
        String viewNotesPageFileName = this.getPageServletFileName();
        this.session.setAttribute("viewNotesPageFileName", (Object)viewNotesPageFileName);
        this.request.setAttribute("mapKeys", (Object)ResolutionStatus.getMembers());
        this.request.setAttribute("typeNames", (Object)DiscrepancyNoteUtil.getTypeNames());
        this.request.setAttribute("typeKeys", (Object)totalMap);
        this.request.setAttribute("grandTotal", (Object)grandTotal);
        if ("yes".equalsIgnoreCase(fp.getString(PRINT))) {
            List allNotes = factory.findAllNotes(tf);
            this.request.setAttribute("allNotes", (Object)allNotes);
            this.forwardPage(Page.VIEW_DISCREPANCY_NOTES_IN_STUDY_PRINT);
        } else {
            this.forwardPage(Page.VIEW_DISCREPANCY_NOTES_IN_STUDY);
        }
    }

    private Map<String, String> generateDiscrepancyNotesTotal(Map<String, Map<String, String>> stats) {
        HashMap<String, String> result = new HashMap<String, String>(stats.size());
        int[] totals = new int[DiscrepancyNoteType.list.size() + 1];
        for (String resStatus : stats.keySet()) {
            Map<String, String> dnTypeMap = stats.get(resStatus);
            for (String dnType : dnTypeMap.keySet()) {
                String stringVal = dnTypeMap.get(dnType);
                int val = stringVal.equals("--") ? 0 : Integer.parseInt(stringVal);
                int n = DiscrepancyNoteType.getByName((String)dnType).getId();
                totals[n] = totals[n] + val;
            }
        }
        for (int i = 1; i < totals.length; ++i) {
            String dnType = DiscrepancyNoteType.get((int)i).getName();
            result.put(dnType, totals[i] == 0 ? "--" : Integer.toString(totals[i]));
        }
        return result;
    }

    private Map<String, Map<String, String>> generateDiscrepancyNotesSummary(DiscrepancyNotesSummary summary) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (ResolutionStatus resStatus : ResolutionStatus.list) {
            HashMap<String, String> resStatusMap = new HashMap<String, String>(DiscrepancyNoteType.list.size());
            for (DiscrepancyNoteType dnType : DiscrepancyNoteType.list) {
                int val = summary.getSum(resStatus, dnType);
                resStatusMap.put(dnType.getName(), val == 0 ? "--" : Integer.toString(val));
            }
            int acc = summary.getSum(resStatus);
            resStatusMap.put("Total", acc == 0 ? "--" : Integer.toString(acc));
            result.put(resStatus.getName(), resStatusMap);
        }
        return result;
    }

    public ArrayList<DiscrepancyNoteBean> filterForOneSubject(ArrayList<DiscrepancyNoteBean> allNotes, int subjectId, int resolutionStatus) {
        if (allNotes == null || allNotes.isEmpty() || subjectId == 0) {
            return allNotes;
        }
        boolean filterByRes = resolutionStatus >= 1 && resolutionStatus <= 5;
        ArrayList<DiscrepancyNoteBean> filteredNotes = new ArrayList<DiscrepancyNoteBean>();
        StudySubjectDAO subjectDao = new StudySubjectDAO(this.sm.getDataSource());
        StudySubjectBean studySubjBean = subjectDao.findByPK(subjectId);
        for (DiscrepancyNoteBean discBean : allNotes) {
            if (!discBean.getSubjectName().equalsIgnoreCase(studySubjBean.getLabel())) continue;
            if (!filterByRes) {
                filteredNotes.add(discBean);
                continue;
            }
            if (discBean.getResolutionStatusId() != resolutionStatus) continue;
            filteredNotes.add(discBean);
        }
        return filteredNotes;
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_permission_to_view_discrepancies") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director_or_study_cordinator"), "1");
    }

    protected ViewNotesService resolveViewNotesService() {
        if (this.viewNotesService == null) {
            this.viewNotesService = (ViewNotesService)WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getBean("viewNotesService");
        }
        return this.viewNotesService;
    }
}

