/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.submit;

import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.rule.RuleSetDAO;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.rule.RuleSetBean;
import org.akaza.openclinica.service.rule.RuleSetServiceInterface;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RestoreRuleSetServlet
extends SecureController {
    private static final long serialVersionUID = 1L;
    RuleSetDAO ruleSetDao;
    RuleSetServiceInterface ruleSetService;
    private static String RULESET_ID = "ruleSetId";
    private static String RULESET = "ruleSet";
    private static String ACTION = "action";

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_DEFINITION_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        String ruleSetId = this.request.getParameter(RULESET_ID);
        String action = this.request.getParameter(ACTION);
        if (ruleSetId == null) {
            this.addPageMessage(respage.getString("please_choose_a_CRF_to_view"));
            this.forwardPage(Page.CRF_LIST);
        } else {
            RuleSetBean ruleSetBean = null;
            ruleSetBean = this.getRuleSetService().getRuleSetById(this.currentStudy, ruleSetId);
            if (action.equals("confirm")) {
                this.request.setAttribute(RULESET, (Object)ruleSetBean);
                this.forwardPage(Page.RESTORE_RULE_SET);
            } else {
                this.getRuleSetService().updateRuleSet(ruleSetBean, this.ub, Status.AVAILABLE);
                this.forwardPage(Page.LIST_RULE_SETS_SERVLET);
            }
        }
    }

    private RuleSetServiceInterface getRuleSetService() {
        this.ruleSetService = this.ruleSetService != null ? this.ruleSetService : (RuleSetServiceInterface)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("ruleSetService");
        return this.ruleSetService;
    }
}

