/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.controller.AccountController;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.cdisc.ns.odm.v130_api.ODM;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionClinicalData;
import org.cdisc.ns.odm.v130_api.ODMcomplexTypeDefinitionSubjectData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/odmss"})
public class OdmStudySubjectController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    CoreResources coreResources;
    @Autowired
    ServletContext context;
    @Autowired
    AccountController accountController;
    StudyDAO sdao;
    ParticipantPortalRegistrar participantPortalRegistrar;
    public static final String FORM_CONTEXT = "ecid";
    private MessageSource messageSource;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/study/{studyOid}/crc/{crcUserName}/studysubject/{studySubjectId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ODM getSubjectODM(@PathVariable(value="studyOid") String studyOid, @PathVariable(value="crcUserName") String crcUserName, @PathVariable(value="studySubjectId") String studySubjectLabel) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        return this.getODM(studyOid, studySubjectLabel, crcUserName);
    }

    private ODM getODM(String studyOID, String studySubjectLabel, String crcUserName) {
        StudyDAO studyDAO = new StudyDAO((DataSource)this.dataSource);
        StudySubjectDAO studySubjectDAO = new StudySubjectDAO((DataSource)this.dataSource);
        StudyBean studyBean = null;
        StudySubjectBean studySubjectBean = null;
        try {
            studyBean = studyDAO.findByOid(studyOID);
            if (studyBean != null) {
                studySubjectBean = studySubjectDAO.findByLabelAndStudy(studySubjectLabel, studyBean);
                if (!this.mayProceed(studyOID, studySubjectBean)) {
                    return null;
                }
                if (studySubjectBean.getId() != 0 && !this.accountController.isCRCHasAccessToStudySubject(studyOID, crcUserName, studySubjectLabel).booleanValue()) {
                    return this.createOdm(studyBean, studySubjectBean);
                }
                if (studySubjectBean.getId() != 0 && this.accountController.isCRCHasAccessToStudySubject(studyOID, crcUserName, studySubjectLabel).booleanValue()) {
                    return null;
                }
                return this.createOdm(studyBean, null);
            }
            return this.createOdm(null, null);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
            this.logger.debug(ExceptionUtils.getStackTrace((Throwable)e));
            return null;
        }
    }

    private ODM createOdm(StudyBean studyBean, StudySubjectBean studySubjectBean) {
        ODM odm = new ODM();
        ODMcomplexTypeDefinitionClinicalData clinicalData = null;
        if (studyBean != null) {
            clinicalData = this.generateClinicalData(studyBean);
            if (studySubjectBean != null) {
                ODMcomplexTypeDefinitionSubjectData subjectData = this.generateSubjectData(studySubjectBean);
                clinicalData.getSubjectData().add(subjectData);
            }
            odm.getClinicalData().add(clinicalData);
        }
        return odm;
    }

    private ODMcomplexTypeDefinitionClinicalData generateClinicalData(StudyBean study) {
        ODMcomplexTypeDefinitionClinicalData clinicalData = new ODMcomplexTypeDefinitionClinicalData();
        clinicalData.setStudyName(study.getName());
        clinicalData.setStudyOID(study.getOid());
        return clinicalData;
    }

    private ODMcomplexTypeDefinitionSubjectData generateSubjectData(StudySubjectBean studySubject) {
        ODMcomplexTypeDefinitionSubjectData subjectData = new ODMcomplexTypeDefinitionSubjectData();
        subjectData.setSubjectKey(studySubject.getOid());
        subjectData.setStudySubjectID(studySubject.getLabel());
        subjectData.setStatus(studySubject.getStatus().getName());
        return subjectData;
    }

    public static boolean isAjaxRequest(String requestedWith) {
        return requestedWith != null ? "XMLHttpRequest".equals(requestedWith) : false;
    }

    public static boolean isAjaxUploadRequest(HttpServletRequest request) {
        return request.getParameter("ajaxUpload") != null;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    @Autowired
    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private boolean mayProceed(String studyOid, StudySubjectBean ssBean) throws Exception {
        boolean accessPermission = false;
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(studyOid).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "  studySubjectStatus: " + ssBean.getStatus().getName());
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE") && ssBean.getStatus() == Status.AVAILABLE) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

