/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.rule.RuleSetService;
import org.akaza.openclinica.service.rule.expression.ExpressionService;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/healthcheck"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class ReportController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ExpressionService expressionService;
    @Autowired
    RuleSetService ruleSetService;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/runonschedule"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap<?, ?>> ruleTrigger(@RequestBody HashMap<String, String> hashMap) throws Exception {
        String serverZoneId = hashMap.get("serverZoneId");
        String ssZoneId = hashMap.get("ssZoneId");
        String runTime = hashMap.get("runTime");
        String serverTime = hashMap.get("serverTime");
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        Boolean result = this.ruleSetService.calculateTimezoneDiff(TimeZone.getTimeZone(serverZoneId), TimeZone.getTimeZone(ssZoneId), Integer.valueOf(runTime).intValue(), Integer.valueOf(serverTime).intValue());
        map.put("result", result);
        if (result.booleanValue()) {
            return new ResponseEntity(map, HttpStatus.OK);
        }
        return new ResponseEntity(map, HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/rulecurrentdate"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap<?, ?>> getSSZone(@RequestBody HashMap<String, String> hashMap) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        String ssZoneId = hashMap.get("ssZoneId");
        String serverZoneId = hashMap.get("serverZoneId");
        HashMap map = this.expressionService.getSSDate(ssZoneId, serverZoneId);
        return new ResponseEntity((Object)map, HttpStatus.OK);
    }

    @RequestMapping(value={"/runtime"}, method={RequestMethod.POST})
    public ResponseEntity<HashMap<?, ?>> getRunTime() throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int result = this.ruleSetService.getRunTimeWhenTimeIsNotSet();
        map.put("result", result);
        return new ResponseEntity(map, HttpStatus.OK);
    }
}

