/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.dao.hibernate.EventCrfDao;
import org.akaza.openclinica.dao.hibernate.EventDefinitionCrfDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDao;
import org.akaza.openclinica.dao.hibernate.StudyEventDefinitionDao;
import org.akaza.openclinica.dao.hibernate.StudyParameterValueDao;
import org.akaza.openclinica.dao.hibernate.StudySubjectDao;
import org.akaza.openclinica.domain.DomainObject;
import org.akaza.openclinica.domain.Status;
import org.akaza.openclinica.domain.datamap.EventCrf;
import org.akaza.openclinica.domain.datamap.EventDefinitionCrf;
import org.akaza.openclinica.domain.datamap.Study;
import org.akaza.openclinica.domain.datamap.StudyEvent;
import org.akaza.openclinica.domain.datamap.StudyEventDefinition;
import org.akaza.openclinica.domain.datamap.StudyParameterValue;
import org.akaza.openclinica.domain.datamap.StudySubject;
import org.akaza.openclinica.patterns.ocobserver.StudyEventChangeDetails;
import org.akaza.openclinica.patterns.ocobserver.StudyEventContainer;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/auth/api/v1/studyevent"})
public class StudyEventController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    private EventCrfDao eventCrfDao;
    @Autowired
    private StudyEventDao studyEventDao;
    @Autowired
    private StudySubjectDao studySubjectDao;
    @Autowired
    private StudyEventDefinitionDao studyEventDefinitionDao;
    @Autowired
    private EventDefinitionCrfDao eventDefinitionCrfDao;
    @Autowired
    private StudyParameterValueDao studyParameterValueDao;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @RequestMapping(value={"/studysubject/{studySubjectOid}/studyevent/{studyEventDefOid}/ordinal/{ordinal}/complete"}, method={RequestMethod.PUT})
    @ResponseBody
    public Map<String, String> completeParticipantEvent(HttpServletRequest request, @PathVariable(value="studySubjectOid") String studySubjectOid, @PathVariable(value="studyEventDefOid") String studyEventDefOid, @PathVariable(value="ordinal") Integer ordinal) throws Exception {
        StudySubject subject = this.studySubjectDao.findByOcOID(studySubjectOid);
        StudyEvent studyEvent = this.studyEventDao.fetchByStudyEventDefOIDAndOrdinal(studyEventDefOid, ordinal, Integer.valueOf(subject.getStudySubjectId()));
        StudyEventDefinition studyEventDefinition = this.studyEventDefinitionDao.findByStudyEventDefinitionId(studyEvent.getStudyEventDefinition().getStudyEventDefinitionId());
        Study study = studyEventDefinition.getStudy();
        HashMap<String, String> response = new HashMap<String, String>();
        if (!this.mayProceed(study)) {
            response.put("code", String.valueOf(HttpStatus.FORBIDDEN.value()));
            response.put("message", "Request Denied.  Operation not allowed.");
            return response;
        }
        List eventDefCrfs = this.eventDefinitionCrfDao.findByStudyEventDefinitionId(studyEventDefinition.getStudyEventDefinitionId());
        List eventCrfs = this.eventCrfDao.findByStudyEventIdStudySubjectId(Integer.valueOf(studyEvent.getStudyEventId()), studySubjectOid);
        try {
            this.completeData(studyEvent, eventDefCrfs, eventCrfs);
        }
        catch (Exception e) {
            this.logger.error("Error encountered while completing Study Event: " + e.getMessage());
            this.logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            response.put("code", String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
            response.put("message", "Error encountered while completing participant event.");
            return response;
        }
        response.put("code", String.valueOf(HttpStatus.OK.value()));
        response.put("message", "Success.");
        return response;
    }

    @Transactional
    private void completeData(StudyEvent studyEvent, List<EventDefinitionCrf> eventDefCrfs, List<EventCrf> eventCrfs) throws Exception {
        boolean completeStudyEvent = true;
        for (EventDefinitionCrf eventDefCrf : eventDefCrfs) {
            boolean foundEventCrfMatch = false;
            for (EventCrf eventCrf : eventCrfs) {
                if (eventDefCrf.getCrf().getCrfId() != eventCrf.getCrfVersion().getCrf().getCrfId()) continue;
                foundEventCrfMatch = true;
                if (eventDefCrf.getParicipantForm().booleanValue()) {
                    eventCrf.setStatusId(Status.UNAVAILABLE.getCode());
                    this.eventCrfDao.saveOrUpdate((DomainObject)eventCrf);
                    continue;
                }
                if (eventCrf.getStatusId() == Status.UNAVAILABLE.getCode()) continue;
                completeStudyEvent = false;
            }
            if (foundEventCrfMatch || eventDefCrf.getParicipantForm().booleanValue()) continue;
            completeStudyEvent = false;
        }
        if (completeStudyEvent) {
            studyEvent.setSubjectEventStatusId(Integer.valueOf(4));
            StudyEventChangeDetails changeDetails = new StudyEventChangeDetails(Boolean.valueOf(true), Boolean.valueOf(false));
            StudyEventContainer container = new StudyEventContainer(studyEvent, changeDetails);
            this.studyEventDao.saveOrUpdateTransactional(container);
        }
    }

    private boolean mayProceed(Study study) throws Exception {
        boolean accessPermission = false;
        StudyParameterValue pStatus = this.studyParameterValueDao.findByStudyIdParameter(study.getStudyId(), "participantPortal");
        ParticipantPortalRegistrar participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = participantPortalRegistrar.getRegistrationStatus(study.getOc_oid()).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
        System.out.println("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

