/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.otp.CertificateBean;
import org.akaza.openclinica.service.otp.TwoFactorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/printout"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class TwoFactorPrintoutController {
    @Autowired
    private TwoFactorService factorService;
    @Autowired
    private UserAccountDAO dao;

    @GetMapping(produces={"application/pdf"})
    public void printout(@RequestParam(name="userId", required=true) int userId, HttpServletResponse response) throws Exception {
        response.setHeader("Content-Disposition", "attachment; filename=\"certificate.pdf\"");
        response.addHeader("Content-Type", "application/pdf");
        response.setContentType("application/octet-stream");
        UserAccountBean userAccount = this.dao.findByPK(userId);
        CertificateBean certificateBean = new CertificateBean();
        certificateBean.setUsername(userAccount.getLastName() + ", " + userAccount.getFirstName());
        certificateBean.setSecret(userAccount.getAuthsecret());
        certificateBean.setEmail(userAccount.getEmail());
        certificateBean.setLogin(userAccount.getName());
        this.factorService.printoutCertificate(certificateBean, (OutputStream)response.getOutputStream());
    }
}

