/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.controller;

import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.login.UserDTO;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.dao.hibernate.AuthoritiesDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.pmanage.ParticipantPortalRegistrar;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/userinfo"})
@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
public class UserInfoController {
    @Autowired
    @Qualifier(value="dataSource")
    private BasicDataSource dataSource;
    @Autowired
    ServletContext context;
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    UserAccountDAO udao;
    StudyDAO sdao;
    StudySubjectDAO ssdao;
    UserDTO uDTO;
    AuthoritiesDao authoritiesDao;
    ParticipantPortalRegistrar participantPortalRegistrar;

    @RequestMapping(value={"/study/{studyOid}/crc"}, method={RequestMethod.GET})
    public ResponseEntity<UserDTO> getCrcAccountBySession(@PathVariable(value="studyOid") String studyOid) throws Exception {
        ResourceBundleProvider.updateLocale((Locale)new Locale("en_US"));
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        boolean isRequestValid = true;
        this.uDTO = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        Object principle = null;
        if (auth != null) {
            principle = auth.getPrincipal();
        }
        StudyBean currentStudy = this.sdao.findByOid(studyOid);
        UserAccountBean userAccount = this.udao.findByUserName(((UserDetails)principle).getUsername());
        StudyBean parentStudy = this.getParentStudy(currentStudy.getOid());
        Integer pStudyId = parentStudy.getId();
        String oid = parentStudy.getOid();
        if (this.isStudyASiteLevelStudy(currentStudy.getOid()).booleanValue()) {
            isRequestValid = false;
        } else if (!this.mayProceed(oid)) {
            isRequestValid = false;
        } else if (this.isStudyDoesNotExist(oid).booleanValue()) {
            isRequestValid = false;
        } else if (this.isCRCUserAccountDoesNotExist(userAccount.getName()).booleanValue()) {
            isRequestValid = false;
        } else if (this.doesCRCNotHaveStudyAccessRole(userAccount.getName(), pStudyId).booleanValue()) {
            isRequestValid = false;
        }
        if (isRequestValid) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            this.buildUserDTO(userAccount);
            return new ResponseEntity((Object)this.uDTO, (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity((Object)this.uDTO, HttpStatus.NOT_ACCEPTABLE);
    }

    public Boolean isCRCHasAccessToStudySubject(String studyOid, String crcUserName, String studySubjectId) {
        this.uDTO = null;
        if (this.isStudySubjecAndCRCRolesMatch(studySubjectId, crcUserName, studyOid).booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isApiKeyExist(String uuid) {
        UserAccountDAO udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean uBean = udao.findByApiKey(uuid);
        if (uBean == null || !uBean.isActive()) {
            return false;
        }
        return true;
    }

    private UserDTO buildUserDTO(UserAccountBean userAccountBean) {
        this.uDTO = new UserDTO();
        this.uDTO.setfName(userAccountBean.getFirstName());
        this.uDTO.setlName(userAccountBean.getLastName());
        this.uDTO.setMobile(userAccountBean.getPhone());
        this.uDTO.setUserName(userAccountBean.getName());
        this.uDTO.setAccessCode(userAccountBean.getAccessCode());
        this.uDTO.setPassword(userAccountBean.getPasswd());
        this.uDTO.setEmail(userAccountBean.getEmail());
        return this.uDTO;
    }

    private UserAccountBean getUserAccount(String userName) {
        this.udao = new UserAccountDAO((DataSource)this.dataSource);
        UserAccountBean userAccountBean = this.udao.findByUserName(userName);
        return userAccountBean;
    }

    private StudyBean getStudy(String oid) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByOid(oid);
        return studyBean;
    }

    private StudyBean getStudy(Integer id) {
        this.sdao = new StudyDAO((DataSource)this.dataSource);
        StudyBean studyBean = this.sdao.findByPK(id.intValue());
        return studyBean;
    }

    private StudySubjectBean getStudySubject(String label, StudyBean study) {
        this.ssdao = new StudySubjectDAO((DataSource)this.dataSource);
        StudySubjectBean studySubjectBean = this.ssdao.findByLabelAndStudy(label, study);
        return studySubjectBean;
    }

    private Boolean isStudyDoesNotExist(String studyOid) {
        StudyBean studyBean = this.getStudy(studyOid);
        if (studyBean == null) {
            this.logger.info("***Study  Does Not Exist ***");
            return true;
        }
        return false;
    }

    private Boolean isStudyASiteLevelStudy(String studyOid) {
        StudyBean studyBean = this.getStudy(studyOid);
        if (studyBean.getParentStudyId() != 0) {
            this.logger.info("***Study provided in the URL is a Site study***");
            return true;
        }
        return false;
    }

    private Boolean isCRCUserAccountDoesNotExist(String crcUserName) {
        UserAccountBean ownerUserAccount = this.getUserAccount(crcUserName);
        if (!ownerUserAccount.isActive()) {
            this.logger.info("***  CRC user acount does not Exist in the User Table ***");
            return true;
        }
        return false;
    }

    private Boolean doesCRCNotHaveStudyAccessRole(String crcUserName, Integer pStudyId) {
        boolean found = false;
        ArrayList studyUserRoleBeans = this.udao.findAllRolesByUserName(crcUserName);
        for (StudyUserRoleBean studyUserRoleBean : studyUserRoleBeans) {
            StudyBean study = this.getParentStudy(Integer.valueOf(studyUserRoleBean.getStudyId()));
            if (study.getId() != pStudyId.intValue() || !studyUserRoleBean.getRoleName().equals("ra") && !studyUserRoleBean.getRoleName().equals("ra2") || !studyUserRoleBean.getStatus().isAvailable()) continue;
            found = true;
            break;
        }
        if (!found) {
            this.logger.info("*** CRC Does not have access to the study/site OR CRC Does not have 'Data Entry Person' role ***");
            return true;
        }
        return false;
    }

    private Boolean doesStudySubjecAndCRCRolesMatch(String crcUserName, Integer subjectStudyId) {
        boolean found = false;
        ArrayList studyUserRoleBeans = this.udao.findAllRolesByUserName(crcUserName);
        for (StudyUserRoleBean studyUserRoleBean : studyUserRoleBeans) {
            if (studyUserRoleBean.getStudyId() == this.getParentStudy(subjectStudyId).getId()) {
                subjectStudyId = this.getParentStudy(subjectStudyId).getId();
                System.out.println("StudySubject Parent Study Id to compare to Overwritten    " + subjectStudyId);
            }
            if (studyUserRoleBean.getStudyId() != subjectStudyId.intValue() || !studyUserRoleBean.getRoleName().equals("ra") && !studyUserRoleBean.getRoleName().equals("ra2") || !studyUserRoleBean.getStatus().isAvailable()) continue;
            found = true;
            break;
        }
        if (!found) {
            this.logger.info("*** CRC Role does not match with StudySubject assignment ***");
            return true;
        }
        return false;
    }

    private Boolean isStudySubjecAndCRCRolesMatch(String studySubjectId, String crcUserName, String studyOid) {
        StudyBean parentStudy = this.getParentStudy(studyOid);
        StudySubjectBean studySubjectBean = this.getStudySubject(studySubjectId, parentStudy);
        Integer studyIdFromStudySubjectId = studySubjectBean.getStudyId();
        return this.doesStudySubjecAndCRCRolesMatch(crcUserName, studyIdFromStudySubjectId);
    }

    private StudyBean getParentStudy(Integer studyId) {
        StudyBean study = this.getStudy(studyId);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private StudyBean getParentStudy(String studyOid) {
        StudyBean study = this.getStudy(studyOid);
        if (study.getParentStudyId() == 0) {
            return study;
        }
        StudyBean parentStudy = this.sdao.findByPK(study.getParentStudyId());
        return parentStudy;
    }

    private boolean mayProceed(String studyOid) throws Exception {
        boolean accessPermission = false;
        StudyBean siteStudy = this.getStudy(studyOid);
        StudyBean study = this.getParentStudy(studyOid);
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO((DataSource)this.dataSource);
        StudyParameterValueBean pStatus = spvdao.findByHandleAndStudy(study.getId(), "participantPortal");
        this.participantPortalRegistrar = new ParticipantPortalRegistrar();
        String pManageStatus = this.participantPortalRegistrar.getRegistrationStatus(study.getOid()).toString();
        String participateStatus = pStatus.getValue().toString();
        String studyStatus = study.getStatus().getName().toString();
        String siteStatus = siteStudy.getStatus().getName().toString();
        this.logger.info("pManageStatus: " + pManageStatus + "  participantStatus: " + participateStatus + "   studyStatus: " + studyStatus + "   siteStatus: " + siteStatus);
        if (participateStatus.equalsIgnoreCase("enabled") && studyStatus.equalsIgnoreCase("available") && siteStatus.equalsIgnoreCase("available") && pManageStatus.equalsIgnoreCase("ACTIVE")) {
            accessPermission = true;
        }
        return accessPermission;
    }
}

