/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view;

import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.extract.FilterBean;
import org.akaza.openclinica.control.extract.ApplyFilterServlet;
import org.akaza.openclinica.control.extract.EditFilterServlet;
import org.akaza.openclinica.control.extract.RemoveFilterServlet;
import org.akaza.openclinica.view.Table;

public class FilterTable
extends Table {
    public FilterTable() {
        this.columns.add("Filter Name");
        this.columns.add("Description");
        this.columns.add("Owner");
        this.columns.add("Creation Date");
        this.columns.add("Status");
        this.columns.add("Actions");
    }

    public String getEntitiesNamePlural() {
        return "filters";
    }

    public String showRow(EntityBean e) {
        FilterBean fb = (FilterBean)e;
        Status s = fb.getStatus();
        String row = "<tr>\n";
        String colorOn = s.equals((Term)Status.AVAILABLE) ? "" : "<font color='gray'>";
        String colorOff = s.equals((Term)Status.AVAILABLE) ? "" : "</font>";
        row = row + "<td>" + colorOn + fb.getName() + colorOff + "</td>\n";
        row = row + "<td>" + fb.getDescription() + "</td>\n";
        row = row + "<td>" + fb.getOwner().getName() + "</td>\n";
        row = row + "<td>" + fb.getCreatedDate().toString() + "</td>\n";
        row = row + "<td>" + s.getName() + "</td>\n";
        row = row + "<td>";
        if (!s.equals((Term)Status.DELETED) && !s.equals((Term)Status.AUTO_DELETED)) {
            String confirmQuestion = "Are you sure you want to delete " + fb.getName() + "?";
            String onClick = "onClick=\"return confirm('" + confirmQuestion + "');\"";
            row = row + "<a href='" + ApplyFilterServlet.getLink((int)fb.getId()) + "'>view</a>";
            row = row + " <a href='" + EditFilterServlet.getLink((int)fb.getId()) + "'>edit</a>";
            row = row + " <a href='" + RemoveFilterServlet.getLink((int)fb.getId()) + "'" + onClick + ">delete</a>";
        }
        row = row + "</td>\n";
        row = row + "</tr>\n";
        row = row + "<tr>\n";
        row = row + "</tr>\n";
        return row;
    }
}

