/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.view;

import java.util.ArrayList;
import java.util.HashMap;
import org.akaza.openclinica.bean.core.EntityBean;
import org.akaza.openclinica.control.form.FormProcessor;

public abstract class Table {
    public static final int NUM_ROWS_PER_PAGE = 10;
    protected ArrayList<EntityBean> rows = new ArrayList();
    protected ArrayList<String> columns = new ArrayList();
    protected int numColumns = 0;
    protected int currPageNumber = 0;
    protected int totalPageNumbers = 0;
    protected int sortingColumnInd = 0;
    protected boolean ascendingSort = true;
    protected boolean filtered = false;
    protected String keywordFilter = "";
    protected String postAction = "";
    protected HashMap<String, String> postArgs = new HashMap();
    protected String baseGetQuery = "";
    protected String noRowsMessage = "";
    protected String noColsMessage = "";

    public int getTotalPageNumbers() {
        return this.totalPageNumbers;
    }

    public ArrayList<String> getColumns() {
        return this.columns;
    }

    public void setColumns(ArrayList<String> columns) {
        this.columns = columns;
        this.numColumns = columns.size();
    }

    public boolean isAscendingSort() {
        return this.ascendingSort;
    }

    public int getCurrPageNumber() {
        return this.currPageNumber;
    }

    public String getKeywordFilter() {
        return this.keywordFilter;
    }

    public ArrayList<EntityBean> getRows() {
        return this.rows;
    }

    private void updateTotalPageNumbers() {
        this.totalPageNumbers = this.rows.size() / 10;
    }

    public void setRows(ArrayList<EntityBean> rows) {
        this.rows = rows;
        this.updateTotalPageNumbers();
    }

    public void addRow(EntityBean e) {
        this.rows.add(e);
        this.updateTotalPageNumbers();
    }

    public void processGetQuery(FormProcessor fp) {
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public int getSortingColumnInd() {
        return this.sortingColumnInd;
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public void setQuery(String baseURL, HashMap<String, String> args) {
        this.postAction = baseURL;
        this.postArgs = args;
        this.baseGetQuery = baseURL + "?";
        this.baseGetQuery = this.baseGetQuery + "submitted=1";
        for (String key : args.keySet()) {
            String value = args.get(key);
            this.baseGetQuery = this.baseGetQuery + "&" + key + "=" + value;
        }
    }

    public String getBaseGetQuery() {
        return this.baseGetQuery;
    }

    public String getPostAction() {
        return this.postAction;
    }

    public HashMap<String, String> getPostArgs() {
        return this.postArgs;
    }

    @Deprecated
    protected String showHeader() {
        String header = "<table border>\n";
        header = header + "<tr>\n";
        for (String column : this.columns) {
            header = header + "<td>" + column + "</td>\n";
        }
        header = header + "</tr>\n";
        return header;
    }

    @Deprecated
    protected String showFooter() {
        return "</table>\n";
    }

    @Deprecated
    protected abstract String showRow(EntityBean var1);

    @Deprecated
    protected abstract String getEntitiesNamePlural();

    @Deprecated
    public String showTable() {
        if (this.rows.size() <= 0) {
            return "<p><i>There are no " + this.getEntitiesNamePlural() + " available for display.</i></p>";
        }
        String table = this.showHeader();
        for (EntityBean e : this.rows) {
            table = table + this.showRow(e);
        }
        table = table + this.showFooter();
        return table;
    }
}

