/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.filter.rest;

import com.sun.jersey.server.impl.application.WebApplicationContext;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;

public class RestODMFilter
implements ContainerRequestFilter,
ResourceFilter {
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    WebApplicationContext context;
    String studyOIDS;
    public static ResourceBundle restext;
    private static String GlOBAL_STUDY_OID;

    public ContainerRequest filter(ContainerRequest containerRequest) {
        UserAccountBean userBean = (UserAccountBean)this.request.getSession().getAttribute("userBean");
        String studyOID = ((PathSegment)containerRequest.getPathSegments().get(3)).getPath();
        if (studyOID.equals(GlOBAL_STUDY_OID)) {
            if (this.checkAuth(userBean).booleanValue()) {
                return containerRequest;
            }
        } else {
            int parentStudyID;
            StudyBean studyBean = this.getStudyByOID(studyOID, this.getDataSource());
            if (this.checkAuth(studyBean, userBean).booleanValue()) {
                return containerRequest;
            }
            if (studyBean.getParentStudyId() != 0 && this.checkAuth(studyBean = this.getStudyByID(parentStudyID = studyBean.getParentStudyId(), this.getDataSource()), userBean).booleanValue()) {
                return containerRequest;
            }
            this.request.setAttribute("pageMessages", (Object)"You don't have correct permission in your current Study.");
        }
        throw new WebApplicationException(Response.Status.FORBIDDEN);
    }

    private Boolean checkAuth(UserAccountBean userBean) {
        Boolean auth = false;
        ArrayList userRoles = userBean.getRoles();
        for (int i = 0; i < userRoles.size() && !auth.booleanValue(); ++i) {
            StudyUserRoleBean studyRole = (StudyUserRoleBean)userRoles.get(i);
            if (!studyRole.getRole().equals((Term)Role.ADMIN) && !studyRole.getRole().equals((Term)Role.COORDINATOR) && !studyRole.getRole().equals((Term)Role.STUDYDIRECTOR)) continue;
            auth = true;
        }
        return auth;
    }

    private Boolean checkAuth(StudyBean studyBean, UserAccountBean userBean) {
        Boolean auth = false;
        StudyUserRoleBean studyRole = this.getRoleByStudy(studyBean, this.getDataSource(), userBean);
        Role r = studyRole.getRole();
        if (r != null) {
            if (r != null && (r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.STUDYDIRECTOR))) {
                auth = true;
            }
            if (r != null && (r.equals((Term)Role.ADMIN) || r.equals((Term)Role.COORDINATOR) || r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.INVESTIGATOR) || r.equals((Term)Role.MONITOR) || r.equals((Term)Role.RESEARCHASSISTANT) || r.equals((Term)Role.RESEARCHASSISTANT2))) {
                auth = true;
            }
        }
        return auth;
    }

    private DataSource getDataSource() {
        return (DataSource)SpringServletAccess.getApplicationContext((ServletContext)this.request.getSession().getServletContext()).getBean("dataSource");
    }

    private StudyBean getStudyByOID(String OID, DataSource ds) {
        StudyDAO studyDAO = new StudyDAO(ds);
        return studyDAO.findByOid(OID);
    }

    private StudyUserRoleBean getRoleByStudy(StudyBean studyBean, DataSource ds, UserAccountBean userBean) {
        UserAccountDAO userAccountDAO = new UserAccountDAO(ds);
        return userAccountDAO.findRoleByUserNameAndStudyId(userBean.getName(), studyBean.getId());
    }

    private StudyBean getStudyByID(int id, DataSource ds) {
        StudyDAO studyDAO = new StudyDAO(ds);
        return studyDAO.findByPK(id);
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    static {
        GlOBAL_STUDY_OID = "*";
    }
}

