/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.job;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.submit.crfdata.FormDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ImportItemDataBean;
import org.akaza.openclinica.bean.submit.crfdata.ImportItemGroupDataBean;
import org.akaza.openclinica.bean.submit.crfdata.StudyEventDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SubjectDataBean;
import org.akaza.openclinica.bean.submit.crfdata.SummaryStatsBean;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.submit.ImportCRFInfo;
import org.akaza.openclinica.control.submit.ImportCRFInfoContainer;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.TriggerBuilder;

public class TriggerService {
    public static final String PERIOD = "periodToRun";
    public static final String TAB = "tab";
    public static final String CDISC = "cdisc";
    public static final String SPSS = "spss";
    public static final String DATASET_ID = "dsId";
    public static final String DATE_START_JOB = "job";
    public static final String EMAIL = "contactEmail";
    public static final String JOB_NAME = "jobName";
    public static final String JOB_DESC = "jobDesc";
    public static final String USER_ID = "user_id";
    public static final String STUDY_NAME = "study_name";
    public static final String STUDY_OID = "study_oid";
    public static final String DIRECTORY = "filePathDir";
    public static final String STUDY_ID = "studyId";
    private static String IMPORT_TRIGGER = "importTrigger";

    public SimpleTrigger generateImportTrigger(FormProcessor fp, UserAccountBean userAccount, StudyBean study, String locale) {
        Date startDateTime = new Date(System.currentTimeMillis());
        return this.generateImportTrigger(fp, userAccount, study, startDateTime, locale);
    }

    public SimpleTrigger generateImportTrigger(FormProcessor fp, UserAccountBean userAccount, StudyBean study, Date startDateTime, String locale) {
        String jobName = fp.getString(JOB_NAME);
        String email = fp.getString(EMAIL);
        String jobDesc = fp.getString(JOB_DESC);
        String directory = fp.getString(DIRECTORY);
        long interval = 0L;
        int hours = fp.getInt("hours");
        int minutes = fp.getInt("minutes");
        if (hours > 0) {
            long hoursInt = hours * 3600000;
            interval += hoursInt;
        }
        if (minutes > 0) {
            long minutesInt = minutes * 60000;
            interval += minutesInt;
        }
        SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(jobName, IMPORT_TRIGGER).forJob(jobName, IMPORT_TRIGGER).withDescription(jobDesc).startAt(startDateTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withRepeatCount(64000).withIntervalInSeconds(new Long(interval).intValue()).withMisfireHandlingInstructionNextWithExistingCount()).build();
        trigger.getJobDataMap().put(EMAIL, email);
        trigger.getJobDataMap().put(USER_ID, userAccount.getId());
        trigger.getJobDataMap().put(STUDY_NAME, study.getName());
        trigger.getJobDataMap().put(STUDY_OID, study.getOid());
        trigger.getJobDataMap().put(DIRECTORY, directory);
        trigger.getJobDataMap().put("locale", locale);
        trigger.getJobDataMap().put("hours", hours);
        trigger.getJobDataMap().put("minutes", minutes);
        return trigger;
    }

    public HashMap<String, ArrayList<String>> validateForm(FormProcessor fp, HttpServletRequest request, String[] triggerNames, String properName) {
        Validator v = new Validator(request);
        v.addValidation(JOB_NAME, 1);
        v.addValidation(JOB_DESC, 1);
        v.addValidation(EMAIL, 6);
        v.addValidation(PERIOD, 1);
        v.addValidation("jobDate", 4);
        String tab = fp.getString(TAB);
        String cdisc = fp.getString(CDISC);
        String cdisc12 = fp.getString("cdisc12");
        String cdisc13 = fp.getString("cdisc13");
        String cdisc13oc = fp.getString("cdisc13oc");
        String spss = fp.getString(SPSS);
        Date jobDate = fp.getDateTime(DATE_START_JOB);
        HashMap errors = v.validate();
        if (tab == "" && cdisc == "" && spss == "" && cdisc12 == "" && cdisc13 == "" && cdisc13oc == "") {
            Validator.addError((HashMap)errors, (String)TAB, (String)"Please pick at least one of the below.");
        }
        for (String triggerName : triggerNames) {
            if (!triggerName.equals(fp.getString(JOB_NAME)) || triggerName.equals(properName)) continue;
            Validator.addError((HashMap)errors, (String)JOB_NAME, (String)"A job with that name already exists.  Please pick another name.");
        }
        if (jobDate.before(new Date())) {
            Validator.addError((HashMap)errors, (String)"jobDate", (String)"This date needs to be later than the present time.");
        }
        return errors;
    }

    public String generateSummaryStatsMessage(SummaryStatsBean ssBean, ResourceBundle respage) {
        StringBuffer sb = new StringBuffer();
        sb.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
        sb.append("<tr valign='top'> <td class='table_header_row'>Summary Statistics:</td> </tr> <tr valign='top'>");
        sb.append("<td class='table_cell_left'>Subjects Affected: " + ssBean.getStudySubjectCount() + "</td> </tr>");
        sb.append("<tr valign='top'> <td class='table_cell_left'>Total Event CRFs: " + ssBean.getEventCrfCount() + "</td> </tr> ");
        sb.append("<tr valign='top'> <td class='table_cell_left'>Event CRFs Available for Import: " + (ssBean.getEventCrfCount() - ssBean.getSkippedCrfCount()) + "</td> </tr> ");
        sb.append("<tr valign='top'> <td class='table_cell_left'>Event CRFs Skipped: " + ssBean.getSkippedCrfCount() + "</td> </tr> ");
        sb.append("<tr valign='top'><td class='table_cell_left'>Validation Rules Generated: " + ssBean.getDiscNoteCount() + "</td> </tr> </table>");
        return sb.toString();
    }

    public String generateSkippedCRFMessage(ImportCRFInfoContainer importCRFList, ResourceBundle resword) {
        StringBuffer sb = new StringBuffer();
        sb.append("Skipped CRFs (due to import rules):<br/>");
        sb.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
        sb.append("<tr valign='top'> <td>Study OID :</td> <td>Study Subject OID :</td> <td>Event CRF OID:</td> <td>CRF Version OID:</td> <td>Event CRF Status:</td> </tr>");
        for (ImportCRFInfo importCrfInfo : importCRFList.getImportCRFList()) {
            String preImportStatus = "";
            preImportStatus = importCrfInfo.getPreImportStage().isInitialDE() ? resword.getString("initial_data_entry") : (importCrfInfo.getPreImportStage().isInitialDE_Complete() ? resword.getString("initial_data_entry_complete") : (importCrfInfo.getPreImportStage().isDoubleDE() ? resword.getString("double_data_entry") : (importCrfInfo.getPreImportStage().isDoubleDE_Complete() ? resword.getString("data_entry_complete") : (importCrfInfo.getPreImportStage().isAdmin_Editing() ? resword.getString("administrative_editing") : (importCrfInfo.getPreImportStage().isLocked() ? resword.getString("locked") : resword.getString("invalid"))))));
            if (importCrfInfo.isProcessImport()) continue;
            sb.append("<tr valign='top'> <td>" + importCrfInfo.getStudyOID() + "</td> <td>" + importCrfInfo.getStudySubjectOID() + "</td><td>" + importCrfInfo.getStudyEventOID() + "</td><td>" + importCrfInfo.getFormOID() + "</td> <td>" + preImportStatus + "</td></tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }

    public String generateHardValidationErrorMessage(ArrayList<SubjectDataBean> subjectData, HashMap<String, String> hardValidationErrors, boolean isValid) {
        StringBuffer sb = new StringBuffer();
        String studyEventRepeatKey = "1";
        String groupRepeatKey = "1";
        sb.append("<table border='0' cellpadding='0' cellspacing='0' width='100%'>");
        for (SubjectDataBean subjectDataBean : subjectData) {
            sb.append("<tr valign='top'> <td class='table_header_row' colspan='4'>Study Subject: " + subjectDataBean.getSubjectOID() + "</td> </tr>");
            ArrayList studyEventDataBeans = subjectDataBean.getStudyEventData();
            for (StudyEventDataBean studyEventDataBean : studyEventDataBeans) {
                sb.append("<tr valign='top'> <td class='table_header_row'>Event CRF OID</td> <td class='table_header_row' colspan='3'></td>");
                sb.append("</tr> <tr valign='top'> <td class='table_cell_left'>");
                sb.append(studyEventDataBean.getStudyEventOID());
                if (studyEventDataBean.getStudyEventRepeatKey() != null) {
                    studyEventRepeatKey = studyEventDataBean.getStudyEventRepeatKey();
                    sb.append(" (Repeat key " + studyEventDataBean.getStudyEventRepeatKey() + ")");
                } else {
                    studyEventRepeatKey = "1";
                }
                sb.append("</td> <td class='table_cell' colspan='3'></td> </tr>");
                ArrayList formDataBeans = studyEventDataBean.getFormData();
                for (FormDataBean formDataBean : formDataBeans) {
                    sb.append("<tr valign='top'> <td class='table_header_row'></td> ");
                    sb.append("<td class='table_header_row'>CRF Version OID</td> <td class='table_header_row' colspan='2'></td></tr>");
                    sb.append("<tr valign='top'> <td class='table_cell_left'></td> <td class='table_cell'>");
                    sb.append(formDataBean.getFormOID());
                    sb.append("</td> <td class='table_cell' colspan='2'></td> </tr>");
                    ArrayList itemGroupDataBeans = formDataBean.getItemGroupData();
                    for (ImportItemGroupDataBean itemGroupDataBean : itemGroupDataBeans) {
                        sb.append("<tr valign='top'> <td class='table_header_row'></td>");
                        sb.append("<td class='table_header_row'></td> <td class='table_header_row' colspan='2'>");
                        sb.append(itemGroupDataBean.getItemGroupOID());
                        if (itemGroupDataBean.getItemGroupRepeatKey() != null) {
                            groupRepeatKey = itemGroupDataBean.getItemGroupRepeatKey();
                            sb.append(" (Repeat key " + itemGroupDataBean.getItemGroupRepeatKey() + ")");
                        } else {
                            groupRepeatKey = "1";
                        }
                        sb.append("</td></tr>");
                        ArrayList itemDataBeans = itemGroupDataBean.getItemData();
                        for (ImportItemDataBean itemDataBean : itemDataBeans) {
                            String oidKey = itemDataBean.getItemOID() + "_" + studyEventRepeatKey + "_" + groupRepeatKey + "_" + subjectDataBean.getSubjectOID();
                            if (!isValid) {
                                if (!hardValidationErrors.containsKey(oidKey)) continue;
                                sb.append("<tr valign='top'> <td class='table_cell_left'></td>");
                                sb.append("<td class='table_cell'></td> <td class='table_cell'><font color='red'>");
                                sb.append(itemDataBean.getItemOID());
                                sb.append("</font></td> <td class='table_cell'>");
                                sb.append(itemDataBean.getValue() + "<br/>");
                                sb.append(hardValidationErrors.get(oidKey));
                                sb.append("</td></tr>");
                                continue;
                            }
                            if (hardValidationErrors.containsKey(oidKey)) continue;
                            sb.append("<tr valign='top'> <td class='table_cell_left'></td>");
                            sb.append("<td class='table_cell'></td> <td class='table_cell'>");
                            sb.append(itemDataBean.getItemOID());
                            sb.append("</td> <td class='table_cell'>");
                            sb.append(itemDataBean.getValue());
                            sb.append("</td></tr>");
                        }
                    }
                }
            }
        }
        sb.append("</table>");
        return sb.toString();
    }

    public String generateValidMessage(ArrayList<SubjectDataBean> subjectData, HashMap<String, String> totalValidationErrors) {
        return this.generateHardValidationErrorMessage(subjectData, totalValidationErrors, true);
    }

    public HashMap<String, ArrayList<String>> validateImportJobForm(FormProcessor fp, HttpServletRequest request, String[] triggerNames, String properName) {
        Validator v = new Validator(request);
        v.addValidation(JOB_NAME, 1);
        v.addValidation(JOB_NAME, 46);
        v.addValidation(JOB_DESC, 1);
        if (!"".equals(fp.getString(EMAIL))) {
            v.addValidation(EMAIL, 6);
        }
        String hours = fp.getString("hours");
        String minutes = fp.getString("minutes");
        HashMap errors = v.validate();
        if (hours.equals("0") && minutes.equals("0")) {
            Validator.addError((HashMap)errors, (String)"hours", (String)"At least one of the following should be greater than zero.");
        }
        for (String triggerName : triggerNames) {
            if (!triggerName.equals(fp.getString(JOB_NAME)) || triggerName.equals(properName)) continue;
            Validator.addError((HashMap)errors, (String)JOB_NAME, (String)"A job with that name already exists.  Please pick another name.");
        }
        return errors;
    }

    public HashMap<String, ArrayList<String>> validateImportJobForm(FormProcessor fp, HttpServletRequest request, String[] triggerNames) {
        return this.validateImportJobForm(fp, request, triggerNames, "");
    }

    public HashMap<String, ArrayList<String>> validateForm(FormProcessor fp, HttpServletRequest request, String[] triggerNames) {
        return this.validateForm(fp, request, triggerNames, "");
    }

    public HashMap<String, ArrayList<String>> validateImportForm(HttpServletRequest request) {
        Validator v = new Validator(request);
        HashMap errors = v.validate();
        return errors;
    }
}

