/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.web.table.scheduledjobs;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.akaza.openclinica.control.AbstractTableFactory;
import org.akaza.openclinica.control.DefaultActionsEditor;
import org.akaza.openclinica.dao.ScheduledJobSort;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.web.table.scheduledjobs.ScheduledJobTableFactory;
import org.akaza.openclinica.web.table.sdv.SDVUtil;
import org.jmesa.facade.TableFacade;
import org.jmesa.limit.Limit;
import org.jmesa.limit.Sort;
import org.jmesa.limit.SortSet;
import org.jmesa.view.View;
import org.jmesa.view.component.Row;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.component.HtmlTable;

public class ScheduledJobTableFactory
extends AbstractTableFactory {
    protected String getTableName() {
        return "scheduledJobs";
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new ScheduledJobView(this, this.getLocale()));
    }

    protected void configureColumns(TableFacade tableFacade, Locale locale) {
        tableFacade.setColumnProperties(new String[]{"datasetId", "fireTime", "exportFileName", "jobStatus", "action"});
        Row row = tableFacade.getTable().getRow();
        String[] allTitles = new String[]{"DataSet Name", "Fire Time", "Export File", "Job Status", "Actions"};
        SDVUtil sdvUtil = new SDVUtil();
        sdvUtil.setTitles(allTitles, (HtmlTable)tableFacade.getTable());
        sdvUtil.setHtmlCellEditors(tableFacade, new String[]{"action"}, false);
        this.configureColumn(row.getColumn("action"), "Actions", (CellEditor)sdvUtil.getCellEditorNoEscapes(), (FilterEditor)new DefaultActionsEditor(locale), true, false);
    }

    public TableFacade createTable(HttpServletRequest request, HttpServletResponse response) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        TableFacade tableFacade = this.getTableFacadeImpl(request, response);
        tableFacade.setStateAttr("restore");
        int maxJobs = (Integer)request.getAttribute("totalJobs");
        tableFacade.setTotalRows(maxJobs);
        List jobs = (List)request.getAttribute("jobs");
        tableFacade.setItems((Collection)jobs);
        this.configureTableFacade(response, tableFacade);
        if (!tableFacade.getLimit().isExported()) {
            this.configureColumns(tableFacade, this.locale);
            tableFacade.setMaxRowsIncrements(this.getMaxRowIncrements());
            this.configureTableFacadePostColumnConfiguration(tableFacade);
            this.configureTableFacadeCustomView(tableFacade);
            this.configureUnexportedTable(tableFacade, this.locale);
        } else {
            this.configureExportColumns(tableFacade, this.locale);
        }
        return tableFacade;
    }

    protected ScheduledJobSort getScheduledJobSort(Limit limit) {
        ScheduledJobSort scheduledJobSort = new ScheduledJobSort();
        SortSet sortSet = limit.getSortSet();
        Collection sorts = sortSet.getSorts();
        for (Sort sort : sorts) {
            String property = sort.getProperty();
            String order = sort.getOrder().toParam();
            scheduledJobSort.addSort(property, order);
        }
        return scheduledJobSort;
    }

    public void setDataAndLimitVariables(TableFacade tableFacade) {
    }
}

