/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.akaza.openclinica.control.DefaultToolbar;
import org.akaza.openclinica.control.DefaultView;
import org.akaza.openclinica.control.OCTableFacadeImpl;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.jmesa.facade.TableFacade;
import org.jmesa.facade.TableFacadeImpl;
import org.jmesa.limit.ExportType;
import org.jmesa.limit.Limit;
import org.jmesa.limit.LimitImpl;
import org.jmesa.limit.RowSelect;
import org.jmesa.limit.RowSelectImpl;
import org.jmesa.view.View;
import org.jmesa.view.component.Column;
import org.jmesa.view.editor.CellEditor;
import org.jmesa.view.editor.FilterEditor;
import org.jmesa.view.html.component.HtmlColumn;
import org.jmesa.view.html.component.HtmlTable;
import org.jmesa.view.html.toolbar.Toolbar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableFactory {
    protected Locale locale;
    protected HttpSession session;
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    protected abstract String getTableName();

    protected String getCaptionName() {
        return "";
    }

    protected abstract void configureColumns(TableFacade var1, Locale var2);

    protected void configureExportColumns(TableFacade tableFacade, Locale locale) {
        this.configureColumns(tableFacade, locale);
    }

    public TableFacade getTableFacadeImpl(HttpServletRequest request, HttpServletResponse response) {
        return new TableFacadeImpl(this.getTableName(), request);
    }

    public abstract void setDataAndLimitVariables(TableFacade var1);

    public TableFacade createTable(HttpServletRequest request, HttpServletResponse response) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        this.session = request.getSession();
        TableFacade tableFacade = this.getTableFacadeImpl(request, response);
        this.setStateAttr(tableFacade);
        this.setDataAndLimitVariables(tableFacade);
        this.configureTableFacade(response, tableFacade);
        if (!tableFacade.getLimit().isExported()) {
            this.configureColumns(tableFacade, this.locale);
            tableFacade.setMaxRowsIncrements(this.getMaxRowIncrements());
            this.configureTableFacadePostColumnConfiguration(tableFacade);
            this.configureTableFacadeCustomView(tableFacade);
            this.configureUnexportedTable(tableFacade, this.locale);
        } else {
            this.configureExportColumns(tableFacade, this.locale);
        }
        return tableFacade;
    }

    public void exportCSVTable(HttpServletRequest request, HttpServletResponse response, String path) {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)request);
        String DATE_FORMAT = "yyyyMMddHHmmss";
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String fileName = this.getTableName() + "_" + sdf.format(new Date());
        for (Limit limit : this.createLimits()) {
            OCTableFacadeImpl tableFacade = new OCTableFacadeImpl(this.getTableName(), request, response, path + File.separator + fileName);
            tableFacade.setStateAttr("restore");
            tableFacade.setLimit(limit);
            tableFacade.autoFilterAndSort(false);
            this.setDataAndLimitVariables((TableFacade)tableFacade);
            this.configureTableFacade(response, (TableFacade)tableFacade);
            this.configureExportColumns((TableFacade)tableFacade, this.locale);
            tableFacade.render();
        }
    }

    private ArrayList<Limit> createLimits() {
        LimitImpl limit = new LimitImpl(this.getTableName());
        ArrayList<Limit> limits = new ArrayList<Limit>();
        int size = this.getSize((Limit)limit);
        for (RowSelect rowSelect : this.getRowSelects(size)) {
            LimitImpl theLimit = new LimitImpl(this.getTableName());
            theLimit.setRowSelect(rowSelect);
            theLimit.setExportType(ExportType.CSV);
            limits.add((Limit)theLimit);
        }
        return limits;
    }

    private ArrayList<RowSelect> getRowSelects(int size) {
        RowSelectImpl rowSelect;
        ArrayList<RowSelect> rowSelects = new ArrayList<RowSelect>();
        int i = 0;
        for (i = 0; i < size / 50; ++i) {
            rowSelect = new RowSelectImpl(i + 1, 50, size);
            rowSelects.add((RowSelect)rowSelect);
        }
        if (size % 50 > 0) {
            rowSelect = new RowSelectImpl(i + 1, size % 50, size);
            rowSelects.add((RowSelect)rowSelect);
        }
        return rowSelects;
    }

    public int getSize(Limit limit) {
        return 0;
    }

    public void configureTableFacade(HttpServletResponse response, TableFacade tableFacade) {
        tableFacade.setExportTypes(response, this.getExportTypes());
    }

    public int[] getMaxRowIncrements() {
        return new int[]{15, 25, 50};
    }

    public void configureTableFacadePostColumnConfiguration(TableFacade tableFacade) {
        tableFacade.setToolbar((Toolbar)new DefaultToolbar());
    }

    public void configureTableFacadeCustomView(TableFacade tableFacade) {
        tableFacade.setView((View)new DefaultView(this.locale));
    }

    protected void configureUnexportedTable(TableFacade tableFacade, Locale locale) {
        HtmlTable table = (HtmlTable)tableFacade.getTable();
        table.setCaption(this.getCaptionName());
    }

    protected ExportType[] getExportTypes() {
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void configureColumn(Column column, String title, CellEditor editor, FilterEditor filterEditor) {
        this.configureColumn(column, title, editor, filterEditor, true, true);
    }

    protected void configureColumn(Column column, String title, CellEditor editor, FilterEditor filterEditor, boolean filterable, boolean sortable) {
        column.setTitle(title);
        if (editor != null) {
            column.getCellRenderer().setCellEditor(editor);
        }
        if (column instanceof HtmlColumn) {
            HtmlColumn htmlColumn = (HtmlColumn)column;
            htmlColumn.setFilterable(Boolean.valueOf(filterable));
            htmlColumn.setSortable(Boolean.valueOf(sortable));
            if (filterEditor != null) {
                htmlColumn.getFilterRenderer().setFilterEditor(filterEditor);
            }
        }
    }

    public static String getDNFlagIconName(int dnResolutionStatusId) {
        String name = "";
        switch (dnResolutionStatusId) {
            case 0: {
                name = "icon_noNote";
                break;
            }
            case 1: {
                name = "icon_Note";
                break;
            }
            case 2: {
                name = "icon_flagYellow";
                break;
            }
            case 3: {
                name = "icon_flagGreen";
                break;
            }
            case 4: {
                name = "icon_flagBlack";
                break;
            }
            case 5: {
                name = "icon_flagWhite";
                break;
            }
            default: {
                name = "icon_noNote";
            }
        }
        return name;
    }

    public List paginateData(List list, int rowStart, int rowEnd) {
        ArrayList mainList = new ArrayList();
        if (rowStart > 0) {
            ++rowStart;
        }
        for (int i = rowStart; i <= rowEnd && i < list.size(); ++i) {
            mainList.add(list.get(i));
        }
        return mainList;
    }

    public void setStateAttr(TableFacade tableFacade) {
        if (this.getTableName() != null) {
            tableFacade.setStateAttr(this.getTableName() + "_restore");
        } else {
            tableFacade.setStateAttr("restore");
            this.logger.debug("getTableName() returned null, so tableFacade.setStateAttr = restore");
        }
    }
}

