/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.admin.EventStatusStatisticsTableFactory;
import org.akaza.openclinica.control.admin.SiteStatisticsTableFactory;
import org.akaza.openclinica.control.admin.StudyStatisticsTableFactory;
import org.akaza.openclinica.control.admin.StudySubjectStatusStatisticsTableFactory;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.submit.ListStudySubjectTableFactory;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.SQLInitServlet;
import org.akaza.openclinica.web.table.sdv.SDVUtil;

public class MainMenuServlet
extends SecureController {
    private static final long serialVersionUID = -7373300139315967558L;
    Locale locale;
    private StudyEventDefinitionDAO studyEventDefinitionDAO;
    private SubjectDAO subjectDAO;
    private StudySubjectDAO studySubjectDAO;
    private StudyEventDAO studyEventDAO;
    private StudyGroupClassDAO studyGroupClassDAO;
    private SubjectGroupMapDAO subjectGroupMapDAO;
    private StudyDAO studyDAO;
    private EventCRFDAO eventCRFDAO;
    private EventDefinitionCRFDAO eventDefintionCRFDAO;
    private StudyGroupDAO studyGroupDAO;
    private DiscrepancyNoteDAO discrepancyNoteDAO;
    private StudyParameterValueDAO studyParameterValueDAO;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        this.ub.incNumVisitsToMainMenu();
        this.session.setAttribute("userBean", (Object)this.ub);
        this.request.setAttribute("iconInfoShown", (Object)true);
        this.request.setAttribute("closeInfoShowIcons", (Object)false);
        if (this.ub == null || this.ub.getId() == 0) {
            this.forwardPage(Page.MENU, false);
            return;
        }
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList studies = null;
        long pwdExpireDay = new Long(SQLInitServlet.getField((String)"passwd_expiration_time"));
        Date lastPwdChangeDate = this.ub.getPasswdTimestamp();
        int pwdChangeRequired = new Integer(SQLInitServlet.getField((String)"change_passwd_required"));
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean ub1 = udao.findByPK(this.ub.getId());
        ub1.setLastVisitDate(new Date(System.currentTimeMillis()));
        ub1.setOwner(ub1);
        ub1.setUpdater(ub1);
        udao.update(ub1);
        this.request.setAttribute("studyId", (Object)this.currentStudy.getId());
        this.request.setAttribute("allDefsArray", (Object)super.getEventDefinitionsByCurrentStudy());
        this.request.setAttribute("studyGroupClasses", (Object)super.getStudyGroupClassesByCurrentStudy());
        if (this.ub.isLdapUser()) {
            lastPwdChangeDate = new Date();
        }
        logger.debug("is ub a ldapuser??" + this.ub.isLdapUser());
        if (lastPwdChangeDate != null || lastPwdChangeDate == null && pwdChangeRequired == 0) {
            Integer assignedDiscrepancies;
            if (lastPwdChangeDate != null) {
                Calendar cal = Calendar.getInstance();
                long difference = Math.abs(cal.getTime().getTime() - lastPwdChangeDate.getTime());
                long days = difference / 86400000L;
                this.session.setAttribute("passwordExpired", (Object)"no");
                if (!this.ub.isLdapUser() && pwdExpireDay > 0L && days >= pwdExpireDay) {
                    System.out.println("here");
                    studies = sdao.findAllByUser(this.ub.getName());
                    this.request.setAttribute("studies", (Object)studies);
                    this.session.setAttribute("userBean1", (Object)this.ub);
                    this.addPageMessage(respage.getString("password_expired"));
                    this.session.setAttribute("passwordExpired", (Object)"yes");
                    if (pwdChangeRequired == 1) {
                        this.request.setAttribute("mustChangePass", (Object)"yes");
                        this.addPageMessage(respage.getString("your_password_has_expired_must_change"));
                    } else {
                        this.request.setAttribute("mustChangePass", (Object)"no");
                        this.addPageMessage(respage.getString("password_expired") + " " + respage.getString("if_you_do_not_want_change_leave_blank"));
                    }
                    this.forwardPage(Page.RESET_PASSWORD);
                }
            }
            if (this.ub.getNumVisitsToMainMenu() <= 1) {
                if (this.ub.getLastVisitDate() != null) {
                    this.addPageMessage(respage.getString("welcome") + " " + this.ub.getFirstName() + " " + this.ub.getLastName() + ". " + respage.getString("last_logged") + " " + this.local_df.format(this.ub.getLastVisitDate()) + ". ");
                } else {
                    this.addPageMessage(respage.getString("welcome") + " " + this.ub.getFirstName() + " " + this.ub.getLastName() + ". ");
                }
                if (this.currentStudy.getStatus().isLocked()) {
                    this.addPageMessage(respage.getString("current_study_locked"));
                } else if (this.currentStudy.getStatus().isFrozen()) {
                    this.addPageMessage(respage.getString("current_study_frozen"));
                }
            }
            this.request.setAttribute("assignedDiscrepancies", (Object)((assignedDiscrepancies = this.getDiscrepancyNoteDAO().getViewNotesCountWithFilter(" AND dn.assigned_user_id =" + this.ub.getId() + " AND (dn.resolution_status_id=1 OR dn.resolution_status_id=2 OR dn.resolution_status_id=3)", this.currentStudy)) == null ? 0 : assignedDiscrepancies));
            int parentStudyId = this.currentStudy.getParentStudyId() > 0 ? this.currentStudy.getParentStudyId() : this.currentStudy.getId();
            StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
            StudyParameterValueBean parentSPV = spvdao.findByHandleAndStudy(parentStudyId, "subjectIdGeneration");
            this.currentStudy.getStudyParameterConfig().setSubjectIdGeneration(parentSPV.getValue());
            String idSetting = parentSPV.getValue();
            if (idSetting.equals("auto editable") || idSetting.equals("auto non-editable")) {
                this.request.setAttribute("label", (Object)resword.getString("id_generated_Save_Add"));
                fp.addPresetValue("label", resword.getString("id_generated_Save_Add"));
            }
            this.setPresetValues(fp.getPresetValues());
            if (this.currentRole.isInvestigator() || this.currentRole.isResearchAssistant() || this.currentRole.isResearchAssistant2()) {
                this.setupListStudySubjectTable();
            }
            if (this.currentRole.isMonitor()) {
                this.setupSubjectSDVTable();
            } else if (this.currentRole.isCoordinator() || this.currentRole.isDirector()) {
                if (this.currentStudy.getStatus().isPending()) {
                    this.response.sendRedirect(this.request.getContextPath() + Page.MANAGE_STUDY_MODULE.getFileName());
                    return;
                }
                this.setupStudySiteStatisticsTable();
                this.setupSubjectEventStatusStatisticsTable();
                this.setupStudySubjectStatusStatisticsTable();
                if (this.currentStudy.getParentStudyId() == 0) {
                    this.setupStudyStatisticsTable();
                }
            }
            this.forwardPage(Page.MENU);
        } else {
            studies = sdao.findAllByUser(this.ub.getName());
            this.request.setAttribute("studies", (Object)studies);
            this.session.setAttribute("userBean1", (Object)this.ub);
            if (pwdChangeRequired != 1) {
                this.forwardPage(Page.MENU);
            }
        }
    }

    private void setupSubjectSDVTable() {
        this.request.setAttribute("studyId", (Object)this.currentStudy.getId());
        this.request.setAttribute("showMoreLink", (Object)"true");
        String sdvMatrix = this.getSDVUtil().renderEventCRFTableWithLimit(this.request, this.currentStudy.getId(), "");
        this.request.setAttribute("sdvMatrix", (Object)sdvMatrix);
    }

    private void setupStudySubjectStatusStatisticsTable() {
        StudySubjectStatusStatisticsTableFactory factory = new StudySubjectStatusStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studySubjectStatusStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studySubjectStatusStatistics", (Object)studySubjectStatusStatistics);
    }

    private void setupSubjectEventStatusStatisticsTable() {
        EventStatusStatisticsTableFactory factory = new EventStatusStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyEventDao(this.getStudyEventDAO());
        factory.setStudyDao(this.getStudyDAO());
        String subjectEventStatusStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("subjectEventStatusStatistics", (Object)subjectEventStatusStatistics);
    }

    private void setupStudySiteStatisticsTable() {
        SiteStatisticsTableFactory factory = new SiteStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studySiteStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studySiteStatistics", (Object)studySiteStatistics);
    }

    private void setupStudyStatisticsTable() {
        StudyStatisticsTableFactory factory = new StudyStatisticsTableFactory();
        factory.setStudySubjectDao(this.getStudySubjectDAO());
        factory.setCurrentStudy(this.currentStudy);
        factory.setStudyDao(this.getStudyDAO());
        String studyStatistics = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("studyStatistics", (Object)studyStatistics);
    }

    private void setupListStudySubjectTable() {
        ListStudySubjectTableFactory factory = new ListStudySubjectTableFactory(true);
        factory.setStudyEventDefinitionDao(this.getStudyEventDefinitionDao());
        factory.setSubjectDAO(this.getSubjectDAO());
        factory.setStudySubjectDAO(this.getStudySubjectDAO());
        factory.setStudyEventDAO(this.getStudyEventDAO());
        factory.setStudyBean(this.currentStudy);
        factory.setStudyGroupClassDAO(this.getStudyGroupClassDAO());
        factory.setSubjectGroupMapDAO(this.getSubjectGroupMapDAO());
        factory.setStudyDAO(this.getStudyDAO());
        factory.setCurrentRole(this.currentRole);
        factory.setCurrentUser(this.ub);
        factory.setEventCRFDAO(this.getEventCRFDAO());
        factory.setEventDefintionCRFDAO(this.getEventDefinitionCRFDAO());
        factory.setStudyGroupDAO(this.getStudyGroupDAO());
        factory.setStudyParameterValueDAO(this.getStudyParameterValueDAO());
        String findSubjectsHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("findSubjectsHtml", (Object)findSubjectsHtml);
    }

    public StudyParameterValueDAO getStudyParameterValueDAO() {
        this.studyParameterValueDAO = this.studyParameterValueDAO == null ? new StudyParameterValueDAO(this.sm.getDataSource()) : this.studyParameterValueDAO;
        return this.studyParameterValueDAO;
    }

    public void setStudyParameterValueDAO(StudyParameterValueDAO studyParameterValueDAO) {
        this.studyParameterValueDAO = studyParameterValueDAO;
    }

    public StudyEventDefinitionDAO getStudyEventDefinitionDao() {
        this.studyEventDefinitionDAO = this.studyEventDefinitionDAO == null ? new StudyEventDefinitionDAO(this.sm.getDataSource()) : this.studyEventDefinitionDAO;
        return this.studyEventDefinitionDAO;
    }

    public SubjectDAO getSubjectDAO() {
        this.subjectDAO = this.subjectDAO == null ? new SubjectDAO(this.sm.getDataSource()) : this.subjectDAO;
        return this.subjectDAO;
    }

    public StudySubjectDAO getStudySubjectDAO() {
        this.studySubjectDAO = this.studySubjectDAO == null ? new StudySubjectDAO(this.sm.getDataSource()) : this.studySubjectDAO;
        return this.studySubjectDAO;
    }

    public StudyGroupClassDAO getStudyGroupClassDAO() {
        this.studyGroupClassDAO = this.studyGroupClassDAO == null ? new StudyGroupClassDAO(this.sm.getDataSource()) : this.studyGroupClassDAO;
        return this.studyGroupClassDAO;
    }

    public SubjectGroupMapDAO getSubjectGroupMapDAO() {
        this.subjectGroupMapDAO = this.subjectGroupMapDAO == null ? new SubjectGroupMapDAO(this.sm.getDataSource()) : this.subjectGroupMapDAO;
        return this.subjectGroupMapDAO;
    }

    public StudyEventDAO getStudyEventDAO() {
        this.studyEventDAO = this.studyEventDAO == null ? new StudyEventDAO(this.sm.getDataSource()) : this.studyEventDAO;
        return this.studyEventDAO;
    }

    public StudyDAO getStudyDAO() {
        this.studyDAO = this.studyDAO == null ? new StudyDAO(this.sm.getDataSource()) : this.studyDAO;
        return this.studyDAO;
    }

    public EventCRFDAO getEventCRFDAO() {
        this.eventCRFDAO = this.eventCRFDAO == null ? new EventCRFDAO(this.sm.getDataSource()) : this.eventCRFDAO;
        return this.eventCRFDAO;
    }

    public EventDefinitionCRFDAO getEventDefinitionCRFDAO() {
        this.eventDefintionCRFDAO = this.eventDefintionCRFDAO == null ? new EventDefinitionCRFDAO(this.sm.getDataSource()) : this.eventDefintionCRFDAO;
        return this.eventDefintionCRFDAO;
    }

    public StudyGroupDAO getStudyGroupDAO() {
        this.studyGroupDAO = this.studyGroupDAO == null ? new StudyGroupDAO(this.sm.getDataSource()) : this.studyGroupDAO;
        return this.studyGroupDAO;
    }

    public DiscrepancyNoteDAO getDiscrepancyNoteDAO() {
        this.discrepancyNoteDAO = this.discrepancyNoteDAO == null ? new DiscrepancyNoteDAO(this.sm.getDataSource()) : this.discrepancyNoteDAO;
        return this.discrepancyNoteDAO;
    }

    public SDVUtil getSDVUtil() {
        return (SDVUtil)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("sdvUtil");
    }
}

