/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.rule.FileUploadHelper;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.core.CoreResources;
import org.akaza.openclinica.dao.hibernate.CrfDao;
import org.akaza.openclinica.dao.hibernate.CrfVersionDao;
import org.akaza.openclinica.domain.datamap.CrfBean;
import org.akaza.openclinica.domain.datamap.CrfVersion;
import org.akaza.openclinica.domain.xform.XformContainer;
import org.akaza.openclinica.domain.xform.XformGroup;
import org.akaza.openclinica.domain.xform.XformItem;
import org.akaza.openclinica.domain.xform.XformParser;
import org.akaza.openclinica.domain.xform.dto.Html;
import org.akaza.openclinica.exception.OpenClinicaSystemException;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.crfdata.XformMetaDataService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CreateXformCRFVersionServlet
extends SecureController {
    private static final long serialVersionUID = -6179543727912996619L;
    Locale locale;
    FileUploadHelper uploadHelper = new FileUploadHelper();

    protected void processRequest() throws Exception {
        BindingResult errors;
        CRFVersionBean version;
        String submittedCrfVersionName;
        String submittedCrfName;
        List items;
        CrfVersionDao crfVersionDao;
        CrfDao crfDao;
        block5: {
            crfDao = (CrfDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("crfDao");
            crfVersionDao = (CrfVersionDao)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("crfVersionDao");
            Locale locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
            ResourceBundleProvider.updateLocale((Locale)locale);
            resword = ResourceBundleProvider.getWordsBundle((Locale)locale);
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            items = upload.parseRequest(this.request);
            submittedCrfName = this.retrieveFormFieldValue(items, "crfName");
            submittedCrfVersionName = this.retrieveFormFieldValue(items, "versionName");
            String submittedCrfVersionDescription = this.retrieveFormFieldValue(items, "versionDescription");
            String submittedRevisionNotes = this.retrieveFormFieldValue(items, "revisionNotes");
            String submittedXformText = this.retrieveFormFieldValue(items, "xformText");
            version = (CRFVersionBean)this.session.getAttribute("version");
            logger.debug("Found original CRF ID for new CRF Version:" + version.getCrfId());
            DataBinder dataBinder = new DataBinder((Object)new CrfVersion());
            errors = dataBinder.getBindingResult();
            this.validateFormFields((Errors)errors, version, submittedCrfName, submittedCrfVersionName, submittedCrfVersionDescription, submittedRevisionNotes, submittedXformText);
            if (!errors.hasErrors()) {
                XformParser parser = (XformParser)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("xformParser");
                XformContainer container = this.parseInstance(submittedXformText);
                Html html = parser.unMarshall(submittedXformText);
                XformMetaDataService xformService = (XformMetaDataService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("xformMetaDataService");
                try {
                    xformService.createCRFMetaData(version, container, this.currentStudy, this.ub, html, submittedCrfName, submittedCrfVersionName, submittedCrfVersionDescription, submittedRevisionNotes, submittedXformText, items, (Errors)errors);
                }
                catch (RuntimeException e) {
                    logger.error("Error encountered while saving CRF: " + e.getMessage());
                    logger.error(ExceptionUtils.getStackTrace((Throwable)e));
                    if (errors.hasErrors()) break block5;
                    throw e;
                }
            }
        }
        if (errors.hasErrors()) {
            this.request.setAttribute("errorList", (Object)errors.getAllErrors());
            logger.debug("Found at least one error.  CRF data not saved.");
        } else {
            logger.debug("Didn't find any errors.  CRF data saved.");
            CrfBean crf = submittedCrfName == null || submittedCrfName.equals("") ? crfDao.findByCrfId(Integer.valueOf(version.getCrfId())) : crfDao.findByName(submittedCrfName);
            CrfVersion newVersion = crfVersionDao.findByNameCrfId(submittedCrfVersionName, Integer.valueOf(crf.getCrfId()));
            this.saveAttachedMedia(items, crf, newVersion);
        }
        this.forwardPage(Page.CREATE_XFORM_CRF_VERSION_SERVLET);
    }

    private void validateFormFields(Errors errors, CRFVersionBean version, String submittedCrfName, String submittedCrfVersionName, String submittedCrfVersionDescription, String submittedRevisionNotes, String submittedXformText) {
        if (version.getCrfId() == 0 && (submittedCrfName == null || submittedCrfName.equals(""))) {
            DataBinder crfDataBinder = new DataBinder((Object)new CrfBean());
            BindingResult crfErrors = crfDataBinder.getBindingResult();
            crfErrors.rejectValue("name", "crf_val_crf_name_blank", resword.getString("CRF_name"));
            errors.addAllErrors((Errors)crfErrors);
        }
        DataBinder crfVersionDataBinder = new DataBinder((Object)new CrfVersion());
        BindingResult crfVersionErrors = crfVersionDataBinder.getBindingResult();
        if (submittedCrfVersionName == null || submittedCrfVersionName.equals("")) {
            crfVersionErrors.rejectValue("name", "crf_ver_val_name_blank", resword.getString("version_name"));
        }
        if (submittedCrfVersionDescription == null || submittedCrfVersionDescription.equals("")) {
            crfVersionErrors.rejectValue("description", "crf_ver_val_desc_blank", resword.getString("crf_version_description"));
        }
        if (submittedRevisionNotes == null || submittedRevisionNotes.equals("")) {
            crfVersionErrors.rejectValue("revisionNotes", "crf_ver_val_rev_notes_blank", resword.getString("revision_notes"));
        }
        if (submittedXformText == null || submittedXformText.equals("")) {
            crfVersionErrors.rejectValue("xform", "crf_ver_val_xform_blank", resword.getString("xform"));
        }
        errors.addAllErrors((Errors)crfVersionErrors);
    }

    private XformContainer parseInstance(String xform) throws Exception {
        Document doc = null;
        try {
            int i;
            ByteArrayInputStream stream = new ByteArrayInputStream(xform.getBytes(StandardCharsets.UTF_8));
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            NodeList instances = doc.getElementsByTagName("instance");
            Node instance = null;
            ArrayList<XformGroup> groups = new ArrayList<XformGroup>();
            for (int i2 = 0; i2 < instances.getLength(); ++i2) {
                Element curInstance = (Element)instances.item(i2);
                if (!(curInstance instanceof Element)) continue;
                instance = curInstance;
                break;
            }
            Node form = null;
            for (i = 0; i < instance.getChildNodes().getLength(); ++i) {
                Node curNode = instance.getChildNodes().item(i);
                if (!(curNode instanceof Element)) continue;
                form = (Element)curNode;
                break;
            }
            for (i = 0; i < form.getChildNodes().getLength(); ++i) {
                if (!(form.getChildNodes().item(i) instanceof Element) || !((Element)form.getChildNodes().item(i)).hasChildNodes() || ((Element)form.getChildNodes().item(i)).getTagName().equals("meta")) continue;
                Element group = (Element)form.getChildNodes().item(i);
                XformGroup newGroup = new XformGroup();
                newGroup.setGroupName(group.getTagName());
                newGroup.setGroupPath("/" + form.getTagName() + "/" + group.getTagName());
                groups.add(newGroup);
                for (int j = 0; j < group.getChildNodes().getLength(); ++j) {
                    if (!(group.getChildNodes().item(j) instanceof Element)) continue;
                    Element item = (Element)group.getChildNodes().item(j);
                    XformItem newItem = new XformItem();
                    newItem.setItemPath("/" + form.getTagName() + "/" + group.getTagName() + "/" + item.getTagName());
                    newItem.setItemName(item.getTagName());
                    newGroup.getItems().add(newItem);
                }
            }
            XformContainer container = new XformContainer();
            container.setGroups(groups);
            container.setInstanceName(form.getTagName());
            return container;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw new Exception(e);
        }
    }

    private String retrieveFormFieldValue(List<FileItem> items, String fieldName) throws Exception {
        for (FileItem item : items) {
            if (!fieldName.equals(item.getFieldName())) continue;
            return item.getString("UTF-8");
        }
        logger.warn("Form field '" + fieldName + "' missing from xform submission.");
        return "";
    }

    private void saveAttachedMedia(List<FileItem> items, CrfBean crf, CrfVersion version) {
        boolean hasFiles = false;
        for (FileItem item : items) {
            if (item.isFormField() || item.getName() == null || item.getName().isEmpty()) continue;
            hasFiles = true;
        }
        if (hasFiles) {
            String dir = Utils.getCrfMediaFilePath((CrfBean)crf, (CrfVersion)version);
            if (!new File(dir).exists()) {
                new File(dir).mkdirs();
                logger.debug("Made the directory " + dir);
            }
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                String fileName = item.getName();
                int startIndex = fileName.lastIndexOf(92);
                if (startIndex != -1) {
                    fileName = fileName.substring(startIndex + 1, fileName.length());
                }
                File uploadedFile = new File(dir + File.separator + fileName);
                try {
                    item.write(uploadedFile);
                }
                catch (Exception e) {
                    throw new OpenClinicaSystemException(e.getMessage());
                }
            }
        }
    }

    protected void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        String xformEnabled = CoreResources.getField((String)"xform.enabled");
        if (xformEnabled == null || !xformEnabled.equals("true")) {
            this.addPageMessage(respage.getString("may_not_create_xforms"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_create_xforms"), "1");
        }
        if (this.ub.isSysAdmin()) {
            return;
        }
        Role r = this.currentRole.getRole();
        if (r.equals((Term)Role.STUDYDIRECTOR) || r.equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }
}

