/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.TermType;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class EditStudyUserRoleServlet
extends SecureController {
    private static final long serialVersionUID = 2676005249787903342L;
    public static final String INPUT_ROLE = "role";
    public static final String PATH = "EditStudyUserRole";
    public static final String ARG_STUDY_ID = "studyId";
    public static final String ARG_USER_NAME = "userName";

    public static String getLink(StudyUserRoleBean s, UserAccountBean user) {
        int studyId = s.getStudyId();
        return "EditStudyUserRole?studyId=" + studyId + "&" + ARG_USER_NAME + "=" + user.getName();
    }

    protected void mayProceed() throws InsufficientPermissionException {
        if (!this.ub.isSysAdmin()) {
            this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
            throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("you_may_not_perform_administrative_functions"), "1");
        }
    }

    protected void processRequest() throws Exception {
        UserAccountDAO udao = new UserAccountDAO(this.sm.getDataSource());
        FormProcessor fp = new FormProcessor(this.request);
        int studyId = fp.getInt(ARG_STUDY_ID);
        String uName = fp.getString(ARG_USER_NAME);
        StudyUserRoleBean studyUserRole = udao.findRoleByUserNameAndStudyId(uName, studyId);
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        StudyBean sb = sdao.findByPK(studyUserRole.getStudyId());
        if (sb != null) {
            studyUserRole.setStudyName(sb.getName());
        }
        if (!studyUserRole.isActive()) {
            String message = respage.getString("the_user_has_no_role_in_study");
            this.addPageMessage(message);
            this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
        } else {
            LinkedHashMap<Integer, String> roleMap = new LinkedHashMap<Integer, String>();
            ResourceBundle resterm = ResourceBundleProvider.getTermsBundle();
            StudyBean study = sdao.findByPK(studyUserRole.getStudyId());
            if (study.getParentStudyId() == 0) {
                for (Role role : this.getRoles()) {
                    switch (role.getId()) {
                        case 2: {
                            roleMap.put(role.getId(), resterm.getString("Study_Coordinator").trim());
                            break;
                        }
                        case 3: {
                            roleMap.put(role.getId(), resterm.getString("Study_Director").trim());
                            break;
                        }
                        case 4: {
                            roleMap.put(role.getId(), resterm.getString("Investigator").trim());
                            break;
                        }
                        case 5: {
                            roleMap.put(role.getId(), resterm.getString("Data_Entry_Person").trim());
                            break;
                        }
                        case 6: {
                            roleMap.put(role.getId(), resterm.getString("Monitor").trim());
                            break;
                        }
                    }
                }
            } else {
                for (Role role : this.getRoles()) {
                    switch (role.getId()) {
                        case 4: {
                            roleMap.put(role.getId(), resterm.getString("site_investigator").trim());
                            break;
                        }
                        case 5: {
                            roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person").trim());
                            break;
                        }
                        case 6: {
                            roleMap.put(role.getId(), resterm.getString("site_monitor").trim());
                            break;
                        }
                        case 7: {
                            roleMap.put(role.getId(), resterm.getString("site_Data_Entry_Person2").trim());
                            break;
                        }
                    }
                }
            }
            if (study.getParentStudyId() > 0) {
                roleMap.remove(Role.COORDINATOR.getId());
                roleMap.remove(Role.STUDYDIRECTOR.getId());
            }
            if (!fp.isSubmitted()) {
                this.request.setAttribute(ARG_USER_NAME, (Object)uName);
                this.request.setAttribute("studyUserRole", (Object)studyUserRole);
                this.request.setAttribute("roles", roleMap);
                this.request.setAttribute("chosenRoleId", (Object)new Integer(studyUserRole.getRole().getId()));
                this.forwardPage(Page.EDIT_STUDY_USER_ROLE);
            } else {
                Validator v = new Validator(this.request);
                v.addValidation(INPUT_ROLE, 17, TermType.ROLE);
                HashMap errors = v.validate();
                if (errors.isEmpty()) {
                    int roleId = fp.getInt(INPUT_ROLE);
                    Role r = Role.get((int)roleId);
                    studyUserRole.setRoleName(r.getName());
                    studyUserRole.setUpdater(this.ub);
                    udao.updateStudyUserRole(studyUserRole, uName);
                    String message = respage.getString("the_user_in_study_has_been_updated");
                    this.addPageMessage(message);
                    this.forwardPage(Page.LIST_USER_ACCOUNTS_SERVLET);
                } else {
                    String message = respage.getString("the_role_choosen_was_invalid_choose_another");
                    this.addPageMessage(message);
                    this.request.setAttribute(ARG_USER_NAME, (Object)uName);
                    this.request.setAttribute("studyUserRole", (Object)studyUserRole);
                    this.request.setAttribute("chosenRoleId", (Object)new Integer(fp.getInt(INPUT_ROLE)));
                    this.request.setAttribute("roles", roleMap);
                    this.forwardPage(Page.EDIT_STUDY_USER_ROLE);
                }
            }
        }
    }

    private ArrayList<Role> getRoles() {
        ArrayList roles = Role.toArrayList();
        roles.remove(Role.ADMIN);
        return roles;
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

