/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.OutputStream;
import java.util.Optional;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.dao.login.UserAccountDAO;
import org.akaza.openclinica.service.otp.CertificateBean;
import org.akaza.openclinica.service.otp.TwoFactorService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class PrintoutCertificateServlet
extends SecureController {
    public void processRequest() throws Exception {
        Optional<String> optUserId = Optional.ofNullable(this.request.getParameter("userId"));
        this.response.setHeader("Content-Disposition", "attachment; filename=\"certificate.pdf\"");
        this.response.addHeader("Content-Type", "application/pdf");
        this.response.setContentType("application/octet-stream");
        UserAccountDAO dao = new UserAccountDAO(this.sm.getDataSource());
        UserAccountBean user = dao.getUserById(Integer.valueOf(optUserId.get()));
        CertificateBean bean = new CertificateBean();
        bean.setUsername(user.getLastName().concat(", ").concat(user.getFirstName()));
        bean.setSecret(user.getAuthsecret());
        bean.setEmail(user.getEmail());
        bean.setLogin(user.getName());
        TwoFactorService factorService = (TwoFactorService)this.getBean(TwoFactorService.class);
        factorService.printoutCertificate(bean, (OutputStream)this.response.getOutputStream());
    }

    public void mayProceed() throws InsufficientPermissionException {
        if (this.ub.isSysAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.LIST_USER_ACCOUNTS_SERVLET, resexception.getString("not_admin"), "1");
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

