/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.core.ApplicationConstants;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Utils;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.control.admin.SpreadSheetItemUtil;
import org.akaza.openclinica.core.util.CrfTemplateColumnNameEnum;
import org.akaza.openclinica.core.util.ItemGroupCrvVersionUtil;
import org.akaza.openclinica.dao.submit.ItemDAO;

/*
 * Exception performing whole class analysis ignored.
 */
public class SpreadSheetItemUtil {
    private String itemName;
    private String descriptionLabel;
    private String leftItemText;
    private String sectionLabel;
    private String groupLabel;
    private String parentItem;
    private int responseTypeId;
    private String[] responseOptions;
    private String defaultValue;
    private String dataType;

    private String cleanProperty(String property) {
        if (property == null) {
            property = "";
        }
        property = property.trim();
        return property.replaceAll("<[^>]*>", "");
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String item_name) {
        this.itemName = item_name = this.cleanProperty(item_name);
    }

    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    public void setDescriptionLabel(String descriptionLabel) {
        this.descriptionLabel = descriptionLabel;
    }

    public String getLeftItemText() {
        return this.leftItemText;
    }

    public void setLeftItemText(String left_item_text) {
        this.leftItemText = left_item_text;
    }

    public String getSectionLabel() {
        return this.sectionLabel;
    }

    public void setSectionLabel(String section_label) {
        this.sectionLabel = this.cleanProperty(section_label);
    }

    public String getGroupLabel() {
        return this.groupLabel;
    }

    public void setGroupLabel(String group_label) {
        this.groupLabel = this.cleanProperty(group_label);
    }

    public String getParentItem() {
        return this.parentItem;
    }

    public void setParentItem(String parent_item) {
        this.parentItem = this.cleanProperty(parent_item);
    }

    public int getResponseTypeId() {
        return this.responseTypeId;
    }

    public void setResponseTypeId(int response_type_id) {
        this.responseTypeId = response_type_id;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String default_value) {
        this.defaultValue = this.cleanProperty(default_value);
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String data_type) {
        this.dataType = this.cleanProperty(data_type);
    }

    public static boolean isItemWithSameParameterExists(String column_value, List<SpreadSheetItemUtil> row_items) {
        if (row_items == null || row_items.size() == 1) {
            return false;
        }
        SpreadSheetItemUtil item = SpreadSheetItemUtil.isItemWithSameParameterExists((CrfTemplateColumnNameEnum)CrfTemplateColumnNameEnum.ITEM_NAME, (String)column_value, row_items, (boolean)false);
        return item != null;
    }

    public static boolean isItemWithSameParameterExistsIncludingMyself(String column_value, List<SpreadSheetItemUtil> row_items) {
        if (row_items == null || row_items.size() == 1) {
            return true;
        }
        SpreadSheetItemUtil item = SpreadSheetItemUtil.isItemWithSameParameterExists((CrfTemplateColumnNameEnum)CrfTemplateColumnNameEnum.ITEM_NAME, (String)column_value, row_items, (boolean)true);
        return item != null;
    }

    public static SpreadSheetItemUtil isItemWithSameParameterExists(CrfTemplateColumnNameEnum param_column_index, String column_value, List<SpreadSheetItemUtil> row_items) {
        if (row_items == null || row_items.size() == 1) {
            return null;
        }
        return SpreadSheetItemUtil.isItemWithSameParameterExists((CrfTemplateColumnNameEnum)param_column_index, (String)column_value, row_items, (boolean)false);
    }

    public static SpreadSheetItemUtil isItemWithSameParameterExists(CrfTemplateColumnNameEnum param_column_index, String column_value, List<SpreadSheetItemUtil> row_items, boolean isIncludingMyself) {
        int last_item_to_check = 0;
        for (SpreadSheetItemUtil cur_item : row_items) {
            if (!isIncludingMyself && last_item_to_check == row_items.size() - 1) break;
            ++last_item_to_check;
            switch (1.$SwitchMap$org$akaza$openclinica$core$util$CrfTemplateColumnNameEnum[param_column_index.ordinal()]) {
                case 1: {
                    if (!cur_item.getItemName().equals(column_value)) break;
                    return cur_item;
                }
            }
        }
        return null;
    }

    public static void verifySectionGroupPlacementForItems(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg, HashMap<String, ItemGroupBean> itemGroups) {
        HashMap<String, String> group_section_map = new HashMap<String, String>();
        int row_number = 1;
        for (SpreadSheetItemUtil cur_item : row_items) {
            ++row_number;
            if (cur_item.getGroupLabel().length() < 1) continue;
            ItemGroupBean item_group = itemGroups.get(cur_item.getGroupLabel());
            boolean isRepeatingGroup = false;
            if (item_group != null) {
                isRepeatingGroup = item_group.getMeta().isRepeatingGroup();
            }
            if (!isRepeatingGroup) continue;
            String section_label = (String)group_section_map.get(cur_item.getGroupLabel());
            if (section_label != null) {
                if (section_label.equals(cur_item.getSectionLabel())) continue;
                ver_errors.add(resPageMsg.getString("group_in_several_sections") + cur_item.getGroupLabel() + "'.");
                htmlErrors.put(sheetNumber + "," + (row_number - 1) + "," + CrfTemplateColumnNameEnum.GROUP_LABEL.getCellNumber(), resPageMsg.getString("INVALID_VALUE"));
                continue;
            }
            group_section_map.put(cur_item.getGroupLabel(), cur_item.getSectionLabel());
        }
    }

    public void verifyParentID(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg, HashMap<String, ItemGroupBean> itemGroups) {
        int row_number = row_items.size();
        if (this.getItemName().equalsIgnoreCase(this.getParentItem())) {
            this.setParentItem("");
        }
        if (!this.getParentItem().isEmpty()) {
            boolean isRepeatingGroup;
            ItemGroupBean item_group;
            SpreadSheetItemUtil cur_item = SpreadSheetItemUtil.isItemWithSameParameterExists((CrfTemplateColumnNameEnum)CrfTemplateColumnNameEnum.ITEM_NAME, (String)this.getParentItem(), row_items);
            if (cur_item == null) {
                ver_errors.add(resPageMsg.getString("parent_id") + row_number + resPageMsg.getString("parent_id_1"));
                htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.PARENT_ITEM.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
            }
            if (cur_item != null && cur_item.getParentItem() != null && cur_item.getParentItem().length() > 0) {
                ver_errors.add(resPageMsg.getString("nested_parent_id") + row_items.size() + resPageMsg.getString("nested_parent_id_1"));
                htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.PARENT_ITEM.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
            }
            if (itemGroups != null && itemGroups.size() > 0 && (item_group = itemGroups.get(this.getGroupLabel())) != null && (isRepeatingGroup = item_group.getMeta().isRepeatingGroup()) && this.getParentItem().length() > 0) {
                ver_errors.add(resPageMsg.getString("parentId_group") + row_items.size() + resPageMsg.getString("nested_parent_id_1"));
                htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.PARENT_ITEM.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
            }
        }
    }

    public void verifySectionLabel(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, ArrayList<String> secNames, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg) {
        int row_number = row_items.size();
        StringBuffer str = new StringBuffer();
        if (this.getSectionLabel().length() == 0) {
            str.append(resPageMsg.getString("the") + " ");
            str.append(resPageMsg.getString("SECTION_LABEL_column") + " ");
            str.append(resPageMsg.getString("not_valid_section_at_row") + " ");
            str.append(row_number + ", " + resPageMsg.getString("items_worksheet_with_dot"));
            str.append(" " + resPageMsg.getString("check_to_see_that_there_is_valid_LABEL"));
            ver_errors.add(str.toString());
            htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.SECTION_LABEL.getCellNumber(), resPageMsg.getString("NOT_A_VALID_LABEL"));
        }
        if (this.getSectionLabel().length() > 2000) {
            ver_errors.add(resPageMsg.getString("section_label_length_error"));
            htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.SECTION_LABEL.getCellNumber(), resPageMsg.getString("NOT_A_VALID_LABEL"));
        }
        if (!secNames.contains(this.getSectionLabel())) {
            if (str.length() == 0) {
                str.append(resPageMsg.getString("the") + " ");
                str.append(resPageMsg.getString("SECTION_LABEL_column") + " ");
                str.append(resPageMsg.getString("not_valid_section_at_row") + " ");
                str.append(row_number + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                str.append(" " + resPageMsg.getString("check_to_see_that_there_is_valid_LABEL"));
            }
            ver_errors.add(str.toString());
            htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.SECTION_LABEL.getCellNumber(), resPageMsg.getString("NOT_A_VALID_LABEL"));
        }
    }

    public void verifyItemName(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg) {
        int k = row_items.size();
        String itemName = this.getItemName();
        if (!Utils.isMatchingRegexp((String)itemName, (String)"\\w+")) {
            ver_errors.add(resPageMsg.getString("item_name_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + " " + resPageMsg.getString("you_can_only_use_letters_or_numbers"));
            htmlErrors.put(sheetNumber + "," + k + ",0", resPageMsg.getString("INVALID_FIELD"));
        }
        if (itemName.isEmpty()) {
            ver_errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("item_name_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
            htmlErrors.put(sheetNumber + "," + k + "," + CrfTemplateColumnNameEnum.ITEM_NAME.getCellNumber(), resPageMsg.getString("required_field"));
        }
        if (itemName.length() > 255) {
            ver_errors.add(resPageMsg.getString("item_name_length_error"));
        }
        if (SpreadSheetItemUtil.isItemWithSameParameterExists((String)itemName, row_items)) {
            ver_errors.add(resPageMsg.getString("duplicate") + " " + resPageMsg.getString("item_name_column") + " " + itemName + " " + resPageMsg.getString("was_detected_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
            htmlErrors.put(sheetNumber + "," + k + "," + CrfTemplateColumnNameEnum.ITEM_NAME.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
        }
    }

    public void verifyDefaultValue(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg) {
        int row_number = row_items.size();
        if ("date".equalsIgnoreCase(this.getDataType()) && !"".equals(this.getDefaultValue())) {
            try {
                this.setDefaultValue(new SimpleDateFormat(ApplicationConstants.getDateFormatInItemData()).format(this.getDefaultValue()));
            }
            catch (Exception e) {
                this.setDefaultValue("");
            }
        }
        if (this.getDefaultValue().length() > 0) {
            if (this.getResponseTypeId() == ResponseType.CALCULATION.getId() || this.getResponseTypeId() == ResponseType.GROUP_CALCULATION.getId() || this.getResponseTypeId() == ResponseType.FILE.getId() || this.getResponseTypeId() == ResponseType.INSTANT_CALCULATION.getId()) {
                ver_errors.add(resPageMsg.getString("default_value_not_allowed") + this.getItemName() + " " + resPageMsg.getString("change_radio") + " " + resPageMsg.getString("items_worksheet_with_dot"));
                htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.DEFAULT_VALUE.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
            } else if (this.getResponseTypeId() == ResponseType.SELECT.getId()) {
                if (this.getDefaultValue().indexOf(44) != -1) {
                    ver_errors.add(resPageMsg.getString("default_value_wrong_select") + row_number + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                    htmlErrors.put(sheetNumber + "," + row_number + "," + CrfTemplateColumnNameEnum.DEFAULT_VALUE.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                }
            } else if (this.getResponseTypeId() == ResponseType.CHECKBOX.getId() || this.getResponseTypeId() == ResponseType.SELECTMULTI.getId()) {
                // empty if block
            }
        }
    }

    public String[] getResponseOptions() {
        return this.responseOptions;
    }

    public void setResponseOptions(String[] response_options) {
        this.responseOptions = response_options;
    }

    public static void verifyUniqueItemPlacementInGroups(ArrayList<SpreadSheetItemUtil> row_items, ArrayList<String> ver_errors, HashMap<String, String> htmlErrors, int sheetNumber, ResourceBundle resPageMsg, String crfName, DataSource ds) {
        ItemDAO idao = new ItemDAO(ds);
        int row_count = 1;
        int check_group_count = 0;
        StringBuffer item_messages = null;
        ArrayList item_group_crf_records = idao.findAllWithItemGroupCRFVersionMetadataByCRFId(crfName);
        for (SpreadSheetItemUtil row_item : row_items) {
            item_messages = new StringBuffer();
            for (ItemGroupCrvVersionUtil check_group : item_group_crf_records) {
                ++check_group_count;
                if (!check_group.getItemName().equals(row_item.getItemName()) || row_item.getGroupLabel().equals("") && check_group.getGroupName().equals("Ungrouped") || row_item.getGroupLabel().equals(check_group.getGroupName()) || check_group.getCrfVersionStatus() != 1) continue;
                item_messages.append(resPageMsg.getString("verifyUniqueItemPlacementInGroups_4") + check_group.getGroupName());
                item_messages.append(resPageMsg.getString("verifyUniqueItemPlacementInGroups_5"));
                item_messages.append(check_group.getCrfVersionName());
                if (check_group_count == item_group_crf_records.size()) continue;
                item_messages.append("', ");
            }
            if (item_messages.length() > 0) {
                htmlErrors.put(sheetNumber + "," + row_count + "," + CrfTemplateColumnNameEnum.GROUP_LABEL.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                ver_errors.add(resPageMsg.getString("verifyUniqueItemPlacementInGroups_1") + row_item.getItemName() + "' " + resPageMsg.getString("at_row") + " '" + row_count + resPageMsg.getString("verifyUniqueItemPlacementInGroups_2") + row_item.getItemName() + resPageMsg.getString("verifyUniqueItemPlacementInGroups_3") + item_messages.toString() + ").");
            }
            ++row_count;
        }
    }
}

