/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.admin;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.sql.DataSource;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.admin.NewCRFBean;
import org.akaza.openclinica.bean.core.ItemDataType;
import org.akaza.openclinica.bean.core.ResponseType;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.oid.MeasurementUnitOidGenerator;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.ItemBean;
import org.akaza.openclinica.bean.submit.ItemFormMetadataBean;
import org.akaza.openclinica.bean.submit.ItemGroupBean;
import org.akaza.openclinica.bean.submit.ItemGroupMetadataBean;
import org.akaza.openclinica.bean.submit.ResponseSetBean;
import org.akaza.openclinica.control.admin.SpreadSheetItemUtil;
import org.akaza.openclinica.control.admin.SpreadSheetTable;
import org.akaza.openclinica.control.form.Validator;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationCell;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidationType;
import org.akaza.openclinica.control.form.spreadsheet.OnChangeSheetValidator;
import org.akaza.openclinica.control.form.spreadsheet.SheetCell;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationContainer;
import org.akaza.openclinica.control.form.spreadsheet.SheetValidationType;
import org.akaza.openclinica.core.form.StringUtil;
import org.akaza.openclinica.core.util.CrfTemplateColumnNameEnum;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.hibernate.MeasurementUnitDao;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.ItemDAO;
import org.akaza.openclinica.dao.submit.ItemGroupDAO;
import org.akaza.openclinica.exception.CRFReadingException;
import org.akaza.openclinica.logic.score.ScoreValidator;
import org.akaza.openclinica.web.SQLInitServlet;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSheetTableRepeating
implements SpreadSheetTable {
    private POIFSFileSystem fs = null;
    private UserAccountBean ub = null;
    private int crfId = 0;
    private String crfName = "";
    private String versionIdString = "";
    private boolean isRepeating = false;
    private final HashMap<String, ItemGroupBean> itemGroups = new HashMap();
    private Locale locale;
    private final int studyId;
    private Set<String> existingUnits = new TreeSet();
    private Set<String> existingOIDs = new TreeSet();
    private MeasurementUnitDao measurementUnitDao = new MeasurementUnitDao();
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public SpreadSheetTableRepeating(FileInputStream parseStream, UserAccountBean ub, String versionName, Locale locale, int studyId) throws IOException {
        this.fs = new POIFSFileSystem((InputStream)parseStream);
        this.ub = ub;
        this.locale = locale;
        this.studyId = studyId;
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        for (int j = 0; j < numSheets; ++j) {
            String sheetName = wb.getSheetName(j);
            if (!sheetName.equalsIgnoreCase("groups")) continue;
            this.isRepeating = true;
        }
    }

    public void setCrfId(int id) {
        this.crfId = id;
    }

    public int getCrfId() {
        return this.crfId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewCRFBean toNewCRF(DataSource ds, ResourceBundle resPageMsg) throws IOException, CRFReadingException {
        String dbName = SQLInitServlet.getDBName();
        NewCRFBean ncrf = new NewCRFBean(ds, this.crfId);
        ncrf.setCrfId(this.crfId);
        StringBuffer buf = new StringBuffer();
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        ArrayList<String> queries = new ArrayList<String>();
        ArrayList errors = new ArrayList();
        HashMap<String, ItemBean> items = new HashMap<String, ItemBean>();
        SpreadSheetItemUtil item_from_row = null;
        String pVersion = "";
        int parentId = 0;
        HashMap itemCheck = ncrf.getItemNames();
        HashMap GroupCheck = ncrf.getItemGroupNames();
        LinkedHashMap<String, String> openQueries = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> backupItemQueries = new LinkedHashMap<String, String>();
        ArrayList<String> secNames = new ArrayList<String>();
        ArrayList<String> itemGroupOids = new ArrayList<String>();
        ArrayList<String> itemOids = new ArrayList<String>();
        CRFDAO cdao = new CRFDAO(ds);
        ItemDAO idao = new ItemDAO(ds);
        CRFVersionDAO cvdao = new CRFVersionDAO(ds);
        ItemGroupDAO itemGroupDao = new ItemGroupDAO(ds);
        SheetValidationContainer sheetContainer = new SheetValidationContainer();
        HashMap allItems = (HashMap)sheetContainer.getAllItems();
        HashMap<String, String[]> controlValues = new HashMap<String, String[]>();
        OnChangeSheetValidator instantValidator = new OnChangeSheetValidator(sheetContainer, resPageMsg);
        int validSheetNum = 0;
        for (int j = 0; j < numSheets; ++j) {
            String sheetName = wb.getSheetName(j);
            if (!sheetName.equalsIgnoreCase("CRF") && !sheetName.equalsIgnoreCase("Sections") && !sheetName.equalsIgnoreCase("Items")) continue;
            ++validSheetNum;
        }
        if (validSheetNum != 3) {
            errors.add("The excel spreadsheet doesn't have required valid worksheets. Please check whether it contains sheets of CRF, Sections and Items.");
        }
        HSSFSheet sheet = wb.getSheetAt(4);
        HSSFCell insCell = sheet.getRow(1).getCell((short)0);
        String versionNo = insCell.toString();
        for (int j = 0; j < numSheets; ++j) {
            sheet = wb.getSheetAt(j);
            String sheetName = wb.getSheetName(j);
            if (sheetName.equalsIgnoreCase("Instructions")) continue;
            int numRows = sheet.getPhysicalNumberOfRows();
            String secName = "";
            String page = "";
            ArrayList<String> resPairs = new ArrayList<String>();
            ArrayList<String> resNames = new ArrayList<String>();
            HashMap htmlErrors = new HashMap();
            int blankRowCount = 0;
            String itemName = null;
            String default_value = null;
            if (sheetName.equalsIgnoreCase("Items")) {
                this.logger.debug("read an item in sheet" + sheetName);
                HashMap<String, String[]> labelWithOptions = new HashMap<String, String[]>();
                HashMap<String, String[]> labelWithValues = new HashMap<String, String[]>();
                HashMap<String, String> labelWithType = new HashMap<String, String>();
                this.logger.debug("row20 is: " + this.getValue(sheet.getRow(0).getCell((short)20)));
                boolean hasWDColumn = "width_decimal".equalsIgnoreCase(this.getValue(sheet.getRow(0).getCell((short)20)));
                ArrayList<SpreadSheetItemUtil> row_items = new ArrayList<SpreadSheetItemUtil>();
                for (int k = 1; k < numRows; ++k) {
                    double dr;
                    double dphi;
                    String value1;
                    String[] resValArray;
                    String[] g;
                    String subHeader;
                    String rightItemText;
                    String leftItemText;
                    if (sheet.getRow(k) == null) {
                        if (++blankRowCount != 5) continue;
                        break;
                    }
                    int cellIndex = 0;
                    HSSFCell cell = sheet.getRow(k).getCell((short)0);
                    item_from_row = new SpreadSheetItemUtil();
                    row_items.add(item_from_row);
                    item_from_row.setItemName(this.getValue(cell));
                    item_from_row.verifyItemName(row_items, errors, htmlErrors, j, resPageMsg);
                    itemName = item_from_row.getItemName();
                    cell = sheet.getRow(k).getCell((short)1);
                    String descLabel = this.getValue(cell);
                    descLabel = descLabel.replaceAll("<[^>]*>", "");
                    item_from_row.setDescriptionLabel(descLabel);
                    if (descLabel == null || descLabel.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DESCRIPTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                    }
                    if (descLabel != null && descLabel.length() > 4000) {
                        errors.add(resPageMsg.getString("item_desc_length_error"));
                    }
                    if ((leftItemText = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && leftItemText.length() > 4000) {
                        errors.add(resPageMsg.getString("left_item_length_error"));
                    }
                    item_from_row.setLeftItemText(leftItemText);
                    cell = sheet.getRow(k).getCell((short)3);
                    String unit = this.getValue(cell).trim();
                    if (unit != null && unit.length() > 0) {
                        String muSql = "";
                        if (unit.length() > 64) {
                            errors.add(resPageMsg.getString("units_length_error"));
                            htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.UNITS.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                        }
                        if (this.existingUnits.size() <= 0) {
                            this.existingUnits = this.measurementUnitDao.findAllNames();
                            if (this.existingUnits == null) {
                                this.existingUnits = new TreeSet();
                            }
                        }
                        if (this.existingOIDs.size() <= 0) {
                            this.existingOIDs = this.measurementUnitDao.findAllOIDs();
                            if (this.existingOIDs == null) {
                                this.existingOIDs = new TreeSet();
                            }
                        }
                        if (this.existingUnits.contains(unit)) {
                            this.logger.debug("unit=" + unit + " existed.");
                        } else {
                            String oid = "";
                            try {
                                oid = new MeasurementUnitOidGenerator().generateOid(new String[]{unit});
                            }
                            catch (Exception e) {
                                throw new RuntimeException("CANNOT GENERATE OID");
                            }
                            if (this.existingOIDs.contains(oid)) {
                                if (oid.length() > 40) {
                                    oid = oid.substring(0, 35);
                                }
                                oid = new MeasurementUnitOidGenerator().randomizeOid(oid);
                            }
                            this.existingOIDs.add(oid);
                            this.existingUnits.add(unit);
                            muSql = this.getMUInsertSql(oid, unit, this.ub.getId(), dbName);
                            queries.add(muSql);
                        }
                    }
                    if ((rightItemText = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && rightItemText.length() > 2000) {
                        errors.add(resPageMsg.getString("right_item_length_error"));
                    }
                    cell = sheet.getRow(k).getCell((short)5);
                    item_from_row.setSectionLabel(this.stripQuotes(this.getValue(cell)));
                    item_from_row.verifySectionLabel(row_items, errors, secNames, htmlErrors, j, resPageMsg);
                    secName = item_from_row.getSectionLabel();
                    cell = sheet.getRow(k).getCell((short)6);
                    item_from_row.setGroupLabel(this.stripQuotes(this.getValue(cell)));
                    String groupLabel = item_from_row.getGroupLabel();
                    if (item_from_row.getItemName().length() > 0) {
                        if (groupLabel != null && !groupLabel.trim().isEmpty()) {
                            allItems.put(item_from_row.getItemName(), groupLabel);
                        } else {
                            allItems.put(item_from_row.getItemName(), "Ungrouped");
                        }
                    }
                    sheetContainer.getItemSectionNameMap().put(itemName, secName);
                    sheetContainer.collectRepGrpItemNameMap(itemName, groupLabel);
                    cell = sheet.getRow(k).getCell((short)7);
                    String header = this.getValue(cell);
                    if (header != null && header.length() > 2000) {
                        errors.add(resPageMsg.getString("item_header_length_error"));
                    }
                    if ((subHeader = this.getValue(cell = sheet.getRow(k).getCell((short)8))) != null && subHeader.length() > 240) {
                        errors.add(resPageMsg.getString("item_subheader_length_error"));
                        htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.SUBHEADER.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                    }
                    cell = sheet.getRow(k).getCell((short)9);
                    String parentItem = this.getValue(cell);
                    item_from_row.setParentItem(parentItem);
                    item_from_row.verifyParentID(row_items, errors, htmlErrors, j, resPageMsg, this.itemGroups);
                    parentItem = item_from_row.getParentItem();
                    cell = sheet.getRow(k).getCell((short)10);
                    int columnNum = 0;
                    String column = this.getValue(cell);
                    if (column != null && !column.trim().isEmpty()) {
                        try {
                            columnNum = Integer.parseInt(column);
                        }
                        catch (NumberFormatException ne) {
                            columnNum = 0;
                        }
                    }
                    if ((cell = sheet.getRow(k).getCell((short)11)) != null) {
                        page = this.getValue(cell);
                    }
                    cell = sheet.getRow(k).getCell((short)12);
                    String questionNum = this.getValue(cell);
                    cell = sheet.getRow(k).getCell((short)13);
                    String responseType = this.getValue(cell);
                    int responseTypeId = 1;
                    if (responseType == null || responseType.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("required_field"));
                    } else {
                        if (!ResponseType.findByName((String)responseType.toLowerCase())) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                            htmlErrors.put(j + "," + k + ",13", resPageMsg.getString("INVALID_FIELD"));
                        } else {
                            responseTypeId = ResponseType.getByName((String)responseType.toLowerCase()).getId();
                            item_from_row.setResponseTypeId(responseTypeId);
                        }
                        if (responseTypeId == 5) {
                            cell = sheet.getRow(k).getCell((short)18);
                            String def = this.getValue(cell);
                            if (def != null && !def.trim().isEmpty()) {
                                errors.add(resPageMsg.getString("radio_with_default") + item_from_row.getItemName() + resPageMsg.getString("change_radio"));
                                htmlErrors.put(j + "," + k + "," + CrfTemplateColumnNameEnum.DEFAULT_VALUE.getCellNumber(), resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else if (responseTypeId == ResponseType.INSTANT_CALCULATION.getId()) {
                            unit = "";
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)14);
                    String responseLabel = this.getValue(cell);
                    if ((responseLabel == null || responseLabel.trim().isEmpty()) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + "," + k + ",14", resPageMsg.getString("required_field"));
                    } else if ("file".equalsIgnoreCase(responseType) && !"file".equalsIgnoreCase(responseLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_LABEL_column") + " " + resPageMsg.getString("should_be_file") + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",14", resPageMsg.getString("should_be_file"));
                    }
                    cell = sheet.getRow(k).getCell((short)15);
                    String resOptions = this.getValue(cell);
                    if (responseTypeId == ResponseType.TEXT.getId()) {
                        responseLabel = "text";
                    } else if (responseTypeId == ResponseType.TEXTAREA.getId()) {
                        responseLabel = "textarea";
                    }
                    if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                        resOptions = "text";
                    } else if ("file".equalsIgnoreCase(responseType)) {
                        resOptions = "file";
                    }
                    int numberOfOptions = 0;
                    if (!resNames.contains(responseLabel) && (resOptions == null || resOptions.trim().isEmpty()) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_OPTIONS_TEXT_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("required_field"));
                    }
                    if (!resNames.contains(responseLabel) && resOptions != null && !resOptions.trim().isEmpty()) {
                        if (responseTypeId == 8 || responseTypeId == 9) {
                            numberOfOptions = 1;
                        } else {
                            String text1 = resOptions.replaceAll("\\\\,", "##");
                            String[] resArray = text1.split(",");
                            numberOfOptions = resArray.length;
                        }
                    }
                    String[] mapResArray = (String[])labelWithOptions.get(responseLabel);
                    String text1 = resOptions.replaceAll("\\\\,", "##");
                    String[] resArray = text1.split(",");
                    item_from_row.setResponseOptions(resArray);
                    this.logger.debug(item_from_row.getItemName());
                    if (labelWithOptions.containsKey(responseLabel)) {
                        if (resOptions != null && !resOptions.trim().isEmpty()) {
                            for (int i = 0; i < resArray.length; ++i) {
                                if (resArray[i].equals(mapResArray[i])) continue;
                                errors.add(resPageMsg.getString("resp_label_with_different_resp_options") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("resp_label_with_different_resp_options_html_error"));
                                break;
                            }
                        }
                    } else {
                        labelWithOptions.put(responseLabel, resArray);
                    }
                    cell = sheet.getRow(k).getCell((short)16);
                    String resValues = this.getValue(cell);
                    if (responseLabel.equalsIgnoreCase("text") || responseLabel.equalsIgnoreCase("textarea")) {
                        resValues = "text";
                    } else if ("file".equalsIgnoreCase(responseType)) {
                        resValues = "file";
                    }
                    if (!resNames.contains(responseLabel) && (resValues == null || resValues.trim().isEmpty()) && responseTypeId != ResponseType.TEXT.getId() && responseTypeId != ResponseType.TEXTAREA.getId() && responseTypeId != ResponseType.INSTANT_CALCULATION.getId()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + ", " + k + ",16", resPageMsg.getString("required_field"));
                    }
                    if (responseTypeId == ResponseType.CALCULATION.getId() || responseTypeId == ResponseType.GROUP_CALCULATION.getId()) {
                        ArrayList variables;
                        StringBuffer err;
                        ScoreValidator scoreValidator;
                        String[] s;
                        if (resValues.contains(":") && !"func".equalsIgnoreCase((s = resValues.split(":"))[0].trim())) {
                            errors.add(resPageMsg.getString("expression_not_start_with_func_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                            htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("INVALID_FIELD"));
                        }
                        String exp = resValues;
                        exp = exp.replace("\\\\,", "##");
                        exp = exp.replace("##", ",");
                        resValues = exp = exp.replace(",", "\\\\,");
                        if (exp.startsWith("func:")) {
                            exp = exp.substring(5).trim();
                        }
                        if (!(scoreValidator = new ScoreValidator(this.locale)).isValidExpression(exp = exp.replace("\\\\,", "##"), err = new StringBuffer(), variables = new ArrayList())) {
                            errors.add(resPageMsg.getString("expression_invalid_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + err);
                            htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("INVALID_FIELD"));
                        }
                        if (!exp.startsWith("getexternalvalue") && !exp.startsWith("getExternalValue")) {
                            String group = groupLabel.length() > 0 ? groupLabel : "Ungrouped";
                            for (String v : variables) {
                                if (!allItems.containsKey(v)) {
                                    errors.add("Item '" + v + "' must be listed before the item '" + itemName + "' at row " + k + ", items worksheet. ");
                                    htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                                    continue;
                                }
                                if (responseTypeId == 8 && !((String)allItems.get(v)).equalsIgnoreCase(group)) {
                                    errors.add("Item '" + v + "' and item '" + itemName + "' must have a same GROUP_LABEL at row " + k + ", items worksheet. ");
                                    htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                                    continue;
                                }
                                if (responseTypeId != 9 || (g = (String[])allItems.get(v)).equalsIgnoreCase("ungrouped") || !g.equalsIgnoreCase(group)) continue;
                                errors.add("Item '" + v + "' and item '" + itemName + "' should not have a same GROUP_LABEL at row " + k + ", items worksheet. ");
                                htmlErrors.put(j + "," + k + ",16", "INVALID FIELD");
                            }
                        }
                    } else if ("instant-calculation".equalsIgnoreCase(responseType)) {
                        OnChangeSheetValidationCell onchangecell = new OnChangeSheetValidationCell(OnChangeSheetValidationType.ALL, new SheetCell.Builder().rowName(itemName).colTitle("RESPONSE_VALUES_column").colValue(resValues).forWhich("instant_calculation").sheetNum(j).rowNum(k).colNum(16).build());
                        instantValidator.addValidationCells(onchangecell);
                    } else if (numberOfOptions > 0 && (resValArray = (value1 = resValues.replaceAll("\\\\,", "##")).split(",")).length != numberOfOptions) {
                        errors.add(resPageMsg.getString("incomplete_option_value_pair") + " " + resPageMsg.getString("RESPONSE_OPTIONS_column") + " " + resPageMsg.getString("and") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("at_row") + k + " " + resPageMsg.getString("items_worksheet") + "; " + resPageMsg.getString("perhaps_missing_comma"));
                        htmlErrors.put(j + "," + k + ",15", resPageMsg.getString("number_option_not_match"));
                        htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("number_value_not_match"));
                    }
                    String[] mapValArray = (String[])labelWithValues.get(responseLabel);
                    String value12 = resValues.replaceAll("\\\\,", "##");
                    String[] resValArray2 = value12.split(",");
                    if (labelWithValues.containsKey(responseLabel)) {
                        if (resValues != null && !resValues.trim().isEmpty()) {
                            if (null != resValArray2 && null != mapValArray && resValArray2.length != mapValArray.length) {
                                errors.add(resPageMsg.getString("resp_label_with_different_resp_values") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("resp_label_with_different_resp_values_html_error"));
                            } else {
                                for (int i = 0; i < resValArray2.length; ++i) {
                                    if (resValArray2[i].equals(mapValArray[i])) continue;
                                    errors.add(resPageMsg.getString("resp_label_with_different_resp_values") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                    htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("resp_label_with_different_resp_values_html_error"));
                                    break;
                                }
                            }
                        }
                        controlValues.put(secName + "---" + itemName, mapValArray);
                    } else {
                        labelWithValues.put(responseLabel, resValArray2);
                        controlValues.put(secName + "---" + itemName, resValArray2);
                    }
                    cell = sheet.getRow(k).getCell((short)17);
                    String responseLayout = this.getValue(cell);
                    responseLayout = responseLayout.replaceAll("<[^>]*>", "");
                    cell = sheet.getRow(k).getCell((short)19);
                    String dataType = this.getValue(cell);
                    dataType = dataType.replaceAll("<[^>]*>", "");
                    item_from_row.setDataType(dataType);
                    String dataTypeIdString = "1";
                    if (dataType == null || dataType.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("required_field"));
                    } else if (!ItemDataType.findByName((String)dataType.toLowerCase())) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                        htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("INVALID_FIELD"));
                    } else {
                        if ("file".equalsIgnoreCase(responseType) && !"FILE".equalsIgnoreCase(dataType)) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("should_be_file") + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                            htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("should_be_file"));
                        } else if ("instant-calculation".equalsIgnoreCase(responseType)) {
                            OnChangeSheetValidationCell onchangecell = new OnChangeSheetValidationCell(OnChangeSheetValidationType.NONE, SheetValidationType.SHOULD_BE_ST, new SheetCell.Builder().rowName(itemName).colTitle("DATA_TYPE_column").colValue(dataType).forWhich("instant_calculation").sheetNum(j).rowNum(k).colNum(19).build());
                            instantValidator.addValidationCells(onchangecell);
                        }
                        dataTypeIdString = "(SELECT ITEM_DATA_TYPE_ID From ITEM_DATA_TYPE Where CODE='" + dataType.toUpperCase() + "')";
                    }
                    if (responseTypeId == 3 || responseTypeId == 5 || responseTypeId == 6 || responseTypeId == 7) {
                        if (labelWithType.containsKey(responseLabel)) {
                            if (!dataType.equalsIgnoreCase(((String)labelWithType.get(responseLabel)).toString())) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("DATA_TYPE_column") + " " + resPageMsg.getString("does_not_match_the_item_data_type_with_the_same_response_label") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                htmlErrors.put(j + "," + k + ",19", resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else {
                            labelWithType.put(responseLabel, dataType);
                            if (resValArray2.length > 0) {
                                String st;
                                boolean wrongType = false;
                                if ("int".equalsIgnoreCase(dataType)) {
                                    g = resValArray2;
                                    int n = g.length;
                                    for (int i = 0; i < n; ++i) {
                                        String s = g[i];
                                        String string = st = s != null && s.length() > 0 ? s.trim() : "";
                                        if (st.length() <= 0) continue;
                                        try {
                                            Integer I = Integer.parseInt(st);
                                            if (I.toString().equals(st)) continue;
                                            wrongType = true;
                                            continue;
                                        }
                                        catch (Exception e) {
                                            wrongType = true;
                                        }
                                    }
                                    if (wrongType) {
                                        wrongType = false;
                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_integer") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                        htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("should_be_integer"));
                                    }
                                } else if ("real".equalsIgnoreCase(dataType)) {
                                    g = resValArray2;
                                    int n = g.length;
                                    for (int i = 0; i < n; ++i) {
                                        String s = g[i];
                                        String string = st = s != null && s.length() > 0 ? s.trim() : "";
                                        if (st.length() <= 0) continue;
                                        try {
                                            Double.parseDouble(st);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            wrongType = true;
                                        }
                                    }
                                    if (wrongType) {
                                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("RESPONSE_VALUES_column") + " " + resPageMsg.getString("should_be_real") + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ".");
                                        htmlErrors.put(j + "," + k + ",16", resPageMsg.getString("should_be_real"));
                                    }
                                }
                            }
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)18);
                    item_from_row.setDefaultValue(this.getValue(cell));
                    item_from_row.verifyDefaultValue(row_items, errors, htmlErrors, j, resPageMsg);
                    default_value = item_from_row.getDefaultValue();
                    cellIndex = 19;
                    String widthDecimal = "";
                    this.logger.debug("hasWidthDecimalColumn=" + hasWDColumn);
                    if (hasWDColumn) {
                        cell = sheet.getRow(k).getCell((short)(++cellIndex));
                        widthDecimal = this.getValue(cell);
                        if (widthDecimal == null || widthDecimal.trim().isEmpty()) {
                            widthDecimal = "";
                        } else if ("single-select".equalsIgnoreCase(responseType) || "multi-select".equalsIgnoreCase(responseType) || "radio".equalsIgnoreCase(responseType) || "checkbox".equalsIgnoreCase(responseType)) {
                            errors.add(resPageMsg.getString("error_message_for_width_decimal_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + resPageMsg.getString("width_decimal_unavailable_for_single_multi_checkbox_radio"));
                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                        } else {
                            StringBuffer message = new StringBuffer();
                            boolean isCalc = responseTypeId == 8 || responseTypeId == 9;
                            message = Validator.validateWidthDecimalSetting((String)widthDecimal, (String)dataType, (boolean)isCalc, (Locale)this.locale);
                            if (message.length() > 0) {
                                errors.add(resPageMsg.getString("error_message_for_width_decimal_at") + " " + k + ", " + resPageMsg.getString("items_worksheet") + ": " + message);
                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                            }
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String regexp = this.getValue(cell);
                    String regexp1 = "";
                    if (regexp != null && !regexp.trim().isEmpty()) {
                        regexp1 = regexp.trim();
                        if (regexp1.startsWith("regexp:")) {
                            String finalRegexp = regexp1.substring(7).trim();
                            if (finalRegexp.contains("\\\\")) {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("regular_expression_contained") + " '\\\\', " + resPageMsg.getString("it_should_only_contain_one") + "'\\'. ");
                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                            } else if (finalRegexp.startsWith("/") && finalRegexp.endsWith("/")) {
                                finalRegexp = finalRegexp.substring(1, finalRegexp.length() - 1);
                                try {
                                    Pattern.compile(finalRegexp);
                                }
                                catch (PatternSyntaxException pse) {
                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("Example") + " regexp: /[0-9]*/ ");
                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                                }
                            } else {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + resPageMsg.getString("has_an_invalid_regular_expression_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + " " + resPageMsg.getString("Example") + " regexp: /[0-9]*/ ");
                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else if (regexp1.startsWith("func:")) {
                            try {
                                Validator.processCRFValidationFunction((String)regexp1);
                            }
                            catch (Exception e) {
                                errors.add(e.getMessage() + ", " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                            }
                        } else {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot"));
                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_FIELD"));
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String regexpError = this.getValue(cell);
                    regexpError = regexpError.replaceAll("<[^>]*>", "");
                    if (regexp != null && !regexp.trim().isEmpty() && (regexpError == null || regexpError.trim().isEmpty())) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("VALIDATION_ERROR_MESSAGE_column") + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + " " + resPageMsg.getString("cannot_be_blank_if_VALIDATION_not_blank"));
                        htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("required_field"));
                    }
                    if (regexpError != null && regexpError.length() > 255) {
                        errors.add(resPageMsg.getString("regexp_errror_length_error"));
                    }
                    boolean phiBoolean = false;
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String phi = this.getValue(cell);
                    if (phi == null || phi.trim().isEmpty()) {
                        phi = "0";
                    } else if (cell.getCellType() == 0 && ((dphi = cell.getNumericCellValue()) - (double)((int)dphi)) * 1000.0 == 0.0) {
                        phi = (int)dphi + "";
                    }
                    if (!"0".equals(phi) && !"1".equals(phi)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("PHI_column") + resPageMsg.getString("was_invalid_at_row") + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("PHI_column") + " " + resPageMsg.getString("can_only_be_either_0_or_1"));
                        htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                    } else {
                        phiBoolean = "1".equals(phi);
                    }
                    boolean isRequired = false;
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String required = this.getValue(cell);
                    if (required == null || required.trim().isEmpty()) {
                        required = "0";
                    } else if (cell.getCellType() == 0 && ((dr = cell.getNumericCellValue()) - (double)((int)dr)) * 1000.0 == 0.0) {
                        required = (int)dr + "";
                    }
                    if (!"0".equals(required) && !"1".equals(required)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REQUIRED_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("REQUIRED_column") + resPageMsg.getString("can_only_be_either_0_or_1"));
                        htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                    } else {
                        isRequired = "1".equals(required);
                    }
                    boolean isShowItem = true;
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String showItem = this.getValue(cell);
                    if (showItem != null && !showItem.trim().isEmpty()) {
                        isShowItem = !"0".equals(showItem);
                        isShowItem = !"Hide".equalsIgnoreCase(showItem);
                    }
                    cell = sheet.getRow(k).getCell((short)(++cellIndex));
                    String display = this.getValue(cell);
                    String controlItemName = "";
                    String optionValue = "";
                    String message = "";
                    if (display != null && !display.trim().isEmpty()) {
                        if (isShowItem) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("ITEM_DISPLAY_STATUS_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("should_be_hide_for_scd"));
                            htmlErrors.put(j + "," + k + "," + (cellIndex - 1), resPageMsg.getString("INVALID_VALUE"));
                        }
                        String pvKey = secName + "---";
                        String d = display.replaceAll("\\\\,", "##");
                        String[] par = d.split(",");
                        if (par.length == 3) {
                            String p0 = par[0].trim();
                            String p1 = par[1].trim();
                            String p2 = par[2].trim();
                            if (p0.length() > 0 && p1.length() > 0 && p2.length() > 0) {
                                if (SpreadSheetItemUtil.isItemWithSameParameterExistsIncludingMyself((String)p0, row_items)) {
                                    controlItemName = p0;
                                    optionValue = p1;
                                    message = p2;
                                    if (controlValues.containsKey(pvKey = pvKey + p0)) {
                                        String[] pvs = (String[])controlValues.get(pvKey);
                                        boolean existing = false;
                                        for (String s : pvs) {
                                            if (!s.trim().equals(p1)) continue;
                                            existing = true;
                                            break;
                                        }
                                        if (!existing) {
                                            optionValue = "";
                                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("control_response_value_invalid") + " " + p1.replace("##", "\\\\,"));
                                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                        }
                                    }
                                } else {
                                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("control_item_name_invalid") + " " + p0);
                                    htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                                }
                            } else {
                                errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("correct_pattern"));
                                htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                            }
                        } else {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SIMPLE_CONDITIONAL_DISPLAY_column") + " " + resPageMsg.getString("was_invalid_at_row") + " " + k + ", " + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("correct_pattern"));
                            htmlErrors.put(j + "," + k + "," + cellIndex, resPageMsg.getString("INVALID_VALUE"));
                        }
                    }
                    String itemOid = idao.getValidOid(new ItemBean(), this.crfName, itemName, itemOids);
                    itemOids.add(itemOid);
                    String vlSql = "INSERT INTO ITEM (NAME,DESCRIPTION,UNITS,PHI_STATUS,ITEM_DATA_TYPE_ID, ITEM_REFERENCE_TYPE_ID,STATUS_ID,OWNER_ID,DATE_CREATED,OC_OID) VALUES ('" + this.stripQuotes(itemName) + "','" + this.stripQuotes(descLabel) + "','" + this.stripQuotes(unit) + "'," + phiBoolean + "," + dataTypeIdString + ",1,1," + this.ub.getId() + ", NOW(),'" + itemOid + "')";
                    backupItemQueries.put(itemName, vlSql);
                    ItemBean ib = new ItemBean();
                    ib.setName(itemName);
                    ib.setUnits(unit);
                    ib.setPhiStatus(phiBoolean);
                    ib.setDescription(descLabel);
                    ib.setDataType(ItemDataType.getByName((String)dataType.toLowerCase()));
                    ResponseSetBean rsb = new ResponseSetBean();
                    String resOptions1 = resOptions.replaceAll("\\\\,", "\\,");
                    String resValues1 = resValues.replaceAll("\\\\,", "\\,");
                    rsb.setOptions(this.stripQuotes(resOptions1), this.stripQuotes(resValues1));
                    ItemFormMetadataBean ifmb = new ItemFormMetadataBean();
                    ifmb.setResponseSet(rsb);
                    ifmb.setShowItem(isShowItem);
                    ib.setItemMeta(ifmb);
                    items.put(itemName, ib);
                    int ownerId = this.ub.getId();
                    if (!itemCheck.containsKey(itemName)) {
                        openQueries.put(itemName, vlSql);
                    } else {
                        ItemBean oldItem = idao.findByNameAndCRFId(itemName, this.crfId);
                        if (oldItem.getOwnerId() == this.ub.getId()) {
                            if (!cvdao.hasItemData(oldItem.getId())) {
                                String upSql = "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',UNITS='" + this.stripQuotes(unit) + "',PHI_STATUS=" + phiBoolean + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                openQueries.put(itemName, upSql);
                            } else {
                                String upSql = "";
                                oldItem.getDataType();
                                ib.getDataType();
                                upSql = oldItem.getDataType() == ItemDataType.DATE && ib.getDataType() == ItemDataType.PDATE ? "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + phiBoolean + ",ITEM_DATA_TYPE_ID=" + dataTypeIdString + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId : "UPDATE ITEM SET DESCRIPTION='" + this.stripQuotes(descLabel) + "',PHI_STATUS=" + phiBoolean + " FROM versioning_map, crf_version WHERE item.name='" + this.stripQuotes(itemName) + "' AND item.owner_id = " + ownerId + " AND item.item_id = versioning_map.item_id AND versioning_map.crf_version_id = crf_version.crf_version_id AND crf_version.crf_id = " + this.crfId;
                                openQueries.put(itemName, upSql);
                            }
                        } else {
                            ownerId = oldItem.getOwner().getId();
                        }
                    }
                    String sql = "INSERT INTO RESPONSE_SET (LABEL, OPTIONS_TEXT, OPTIONS_VALUES, RESPONSE_TYPE_ID, VERSION_ID) VALUES ('" + this.stripQuotes(responseLabel) + "', E'" + this.stripQuotes(resOptions) + "', E'" + this.stripQuotes(resValues) + "',(SELECT RESPONSE_TYPE_ID From RESPONSE_TYPE Where NAME='" + this.stripQuotes(responseType.toLowerCase()) + "')," + this.versionIdString + ")";
                    if (!resPairs.contains(responseLabel.toString().toLowerCase() + "_" + responseType.toString().toLowerCase())) {
                        if (!resNames.contains(responseLabel)) {
                            queries.add(sql);
                            resNames.add(responseLabel);
                        } else {
                            errors.add("Error found at row \"" + (k + 1) + "\" in items worksheet. ResponseLabel \"" + responseLabel + "\" for ResponseType \"" + responseType + "\" has been used for another ResponseType.  ");
                            htmlErrors.put(j + "," + k + ",14", "INVALID FIELD");
                        }
                        resPairs.add(responseLabel.toString().toLowerCase() + "_" + responseType.toString().toLowerCase());
                    }
                    String parentItemString = "0";
                    if (parentItem != null && !parentItem.trim().isEmpty()) {
                        parentItemString = "(SELECT ITEM_ID FROM ITEM WHERE NAME='" + this.stripQuotes(parentItem) + "' AND owner_id = " + ownerId + " ORDER BY OC_OID DESC LIMIT 1)";
                    }
                    String selectCorrectItemQueryPostgres = " (SELECT I.ITEM_ID FROM ITEM I LEFT OUTER JOIN ITEM_FORM_METADATA IFM ON I.ITEM_Id = IFM.ITEM_ID LEFT OUTER JOIN CRF_VERSION CV ON IFM.CRF_VERSION_ID = CV.CRF_VERSION_ID  WHERE  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is null ) OR  ( I.NAME='" + itemName + "' AND I.owner_id = " + ownerId + " AND CV.CRF_VERSION_ID is not null AND CV.CRF_ID =" + this.crfId + " )  ORDER BY I.OC_OID DESC LIMIT 1) ";
                    String sql2 = "INSERT INTO ITEM_FORM_METADATA (CRF_VERSION_ID, RESPONSE_SET_ID,ITEM_ID,SUBHEADER,HEADER,LEFT_ITEM_TEXT,RIGHT_ITEM_TEXT,PARENT_ID,SECTION_ID,ORDINAL,PARENT_LABEL,COLUMN_NUMBER,PAGE_NUMBER_LABEL,question_number_label,REGEXP,REGEXP_ERROR_MSG,REQUIRED,DEFAULT_VALUE,RESPONSE_LAYOUT,WIDTH_DECIMAL, show_item) VALUES (" + this.versionIdString + ",(SELECT RESPONSE_SET_ID FROM RESPONSE_SET WHERE LABEL='" + this.stripQuotes(responseLabel) + "' AND VERSION_ID=" + this.versionIdString + ")," + selectCorrectItemQueryPostgres + ",'" + this.stripQuotes(subHeader) + "','" + this.stripQuotes(header) + "','" + this.stripQuotes(leftItemText) + "','" + this.stripQuotes(rightItemText) + "'," + parentItemString + ", (SELECT SECTION_ID FROM SECTION WHERE LABEL='" + secName + "' AND CRF_VERSION_ID IN " + this.versionIdString + "), " + k + ",'" + parentItem + "'," + columnNum + ",'" + this.stripQuotes(page) + "','" + this.stripQuotes(questionNum) + "','" + this.stripQuotes(regexp1) + "','" + this.stripQuotes(regexpError) + "', " + isRequired + ", '" + this.stripQuotes(default_value) + "','" + this.stripQuotes(responseLayout) + "','" + widthDecimal + "'," + isShowItem + ")";
                    queries.add(sql2);
                    String sql3 = "INSERT INTO VERSIONING_MAP (CRF_VERSION_ID, ITEM_ID) VALUES ( " + this.versionIdString + "," + selectCorrectItemQueryPostgres + ")";
                    queries.add(sql3);
                    String sql2_1 = "";
                    if (display.length() > 0) {
                        if (controlItemName.length() > 0 && optionValue.length() > 0 && message.length() > 0) {
                            sql2_1 = "insert into scd_item_metadata (scd_item_form_metadata_id,control_item_form_metadata_id,control_item_name,option_value,message) values((select max(ifm.item_form_metadata_id) from item_form_metadata ifm where ifm.item_id=" + selectCorrectItemQueryPostgres + "and ifm.show_item=false ),(select cifm.item_form_metadata_id from item, item_form_metadata cifm where cifm.crf_version_id = " + this.versionIdString + " and item.item_id = (select it.item_id from item it, versioning_map vm where it.name = '" + controlItemName + "' and vm.crf_version_id = " + this.versionIdString + " and vm.item_id = it.item_id) and cifm.item_id = item.item_id), '" + controlItemName + "', '" + this.stripQuotes(optionValue) + "', '" + this.stripQuotes(message) + "')";
                            queries.add(sql2_1);
                        } else {
                            this.logger.debug("No insert into scd_item_metadata for item name = " + itemName + "with Simple_Conditional_Display = \"" + display + "\".");
                        }
                    }
                    if (groupLabel != null && !groupLabel.trim().isEmpty()) {
                        ItemGroupMetadataBean igMeta = new ItemGroupMetadataBean();
                        ItemGroupBean itemGroup = new ItemGroupBean();
                        try {
                            this.logger.debug("found " + groupLabel);
                            itemGroup = (ItemGroupBean)this.itemGroups.get(groupLabel);
                            this.logger.debug("*** Found " + groupLabel + " and matched with " + itemGroup.getName());
                            igMeta = itemGroup.getMeta();
                            if (igMeta == null) {
                                igMeta = new ItemGroupMetadataBean();
                            }
                            String sqlGroupLabel = "INSERT INTO ITEM_GROUP_METADATA (item_group_id,header,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, show_group, repeating_group) VALUES ((SELECT ITEM_GROUP_ID FROM ITEM_GROUP WHERE NAME='" + itemGroup.getName() + "' AND crf_id = " + this.crfId + " LIMIT 1),E'" + igMeta.getHeader() + "', E'" + igMeta.getSubheader() + "', '" + igMeta.getLayout() + "', " + igMeta.getRepeatNum() + ", " + igMeta.getRepeatMax() + ", '" + igMeta.getRepeatArray() + "', " + igMeta.getRowStartNumber() + "," + this.versionIdString + ",(SELECT ITEM.ITEM_ID FROM ITEM,ITEM_FORM_METADATA,CRF_VERSION WHERE ITEM.NAME='" + itemName + "' AND ITEM.ITEM_ID = ITEM_FORM_METADATA.ITEM_ID and ITEM_FORM_METADATA.CRF_VERSION_ID=CRF_VERSION.CRF_VERSION_ID AND CRF_VERSION.CRF_ID= " + this.crfId + " ORDER BY ITEM.OC_OID DESC LIMIT 1)," + k + ", " + igMeta.isShowGroup() + ", " + igMeta.isRepeatingGroup() + ")";
                            queries.add(sqlGroupLabel);
                        }
                        catch (NullPointerException e) {
                            this.logger.error("Error  message", (Throwable)e);
                            errors.add(resPageMsg.getString("Error_found_at_row") + " \"" + (k + 1) + "\"" + resPageMsg.getString("items_worksheet_with_dot") + resPageMsg.getString("GROUP_LABEL") + "\"" + groupLabel + "\" " + resPageMsg.getString("does_not_exist_in_group_spreadsheet"));
                            htmlErrors.put(j + "," + k + ",6", resPageMsg.getString("GROUP_DOES_NOT_EXIST"));
                        }
                        continue;
                    }
                    String sqlGroupLabel = "INSERT INTO ITEM_GROUP_METADATA (item_group_id,header,subheader, layout, repeat_number, repeat_max, repeat_array,row_start_number, crf_version_id,item_id , ordinal, repeating_group) VALUES ((SELECT ITEM_GROUP_ID FROM ITEM_GROUP WHERE NAME='Ungrouped' AND crf_id = " + this.crfId + "  LIMIT 1),'', '', '', " + 1 + ", " + 1 + ", '', 1," + this.versionIdString + "," + selectCorrectItemQueryPostgres + "," + k + ", false)";
                    queries.add(sqlGroupLabel);
                }
                SpreadSheetItemUtil.verifySectionGroupPlacementForItems(row_items, errors, htmlErrors, (int)j, (ResourceBundle)resPageMsg, (HashMap)this.itemGroups);
                SpreadSheetItemUtil.verifyUniqueItemPlacementInGroups(row_items, errors, htmlErrors, (int)j, (ResourceBundle)resPageMsg, (String)this.crfName, (DataSource)ds);
                instantValidator.validate();
                errors = (ArrayList)instantValidator.getSheetErrors().addErrorsToSheet(errors);
                htmlErrors = (HashMap)instantValidator.getSheetErrors().putHtmlErrorsToSheet(htmlErrors);
            } else if (sheetName.equalsIgnoreCase("Groups")) {
                this.logger.debug("read groups, ***comment added 5.14.07");
                ArrayList<String> groupNames = new ArrayList<String>();
                ItemGroupBean defaultGroup = new ItemGroupBean();
                defaultGroup.setName("Ungrouped");
                defaultGroup.setCrfId(Integer.valueOf(this.crfId));
                defaultGroup.setStatus(Status.AVAILABLE);
                String defaultGroupOid = itemGroupDao.getValidOid(defaultGroup, this.crfName, defaultGroup.getName(), itemGroupOids);
                itemGroupOids.add(defaultGroupOid);
                String defaultSql = "INSERT INTO ITEM_GROUP (  name, crf_id, status_id, date_created ,owner_id,oc_oid) VALUES ('" + defaultGroup.getName() + "', " + defaultGroup.getCrfId() + "," + defaultGroup.getStatus().getId() + ",now()," + this.ub.getId() + ",'" + defaultGroupOid + "')";
                if (!GroupCheck.containsKey("Ungrouped")) {
                    queries.add(defaultSql);
                }
                for (int gk = 1; gk < numRows; ++gk) {
                    if (sheet.getRow(gk) == null) {
                        if (++blankRowCount != 5) continue;
                        break;
                    }
                    HSSFCell cell = sheet.getRow(gk).getCell((short)0);
                    String groupLabel = this.getValue(cell);
                    groupLabel = groupLabel.replaceAll("<[^>]*>", "");
                    if ((groupLabel = this.stripQuotes(groupLabel)) == null || groupLabel.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_LABEL_column") + resPageMsg.getString("was_blank_at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ".");
                        htmlErrors.put(j + "," + gk + ",0", resPageMsg.getString("required_field"));
                    }
                    if (groupLabel != null && groupLabel.length() > 255) {
                        errors.add(resPageMsg.getString("group_label_length_error"));
                    }
                    if (groupNames.contains(groupLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_LABEL_column") + resPageMsg.getString("was_a_duplicate_of") + " " + groupLabel + resPageMsg.getString("at_row") + gk + ", " + resPageMsg.getString("Groups_worksheet") + ".");
                        htmlErrors.put(j + "," + gk + ",0", resPageMsg.getString("DUPLICATE_FIELD"));
                    } else {
                        groupNames.add(groupLabel);
                    }
                    boolean isRepeatingGroup = true;
                    boolean newVersionCrf = false;
                    int cellNo = 0;
                    if (!(versionNo.equalsIgnoreCase("Version: 2.2") || versionNo.equalsIgnoreCase("Version: 2.5") || versionNo.equalsIgnoreCase("Version: 3.0"))) {
                        cellNo = 1;
                        cell = sheet.getRow(gk).getCell((short)cellNo);
                        try {
                            isRepeatingGroup = this.getValue(cell).equalsIgnoreCase("grid");
                            newVersionCrf = true;
                        }
                        catch (Exception eee) {
                            errors.add(resPageMsg.getString("repeating_group_error"));
                        }
                    }
                    cell = sheet.getRow(gk).getCell((short)(++cellNo));
                    String groupHeader = this.getValue(cell);
                    if ((groupHeader = StringUtil.escapeSingleQuote((String)groupHeader)) != null && groupHeader.length() > 255) {
                        errors.add(resPageMsg.getString("group_header_length_error"));
                    }
                    if (isRepeatingGroup) {
                        sheetContainer.getRepeatingGroupLabels().add(groupLabel);
                    }
                    cell = sheet.getRow(gk).getCell((short)(++cellNo));
                    String groupRepeatNumber = this.getValue(cell);
                    if (newVersionCrf && !isRepeatingGroup && groupRepeatNumber != null && !groupRepeatNumber.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("repeat_number_none_repeating"));
                    } else if (!isRepeatingGroup && (groupRepeatNumber == null || groupRepeatNumber.trim().isEmpty())) {
                        groupRepeatNumber = "1";
                    } else if (groupRepeatNumber == null || groupRepeatNumber.trim().isEmpty()) {
                        groupRepeatNumber = "1";
                    } else if (cell.getCellType() == 0) {
                        double dr = cell.getNumericCellValue();
                        if ((dr - (double)((int)dr)) * 1000.0 == 0.0) {
                            groupRepeatNumber = (int)dr + "";
                        }
                    } else {
                        this.logger.debug("found a non-numeric code in a numeric field: groupRepeatNumber");
                    }
                    cell = sheet.getRow(gk).getCell((short)(++cellNo));
                    String groupRepeatMax = this.getValue(cell);
                    if (newVersionCrf && !isRepeatingGroup && groupRepeatMax != null && !groupRepeatMax.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("repeat_max_none_repeating"));
                    } else if (!isRepeatingGroup && (groupRepeatMax == null || groupRepeatMax.trim().isEmpty())) {
                        groupRepeatMax = "1";
                    } else if (groupRepeatMax == null || groupRepeatMax.trim().isEmpty()) {
                        groupRepeatMax = "40";
                    } else if (cell.getCellType() == 0) {
                        double dr = cell.getNumericCellValue();
                        if ((dr - (double)((int)dr)) * 1000.0 == 0.0) {
                            groupRepeatMax = (int)dr + "";
                            try {
                                int repeatMaxInt = Integer.parseInt(groupRepeatMax);
                                if (repeatMaxInt < 1) {
                                    groupRepeatMax = "40";
                                }
                            }
                            catch (NumberFormatException nfe) {
                                groupRepeatMax = "40";
                            }
                        }
                    } else {
                        this.logger.debug("found a non-numeric code in a numeric field: groupRepeatMax");
                    }
                    cell = sheet.getRow(gk).getCell((short)(++cellNo));
                    String showGroup = this.getValue(cell);
                    boolean isShowGroup = true;
                    if (showGroup != null && !showGroup.trim().isEmpty()) {
                        try {
                            isShowGroup = !"0".equals(showGroup);
                            isShowGroup = !"Hide".equalsIgnoreCase(showGroup);
                        }
                        catch (Exception eee) {
                            this.logger.debug("caught an exception with the boolean value for groups");
                        }
                    }
                    ItemGroupBean fgb = new ItemGroupBean();
                    fgb.setName(groupLabel);
                    fgb.setCrfId(Integer.valueOf(this.crfId));
                    fgb.setStatus(Status.AVAILABLE);
                    ItemGroupMetadataBean igMeta = new ItemGroupMetadataBean();
                    igMeta.setHeader(groupHeader);
                    igMeta.setRepeatingGroup(isRepeatingGroup);
                    igMeta.setBorders(Integer.valueOf(0));
                    igMeta.setShowGroup(isShowGroup);
                    try {
                        igMeta.setRepeatMax(new Integer(Integer.parseInt(groupRepeatMax)));
                        if (igMeta.getRepeatMax() < 1) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_MAX_column") + " " + resPageMsg.getString("must_be_a_positive_integer") + ". " + groupRepeatMax + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                            htmlErrors.put(j + "," + gk + ",3", resPageMsg.getString("INVALID_FIELD"));
                        }
                    }
                    catch (NumberFormatException n2) {
                        this.logger.error("Error  message", (Throwable)n2);
                        if ("".equals(groupRepeatMax)) {
                            igMeta.setRepeatMax(Integer.valueOf(40));
                        }
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_MAX_column") + " " + resPageMsg.getString("must_be_a_positive_integer") + ". " + groupRepeatMax + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                        htmlErrors.put(j + "," + gk + ",3", resPageMsg.getString("INVALID_FIELD"));
                    }
                    try {
                        igMeta.setRepeatNum(new Integer(Integer.parseInt(groupRepeatNumber)));
                        if (igMeta.getRepeatNum() < 1) {
                            errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_NUM_column") + " " + resPageMsg.getString("must_be_a_positive_integer_or_blank") + ". " + groupRepeatNumber + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                            htmlErrors.put(j + "," + gk + ",2", resPageMsg.getString("INVALID_FIELD"));
                        }
                    }
                    catch (NumberFormatException n3) {
                        this.logger.error(n3.getMessage());
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("GROUP_REPEAT_NUM_column") + " " + resPageMsg.getString("must_be_a_positive_integer_or_blank") + ". " + groupRepeatNumber + " " + resPageMsg.getString("at_row") + " " + gk + ", " + resPageMsg.getString("Groups_worksheet") + ". ");
                        htmlErrors.put(j + "," + gk + ",2", resPageMsg.getString("INVALID_FIELD"));
                    }
                    fgb.setMeta(igMeta);
                    String groupOid = itemGroupDao.getValidOid(fgb, this.crfName, fgb.getName(), itemGroupOids);
                    itemGroupOids.add(groupOid);
                    String gsql = "INSERT INTO ITEM_GROUP ( name, crf_id, status_id, date_created ,owner_id,oc_oid)VALUES ('" + fgb.getName() + "', " + fgb.getCrfId() + "," + fgb.getStatus().getId() + ",now()," + this.ub.getId() + ",'" + groupOid + "')";
                    this.itemGroups.put(fgb.getName(), fgb);
                    if (GroupCheck.containsKey(fgb.getName())) continue;
                    queries.add(gsql);
                }
            } else if (sheetName.equalsIgnoreCase("Sections")) {
                this.logger.debug("read sections");
                for (int k = 1; k < numRows && blankRowCount != 5; ++k) {
                    String pageNumber;
                    String instructions;
                    String subtitle;
                    if (sheet.getRow(k) == null) {
                        ++blankRowCount;
                        continue;
                    }
                    HSSFCell cell = sheet.getRow(k).getCell((short)0);
                    String secLabel = this.getValue(cell);
                    secLabel = secLabel.replaceAll("<[^>]*>", "");
                    if ((secLabel = this.stripQuotes(secLabel)) == null || secLabel.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + " , " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("required_field"));
                    }
                    if (secLabel != null && secLabel.length() > 2000) {
                        errors.add(resPageMsg.getString("section_label_length_error"));
                    }
                    if (secNames.contains(secLabel)) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_LABEL_column") + resPageMsg.getString("was_a_duplicate_of") + secLabel + " " + resPageMsg.getString("at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",0", resPageMsg.getString("DUPLICATE_FIELD"));
                    }
                    secNames.add(secLabel);
                    cell = sheet.getRow(k).getCell((short)1);
                    String title = this.getValue(cell);
                    title = title.replaceAll("<[^>]*>", "");
                    if (title == null || title.trim().isEmpty()) {
                        errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("SECTION_TITLE_column") + " " + resPageMsg.getString("was_blank_at_row") + " " + k + ", " + resPageMsg.getString("sections_worksheet") + ".");
                        htmlErrors.put(j + "," + k + ",1", resPageMsg.getString("required_field"));
                    }
                    if (title != null && title.length() > 2000) {
                        errors.add(resPageMsg.getString("section_title_length_error"));
                    }
                    if ((subtitle = this.getValue(cell = sheet.getRow(k).getCell((short)2))) != null && subtitle.length() > 2000) {
                        errors.add(resPageMsg.getString("section_subtitle_length_error"));
                    }
                    if ((instructions = this.getValue(cell = sheet.getRow(k).getCell((short)3))) != null && instructions.length() > 2000) {
                        errors.add(resPageMsg.getString("section_instruction_length_error"));
                    }
                    if ((pageNumber = this.getValue(cell = sheet.getRow(k).getCell((short)4))) != null && pageNumber.length() > 5) {
                        errors.add(resPageMsg.getString("section_page_number_length_error"));
                    }
                    cell = sheet.getRow(k).getCell((short)5);
                    String parentSection = this.getValue(cell);
                    if ((parentSection = parentSection.replaceAll("<[^>]*>", "")) != null && !parentSection.trim().isEmpty()) {
                        try {
                            parentId = Integer.parseInt(parentSection);
                        }
                        catch (NumberFormatException ne) {
                            parentId = 0;
                        }
                    }
                    cell = sheet.getRow(k).getCell((short)6);
                    String strBorder = this.getValue(cell);
                    strBorder = strBorder.replaceAll("<[^>]*>", "");
                    int intBorder = 0;
                    try {
                        intBorder = Integer.parseInt(strBorder);
                    }
                    catch (NumberFormatException npe) {
                        this.logger.error("Sections BORDER column is not valid integer", (Throwable)npe);
                    }
                    String sql = "INSERT INTO SECTION (CRF_VERSION_ID,STATUS_ID,LABEL, TITLE, INSTRUCTIONS, SUBTITLE, PAGE_NUMBER_LABEL,ORDINAL, PARENT_ID, OWNER_ID, DATE_CREATED, BORDERS) VALUES (" + this.versionIdString + ",1,'" + secLabel + "','" + this.stripQuotes(title) + "', '" + this.stripQuotes(instructions) + "', '" + this.stripQuotes(subtitle) + "','" + pageNumber + "'," + k + "," + parentId + "," + this.ub.getId() + ",NOW()," + intBorder + ")";
                    queries.add(sql);
                }
            } else if (sheetName.equalsIgnoreCase("CRF")) {
                String oid;
                HashMap checkCRFVersions;
                CRFBean checkName;
                this.logger.debug("read crf");
                if (sheet == null || sheet.getRow(1) == null || sheet.getRow(1).getCell((short)0) == null) {
                    throw new CRFReadingException("Blank row found in sheet CRF.");
                }
                HSSFCell cell = sheet.getRow(1).getCell((short)0);
                this.crfName = this.getValue(cell);
                this.crfName = this.crfName.replaceAll("<[^>]*>", "");
                if (this.crfName == null || this.crfName.trim().isEmpty()) {
                    throw new CRFReadingException("The CRF_NAME column was blank in the CRF worksheet.");
                }
                if (this.crfId > 0 && !(checkName = cdao.findByPK(this.crfId)).getName().equals(this.crfName)) {
                    throw new CRFReadingException(resPageMsg.getString("the") + " " + resPageMsg.getString("CRF_NAME_column") + " '" + this.crfName + "' " + resPageMsg.getString("did_not_match_crf_name") + " '" + checkName.getName() + "'.");
                }
                if (this.crfName.length() > 255) {
                    errors.add(resPageMsg.getString("crf_name_length_error"));
                }
                CRFBean existingCRFWithSameName = cdao.findByName(this.crfName);
                if (this.getCrfId() == 0 && existingCRFWithSameName.getName() != null && existingCRFWithSameName.getName().equals(this.crfName)) {
                    errors.add(resPageMsg.getString("crf_name_already_used"));
                }
                cell = sheet.getRow(1).getCell((short)1);
                String version = this.getValue(cell);
                version = version.replaceAll("<[^>]*>", "");
                ncrf.setVersionName(version);
                if (version != null && version.length() > 255) {
                    errors.add(resPageMsg.getString("version_length_error"));
                }
                cell = sheet.getRow(1).getCell((short)2);
                String versionDesc = this.getValue(cell);
                if ((versionDesc = versionDesc.replaceAll("<[^>]*>", "")) != null && versionDesc.length() > 4000) {
                    errors.add(resPageMsg.getString("version_description_length_error"));
                }
                cell = sheet.getRow(1).getCell((short)3);
                String revisionNotes = this.getValue(cell);
                if ((revisionNotes = revisionNotes.replaceAll("<[^>]*>", "")) != null && revisionNotes.length() > 255) {
                    errors.add(resPageMsg.getString("revision_notes_length_error"));
                }
                if (revisionNotes == null || revisionNotes.trim().isEmpty()) {
                    errors.add(resPageMsg.getString("the") + " " + resPageMsg.getString("REVISION_NOTES_column") + " " + resPageMsg.getString("was_blank_in_the_CRF_worksheet"));
                    htmlErrors.put(j + ",1,3", resPageMsg.getString("required_field"));
                }
                Connection con = null;
                String crfOid = null;
                if (this.crfId == 0) {
                    crfOid = cdao.getValidOid(new CRFBean(), this.crfName);
                    try {
                        int nextCRFId;
                        con = ds.getConnection();
                        ResultSet nextIdRs = con.createStatement().executeQuery("select nextval('crf_crf_id_seq')");
                        nextIdRs.next();
                        this.crfId = nextCRFId = nextIdRs.getInt(1);
                        ncrf.setCrfId(this.crfId);
                        String createCRFSql = "INSERT INTO CRF (CRF_ID, STATUS_ID, NAME, DESCRIPTION, OWNER_ID, DATE_CREATED, OC_OID, SOURCE_STUDY_ID) VALUES (" + this.crfId + ", 1,'" + this.stripQuotes(this.crfName) + "','" + this.stripQuotes(versionDesc) + "'," + this.ub.getId() + ",NOW(),'" + crfOid + "'," + this.studyId + ")";
                        queries.add(createCRFSql);
                    }
                    catch (SQLException e) {
                        this.logger.warn("Exception encountered with query select nextval('crf_crf_id_seq'), Message-" + e.getMessage());
                    }
                    finally {
                        if (con != null) {
                            try {
                                con.close();
                            }
                            catch (SQLException e) {
                                this.logger.warn("Connection can't be closed");
                            }
                        }
                    }
                }
                if ((checkCRFVersions = ncrf.getCrfVersions()).containsKey(version)) {
                    this.logger.debug("found a matching version name..." + version);
                    errors.add(resPageMsg.getString("version_not_unique_cause_confusion"));
                    htmlErrors.put(j + ",1,2", resPageMsg.getString("NOT_UNIQUE"));
                }
                if (crfOid != null) {
                    oid = cvdao.getValidOid(new CRFVersionBean(), crfOid, version);
                } else {
                    CRFBean crfBean = cdao.findByName(this.crfName);
                    oid = cvdao.getValidOid(new CRFVersionBean(), crfBean.getOid(), version);
                }
                String sql = "";
                sql = this.crfId == 0 ? "INSERT INTO CRF_VERSION (NAME, DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + this.stripQuotes(version) + "','" + this.stripQuotes(versionDesc) + "',(SELECT CRF_ID FROM CRF WHERE NAME='" + this.crfName + "'),1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')" : "INSERT INTO CRF_VERSION (NAME,DESCRIPTION, CRF_ID, STATUS_ID,DATE_CREATED,OWNER_ID,REVISION_NOTES,OC_OID) VALUES ('" + version + "','" + this.stripQuotes(versionDesc) + "'," + this.crfId + ",1,NOW()," + this.ub.getId() + ",'" + this.stripQuotes(revisionNotes) + "','" + oid + "')";
                queries.add(sql);
                pVersion = version;
            }
            this.versionIdString = "(SELECT CRF_VERSION_ID FROM CRF_VERSION WHERE NAME ='" + pVersion + "' AND CRF_ID=" + this.crfId + ")";
            buf.append(sheetName + "<br>");
            buf.append("<div class=\"box_T\"><div class=\"box_L\"><div class=\"box_R\"><div class=\"box_B\"><div class=\"box_TL\"><div class=\"box_TR\"><div class=\"box_BL\"><div class=\"box_BR\">");
            buf.append("<div class=\"textbox_center\">");
            buf.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\"");
            buf.append("caption=\"" + wb.getSheetName(j) + "\">");
            for (int i = 0; i < numRows; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                int numCells = sheet.getRow(i).getLastCellNum();
                block56: for (int y = 0; y < numCells; ++y) {
                    HSSFCell cell = sheet.getRow(i).getCell((short)y);
                    int cellType = 0;
                    String error = "&nbsp;";
                    String errorKey = j + "," + i + "," + y;
                    if (htmlErrors.containsKey(errorKey)) {
                        error = "<span class=\"alert\">" + (String)htmlErrors.get(errorKey) + "</span>";
                    }
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                            continue block56;
                        }
                        case 0: {
                            buf.append("<td class=\"table_cell\">" + cell.getNumericCellValue() + " " + error + "</td>");
                            continue block56;
                        }
                        case 1: {
                            String stringCellValue = cell.getStringCellValue();
                            buf.append("<td class=\"table_cell\">" + stringCellValue + " " + error + "</td>");
                            continue block56;
                        }
                        default: {
                            buf.append("<td class=\"table_cell\">" + error + "</td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
            buf.append("<br></div>");
            buf.append("</div></div></div></div></div></div></div></div>");
            buf.append("</div><br>");
        }
        ncrf.setQueries(queries);
        ncrf.setItemQueries(openQueries);
        ncrf.setBackupItemQueries(backupItemQueries);
        ncrf.setItems(items);
        if (!errors.isEmpty()) {
            ncrf.setErrors(errors);
        }
        ncrf.setHtmlTable(buf.toString());
        return ncrf;
    }

    public String stripQuotes(String unescapedText) {
        return StringEscapeUtils.escapeSql((String)unescapedText);
    }

    public String getValue(HSSFCell cell) {
        String val = null;
        int cellType = 0;
        cellType = cell == null ? 3 : cell.getCellType();
        switch (cellType) {
            case 3: {
                val = "";
                break;
            }
            case 0: {
                val = cell.getNumericCellValue() + "";
                double dphi = cell.getNumericCellValue();
                if ((dphi - (double)((int)dphi)) * 1000.0 != 0.0) break;
                val = (int)dphi + "";
                break;
            }
            case 1: {
                String stringCellValue;
                val = stringCellValue = cell.getStringCellValue();
                if (!val.matches("'")) break;
                val.replaceAll("'", "''");
                break;
            }
            case 4: {
                boolean val2 = cell.getBooleanCellValue();
                val = val2 ? "true" : "false";
            }
            default: {
                val = "";
            }
        }
        return val.trim();
    }

    public String toHTML(int sheetIndex) throws IOException {
        StringBuffer buf = new StringBuffer();
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        int numSheets = wb.getNumberOfSheets();
        for (int j = 0; j < numSheets; ++j) {
            HSSFSheet sheet = wb.getSheetAt(j);
            String sheetName = wb.getSheetName(j);
            buf.append(sheetName + "<br>");
            buf.append("<table border=\"2\"");
            buf.append("caption=\"" + wb.getSheetName(sheetIndex) + "\">");
            int numCols = sheet.getPhysicalNumberOfRows();
            for (int i = 0; i < numCols; ++i) {
                buf.append("<tr>");
                if (sheet.getRow(i) == null) continue;
                int numCells = sheet.getRow(i).getLastCellNum();
                block7: for (int y = 0; y < numCells; ++y) {
                    HSSFCell cell = sheet.getRow(i).getCell((short)y);
                    int cellType = 0;
                    cellType = cell == null ? 3 : cell.getCellType();
                    switch (cellType) {
                        case 3: {
                            buf.append("<td> </td>");
                            continue block7;
                        }
                        case 0: {
                            buf.append("<td>" + cell.getNumericCellValue() + "</td>");
                            continue block7;
                        }
                        case 1: {
                            String stringCellValue = cell.getStringCellValue();
                            buf.append("<td>" + stringCellValue + "</td>");
                            continue block7;
                        }
                        default: {
                            buf.append("<td></td>");
                        }
                    }
                }
                buf.append("</tr>");
            }
            buf.append("</table>");
        }
        return buf.toString();
    }

    private String getMUInsertSql(String oid, String measurementUnitName, int ownerId, String dbName) {
        return "insert into measurement_unit (oc_oid, name) values ('" + oid + "', '" + this.stripQuotes(measurementUnitName) + "')";
    }

    public boolean isRepeating() {
        return this.isRepeating;
    }

    public void setRepeating(boolean isRepeating) {
        this.isRepeating = isRepeating;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MeasurementUnitDao getMeasurementUnitDao() {
        return this.measurementUnitDao;
    }

    public void setMeasurementUnitDao(MeasurementUnitDao measurementUnitDao) {
        this.measurementUnitDao = measurementUnitDao;
    }
}

