/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.extract;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.extract.FilterDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.EntityBeanTable;
import org.akaza.openclinica.web.bean.FilterRow;

public class CreateFiltersOneServlet
extends SecureController {
    private static final long serialVersionUID = -4896891632087112903L;
    Locale locale;

    public void processRequest() throws Exception {
        this.session.removeAttribute("newExp");
        String action = this.request.getParameter("action");
        if (action == null || action.trim().isEmpty()) {
            FormProcessor fp = new FormProcessor(this.request);
            FilterDAO fdao = new FilterDAO(this.sm.getDataSource());
            EntityBeanTable table = fp.getEntityBeanTable();
            ArrayList filters = new ArrayList();
            filters = this.ub.isSysAdmin() ? fdao.findAllAdmin() : fdao.findAll();
            ArrayList filterRows = FilterRow.generateRowsFromBeans((ArrayList)filters);
            String[] columns = new String[]{resword.getString("filter_name"), resword.getString("description"), resword.getString("created_by"), resword.getString("created_date"), resword.getString("status"), resword.getString("actions")};
            table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
            table.hideColumnLink(5);
            table.addLink(resword.getString("create_new_filter"), "CreateFiltersOne?action=begin");
            table.setQuery("CreateFiltersOne", new HashMap());
            table.setRows(filterRows);
            table.computeDisplay();
            this.request.setAttribute("table", (Object)table);
            this.forwardPage(Page.CREATE_FILTER_SCREEN_1);
        } else if ("begin".equalsIgnoreCase(action)) {
            this.forwardPage(Page.CREATE_FILTER_SCREEN_2);
        }
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR) || this.currentRole.getRole().equals((Term)Role.INVESTIGATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU, resexception.getString("not_allowed_access_extract_data_servlet"), "1");
    }
}

