/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.login;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.dao.hibernate.PasswordRequirementsDao;
import org.akaza.openclinica.dao.login.UserAccountDAO;

/*
 * Exception performing whole class analysis ignored.
 */
public class PasswordValidator {
    private static boolean hasLowerCaseChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isLowerCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUpperCaseChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasDigits(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSpecialChars(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if ("!@#$%&*()".indexOf(str.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    public static List<String> validatePassword(PasswordRequirementsDao passwordRequirementsDao, UserAccountDAO userDao, int userId, String newPassword, String newHash, ResourceBundle resexception) {
        ArrayList<String> errors = new ArrayList<String>();
        UserAccountBean userBean = userDao.findByPK(userId);
        if (userBean.getPasswd().equals(newHash)) {
            errors.add(resexception.getString("pwd_cannot_reuse"));
        }
        int minLen = passwordRequirementsDao.minLength();
        int maxLen = passwordRequirementsDao.maxLength();
        if (newPassword.length() == 0) {
            return new ArrayList<String>();
        }
        if (minLen > 0 && newPassword.length() < minLen) {
            errors.add(resexception.getString("pwd_too_short") + " " + minLen + " " + resexception.getString("chars"));
        }
        if (maxLen > 0 && newPassword.length() > maxLen) {
            errors.add(resexception.getString("pwd_too_long") + " " + maxLen + " " + resexception.getString("chars"));
        }
        if (passwordRequirementsDao.hasLower() && !PasswordValidator.hasLowerCaseChars((String)newPassword)) {
            errors.add(resexception.getString("pwd_needs_lower_case"));
        }
        if (passwordRequirementsDao.hasUpper() && !PasswordValidator.hasUpperCaseChars((String)newPassword)) {
            errors.add(resexception.getString("pwd_needs_upper_case"));
        }
        if (passwordRequirementsDao.hasDigits() && !PasswordValidator.hasDigits((String)newPassword)) {
            errors.add(resexception.getString("pwd_needs_digits"));
        }
        if (passwordRequirementsDao.hasSpecials() && !PasswordValidator.hasSpecialChars((String)newPassword)) {
            errors.add(resexception.getString("pwd_needs_special_chars"));
        }
        return errors;
    }
}

