/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.DataEntryStage;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.SubjectBean;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.jmesa.view.html.HtmlBuilder;

public class EventCrfLayerBuilder {
    HtmlBuilder html;
    SubjectBean subject;
    Integer rowCount;
    List<StudyEventBean> studyEvents;
    DataEntryStage eventCrfStatus;
    EventCRFBean eventCrfBean;
    StudySubjectBean studySubject;
    StudyBean currentStudy;
    StudyUserRoleBean currentRole;
    UserAccountBean currentUser;
    EventDefinitionCRFBean eventDefinitionCrf;
    CRFBean crf;
    StudyEventDefinitionBean studyEventDefinition;
    private ResourceBundle reswords = ResourceBundleProvider.getWordsBundle();
    private ResourceBundle restexts = ResourceBundleProvider.getTextsBundle();
    String contextPath;

    public EventCrfLayerBuilder(SubjectBean subject, Integer rowCount, List<StudyEventBean> studyEvents, DataEntryStage eventCrfStatus, EventCRFBean eventCrfBean, StudySubjectBean studySubject, StudyBean currentStudy, StudyUserRoleBean currentRole, UserAccountBean currentUser, EventDefinitionCRFBean eventDefinitionCrf, CRFBean crf, StudyEventDefinitionBean studyEventDefinition, String contextPath) {
        this.html = new HtmlBuilder();
        this.subject = subject;
        this.rowCount = rowCount;
        this.studyEvents = studyEvents;
        this.eventCrfStatus = eventCrfStatus;
        this.eventCrfBean = eventCrfBean;
        this.studySubject = studySubject;
        this.currentStudy = currentStudy;
        this.currentRole = currentRole;
        this.currentUser = currentUser;
        this.eventDefinitionCrf = eventDefinitionCrf;
        this.crf = crf;
        this.studyEventDefinition = studyEventDefinition;
        this.contextPath = contextPath;
    }

    StudyEventBean getStudyEvent() {
        return this.studyEvents.size() < 1 ? null : (StudyEventBean)this.studyEvents.get(0);
    }

    String buid() {
        this.buildLock();
        this.buildEvent();
        this.clickToEnterData();
        this.buildEnd();
        return this.html.toString();
    }

    void buildLock() {
        String studySubjectLabel = this.studySubject.getLabel();
        this.html.table(0).border("0").cellpadding("0").cellspacing("0").close();
        this.html.tr(0).valign("top").close().td(0).close();
        this.html.div().id("Lock_" + studySubjectLabel + "_" + this.crf.getId() + "_" + this.rowCount).style("position: absolute; visibility: hidden; z-index: 3; width: 50px; height: 30px; top: 0px;").close();
        if (this.eventCrfStatus == DataEntryStage.ADMINISTRATIVE_EDITING) {
            this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Complete_collapse.gif", "images/CRF_status_icon_Complete.gif");
        } else if (this.eventCrfStatus == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) {
            this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_InitialDEcomplete_collapse.gif", "images/CRF_status_icon_InitialDEcomplete.gif");
        } else if (this.eventCrfStatus == DataEntryStage.DOUBLE_DATA_ENTRY) {
            this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_DDE_collapse.gif", "images/CRF_status_icon_DDE.gif");
        } else if (this.eventCrfStatus != DataEntryStage.LOCKED) {
            if (this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
                this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Scheduled.gif", "images/CRF_status_icon_Scheduled.gif");
            } else if (this.eventCrfStatus == DataEntryStage.INVALID) {
                this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Invalid_collapse.gif", "images/CRF_status_icon_Invalid.gif");
            } else {
                this.lockLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Started.gif", "images/CRF_status_icon_Started.gif");
            }
        }
        this.html.divEnd();
    }

    void buildEvent() {
        String studySubjectLabel = this.studySubject.getLabel();
        String tableHeaderRowLeftStyleClass = "table_header_row_left";
        String subjectText = this.reswords.getString("subject");
        String crfText = this.reswords.getString("CRF");
        this.html.div().id("Event_" + studySubjectLabel + "_" + this.crf.getId() + "_" + this.rowCount).style("position: absolute; visibility: hidden; z-index: 3;width:180px; top: 0px;").close();
        this.html.div().styleClass("box_T").close().div().styleClass("box_L").close().div().styleClass("box_R").close().div().styleClass("box_B").close().div().styleClass("box_TL").close().div().styleClass("box_TR").close().div().styleClass("box_BL").close().div().styleClass("box_BR").close();
        this.html.div().styleClass("tablebox_center").close();
        this.html.div().styleClass("ViewSubjectsPopup").style("color:#5b5b5b").close();
        this.html.table(0).border("0").cellpadding("0").cellspacing("0").close();
        this.html.tr(0).valign("top").close();
        this.html.td(0).styleClass(tableHeaderRowLeftStyleClass).close();
        this.html.append((Object)subjectText).append((Object)": ").append((Object)studySubjectLabel).br();
        this.html.append((Object)crfText).append((Object)": ").append((Object)this.crf.getName()).br();
        this.html.append((Object)"Status").append((Object)": ").append((Object)this.eventCrfStatus.getName()).br();
        this.html.tdEnd();
        this.html.td(0).styleClass(tableHeaderRowLeftStyleClass).align("right").close();
        if (this.eventCrfStatus == DataEntryStage.ADMINISTRATIVE_EDITING) {
            this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Complete.gif");
        } else if (this.eventCrfStatus == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) {
            this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_InitialDEcomplete.gif");
        } else if (this.eventCrfStatus == DataEntryStage.DOUBLE_DATA_ENTRY) {
            this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_DDE.gif");
        } else if (this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
            this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Scheduled.gif");
        } else if (this.eventCrfStatus != DataEntryStage.LOCKED) {
            if (this.eventCrfStatus == DataEntryStage.INVALID) {
                this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Invalid.gif");
            } else {
                this.linkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Started.gif");
            }
        }
        this.html.tdEnd().trEnd(0);
    }

    void clickToEnterData() {
        String click_to_enter_data = this.restexts.getString("click_to_enter_data");
        String to_use_another_version_click = this.restexts.getString("to_use_another_version");
        String in_order_to_enter_data_create_event = this.restexts.getString("in_order_to_enter_data_create_e");
        String click_for_more_options = this.restexts.getString("click_for_more_options");
        String table_cell_left = "table_cell_left";
        String studySubjectLabel = this.studySubject.getLabel();
        this.html.tr(0).id("Menu_off_" + studySubjectLabel + "_" + this.crf.getId() + "_" + this.rowCount).style("display: all").close();
        this.html.td(0).styleClass("table_cell_left").colspan("2").close();
        if (this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
            if (this.getStudyEvent() != null) {
                this.html.append((Object)("<i>" + click_to_enter_data)).br();
                this.html.append((Object)(to_use_another_version_click + "</i>"));
            } else {
                this.html.append((Object)("<i>" + in_order_to_enter_data_create_event + "</i>"));
            }
        } else if (this.getStudyEvent() == null && this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
            this.html.append((Object)("<i>" + click_to_enter_data)).br();
            this.html.append((Object)(to_use_another_version_click + "</i>"));
        } else {
            this.html.append((Object)("<i>" + click_for_more_options + "</i>"));
        }
        this.html.tdEnd().trEnd(0);
        this.html.tr(0).id("Menu_on_" + studySubjectLabel + "_" + this.crf.getId() + "_" + this.rowCount).style("display: none").close();
        this.html.td(0).colspan("2").close();
        this.html.table(0).border("0").cellpadding("0").cellspacing("0").close();
        if (this.eventCrfStatus == DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE || this.eventCrfStatus == DataEntryStage.ADMINISTRATIVE_EDITING) {
            if (!this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewEventCrfContentLink(this.html, this.studySubject, this.eventCrfBean, this.getStudyEvent());
                this.html.nbsp().nbsp();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.reswords.getString("view"), this.eventDefinitionCrf);
                this.html.tdEnd().trEnd(0);
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.printDataEntry(this.html, this.eventCrfBean);
                this.html.nbsp().nbsp();
                this.printDataEntry(this.html, this.eventCrfBean, this.reswords.getString("print"));
                this.html.tdEnd().trEnd(0);
            }
            if (!this.currentRole.isMonitor() && this.currentStudy.getStatus() == Status.AVAILABLE) {
                if (!this.hiddenCrf()) {
                    this.html.tr(0).valign("top").close();
                    this.html.td(0).styleClass(table_cell_left).close();
                    this.administrativeEditing(this.html, this.eventCrfBean);
                    this.html.nbsp().nbsp();
                    this.administrativeEditing(this.html, this.eventCrfBean, this.reswords.getString("edit"));
                    this.html.tdEnd().trEnd(0);
                }
                if (this.currentRole.isDirector() || this.currentUser.isSysAdmin()) {
                    this.html.tr(0).valign("top").close();
                    this.html.td(0).styleClass(table_cell_left).close();
                    this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject);
                    this.html.nbsp().nbsp();
                    this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject, this.reswords.getString("remove"));
                    this.html.tdEnd().trEnd(0);
                }
            }
            if (this.currentStudy.getStatus() == Status.AVAILABLE && this.currentUser.isSysAdmin()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.deleteEventCrf(this.html, this.eventCrfBean, this.studySubject);
                this.html.nbsp().nbsp();
                this.deleteEventCrf(this.html, this.eventCrfBean, this.studySubject, this.reswords.getString("delete"));
                this.html.tdEnd().trEnd(0);
            }
        } else if (this.eventCrfStatus == DataEntryStage.LOCKED) {
            if (!this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewEventCrfContentLink(this.html, this.studySubject, this.eventCrfBean, this.getStudyEvent());
                this.html.nbsp().nbsp();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.reswords.getString("view"), this.eventDefinitionCrf);
                this.html.tdEnd().trEnd(0);
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewEventCrfContentLinkPrint(this.html, this.studySubject, this.eventCrfBean, this.getStudyEvent());
                this.html.nbsp().nbsp();
                this.viewEventCrfContentLink(this.html, this.studySubject, this.eventCrfBean, this.getStudyEvent(), this.reswords.getString("print"));
                this.html.tdEnd().trEnd(0);
            }
            if (this.currentStudy.getStatus() == Status.AVAILABLE && (this.currentRole.isDirector() || this.currentUser.isSysAdmin())) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject);
                this.html.nbsp().nbsp();
                this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject, this.reswords.getString("remove"));
                this.html.tdEnd().trEnd(0);
            }
        } else if (this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
            if (this.getStudyEvent() != null && !this.currentRole.isMonitor() && this.currentStudy.getStatus() == Status.AVAILABLE && !this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.initialDataEntryLink(this.html, this.eventCrfBean == null ? new EventCRFBean() : this.eventCrfBean, this.studySubject, this.eventDefinitionCrf, this.getStudyEvent());
                this.html.nbsp().nbsp();
                this.initialDataEntryLink(this.html, this.eventCrfBean == null ? new EventCRFBean() : this.eventCrfBean, this.studySubject, this.eventDefinitionCrf, this.getStudyEvent(), this.reswords.getString("enter_data"));
                this.html.tdEnd().trEnd(0);
            }
            if (!this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewSectionDataEntryParameterized(this.html, this.eventDefinitionCrf);
                this.html.nbsp().nbsp();
                this.viewSectionDataEntryParameterized(this.html, this.eventDefinitionCrf, this.reswords.getString("view"));
                this.html.tdEnd().trEnd(0);
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                if (this.eventCrfBean == null) {
                    this.printCrf(this.html, this.eventDefinitionCrf);
                } else {
                    this.printDataEntry(this.html, this.eventCrfBean);
                }
                this.html.nbsp().nbsp();
                if (this.eventCrfBean == null) {
                    this.printCrf(this.html, this.eventDefinitionCrf, this.reswords.getString("print"));
                } else {
                    this.printDataEntry(this.html, this.eventCrfBean, this.reswords.getString("print"));
                }
                this.html.tdEnd().trEnd(0);
            }
        } else if (this.eventCrfStatus == DataEntryStage.INVALID) {
            if (!this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.eventDefinitionCrf);
                this.html.nbsp().nbsp();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.reswords.getString("view"), this.eventDefinitionCrf);
                this.html.tdEnd().trEnd(0);
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.printDataEntry(this.html, this.eventCrfBean);
                this.html.nbsp().nbsp();
                this.printDataEntry(this.html, this.eventCrfBean, this.reswords.getString("print"));
                this.html.tdEnd().trEnd(0);
            }
            if (this.studySubject.getStatus() != Status.DELETED && this.studySubject.getStatus() != Status.AUTO_DELETED && (this.currentRole.isDirector() || this.currentUser.isSysAdmin())) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.restoreEventCrf(this.html, this.eventCrfBean, this.studySubject);
                this.html.nbsp().nbsp();
                this.restoreEventCrf(this.html, this.eventCrfBean, this.studySubject, "Restore");
                this.html.tdEnd().trEnd(0);
            }
        } else {
            if (!this.currentRole.isMonitor() && this.currentStudy.getStatus() == Status.AVAILABLE) {
                if (this.eventCrfStatus == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE || this.eventCrfStatus == DataEntryStage.DOUBLE_DATA_ENTRY) {
                    if (!this.hiddenCrf()) {
                        this.html.tr(0).valign("top").close();
                        this.html.td(0).styleClass(table_cell_left).close();
                        this.doubleDataEntryLink(this.html, this.eventCrfBean);
                        this.html.nbsp().nbsp();
                        this.doubleDataEntryLink(this.html, this.eventCrfBean, this.reswords.getString("enter_data"));
                        this.html.tdEnd().trEnd(0);
                    }
                } else if (!this.hiddenCrf()) {
                    this.html.tr(0).valign("top").close();
                    this.html.td(0).styleClass(table_cell_left).close();
                    this.initialDataEntryParameterizedLink(this.html, this.eventCrfBean);
                    this.html.nbsp().nbsp();
                    this.initialDataEntryParameterizedLink(this.html, this.eventCrfBean, this.reswords.getString("enter_data"));
                    this.html.tdEnd().trEnd(0);
                }
            }
            if (!this.hiddenCrf()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.eventDefinitionCrf);
                this.html.nbsp().nbsp();
                this.viewSectionDataEntry(this.html, this.eventCrfBean, this.reswords.getString("view"), this.eventDefinitionCrf);
                this.html.tdEnd().trEnd(0);
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.printDataEntry(this.html, this.eventCrfBean);
                this.html.nbsp().nbsp();
                this.printDataEntry(this.html, this.eventCrfBean, this.reswords.getString("print"));
                this.html.tdEnd().trEnd(0);
            }
            if (this.currentStudy.getStatus() == Status.AVAILABLE && (this.currentRole.isDirector() || this.currentUser.isSysAdmin())) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject);
                this.html.nbsp().nbsp();
                this.removeEventCrf(this.html, this.eventCrfBean, this.studySubject, this.reswords.getString("remove"));
                this.html.tdEnd().trEnd(0);
            }
            if (this.currentStudy.getStatus() == Status.AVAILABLE && this.currentUser.isSysAdmin()) {
                this.html.tr(0).valign("top").close();
                this.html.td(0).styleClass(table_cell_left).close();
                this.deleteEventCrf(this.html, this.eventCrfBean, this.studySubject);
                this.html.nbsp().nbsp();
                this.deleteEventCrf(this.html, this.eventCrfBean, this.studySubject, this.reswords.getString("delete"));
                this.html.tdEnd().trEnd(0);
            }
        }
        this.html.tableEnd(0);
        this.html.tdEnd().trEnd(0).tableEnd(0);
        this.html.divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd().divEnd();
    }

    private StudyEventBean getStudyEventForThisEventCRF() {
        List ses = this.studyEvents;
        Iterator iterator = ses.iterator();
        if (iterator.hasNext()) {
            StudyEventBean studyEvent = (StudyEventBean)iterator.next();
            if (studyEvent.getId() == this.eventCrfBean.getStudyEventId()) {
                studyEvent.setStudyEventDefinition(this.studyEventDefinition);
            }
            return studyEvent;
        }
        return null;
    }

    private String getCRFVersionOID() {
        for (CRFVersionBean crfV : this.crf.getVersions()) {
            if (crfV.getId() != this.eventCrfBean.getCRFVersionId()) continue;
            return crfV.getOid();
        }
        return null;
    }

    void buildEnd() {
        String studySubjectLabel = this.studySubject.getLabel();
        if (this.eventCrfStatus == DataEntryStage.DOUBLE_DATA_ENTRY_COMPLETE || this.eventCrfStatus == DataEntryStage.ADMINISTRATIVE_EDITING) {
            this.iconLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Complete_expand.gif", "images/CRF_status_icon_Complete.gif");
        } else if (this.eventCrfStatus == DataEntryStage.INITIAL_DATA_ENTRY_COMPLETE) {
            this.iconLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_InitialDEcomplete_expand.gif", "images/CRF_status_icon_InitialDEcomplete.gif");
        } else if (this.eventCrfStatus != DataEntryStage.LOCKED) {
            if (this.eventCrfStatus == DataEntryStage.UNCOMPLETED) {
                this.iconLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Scheduled.gif", "images/CRF_status_icon_Scheduled.gif");
            } else if (this.eventCrfStatus == DataEntryStage.INVALID) {
                this.iconLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Invalid_expand.gif", "images/CRF_status_icon_Invalid.gif");
            } else {
                this.iconLinkBuilder(this.html, studySubjectLabel, this.rowCount, this.crf, "images/CRF_status_icon_Started.gif", "images/CRF_status_icon_Started.gif");
            }
        }
    }

    private void viewEventCrfContentLink(HtmlBuilder builder, StudySubjectBean studySubject, EventCRFBean eventCrf, StudyEventBean studyEvent) {
        String href = "ViewEventCRFContent?id=" + studySubject.getId() + "&ecId=" + eventCrf.getId() + "&eventId=" + studyEvent.getId();
        builder.a().href(href).close();
        builder.img().src("images/bt_View.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void viewEventCrfContentLinkPrint(HtmlBuilder builder, StudySubjectBean studySubject, EventCRFBean eventCrf, StudyEventBean studyEvent) {
        String href = "ViewEventCRFContent?id=" + studySubject.getId() + "&ecId=" + eventCrf.getId() + "&eventId=" + studyEvent.getId();
        builder.a().href(href).close();
        builder.img().src("images/bt_Print.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void viewEventCrfContentLink(HtmlBuilder builder, StudySubjectBean studySubject, EventCRFBean eventCrf, StudyEventBean studyEvent, String link) {
        String href = "ViewEventCRFContent?id=" + studySubject.getId() + "&ecId=" + eventCrf.getId() + "&eventId=" + studyEvent.getId();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void viewSectionDataEntry(HtmlBuilder builder, EventCRFBean eventCrf, String link, EventDefinitionCRFBean eventDefinitionCrf) {
        String href = "ViewSectionDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&ecId=" + eventCrf.getId() + "&tabId=1&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void viewSectionDataEntry(HtmlBuilder builder, EventCRFBean eventCrf, EventDefinitionCRFBean eventDefinitionCrf) {
        String href = "ViewSectionDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&ecId=" + eventCrf.getId() + "&tabId=1&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_View.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void viewSectionDataEntryParameterized(HtmlBuilder builder, EventDefinitionCRFBean eventDefinitionCrf, String link) {
        String href = "ViewSectionDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&crfVersionId=" + eventDefinitionCrf.getDefaultVersionId() + "&tabId=1&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void viewSectionDataEntryParameterized(HtmlBuilder builder, EventDefinitionCRFBean eventDefinitionCrf) {
        String href = "ViewSectionDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&crfVersionId=" + eventDefinitionCrf.getDefaultVersionId() + "&tabId=1&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_View.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void printDataEntry(HtmlBuilder builder, EventCRFBean eventCrf) {
        String href = this.contextPath + "/rest/clinicaldata/html/print/" + this.currentStudy.getOid() + "/" + this.studySubject.getOid() + "/" + this.getStudyEventForThisEventCRF().getStudyEventDefinition().getOid() + "[" + this.getStudyEventForThisEventCRF().getSampleOrdinal() + "]/" + this.getCRFVersionOID();
        builder.a().href(href).close();
        builder.img().src("images/bt_Print.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void printDataEntry(HtmlBuilder builder, EventCRFBean eventCrf, String link) {
        String href = this.contextPath + "/rest/clinicaldata/html/print/" + this.currentStudy.getOid() + "/" + this.studySubject.getOid() + "/" + this.getStudyEventForThisEventCRF().getStudyEventDefinition().getOid() + "%5b" + this.getStudyEventForThisEventCRF().getSampleOrdinal() + "%5d/" + this.getCRFVersionOID();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void printCrf(HtmlBuilder builder, EventDefinitionCRFBean eventDefinitionCrf) {
        int sampleOrdinal = 1;
        if (this.getStudyEvent() != null) {
            sampleOrdinal = this.getStudyEvent().getSampleOrdinal();
        }
        String href = this.contextPath + "/rest/clinicaldata/html/print/" + this.currentStudy.getOid() + "/" + this.studySubject.getOid() + "/" + this.studyEventDefinition.getOid() + "%5b" + sampleOrdinal + "%5d/" + this.eventDefinitionCrf.getDefaultCRF().getOid();
        builder.a().href(href).close();
        builder.img().src("images/bt_Print.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void printCrf(HtmlBuilder builder, EventDefinitionCRFBean eventDefinitionCrf, String link) {
        int sampleOrdinal = 1;
        if (this.getStudyEvent() != null) {
            sampleOrdinal = this.getStudyEvent().getSampleOrdinal();
        }
        String href = this.contextPath + "/rest/clinicaldata/html/print/" + this.currentStudy.getOid() + "/" + this.studySubject.getOid() + "/" + this.studyEventDefinition.getOid() + "%5b" + sampleOrdinal + "%5d/" + this.eventDefinitionCrf.getDefaultCRF().getOid();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void administrativeEditing(HtmlBuilder builder, EventCRFBean eventCrf) {
        String href = "AdministrativeEditing?eventCRFId=" + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void administrativeEditing(HtmlBuilder builder, EventCRFBean eventCrf, String link) {
        String href = "AdministrativeEditing?eventCRFId=" + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void removeEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject) {
        String href = "RemoveEventCRF?action=confirm&id=" + eventCrf.getId() + "&studySubId=" + studySubject.getId();
        builder.a().href(href).close();
        builder.img().src("images/bt_Remove.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void removeEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject, String link) {
        String href = "RemoveEventCRF?action=confirm&id=" + eventCrf.getId() + "&studySubId=" + studySubject.getId();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void restoreEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject) {
        String href = "RestoreEventCRF?action=confirm&id=" + eventCrf.getId() + "&studySubId=" + studySubject.getId();
        builder.a().href(href).close();
        builder.img().src("images/bt_Restore.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void restoreEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject, String link) {
        String href = "RestoreEventCRF?action=confirm&id=" + eventCrf.getId() + "&studySubId=" + studySubject.getId();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void deleteEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject) {
        String href = "DeleteEventCRF?action=confirm&ssId=" + studySubject.getId() + "&ecId=" + eventCrf.getId();
        builder.a().href(href).close();
        builder.img().src("images/bt_Delete.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void deleteEventCrf(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject, String link) {
        String href = "DeleteEventCRF?action=confirm&ssId=" + studySubject.getId() + "&ecId=" + eventCrf.getId();
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void initialDataEntryLink(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject, EventDefinitionCRFBean eventDefinitionCrf, StudyEventBean studyEvent) {
        String href = "InitialDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&studyEventId=" + studyEvent.getId() + "&subjectId=" + studySubject.getSubjectId() + "&eventCRFId=" + eventCrf.getId() + "&crfVersionId=" + eventDefinitionCrf.getDefaultVersionId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void initialDataEntryLink(HtmlBuilder builder, EventCRFBean eventCrf, StudySubjectBean studySubject, EventDefinitionCRFBean eventDefinitionCrf, StudyEventBean studyEvent, String link) {
        String href = "InitialDataEntry?eventDefinitionCRFId=" + eventDefinitionCrf.getId() + "&studyEventId=" + studyEvent.getId() + "&subjectId=" + studySubject.getSubjectId() + "&eventCRFId=" + eventCrf.getId() + "&crfVersionId=" + eventDefinitionCrf.getDefaultVersionId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void initialDataEntryParameterizedLink(HtmlBuilder builder, EventCRFBean eventCrf) {
        String href = "InitialDataEntry?eventCRFId=" + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void initialDataEntryParameterizedLink(HtmlBuilder builder, EventCRFBean eventCrf, String link) {
        String href = "InitialDataEntry?eventCRFId=" + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void doubleDataEntryLink(HtmlBuilder builder, EventCRFBean eventCrf) {
        String href = "DoubleDataEntry?eventCRFId= " + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.img().src("images/bt_Edit.gif").border("0").align("left").close();
        builder.aEnd();
    }

    private void doubleDataEntryLink(HtmlBuilder builder, EventCRFBean eventCrf, String link) {
        String href = "DoubleDataEntry?eventCRFId= " + eventCrf.getId() + "&exitTo=ListStudySubjects";
        builder.a().href(href).close();
        builder.append((Object)link);
        builder.aEnd();
    }

    private void linkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, CRFBean crf, String icon) {
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('CRFicon_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "','" + icon + "'); ";
        builder.a().href(href1 + href2);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close().append((Object)"X").aEnd();
    }

    private void lockLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, CRFBean crf, String collapsedIcon, String icon) {
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onmouseover = "layersShowOrHide('visible','Event_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        onmouseover = onmouseover + "javascript:setImage('CRFicon_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "','" + collapsedIcon + "');";
        String onClick1 = "layersShowOrHide('hidden','Lock_all'); ";
        String onClick2 = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onClick3 = "layersShowOrHide('hidden','Lock_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onClick4 = "javascript:setImage('CRFicon_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "','" + icon + "'); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onclick(onClick1 + onClick2 + onClick3 + onClick4);
        builder.close();
        builder.img().src("images/spacer.gif").border("0").append((Object)"height=\"30\"").width("144").close().aEnd();
    }

    private void iconLinkBuilder(HtmlBuilder builder, String studySubjectLabel, Integer rowCount, CRFBean crf, String expandedIcon, String icon) {
        String href1 = "javascript:leftnavExpand('Menu_on_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String href2 = "javascript:leftnavExpand('Menu_off_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        String onmouseover = "moveObject('Event_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "', event); ";
        onmouseover = onmouseover + "setImage('CRFicon" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "','" + expandedIcon + "');";
        String onmouseout = "layersShowOrHide('hidden','Event_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "'); ";
        onmouseout = onmouseout + "setImage('CRFicon_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "','" + icon + "');";
        String onClick1 = "layersShowOrHide('visible','Lock_all'); ";
        String onClick2 = "LockObject('Lock_" + studySubjectLabel + "_" + crf.getId() + "_" + rowCount + "',event); ";
        builder.a().href(href1 + href2);
        builder.onmouseover(onmouseover);
        builder.onmouseout(onmouseout);
        builder.onclick(onClick1 + onClick2);
        builder.close();
    }

    private boolean hiddenCrf() {
        return this.currentStudy.getParentStudyId() > 0 && this.eventDefinitionCrf.isHideCrf();
    }
}

