/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.net.MalformedURLException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.service.StudyParameterValueBean;
import org.akaza.openclinica.bean.service.StudyParamsConfig;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.control.SpringServletAccess;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.control.managestudy.CreateStudyServlet;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.service.StudyParameterValueDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.domain.SourceDataVerification;
import org.akaza.openclinica.service.managestudy.EventDefinitionCrfTagService;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class InitUpdateSubStudyServlet
extends SecureController {
    private static final long serialVersionUID = 1348293062808929660L;
    EventDefinitionCrfTagService eventDefinitionCrfTagService = null;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.SITE_LIST_SERVLET, respage.getString("current_study_locked"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        String idString = this.request.getParameter("id");
        logger.info("study id:" + idString);
        if (idString == null || idString.trim().isEmpty()) {
            this.addPageMessage(respage.getString("please_choose_a_study_to_edit"));
            this.forwardPage(Page.STUDY_LIST_SERVLET);
        } else {
            int studyId = Integer.valueOf(idString.trim());
            StudyBean study = sdao.findByPK(studyId);
            this.checkRoleByUserAndStudy(this.ub, study.getParentStudyId(), study.getId());
            String parentStudyName = "";
            StudyBean parent = new StudyBean();
            if (study.getParentStudyId() > 0) {
                parent = sdao.findByPK(study.getParentStudyId());
                parentStudyName = parent.getName();
                this.createEventDefinitions(parent);
            }
            if (this.currentStudy.getId() != study.getId()) {
                ArrayList parentConfigs = this.currentStudy.getStudyParameters();
                ArrayList<StudyParamsConfig> configs = new ArrayList<StudyParamsConfig>();
                StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
                for (int i = 0; i < parentConfigs.size(); ++i) {
                    StudyParamsConfig scg = (StudyParamsConfig)parentConfigs.get(i);
                    if (scg == null || scg.getValue().getId() <= 0 || !scg.getParameter().isOverridable()) continue;
                    StudyParameterValueBean spvb = spvdao.findByHandleAndStudy(study.getId(), scg.getParameter().getHandle());
                    if (spvb.getValue().equals("enabled")) {
                        this.baseUrl();
                    }
                    if (spvb.getId() > 0) {
                        scg.setValue(spvb);
                    }
                    configs.add(scg);
                }
                study.setStudyParameters(configs);
            }
            this.request.setAttribute("parentStudy", (Object)parent);
            this.session.setAttribute("parentName", (Object)parentStudyName);
            this.session.setAttribute("newStudy", (Object)study);
            this.request.setAttribute("facRecruitStatusMap", (Object)CreateStudyServlet.facRecruitStatusMap);
            this.request.setAttribute("statuses", (Object)Status.toStudyUpdateMembersList());
            FormProcessor fp = new FormProcessor(this.request);
            logger.info("start date:" + study.getDatePlannedEnd());
            if (study.getDatePlannedEnd() != null) {
                fp.addPresetValue("endDate", this.local_df.format(study.getDatePlannedEnd()));
            }
            if (study.getDatePlannedStart() != null) {
                fp.addPresetValue("startDate", this.local_df.format(study.getDatePlannedStart()));
            }
            if (study.getProtocolDateVerification() != null) {
                fp.addPresetValue("protocolDateVerification", this.local_df.format(study.getProtocolDateVerification()));
            }
            this.setPresetValues(fp.getPresetValues());
            this.forwardPage(Page.UPDATE_SUB_STUDY);
        }
    }

    private void createEventDefinitions(StudyBean parentStudy) throws MalformedURLException {
        StudyParameterValueDAO spvdao = new StudyParameterValueDAO(this.sm.getDataSource());
        int siteId = Integer.valueOf(this.request.getParameter("id").trim());
        ArrayList seds = new ArrayList();
        StudyEventDefinitionDAO sedDao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        seds = sedDao.findAllByStudy(parentStudy);
        for (StudyEventDefinitionBean sed : seds) {
            String participateFormStatus = spvdao.findByHandleAndStudy(sed.getStudyId(), "participantPortal").getValue();
            if (participateFormStatus.equals("enabled")) {
                this.baseUrl();
            }
            this.request.setAttribute("participateFormStatus", (Object)participateFormStatus);
            int defId = sed.getId();
            ArrayList edcs = edcdao.findAllByDefinitionAndSiteIdAndParentStudyId(defId, siteId, parentStudy.getId());
            ArrayList<EventDefinitionCRFBean> defCrfs = new ArrayList<EventDefinitionCRFBean>();
            for (EventDefinitionCRFBean edcBean : edcs) {
                CRFBean cBean = cdao.findByPK(edcBean.getCrfId());
                String crfPath = sed.getOid() + "." + cBean.getOid();
                edcBean.setOffline(this.getEventDefinitionCrfTagService().getEventDefnCrfOfflineStatus(2, crfPath, true));
                int edcStatusId = edcBean.getStatus().getId();
                CRFBean crf = cdao.findByPK(edcBean.getCrfId());
                int crfStatusId = crf.getStatusId();
                if (edcStatusId == 5 || edcStatusId == 7 || crfStatusId == 5 || crfStatusId == 7) continue;
                ArrayList versions = cvdao.findAllActiveByCRF(edcBean.getCrfId());
                edcBean.setVersions(versions);
                edcBean.setCrfName(crf.getName());
                if (edcBean.getParentId() == 0) {
                    edcBean.setSubmissionUrl("");
                }
                CRFVersionBean defaultVersion = cvdao.findByPK(edcBean.getDefaultVersionId());
                edcBean.setDefaultVersionName(defaultVersion.getName());
                String sversionIds = edcBean.getSelectedVersionIds();
                ArrayList<Integer> idList = new ArrayList<Integer>();
                if (sversionIds.length() > 0) {
                    String[] ids;
                    for (String id : ids = sversionIds.split("\\,")) {
                        idList.add(Integer.valueOf(id));
                    }
                }
                edcBean.setSelectedVersionIdList(idList);
                defCrfs.add(edcBean);
            }
            logger.debug("definitionCrfs size=" + defCrfs.size() + " total size=" + edcs.size());
            sed.setCrfs(defCrfs);
            sed.setCrfNum(defCrfs.size());
        }
        this.session.setAttribute("definitions", (Object)seds);
        this.session.setAttribute("sdvOptions", (Object)this.setSDVOptions());
    }

    private ArrayList<String> setSDVOptions() {
        ArrayList<String> sdvOptions = new ArrayList<String>();
        sdvOptions.add(SourceDataVerification.AllREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.PARTIALREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTREQUIRED.toString());
        sdvOptions.add(SourceDataVerification.NOTAPPLICABLE.toString());
        return sdvOptions;
    }

    protected String getAdminServlet() {
        if (this.ub.isSysAdmin()) {
            return "admin";
        }
        return "";
    }

    public EventDefinitionCrfTagService getEventDefinitionCrfTagService() {
        this.eventDefinitionCrfTagService = this.eventDefinitionCrfTagService != null ? this.eventDefinitionCrfTagService : (EventDefinitionCrfTagService)SpringServletAccess.getApplicationContext((ServletContext)this.context).getBean("eventDefinitionCrfTagService");
        return this.eventDefinitionCrfTagService;
    }
}

