/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.login.StudyUserRoleBean;
import org.akaza.openclinica.bean.login.UserAccountBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.submit.ListDiscNotesSubjectTableFactory;
import org.akaza.openclinica.control.submit.SubmitDataServlet;
import org.akaza.openclinica.core.util.ClassCastHelper;
import org.akaza.openclinica.dao.managestudy.DiscrepancyNoteDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupClassDAO;
import org.akaza.openclinica.dao.managestudy.StudyGroupDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.SubjectDAO;
import org.akaza.openclinica.dao.submit.SubjectGroupMapDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.i18n.util.ResourceBundleProvider;
import org.akaza.openclinica.service.DiscrepancyNoteUtil;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class ListDiscNotesSubjectServlet
extends SecureController {
    private static final long serialVersionUID = 8523580243601167003L;
    public static final String RESOLUTION_STATUS = "resolutionStatus";
    public static final String EXTRA_PATH_INFO = "discrepancyNoteReport";
    public static final String DISCREPANCY_NOTE_TYPE = "discrepancyNoteType";
    public static final String FILTER_SUMMARY = "filterSummary";
    Locale locale;

    protected void processRequest() throws Exception {
        String module = this.request.getParameter("module");
        String moduleStr = "manage";
        if (module != null && module.trim().length() > 0) {
            if ("submit".equals(module)) {
                this.request.setAttribute("module", (Object)"submit");
                moduleStr = "submit";
            } else if ("admin".equals(module)) {
                this.request.setAttribute("module", (Object)"admin");
                moduleStr = "admin";
            } else {
                this.request.setAttribute("module", (Object)"manage");
            }
        }
        this.request.setAttribute("closeInfoShowIcons", (Object)true);
        int resolutionStatus = 0;
        try {
            resolutionStatus = Integer.parseInt(this.request.getParameter(RESOLUTION_STATUS));
        }
        catch (NumberFormatException nfe) {
            resolutionStatus = -1;
        }
        boolean hasAResolutionStatus = resolutionStatus >= 1 && resolutionStatus <= 5;
        HashSet<Integer> resolutionStatusIds = ClassCastHelper.asHashSet((Object)this.session.getAttribute(RESOLUTION_STATUS), Integer.class);
        if (!hasAResolutionStatus && resolutionStatusIds != null) {
            this.session.removeAttribute(RESOLUTION_STATUS);
            resolutionStatusIds = null;
        }
        if (hasAResolutionStatus) {
            if (resolutionStatusIds == null) {
                resolutionStatusIds = new HashSet<Integer>();
            }
            resolutionStatusIds.add(resolutionStatus);
            this.session.setAttribute(RESOLUTION_STATUS, resolutionStatusIds);
        }
        int discNoteType = 0;
        try {
            discNoteType = Integer.parseInt(this.request.getParameter("type"));
        }
        catch (NumberFormatException nfe) {
            discNoteType = -1;
        }
        this.request.setAttribute(DISCREPANCY_NOTE_TYPE, (Object)discNoteType);
        DiscrepancyNoteUtil discNoteUtil = new DiscrepancyNoteUtil();
        Map filterSummary = discNoteUtil.generateFilterSummary(discNoteType, resolutionStatusIds);
        if (!filterSummary.isEmpty()) {
            this.request.setAttribute(FILTER_SUMMARY, (Object)filterSummary);
        }
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        Map stats = discNoteUtil.generateDiscNoteSummaryRefactored(this.sm.getDataSource(), this.currentStudy, resolutionStatusIds, discNoteType);
        this.request.setAttribute("summaryMap", (Object)stats);
        Set mapKeys = stats.keySet();
        this.request.setAttribute("mapKeys", mapKeys);
        StudyDAO studyDAO = new StudyDAO(this.sm.getDataSource());
        StudySubjectDAO sdao = new StudySubjectDAO(this.sm.getDataSource());
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
        SubjectGroupMapDAO sgmdao = new SubjectGroupMapDAO(this.sm.getDataSource());
        StudyGroupClassDAO sgcdao = new StudyGroupClassDAO(this.sm.getDataSource());
        StudyGroupDAO sgdao = new StudyGroupDAO(this.sm.getDataSource());
        EventCRFDAO edao = new EventCRFDAO(this.sm.getDataSource());
        EventDefinitionCRFDAO eddao = new EventDefinitionCRFDAO(this.sm.getDataSource());
        SubjectDAO subdao = new SubjectDAO(this.sm.getDataSource());
        DiscrepancyNoteDAO dnDAO = new DiscrepancyNoteDAO(this.sm.getDataSource());
        ListDiscNotesSubjectTableFactory factory = new ListDiscNotesSubjectTableFactory(ResourceBundleProvider.getTermsBundle((Locale)this.locale));
        factory.setStudyEventDefinitionDao(seddao);
        factory.setSubjectDAO(subdao);
        factory.setStudySubjectDAO(sdao);
        factory.setStudyEventDAO(sedao);
        factory.setStudyBean(this.currentStudy);
        factory.setStudyGroupClassDAO(sgcdao);
        factory.setSubjectGroupMapDAO(sgmdao);
        factory.setStudyDAO(studyDAO);
        factory.setCurrentRole(this.currentRole);
        factory.setCurrentUser(this.ub);
        factory.setEventCRFDAO(edao);
        factory.setEventDefintionCRFDAO(eddao);
        factory.setStudyGroupDAO(sgdao);
        factory.setDiscrepancyNoteDAO(dnDAO);
        factory.setModule(moduleStr);
        factory.setDiscNoteType(Integer.valueOf(discNoteType));
        factory.setResolutionStatus(Integer.valueOf(resolutionStatus));
        factory.setResolutionStatusIds(resolutionStatusIds);
        factory.setResword(ResourceBundleProvider.getWordsBundle((Locale)this.locale));
        String listDiscNotesHtml = factory.createTable(this.request, this.response).render();
        this.request.setAttribute("listDiscNotesHtml", (Object)listDiscNotesHtml);
        this.forwardPage(this.getJSP());
    }

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (SubmitDataServlet.mayViewData((UserAccountBean)this.ub, (StudyUserRoleBean)this.currentRole)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    protected Page getJSP() {
        return Page.LIST_SUBJECT_DISC_NOTE;
    }

    protected String getBaseURL() {
        return "ListDiscNotesSubjectServlet";
    }
}

