/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.akaza.openclinica.bean.admin.DisplayStudyBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.i18n.core.LocaleResolver;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;
import org.akaza.openclinica.web.bean.DisplayStudyRow;
import org.akaza.openclinica.web.bean.EntityBeanTable;

public class ListStudyServlet
extends SecureController {
    private static final long serialVersionUID = 1660543632636179574L;
    Locale locale;

    public void mayProceed() throws InsufficientPermissionException {
        this.locale = LocaleResolver.getLocale((HttpServletRequest)this.request);
        if (this.ub.isSysAdmin() || this.ub.isTechAdmin()) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("may_not_submit_data"), "1");
    }

    public void processRequest() throws Exception {
        StudyDAO sdao = new StudyDAO(this.sm.getDataSource());
        ArrayList studies = sdao.findAll();
        ArrayList parents = sdao.findAllParents();
        ArrayList<DisplayStudyBean> displayStudies = new ArrayList<DisplayStudyBean>();
        for (int i = 0; i < parents.size(); ++i) {
            StudyBean parent = (StudyBean)parents.get(i);
            ArrayList children = new ArrayList(sdao.findAllByParent(parent.getId()));
            DisplayStudyBean displayStudy = new DisplayStudyBean();
            displayStudy.setParent(parent);
            displayStudy.setChildren(children);
            displayStudies.add(displayStudy);
        }
        FormProcessor fp = new FormProcessor(this.request);
        EntityBeanTable table = fp.getEntityBeanTable();
        ArrayList allStudyRows = DisplayStudyRow.generateRowsFromBeans(displayStudies);
        String[] columns = new String[]{resword.getString("name"), resword.getString("unique_identifier"), resword.getString("OID"), resword.getString("principal_investigator"), resword.getString("facility_name"), resword.getString("date_created"), resword.getString("status"), resword.getString("actions")};
        table.setColumns(new ArrayList<String>(Arrays.asList(columns)));
        table.hideColumnLink(2);
        table.hideColumnLink(6);
        table.setQuery("ListStudy", new HashMap());
        table.setRows(allStudyRows);
        table.computeDisplay();
        this.request.setAttribute("table", (Object)table);
        this.session.setAttribute("fromListSite", (Object)"no");
        this.resetPanel();
        this.panel.setStudyInfoShown(false);
        this.panel.setOrderedData(true);
        this.setToPanel(resword.getString("in_the_application"), "");
        if (parents.size() > 0) {
            this.setToPanel(resword.getString("studies"), new Integer(parents.size()).toString());
        }
        if (studies.size() > 0) {
            this.setToPanel(resword.getString("sites"), new Integer(studies.size() - parents.size()).toString());
        }
        this.forwardPage(Page.STUDY_LIST);
    }

    protected String getAdminServlet() {
        return "admin";
    }
}

