/*
 * Decompiled with CFR 0.152.
 */
package org.akaza.openclinica.control.managestudy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.akaza.openclinica.bean.admin.CRFBean;
import org.akaza.openclinica.bean.core.Role;
import org.akaza.openclinica.bean.core.Status;
import org.akaza.openclinica.bean.core.Term;
import org.akaza.openclinica.bean.managestudy.DisplayStudyEventBean;
import org.akaza.openclinica.bean.managestudy.EventDefinitionCRFBean;
import org.akaza.openclinica.bean.managestudy.StudyBean;
import org.akaza.openclinica.bean.managestudy.StudyEventBean;
import org.akaza.openclinica.bean.managestudy.StudyEventDefinitionBean;
import org.akaza.openclinica.bean.managestudy.StudySubjectBean;
import org.akaza.openclinica.bean.submit.CRFVersionBean;
import org.akaza.openclinica.bean.submit.DisplayEventCRFBean;
import org.akaza.openclinica.bean.submit.EventCRFBean;
import org.akaza.openclinica.bean.submit.ItemDataBean;
import org.akaza.openclinica.control.core.SecureController;
import org.akaza.openclinica.control.form.FormProcessor;
import org.akaza.openclinica.dao.admin.CRFDAO;
import org.akaza.openclinica.dao.managestudy.EventDefinitionCRFDAO;
import org.akaza.openclinica.dao.managestudy.StudyDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDAO;
import org.akaza.openclinica.dao.managestudy.StudyEventDefinitionDAO;
import org.akaza.openclinica.dao.managestudy.StudySubjectDAO;
import org.akaza.openclinica.dao.submit.CRFVersionDAO;
import org.akaza.openclinica.dao.submit.EventCRFDAO;
import org.akaza.openclinica.dao.submit.ItemDataDAO;
import org.akaza.openclinica.view.Page;
import org.akaza.openclinica.web.InsufficientPermissionException;

public class RemoveStudyEventServlet
extends SecureController {
    private static final long serialVersionUID = -1651245666702474675L;

    public void mayProceed() throws InsufficientPermissionException {
        this.checkStudyLocked(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_locked"));
        this.checkStudyFrozen(Page.LIST_STUDY_SUBJECTS, respage.getString("current_study_frozen"));
        if (this.ub.isSysAdmin()) {
            return;
        }
        if (this.currentRole.getRole().equals((Term)Role.STUDYDIRECTOR) || this.currentRole.getRole().equals((Term)Role.COORDINATOR)) {
            return;
        }
        this.addPageMessage(respage.getString("no_have_correct_privilege_current_study") + respage.getString("change_study_contact_sysadmin"));
        throw new InsufficientPermissionException(Page.MENU_SERVLET, resexception.getString("not_study_director"), "1");
    }

    public void processRequest() throws Exception {
        FormProcessor fp = new FormProcessor(this.request);
        int studyEventId = fp.getInt("id");
        int studySubId = fp.getInt("studySubId");
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        StudySubjectDAO subdao = new StudySubjectDAO(this.sm.getDataSource());
        if (studyEventId == 0) {
            this.addPageMessage(respage.getString("please_choose_a_SE_to_remove"));
            this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
            this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
        } else {
            StudyEventBean event = sedao.findByPK(studyEventId);
            StudySubjectBean studySub = subdao.findByPK(studySubId);
            this.request.setAttribute("studySub", (Object)studySub);
            StudyEventDefinitionDAO seddao = new StudyEventDefinitionDAO(this.sm.getDataSource());
            StudyEventDefinitionBean sed = seddao.findByPK(event.getStudyEventDefinitionId());
            event.setStudyEventDefinition(sed);
            StudyDAO studydao = new StudyDAO(this.sm.getDataSource());
            StudyBean study = studydao.findByPK(studySub.getStudyId());
            this.request.setAttribute("subStudy", (Object)study);
            String action = this.request.getParameter("action");
            if ("confirm".equalsIgnoreCase(action)) {
                EventDefinitionCRFDAO edcdao = new EventDefinitionCRFDAO(this.sm.getDataSource());
                ArrayList eventDefinitionCRFs = edcdao.findAllByEventDefinitionId(study, sed.getId());
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                DisplayStudyEventBean de = new DisplayStudyEventBean();
                de.setStudyEvent(event);
                de.setDisplayEventCRFs(this.getDisplayEventCRFs(eventCRFs, eventDefinitionCRFs));
                this.request.setAttribute("displayEvent", (Object)de);
                this.forwardPage(Page.REMOVE_STUDY_EVENT);
            } else {
                logger.info("submit to remove the event from study");
                event.setStatus(Status.DELETED);
                event.setUpdater(this.ub);
                event.setUpdatedDate(new Date());
                sedao.update(event);
                EventCRFDAO ecdao = new EventCRFDAO(this.sm.getDataSource());
                ArrayList eventCRFs = ecdao.findAllByStudyEvent(event);
                ItemDataDAO iddao = new ItemDataDAO(this.sm.getDataSource());
                for (int k = 0; k < eventCRFs.size(); ++k) {
                    EventCRFBean eventCRF = (EventCRFBean)eventCRFs.get(k);
                    if (eventCRF.getStatus().equals((Term)Status.DELETED)) continue;
                    eventCRF.setStatus(Status.AUTO_DELETED);
                    eventCRF.setUpdater(this.ub);
                    eventCRF.setUpdatedDate(new Date());
                    ecdao.update(eventCRF);
                    ArrayList itemDatas = iddao.findAllByEventCRFId(eventCRF.getId());
                    for (int a = 0; a < itemDatas.size(); ++a) {
                        ItemDataBean item = (ItemDataBean)itemDatas.get(a);
                        if (item.getStatus().equals((Term)Status.DELETED)) continue;
                        item.setStatus(Status.AUTO_DELETED);
                        item.setUpdater(this.ub);
                        item.setUpdatedDate(new Date());
                        iddao.update(item);
                    }
                }
                String emailBody = respage.getString("the_event") + " " + event.getStudyEventDefinition().getName() + " " + respage.getString("has_been_removed_from_the_subject_record_for") + " " + studySub.getLabel() + " " + respage.getString("in_the_study") + " " + study.getName() + ".";
                this.addPageMessage(emailBody);
                this.request.setAttribute("id", (Object)new Integer(studySubId).toString());
                this.forwardPage(Page.VIEW_STUDY_SUBJECT_SERVLET);
            }
        }
    }

    private ArrayList<DisplayEventCRFBean> getDisplayEventCRFs(ArrayList<EventCRFBean> eventCRFs, ArrayList<EventDefinitionCRFBean> eventDefinitionCRFs) {
        int i;
        ArrayList<DisplayEventCRFBean> answer = new ArrayList<DisplayEventCRFBean>();
        HashMap<Integer, EventDefinitionCRFBean> definitionsById = new HashMap<Integer, EventDefinitionCRFBean>();
        for (i = 0; i < eventDefinitionCRFs.size(); ++i) {
            EventDefinitionCRFBean edc = eventDefinitionCRFs.get(i);
            definitionsById.put(new Integer(edc.getStudyEventDefinitionId()), edc);
        }
        StudyEventDAO sedao = new StudyEventDAO(this.sm.getDataSource());
        CRFDAO cdao = new CRFDAO(this.sm.getDataSource());
        CRFVersionDAO cvdao = new CRFVersionDAO(this.sm.getDataSource());
        for (i = 0; i < eventCRFs.size(); ++i) {
            EventCRFBean ecb = eventCRFs.get(i);
            int crfVersionId = ecb.getCRFVersionId();
            CRFBean cb = cdao.findByVersionId(crfVersionId);
            ecb.setCrf(cb);
            CRFVersionBean cvb = cvdao.findByPK(crfVersionId);
            ecb.setCrfVersion(cvb);
            int studyEventId = ecb.getStudyEventId();
            int studyEventDefinitionId = sedao.getDefinitionIdFromStudyEventId(studyEventId);
            EventDefinitionCRFBean edc = (EventDefinitionCRFBean)definitionsById.get(new Integer(studyEventDefinitionId));
            DisplayEventCRFBean dec = new DisplayEventCRFBean();
            dec.setFlags(ecb, this.ub, this.currentRole, edc.isDoubleEntry());
            answer.add(dec);
        }
        return answer;
    }
}

